/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.xsd.dtdtoxsd;

import com.jclark.xml.parse.EndPrologEvent;
import com.jclark.xml.parse.EntityManagerImpl;
import com.jclark.xml.parse.OpenEntity;
import com.jclark.xml.parse.io.ApplicationImpl;
import com.jclark.xml.parse.io.ParserImpl;
import com.xmlmind.xmledit.util.FileUtil;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xmlutil.Namespace;
import com.xmlmind.xmledit.xmlutil.XMLUtil;
import com.xmlmind.xmledit.xsd.datatype.DataType;
import com.xmlmind.xmledit.xsd.datatype.ENTITIESType;
import com.xmlmind.xmledit.xsd.datatype.ENTITYType;
import com.xmlmind.xmledit.xsd.datatype.IDREFSType;
import com.xmlmind.xmledit.xsd.datatype.IDREFType;
import com.xmlmind.xmledit.xsd.datatype.IDType;
import com.xmlmind.xmledit.xsd.datatype.NMTOKENSType;
import com.xmlmind.xmledit.xsd.datatype.NMTOKENType;
import com.xmlmind.xmledit.xsd.datatype.NOTATIONType;
import com.xmlmind.xmledit.xsd.datatype.QNameValue;
import com.xmlmind.xmledit.xsd.datatype.StringType;
import com.xmlmind.xmledit.xsd.datatype.Value;
import com.xmlmind.xmledit.xsd.dtdtoxsd.DTD;
import com.xmlmind.xmledit.xsd.dtdtoxsd.DTDLoader;
import com.xmlmind.xmledit.xsd.dtdtoxsd.DTDUtil;
import com.xmlmind.xmledit.xsd.validate.AttributeDeclaration;
import com.xmlmind.xmledit.xsd.validate.AttributeUse;
import com.xmlmind.xmledit.xsd.validate.ChoiceParticle;
import com.xmlmind.xmledit.xsd.validate.ComplexType;
import com.xmlmind.xmledit.xsd.validate.ElementDeclaration;
import com.xmlmind.xmledit.xsd.validate.ElementParticle;
import com.xmlmind.xmledit.xsd.validate.Notation;
import com.xmlmind.xmledit.xsd.validate.Particle;
import com.xmlmind.xmledit.xsd.validate.SequenceParticle;
import com.xmlmind.xmledit.xsd.validate.WildcardParticle;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;

public final class DTDToXSD {
    private static NotationCompare notationCompare = new NotationCompare();
    private static ElementDeclarationCompare elementDeclarationCompare = new ElementDeclarationCompare();
    private static AttributeDeclarationCompare attributeDeclarationCompare = new AttributeDeclarationCompare();
    private static final String xmlAttributesSchema = "<?xml version='1.0' encoding='UTF-8'?>\n<xs:schema targetNamespace='http://www.w3.org/XML/1998/namespace'\n           xmlns:xs='http://www.w3.org/2001/XMLSchema'>\n  <xs:attribute name='space'>\n    <xs:simpleType>\n      <xs:restriction base='xs:NMTOKEN'>\n       <xs:enumeration value='default'/>\n       <xs:enumeration value='preserve'/>\n      </xs:restriction>\n    </xs:simpleType>\n  </xs:attribute>\n  <xs:attribute name='lang' type='xs:language'/>\n  <xs:attribute name='base' type='xs:anyURI'/>\n</xs:schema>\n";
    private static final String xmlAttributesSchemaDefaultLocation = "xml.xsd";

    public static void writeDTD(DTD dTD, Namespace namespace, String string, Writer writer) throws IOException {
        Notation[] notationArray;
        writer.write("<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"");
        if (namespace != null) {
            notationArray = namespace.getURI();
            writer.write("\n    targetNamespace=\"" + (String)notationArray + "\"");
            writer.write("\n    xmlns=\"" + (String)notationArray + "\"");
        }
        writer.write(">\n\n");
        if (string != null) {
            writer.write("<xs:import namespace=\"http://www.w3.org/XML/1998/namespace\"\n");
            writer.write("    schemaLocation=\"" + string + "\"/>\n\n");
        }
        notationArray = new Notation[dTD.getNotationCount()];
        Enumeration enumeration = dTD.getNotations();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            notationArray[n++] = (Notation)enumeration.nextElement();
        }
        if (notationArray.length > 1) {
            Arrays.sort(notationArray, notationCompare);
        }
        n = 0;
        while (n < notationArray.length) {
            DTDToXSD.writeNotation(notationArray[n], writer);
            writer.write(10);
            ++n;
        }
        ElementDeclaration[] elementDeclarationArray = new ElementDeclaration[dTD.getElementDeclarationCount()];
        enumeration = dTD.getElementDeclarations();
        n = 0;
        while (enumeration.hasMoreElements()) {
            elementDeclarationArray[n++] = (ElementDeclaration)enumeration.nextElement();
        }
        if (elementDeclarationArray.length > 1) {
            Arrays.sort(elementDeclarationArray, elementDeclarationCompare);
        }
        n = 0;
        while (n < elementDeclarationArray.length) {
            DTDToXSD.writeElementDeclaration(elementDeclarationArray[n], writer);
            writer.write(10);
            ++n;
        }
        writer.write("</xs:schema>\n");
    }

    private static void writeNotation(Notation notation, Writer writer) throws IOException {
        String string = notation.getName().getLocalPart();
        writer.write("<xs:notation name=\"");
        writer.write(string);
        writer.write("\"");
        String string2 = notation.getPublicId();
        if (string2 == null) {
            string2 = string;
        }
        writer.write("\n    public=\"");
        writer.write(string2);
        writer.write("\"");
        String string3 = notation.getSystemId();
        if (string3 != null) {
            writer.write("\n    system=\"");
            writer.write(string3);
            writer.write("\"");
        }
        writer.write("/>\n");
    }

    private static void writeElementDeclaration(ElementDeclaration elementDeclaration, Writer writer) throws IOException {
        AttributeDeclaration[] attributeDeclarationArray;
        writer.write("<xs:element name=\"");
        writer.write(elementDeclaration.getName().getLocalPart());
        writer.write("\">\n");
        writer.write("  <xs:complexType");
        ComplexType complexType = (ComplexType)elementDeclaration.getType();
        int n = complexType.getContentType();
        switch (n) {
            case 0: 
            case 2: {
                break;
            }
            case 3: {
                writer.write(" mixed=\"true\"");
                break;
            }
            default: {
                throw new RuntimeException("internal error: unexpected content type " + n);
            }
        }
        writer.write(">\n");
        int n2 = complexType.getAttributeDeclarationCount();
        switch (n) {
            case 2: 
            case 3: {
                attributeDeclarationArray = complexType.getParticle();
                switch (attributeDeclarationArray.getType()) {
                    case 0: 
                    case 1: 
                    case 2: {
                        DTDToXSD.writeParticle((Particle)attributeDeclarationArray, 4, writer);
                        break;
                    }
                    default: {
                        writer.write("    <xs:sequence>\n");
                        DTDToXSD.writeParticle((Particle)attributeDeclarationArray, 6, writer);
                        writer.write("    </xs:sequence>\n");
                    }
                }
                if (n2 <= 0) break;
                writer.write(10);
            }
        }
        attributeDeclarationArray = new AttributeDeclaration[n2];
        Enumeration enumeration = complexType.getAttributeDeclarations();
        int n3 = 0;
        while (enumeration.hasMoreElements()) {
            attributeDeclarationArray[n3++] = (AttributeDeclaration)enumeration.nextElement();
        }
        if (attributeDeclarationArray.length > 1) {
            Arrays.sort(attributeDeclarationArray, attributeDeclarationCompare);
        }
        n3 = 0;
        while (n3 < attributeDeclarationArray.length) {
            AttributeDeclaration attributeDeclaration = attributeDeclarationArray[n3];
            AttributeUse attributeUse = complexType.getAttributeUse(attributeDeclaration.getName());
            DTDToXSD.writeAttributeDeclaration(attributeDeclaration, attributeUse.isRequired(), writer);
            ++n3;
        }
        writer.write("  </xs:complexType>\n");
        writer.write("</xs:element>\n");
    }

    private static void writeParticle(Particle particle, int n, Writer writer) throws IOException {
        switch (particle.getType()) {
            case 0: {
                DTDToXSD.writeSequenceParticle((SequenceParticle)particle, n, writer);
                break;
            }
            case 1: {
                DTDToXSD.writeChoiceParticle((ChoiceParticle)particle, n, writer);
                break;
            }
            case 3: {
                DTDToXSD.writeElementParticle((ElementParticle)particle, n, writer);
                break;
            }
            case 4: {
                DTDToXSD.writeWildcardParticle((WildcardParticle)particle, n, writer);
                break;
            }
            default: {
                throw new RuntimeException("internal error: unexpected particle " + particle.getType());
            }
        }
    }

    private static void writeSequenceParticle(SequenceParticle sequenceParticle, int n, Writer writer) throws IOException {
        DTDToXSD.writeIndent(n, writer);
        writer.write("<xs:sequence");
        DTDToXSD.writeOccurs(sequenceParticle, writer);
        writer.write(">\n");
        Particle[] particleArray = sequenceParticle.getParticles();
        int n2 = 0;
        while (n2 < particleArray.length) {
            DTDToXSD.writeParticle(particleArray[n2], n + 2, writer);
            ++n2;
        }
        DTDToXSD.writeIndent(n, writer);
        writer.write("</xs:sequence>\n");
    }

    private static void writeChoiceParticle(ChoiceParticle choiceParticle, int n, Writer writer) throws IOException {
        DTDToXSD.writeIndent(n, writer);
        writer.write("<xs:choice");
        DTDToXSD.writeOccurs(choiceParticle, writer);
        writer.write(">\n");
        Particle[] particleArray = choiceParticle.getParticles();
        int n2 = 0;
        while (n2 < particleArray.length) {
            DTDToXSD.writeParticle(particleArray[n2], n + 2, writer);
            ++n2;
        }
        DTDToXSD.writeIndent(n, writer);
        writer.write("</xs:choice>\n");
    }

    private static void writeElementParticle(ElementParticle elementParticle, int n, Writer writer) throws IOException {
        DTDToXSD.writeIndent(n, writer);
        writer.write("<xs:element ref=\"");
        writer.write(elementParticle.getElementName().getLocalPart());
        writer.write("\"");
        DTDToXSD.writeOccurs(elementParticle, writer);
        writer.write("/>\n");
    }

    private static void writeWildcardParticle(WildcardParticle wildcardParticle, int n, Writer writer) throws IOException {
        DTDToXSD.writeIndent(n, writer);
        writer.write("<xs:any namespace=\"##any\" processContents=\"strict\"");
        DTDToXSD.writeOccurs(wildcardParticle, writer);
        writer.write("/>\n");
    }

    private static void writeIndent(int n, Writer writer) throws IOException {
        while (n > 0) {
            writer.write(32);
            --n;
        }
    }

    private static void writeOccurs(Particle particle, Writer writer) throws IOException {
        int n = particle.getMinOccurs();
        int n2 = particle.getMaxOccurs();
        if (n == 1 && n2 == 1) {
            return;
        }
        writer.write(" minOccurs=\"");
        writer.write(Integer.toString(n));
        writer.write("\" maxOccurs=\"");
        if (n2 == -1) {
            writer.write("unbounded");
        } else {
            writer.write(Integer.toString(n2));
        }
        writer.write("\"");
    }

    private static void writeAttributeDeclaration(AttributeDeclaration attributeDeclaration, boolean bl, Writer writer) throws IOException {
        String string;
        Name name = attributeDeclaration.getName();
        String string2 = name.getLocalPart();
        boolean bl2 = false;
        if (name == Name.XML_SPACE || name == Name.XML_LANG || name == Name.XML_BASE) {
            writer.write("    <xs:attribute ref=\"xml:");
            bl2 = true;
        } else {
            if ("xmlns".regionMatches(true, 0, string2, 0, 5)) {
                return;
            }
            writer.write("    <xs:attribute name=\"");
        }
        writer.write(string2);
        writer.write("\"");
        Value value = attributeDeclaration.getDefaultValue();
        if (value != null) {
            if (attributeDeclaration.isFixedValue()) {
                writer.write(" fixed=\"");
            } else {
                writer.write(" default=\"");
            }
            writer.write(XMLUtil.escapeXML(value.toString()));
            writer.write("\"");
        }
        if (bl) {
            writer.write(" use=\"required\"");
        }
        if (bl2) {
            writer.write("/>\n");
            return;
        }
        DataType dataType = attributeDeclaration.getDataType();
        if (dataType instanceof IDType) {
            string = "ID";
        } else if (dataType instanceof IDREFType) {
            string = "IDREF";
        } else if (dataType instanceof IDREFSType) {
            string = "IDREFS";
        } else if (dataType instanceof ENTITYType) {
            string = "ENTITY";
        } else if (dataType instanceof ENTITIESType) {
            string = "ENTITIES";
        } else if (dataType instanceof NMTOKENType) {
            string = "NMTOKEN";
        } else if (dataType instanceof NMTOKENSType) {
            string = "NMTOKENS";
        } else if (dataType instanceof NOTATIONType) {
            string = "NOTATION";
        } else if (dataType instanceof StringType) {
            string = "string";
        } else {
            throw new RuntimeException("internal error: unexpected DataType " + dataType.getClass().getName());
        }
        Value[] valueArray = dataType.getEnumeration();
        if (valueArray == null) {
            writer.write(" type=\"xs:");
            writer.write(string);
            writer.write("\"/>\n");
        } else {
            writer.write(">\n");
            writer.write("      <xs:simpleType>\n");
            writer.write("        <xs:restriction base=\"xs:");
            writer.write(string);
            writer.write("\">\n");
            if (dataType instanceof NMTOKENType) {
                int n = 0;
                while (n < valueArray.length) {
                    String string3 = valueArray[n].toString();
                    writer.write("          <xs:enumeration value=\"");
                    writer.write(string3);
                    writer.write("\"/>\n");
                    ++n;
                }
            } else if (dataType instanceof NOTATIONType) {
                int n = 0;
                while (n < valueArray.length) {
                    String string4 = ((QNameValue)valueArray[n]).getName().getLocalPart();
                    writer.write("          <xs:enumeration value=\"");
                    writer.write(string4);
                    writer.write("\"/>\n");
                    ++n;
                }
            }
            writer.write("        </xs:restriction>\n");
            writer.write("      </xs:simpleType>\n");
            writer.write("    </xs:attribute>\n");
        }
    }

    public static void main(final String[] stringArray) {
        Thread thread = new Thread(){

            public void run() {
                DTDToXSD.run(stringArray);
            }
        };
        thread.start();
    }

    private static void run(String[] stringArray) {
        block21: {
            DTD dTD;
            String string;
            String string2 = null;
            int n = 0;
            while (n < stringArray.length) {
                string = stringArray[n];
                if ("-t".equals(string)) {
                    if (n + 1 >= stringArray.length) {
                        DTDToXSD.usage();
                    }
                    if ((string2 = stringArray[++n].trim()).length() == 0) {
                        string2 = null;
                    }
                } else {
                    if (string.indexOf(45) != 0) break;
                    DTDToXSD.usage();
                }
                ++n;
            }
            if (n + 1 >= stringArray.length) {
                DTDToXSD.usage();
            }
            string = stringArray[n];
            String string3 = stringArray[n + 1];
            com.jclark.xml.parse.DTD dTD2 = DTDToXSD.loadDTD(string);
            if (dTD2 == null) {
                System.exit(2);
            }
            if ((dTD = DTDToXSD.convertDTD(dTD2, string)) == null) {
                System.exit(3);
            }
            Writer writer = null;
            try {
                writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string3), "UTF8"));
            }
            catch (IOException iOException) {
                System.err.println("cannot create '" + string3 + "': " + iOException.getMessage());
                System.exit(4);
            }
            Namespace namespace = null;
            if (string2 != null) {
                namespace = Namespace.get(string2);
            }
            try {
                writer.write("<?xml version='1.0' encoding='UTF-8'?>\n");
                DTDToXSD.writeDTD(dTD, namespace, xmlAttributesSchemaDefaultLocation, writer);
                writer.flush();
                writer.close();
            }
            catch (IOException iOException) {
                System.err.println("error writing '" + string3 + "': " + iOException.getMessage());
                System.exit(5);
            }
            String string4 = FileUtil.fileDirName(string3) + File.separatorChar + xmlAttributesSchemaDefaultLocation;
            try {
                writer = new OutputStreamWriter((OutputStream)new FileOutputStream(string4), "UTF8");
            }
            catch (IOException iOException) {
                System.err.println("cannot create '" + string4 + "': " + iOException.getMessage());
                System.exit(6);
            }
            try {
                writer.write(xmlAttributesSchema);
                writer.flush();
                writer.close();
            }
            catch (IOException iOException) {
                System.err.println("error writing '" + string4 + "': " + iOException.getMessage());
                System.exit(7);
            }
            String string5 = DTDUtil.getGeneralEntities(dTD2);
            if (string5 == null) break block21;
            String string6 = FileUtil.trimFileExtension(string3) + ".ent";
            try {
                writer = new OutputStreamWriter((OutputStream)new FileOutputStream(string6), "UTF8");
            }
            catch (IOException iOException) {
                System.err.println("cannot create '" + string6 + "': " + iOException.getMessage());
                System.exit(8);
            }
            try {
                writer.write("<?xml encoding='UTF-8'?>\n");
                writer.write(string5);
                writer.flush();
                writer.close();
            }
            catch (IOException iOException) {
                System.err.println("error writing '" + string6 + "': " + iOException.getMessage());
                System.exit(9);
            }
        }
    }

    private static void usage() {
        System.out.println("usage: java com.xmlmind.xmledit.xsd.dtdtoxsd.DTDToXSD ?options? in_dtd_file out_xsd_file\nOptions are:\n  -t <namespace> Use <namespace> as the target namespace\n      of the generated XML-Schema.\n      Default: none (generated schema has no target\n      namespace).\n");
        System.exit(1);
    }

    private static com.jclark.xml.parse.DTD loadDTD(String string) {
        final com.jclark.xml.parse.DTD[] dTDArray = new com.jclark.xml.parse.DTD[1];
        ParserImpl parserImpl = new ParserImpl();
        parserImpl.setApplication(new ApplicationImpl(){

            public void endProlog(EndPrologEvent endPrologEvent) throws IOException {
                dTDArray[0] = endPrologEvent.getDTD();
            }
        });
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<?xml version='1.0' encoding='UTF-8' ?>\n");
        stringBuffer.append("<!DOCTYPE dummy SYSTEM '");
        stringBuffer.append(EntityManagerImpl.fileToURL(new File(string)) + "' >\n");
        stringBuffer.append("<dummy/>\n");
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(stringBuffer.toString().getBytes("UTF8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        URL uRL = FileUtil.fileToURL("bytes");
        OpenEntity openEntity = new OpenEntity(byteArrayInputStream, uRL.toExternalForm(), uRL);
        try {
            parserImpl.parseDocument(openEntity);
        }
        catch (IOException iOException) {
            System.err.println("cannot load '" + string + "': " + iOException.getMessage());
            return null;
        }
        return dTDArray[0];
    }

    private static DTD convertDTD(com.jclark.xml.parse.DTD dTD, String string) {
        if (!DTDUtil.isGrammar(dTD)) {
            System.err.println("DTD '" + string + "' does not declare any element");
            return null;
        }
        DTDLoader dTDLoader = new DTDLoader();
        DTD dTD2 = dTDLoader.load(dTD);
        DTDToXSD.reportDTDErrors(dTDLoader, string);
        return dTD2;
    }

    private static void reportDTDErrors(DTDLoader dTDLoader, String string) {
        String[] stringArray;
        String[] stringArray2 = dTDLoader.getErrors();
        if (stringArray2.length > 0) {
            int n = 0;
            while (n < stringArray2.length) {
                System.err.print(string);
                System.err.print(":E::: ");
                System.err.println(stringArray2[n]);
                ++n;
            }
        }
        if ((stringArray = dTDLoader.getWarnings()).length > 0) {
            int n = 0;
            while (n < stringArray.length) {
                System.err.print(string);
                System.err.print(":W::: ");
                System.err.println(stringArray[n]);
                ++n;
            }
            System.err.println();
        }
    }

    private static class AttributeDeclarationCompare
    implements Comparator {
        private AttributeDeclarationCompare() {
        }

        public int compare(Object object, Object object2) {
            Name name = ((AttributeDeclaration)object).getName();
            Name name2 = ((AttributeDeclaration)object2).getName();
            return name.compareTo(name2);
        }
    }

    private static class ElementDeclarationCompare
    implements Comparator {
        private ElementDeclarationCompare() {
        }

        public int compare(Object object, Object object2) {
            Name name = ((ElementDeclaration)object).getName();
            Name name2 = ((ElementDeclaration)object2).getName();
            return name.compareTo(name2);
        }
    }

    private static class NotationCompare
    implements Comparator {
        private NotationCompare() {
        }

        public int compare(Object object, Object object2) {
            Name name = ((Notation)object).getName();
            Name name2 = ((Notation)object2).getName();
            return name.compareTo(name2);
        }
    }
}

