/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.xsd.dtdtoxsd;

import com.jclark.xml.parse.DTD;
import com.jclark.xml.parse.Entity;
import com.jclark.xml.parse.OpenEntity;
import com.xmlmind.xmledit.util.FileUtil;
import com.xmlmind.xmledit.util.URLUtil;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xmlutil.XMLCatalogs;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;

public final class DTDUtil {
    public static boolean isGrammar(DTD dTD) {
        return dTD.elementTypeNames().hasMoreElements();
    }

    public static OpenEntity toOpenEntity(String string) throws UnsupportedEncodingException {
        if (string == null) {
            string = "<?xml version='1.0' encoding='UTF-8'?>\n";
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes("UTF8"));
        URL uRL = FileUtil.fileToURL("bytes");
        return new OpenEntity(byteArrayInputStream, uRL.toExternalForm(), uRL);
    }

    public static OpenEntity toOpenEntity(URL uRL) throws IOException {
        if (uRL == null) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream("<?xml version='1.0' encoding='UTF-8'?>\n".getBytes("UTF8"));
            URL uRL2 = FileUtil.fileToURL("bytes");
            return new OpenEntity(byteArrayInputStream, uRL2.toExternalForm(), uRL2);
        }
        return new OpenEntity(uRL.openStream(), uRL.toExternalForm(), uRL);
    }

    public static Name getDocumentTypeName(DTD dTD) {
        return Name.get(dTD.getDocumentTypeName());
    }

    public static String getPublicId(DTD dTD) {
        Entity entity = dTD.getEntity((byte)1, "#DOCTYPE");
        return entity == null ? null : entity.getPublicId();
    }

    public static String getSystemId(DTD dTD) {
        Entity entity = dTD.getEntity((byte)1, "#DOCTYPE");
        String string = entity == null ? null : entity.getSystemId();
        return string;
    }

    public static URL getExternalSubsetURL(DTD dTD) {
        URL uRL;
        block2: {
            Entity entity = dTD.getEntity((byte)1, "#DOCTYPE");
            uRL = null;
            if (entity == null) break block2;
            try {
                uRL = new URL(entity.getBase(), entity.getSystemId());
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return uRL;
    }

    public static URL[] getSourceURLs(DTD dTD) {
        Object object;
        ArrayList arrayList = new ArrayList();
        Entity entity = dTD.getEntity((byte)1, "#DOCTYPE");
        if (entity != null) {
            DTDUtil.addResolvedSourceURL(entity.getSystemId(), entity.getBase(), entity.getPublicId(), arrayList);
        }
        Enumeration enumeration = dTD.entityNames((byte)1);
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            entity = dTD.getEntity((byte)1, (String)object);
            if (entity.getReplacementText() != null) continue;
            DTDUtil.addResolvedSourceURL(entity.getSystemId(), entity.getBase(), entity.getPublicId(), arrayList);
        }
        object = new URL[arrayList.size()];
        arrayList.toArray((T[])object);
        return object;
    }

    private static final void addResolvedSourceURL(String string, URL uRL, String string2, ArrayList arrayList) {
        URL uRL2 = null;
        try {
            URL uRL3 = XMLCatalogs.resolveEntity(string2, string, uRL);
            if (URLUtil.exists(uRL3)) {
                uRL2 = uRL3;
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (uRL2 != null) {
            arrayList.add(uRL2);
        }
    }

    public static String getGeneralEntities(DTD dTD) {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = dTD.entityNames((byte)0);
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            DTDUtil.appendEntityDecl(stringBuffer, string, dTD.getEntity((byte)0, string));
        }
        return stringBuffer.length() > 0 ? stringBuffer.toString() : null;
    }

    private static void appendEntityDecl(StringBuffer stringBuffer, String string, Entity entity) {
        stringBuffer.append("<!ENTITY ");
        stringBuffer.append(string);
        stringBuffer.append(' ');
        String string2 = entity.getReplacementText();
        if (string2 == null) {
            DTDUtil.appendExternalId(stringBuffer, entity);
            String string3 = entity.getNotationName();
            if (string3 != null) {
                stringBuffer.append(" NDATA ");
                stringBuffer.append(string3);
            }
        } else {
            stringBuffer.append('\"');
            int n = string2.length();
            int n2 = 0;
            while (n2 < n) {
                char c = string2.charAt(n2);
                switch (c) {
                    case '\r': 
                    case '\"': 
                    case '%': 
                    case '&': {
                        stringBuffer.append("&#");
                        stringBuffer.append((int)c);
                        stringBuffer.append(';');
                        break;
                    }
                    default: {
                        stringBuffer.append(c);
                    }
                }
                ++n2;
            }
            stringBuffer.append('\"');
        }
        stringBuffer.append(">\n");
    }

    private static void appendExternalId(StringBuffer stringBuffer, Entity entity) {
        String string;
        String string2 = entity.getPublicId();
        try {
            URL uRL = new URL(entity.getBase(), entity.getSystemId());
            string = uRL.toExternalForm();
        }
        catch (MalformedURLException malformedURLException) {
            string = entity.getSystemId();
        }
        if (string2 != null) {
            stringBuffer.append("PUBLIC \"");
            stringBuffer.append(string2);
            stringBuffer.append('\"');
        }
        if (string != null) {
            if (string2 == null) {
                stringBuffer.append("SYSTEM");
            }
            stringBuffer.append(' ');
            char c = string.indexOf(34) < 0 ? (char)'\"' : '\'';
            stringBuffer.append(c);
            stringBuffer.append(string);
            stringBuffer.append(c);
        }
    }
}

