/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.xsd.dtdtoxsd;

import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doctype.DocumentType;
import com.xmlmind.xmledit.doctype.DocumentTypeError;
import com.xmlmind.xmledit.doctype.DocumentTypeLoader;
import com.xmlmind.xmledit.util.Console;
import com.xmlmind.xmledit.xsd.dtdtoxsd.DTD;
import com.xmlmind.xmledit.xsd.dtdtoxsd.DTDLoader;
import com.xmlmind.xmledit.xsd.dtdtoxsd.DTDUtil;
import com.xmlmind.xmledit.xsd.dtdtoxsd.Msg;
import java.io.IOException;
import java.net.URL;

public class DocumentTypeLoaderImpl
implements DocumentTypeLoader {
    private static final ErrorImpl[] NO_ERRORS = new ErrorImpl[0];
    private DTDLoader loader = new DTDLoader();
    private Console console = null;
    private boolean noDocType = true;
    private URL docTypeURL = null;

    public void setDocumentTypeLoadConsole(Console console) {
        this.console = console;
    }

    public Console getDocumentTypeLoadConsole() {
        return this.console;
    }

    public DocumentType loadDocumentType(URL uRL, String string, String string2) throws IOException {
        this.noDocType = true;
        this.docTypeURL = null;
        DTD dTD = this.loader.load(uRL);
        this.noDocType = false;
        this.docTypeURL = uRL;
        return dTD;
    }

    public DocumentType loadDocumentTypeForInstance(Document document) throws IOException {
        Object object;
        this.noDocType = true;
        this.docTypeURL = null;
        com.jclark.xml.parse.DTD dTD = (com.jclark.xml.parse.DTD)document.getProperty("DTD");
        if (dTD == null || !DTDUtil.isGrammar(dTD)) {
            return null;
        }
        this.docTypeURL = DTDUtil.getExternalSubsetURL(dTD);
        if (this.docTypeURL == null) {
            this.docTypeURL = document.getLocation();
        }
        if (this.console != null) {
            String string = DTDUtil.getSystemId(dTD);
            if (string != null) {
                StringBuffer stringBuffer = new StringBuffer();
                String string2 = DTDUtil.getPublicId(dTD);
                if (string2 != null) {
                    stringBuffer.append("PUBLIC '");
                    stringBuffer.append(string2);
                    stringBuffer.append("' '");
                    stringBuffer.append(string);
                    stringBuffer.append('\'');
                } else {
                    stringBuffer.append("SYSTEM '");
                    stringBuffer.append(string);
                    stringBuffer.append('\'');
                }
                object = stringBuffer.toString();
            } else {
                object = "(internal subset in '" + this.docTypeURL + "')";
            }
            this.console.showMessage(Msg.msg("loadingDTD", object), 0);
        }
        object = this.loader.load(dTD);
        this.noDocType = false;
        return object;
    }

    public DocumentTypeError[] getDocumentTypeErrors() {
        return this.noDocType ? NO_ERRORS : this.toErrors(this.loader.getErrors());
    }

    public DocumentTypeError[] getDocumentTypeWarnings() {
        return this.noDocType ? NO_ERRORS : this.toErrors(this.loader.getWarnings());
    }

    private ErrorImpl[] toErrors(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return NO_ERRORS;
        }
        ErrorImpl[] errorImplArray = new ErrorImpl[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            errorImplArray[n] = new ErrorImpl(stringArray[n]);
            ++n;
        }
        return errorImplArray;
    }

    private class ErrorImpl
    implements DocumentTypeError {
        private String message;

        public ErrorImpl(String string) {
            this.message = string;
        }

        public URL getErrorLocation() {
            return DocumentTypeLoaderImpl.this.docTypeURL;
        }

        public int getErrorLineNumber() {
            return -1;
        }

        public int getErrorColumnNumber() {
            return -1;
        }

        public String getErrorMessage() {
            return this.message;
        }
    }
}

