/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.xsd.dtdtoxsd;

import com.jclark.xml.parse.EndPrologEvent;
import com.jclark.xml.parse.OpenEntity;
import com.jclark.xml.parse.StartElementEvent;
import com.jclark.xml.parse.io.ApplicationImpl;
import com.jclark.xml.parse.io.ParserImpl;
import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.DocumentLoader;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.TypedDocumentLoader;
import com.xmlmind.xmledit.util.FileUtil;
import com.xmlmind.xmledit.xsd.dtdtoxsd.DTD;
import com.xmlmind.xmledit.xsd.dtdtoxsd.DTDLoader;
import com.xmlmind.xmledit.xsd.dtdtoxsd.DTDUtil;
import com.xmlmind.xmledit.xsd.validate.DocumentationGenerator;
import com.xmlmind.xmledit.xsd.validate.SerializedSchemas;
import com.xmlmind.xmledit.xsd.validate.ValidationError;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;

public class Validate
implements TypedDocumentLoader {
    private DTDLoader dtdLoader = new DTDLoader();
    private DocumentLoader xmlDocLoader = new DocumentLoader();
    private boolean verbose = false;
    private DTD globalDTD = null;
    private String globalDTDPublicId = null;
    private SerializedSchemas inSchemas = null;
    private SerializedSchemas outSchemas = null;
    private File docDir = null;
    private String docCSS = null;
    private PrintWriter report;
    private SerializedSchemas.Entry serializedGlobalDTDEntry = null;
    private DTD localDTD = null;

    public static void main(final String[] stringArray) {
        Thread thread = new Thread(){

            public void run() {
                Validate validate = new Validate();
                validate.run(stringArray);
            }
        };
        thread.start();
    }

    private static void usage() {
        System.out.println("usage: java com.xmlmind.xmledit.xsd.dtdtoxsd.Validate ?options? ?xml_doc ... xml_doc?\nOptions are:\n  -o <file> Generate report in file <file>.\n        Default: output report to console.\n  -d <dtd> Use DTD <dtd> to validate XML documents.\n        Default: use DTD specified in the XML document.\n  -dd <pubid> <dtd> Same as '-d' except that first\n        parameter specifies the public ID of the DTD.\n        This public ID is mandatory if the DTD is\n        to be serialized or deserialized.\n  -r <dir> Load serialized DTDs from directory <dir>\n        if found there, otherwise load DTDs from\n        their XML sources.\n  -w <dir> Serialize loaded DTDs to directory <dir>.\n  -gendoc <dir> Generate documentation in directory <dir>.\n  -css <URL> Add link to specified CSS URL in generated\n        documentation.\n  -v Be verbose. Default: be quiet.\n");
        System.exit(1);
    }

    private Validate() {
        this.xmlDocLoader.setTypedDocumentLoader(this);
        this.xmlDocLoader.setNamespaceMode(0);
        this.xmlDocLoader.setAddedProperties(35);
    }

    private void run(String[] stringArray) {
        int n = this.configure(stringArray);
        int n2 = 0;
        int n3 = n;
        while (n3 < stringArray.length) {
            if (!this.validate(stringArray[n3])) {
                n2 = 3;
            }
            ++n3;
        }
        this.report.flush();
        this.report.close();
        System.exit(n2);
    }

    private int configure(String[] stringArray) {
        Object object;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        int n = 0;
        while (n < stringArray.length) {
            object = stringArray[n];
            if ("-o".equals(object)) {
                if (n + 1 >= stringArray.length) {
                    Validate.usage();
                }
                string = stringArray[++n];
            } else if ("-d".equals(object)) {
                if (n + 1 >= stringArray.length) {
                    Validate.usage();
                }
                string2 = stringArray[++n];
            } else if ("-dd".equals(object)) {
                if (n + 2 >= stringArray.length) {
                    Validate.usage();
                }
                this.globalDTDPublicId = stringArray[++n];
                string2 = stringArray[++n];
            } else if ("-r".equals(object)) {
                if (n + 1 >= stringArray.length) {
                    Validate.usage();
                }
                string3 = stringArray[++n];
            } else if ("-w".equals(object)) {
                if (n + 1 >= stringArray.length) {
                    Validate.usage();
                }
                string4 = stringArray[++n];
            } else if ("-gendoc".equals(object)) {
                if (n + 1 >= stringArray.length) {
                    Validate.usage();
                }
                this.docDir = new File(stringArray[++n]);
                if (!this.docDir.isDirectory()) {
                    Validate.usage();
                }
            } else if ("-css".equals(object)) {
                if (n + 1 >= stringArray.length) {
                    Validate.usage();
                }
                this.docCSS = stringArray[++n].trim();
                if (this.docCSS.length() == 0) {
                    Validate.usage();
                }
            } else if ("-v".equals(object)) {
                this.verbose = true;
            } else {
                if (((String)object).indexOf(45) != 0) break;
                Validate.usage();
            }
            ++n;
        }
        object = null;
        if (string == null) {
            object = System.out;
        } else {
            try {
                object = new FileOutputStream(string);
            }
            catch (IOException iOException) {
                System.err.println("cannot create '" + string + "': " + iOException.getMessage());
                System.exit(1);
            }
        }
        this.report = new PrintWriter((OutputStream)object);
        if (string3 != null) {
            try {
                this.inSchemas = new SerializedSchemas(string3);
            }
            catch (Exception exception) {
                System.err.println("cannot initialize serialized schemas '" + string3 + "': " + exception.getMessage());
                System.exit(1);
            }
        }
        if (string4 != null) {
            File file = new File(string4);
            try {
                this.outSchemas = this.inSchemas != null && this.inSchemas.getDirectory().getCanonicalPath().equals(file.getCanonicalPath()) ? this.inSchemas : new SerializedSchemas(file);
            }
            catch (Exception exception) {
                System.err.println("cannot initialize serialized schemas '" + string4 + "': " + exception.getMessage());
                System.exit(1);
            }
        }
        if (string2 != null) {
            this.globalDTD = this.deserializeGlobalDTD();
            if (this.globalDTD == null) {
                this.globalDTD = this.parseGlobalDTD(string2);
            }
            if (this.globalDTD == null) {
                this.report.flush();
                this.report.close();
                System.exit(2);
            }
            if (this.docDir != null) {
                if (!this.generateDocumentation(this.globalDTD, this.docDir) && n >= stringArray.length) {
                    this.report.flush();
                    this.report.close();
                    System.exit(2);
                }
                this.docDir = null;
            }
        }
        return n;
    }

    private boolean generateDocumentation(DTD dTD, File file) {
        long l = 0L;
        if (this.verbose) {
            System.err.print("Generating documentation in '" + file + "'");
            l = System.currentTimeMillis();
        }
        DocumentationGenerator documentationGenerator = new DocumentationGenerator(dTD);
        if (this.docCSS != null) {
            documentationGenerator.setCSS(this.docCSS);
        }
        boolean bl = false;
        try {
            documentationGenerator.generateAll(file);
            bl = true;
        }
        catch (IOException iOException) {
            System.err.println("cannot generate documentation in '" + file + "': " + iOException.getMessage());
        }
        if (this.verbose) {
            l = System.currentTimeMillis() - l;
            System.err.println(" (" + l + "ms)");
        }
        return bl;
    }

    private DTD deserializeGlobalDTD() {
        SerializedSchemas.Entry entry;
        if (this.inSchemas == null || this.globalDTDPublicId == null || (entry = this.inSchemas.get(this.globalDTDPublicId)) == null) {
            this.serializedGlobalDTDEntry = null;
            return null;
        }
        long l = 0L;
        if (this.verbose) {
            System.err.print("Deserializing global DTD '" + this.globalDTDPublicId + "'");
            l = System.currentTimeMillis();
        }
        DTD dTD = null;
        try {
            dTD = (DTD)entry.loadSchema();
        }
        catch (Exception exception) {
            System.err.println("cannot deserialize global DTD '" + this.globalDTDPublicId + "': " + exception.getClass().getName() + ": " + exception.getMessage());
        }
        if (this.verbose) {
            l = System.currentTimeMillis() - l;
            System.err.println(" (" + l + "ms)");
        }
        if (dTD != null) {
            this.serializedGlobalDTDEntry = entry;
        }
        return dTD;
    }

    private DTD parseGlobalDTD(String string) {
        final com.jclark.xml.parse.DTD[] dTDArray = new com.jclark.xml.parse.DTD[1];
        ParserImpl parserImpl = new ParserImpl();
        parserImpl.setApplication(new ApplicationImpl(){

            public void endProlog(EndPrologEvent endPrologEvent) throws IOException {
                dTDArray[0] = endPrologEvent.getDTD();
            }
        });
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<?xml version='1.0' encoding='UTF-8' ?>\n");
        if (this.globalDTDPublicId == null) {
            stringBuffer.append("<!DOCTYPE dummy SYSTEM ");
        } else {
            stringBuffer.append("<!DOCTYPE dummy PUBLIC '" + this.globalDTDPublicId + "' ");
        }
        String string2 = FileUtil.fileToURL(string).toExternalForm();
        char c = string2.indexOf(34) < 0 ? (char)'\"' : '\'';
        stringBuffer.append(c);
        stringBuffer.append(string2);
        stringBuffer.append(c);
        stringBuffer.append(">\n");
        stringBuffer.append("<dummy/>\n");
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(stringBuffer.toString().getBytes("UTF8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        URL uRL = FileUtil.fileToURL("bytes");
        OpenEntity openEntity = new OpenEntity(byteArrayInputStream, uRL.toExternalForm(), uRL);
        long l = 0L;
        if (this.verbose) {
            System.err.print("Loading global DTD '" + string + "'");
            l = System.currentTimeMillis();
        }
        try {
            parserImpl.parseDocument(openEntity);
        }
        catch (IOException iOException) {
            System.err.println("cannot load '" + string + "': " + iOException.getMessage());
            return null;
        }
        if (this.verbose) {
            l = System.currentTimeMillis() - l;
            System.err.println(" (" + l + "ms)");
        }
        if (!DTDUtil.isGrammar(dTDArray[0])) {
            System.err.println("DTD '" + string + "' does not declare any element");
            return null;
        }
        l = 0L;
        if (this.verbose) {
            System.err.print("Converting global DTD '" + string + "' to schema");
            l = System.currentTimeMillis();
        }
        DTD dTD = this.dtdLoader.load(dTDArray[0]);
        if (this.verbose) {
            l = System.currentTimeMillis() - l;
            System.err.println(" (" + l + "ms)");
        }
        this.reportDTDErrors(this.dtdLoader, string);
        if (dTD != null) {
            this.serializeDTD(dTD, dTDArray[0]);
        }
        return dTD;
    }

    private void reportDTDErrors(DTDLoader dTDLoader, String string) {
        String[] stringArray;
        String[] stringArray2 = dTDLoader.getErrors();
        if (stringArray2.length > 0) {
            this.docDir = null;
            int n = 0;
            while (n < stringArray2.length) {
                this.report.print(string);
                this.report.print(":E::: ");
                this.report.println(stringArray2[n]);
                ++n;
            }
        }
        if ((stringArray = dTDLoader.getWarnings()).length > 0) {
            int n = 0;
            while (n < stringArray.length) {
                this.report.print(string);
                this.report.print(":W::: ");
                this.report.println(stringArray[n]);
                ++n;
            }
            this.report.println();
        }
    }

    private boolean validate(String string) {
        DTD dTD;
        boolean bl;
        this.localDTD = null;
        Document document = null;
        try {
            long l = 0L;
            if (this.verbose) {
                System.err.print("Loading XML document '" + string + "'");
                l = System.currentTimeMillis();
            }
            document = this.xmlDocLoader.load(new File(string));
            if (this.verbose) {
                l = System.currentTimeMillis() - l;
                System.err.println(" (" + l + "ms)");
            }
        }
        catch (IOException iOException) {
            System.err.println("cannot load '" + string + "': " + iOException.getMessage());
            return false;
        }
        if (this.globalDTD != null) {
            bl = false;
            dTD = this.globalDTD;
        } else {
            bl = true;
            dTD = this.localDTD;
            if (dTD == null) {
                dTD = this.parseLocalDTD(document);
            }
            if (dTD == null) {
                return false;
            }
            if (this.docDir != null) {
                this.generateDocumentation(dTD, this.docDir);
                this.docDir = null;
            }
        }
        long l = 0L;
        if (this.verbose) {
            System.err.print("Validating '" + string + "'");
            l = System.currentTimeMillis();
        }
        ValidationError[] validationErrorArray = dTD.validate(document, bl);
        if (this.verbose) {
            l = System.currentTimeMillis() - l;
            System.err.println(" (" + l + "ms)");
        }
        if (validationErrorArray.length > 0) {
            int n = 0;
            while (n < validationErrorArray.length) {
                String string2;
                String string3;
                String string4;
                ValidationError validationError = validationErrorArray[n];
                Element element = validationError.element;
                URL uRL = element.getLocation();
                int[] nArray = (int[])element.getProperty("LINE_COLUMN");
                String string5 = string4 = uRL == null ? "" : uRL.toString();
                if (nArray == null) {
                    string3 = "";
                    string2 = "";
                } else {
                    string2 = Integer.toString(nArray[0]);
                    string3 = Integer.toString(nArray[1]);
                }
                this.report.print(string4);
                this.report.print(":E:");
                this.report.print(string2);
                this.report.print(':');
                this.report.print(string3);
                this.report.print(": ");
                this.report.print(validationError.message);
                if (validationError.constraint != null) {
                    this.report.print(" [");
                    this.report.print(validationError.constraint);
                    this.report.println(']');
                }
                ++n;
            }
            this.report.println();
            return false;
        }
        return true;
    }

    private DTD parseLocalDTD(Document document) {
        String string;
        com.jclark.xml.parse.DTD dTD = (com.jclark.xml.parse.DTD)document.getProperty("DTD");
        if (dTD == null || !DTDUtil.isGrammar(dTD)) {
            System.err.println("'" + document.getLocation() + "' has no DTD or its DTD does not declare any element");
            return null;
        }
        long l = 0L;
        if (this.verbose) {
            System.err.print("Converting DTD local to '" + document.getLocation() + "' to schema");
            l = System.currentTimeMillis();
        }
        DTD dTD2 = this.dtdLoader.load(dTD);
        if (this.verbose) {
            l = System.currentTimeMillis() - l;
            System.err.println(" (" + l + "ms)");
        }
        String string2 = (string = DTDUtil.getSystemId(dTD)) == null ? "[DTD internal subset] " + document.getLocation() : string;
        this.reportDTDErrors(this.dtdLoader, string2);
        if (dTD2 != null) {
            this.serializeDTD(dTD2, dTD);
        }
        return dTD2;
    }

    private void serializeDTD(DTD dTD, com.jclark.xml.parse.DTD dTD2) {
        if (this.outSchemas == null) {
            return;
        }
        String string = dTD.getPublicId();
        if (string == null) {
            return;
        }
        String string2 = DTDUtil.getGeneralEntities(dTD2);
        try {
            long l = 0L;
            if (this.verbose) {
                System.err.print("Serializing DTD '" + string + "'");
                l = System.currentTimeMillis();
            }
            this.outSchemas.save(string, dTD, string2);
            if (this.verbose) {
                l = System.currentTimeMillis() - l;
                System.err.println(" (" + l + "ms)");
            }
        }
        catch (IOException iOException) {
            System.err.print("cannot serialize DTD '" + string + "': " + iOException.getMessage());
        }
    }

    public OpenEntity openExternalDTDSubset(String string, URL uRL, String string2) throws IOException {
        SerializedSchemas.Entry entry;
        if (this.globalDTD != null) {
            if (this.serializedGlobalDTDEntry != null) {
                return DTDUtil.toOpenEntity(this.serializedGlobalDTDEntry.getGeneralEntitiesURL());
            }
            return null;
        }
        if (this.inSchemas == null || string2 == null || (entry = this.inSchemas.get(string2)) == null) {
            return null;
        }
        long l = 0L;
        if (this.verbose) {
            System.err.print(" [[[Deserializing local DTD '" + string2 + "'");
            l = System.currentTimeMillis();
        }
        try {
            this.localDTD = (DTD)entry.loadSchema();
        }
        catch (Exception exception) {
            System.err.println("cannot deserialize local DTD '" + string2 + "': " + exception.getClass().getName() + ": " + exception.getMessage());
        }
        if (this.verbose) {
            l = System.currentTimeMillis() - l;
            System.err.print(" (" + l + "ms)]]]");
        }
        return DTDUtil.toOpenEntity(entry.getGeneralEntitiesURL());
    }

    public void startRootElement(Document document, boolean bl, StartElementEvent startElementEvent) throws IOException {
    }

    public String getDocumentElementEntityName() {
        return null;
    }
}

