/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.xsd.load;

import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xsd.datatype.DataType;
import com.xmlmind.xmledit.xsd.datatype.IDType;
import com.xmlmind.xmledit.xsd.datatype.InvalidDataException;
import com.xmlmind.xmledit.xsd.datatype.InvalidTypeException;
import com.xmlmind.xmledit.xsd.datatype.ListType;
import com.xmlmind.xmledit.xsd.datatype.NOTATIONType;
import com.xmlmind.xmledit.xsd.datatype.Restriction;
import com.xmlmind.xmledit.xsd.datatype.UnionType;
import com.xmlmind.xmledit.xsd.load.AllInfo;
import com.xmlmind.xmledit.xsd.load.AnyAttributeInfo;
import com.xmlmind.xmledit.xsd.load.AttributeGroupInfo;
import com.xmlmind.xmledit.xsd.load.AttributeInfo;
import com.xmlmind.xmledit.xsd.load.ChoiceInfo;
import com.xmlmind.xmledit.xsd.load.ComplexContentInfo;
import com.xmlmind.xmledit.xsd.load.ElementInfo;
import com.xmlmind.xmledit.xsd.load.ExtensionInfo;
import com.xmlmind.xmledit.xsd.load.FacetInfo;
import com.xmlmind.xmledit.xsd.load.GroupInfo;
import com.xmlmind.xmledit.xsd.load.Info;
import com.xmlmind.xmledit.xsd.load.LoadContext;
import com.xmlmind.xmledit.xsd.load.LoadState;
import com.xmlmind.xmledit.xsd.load.Msg;
import com.xmlmind.xmledit.xsd.load.RestrictionInfo;
import com.xmlmind.xmledit.xsd.load.SchemaErrors;
import com.xmlmind.xmledit.xsd.load.SchemaInfo;
import com.xmlmind.xmledit.xsd.load.SequenceInfo;
import com.xmlmind.xmledit.xsd.load.SimpleContentInfo;
import com.xmlmind.xmledit.xsd.load.SimpleTypeInfo;
import com.xmlmind.xmledit.xsd.load.TypeInfo;
import com.xmlmind.xmledit.xsd.validate.AllParticle;
import com.xmlmind.xmledit.xsd.validate.AttributeDeclaration;
import com.xmlmind.xmledit.xsd.validate.AttributeUse;
import com.xmlmind.xmledit.xsd.validate.ChoiceParticle;
import com.xmlmind.xmledit.xsd.validate.ComplexType;
import com.xmlmind.xmledit.xsd.validate.ElementDeclaration;
import com.xmlmind.xmledit.xsd.validate.ElementParticle;
import com.xmlmind.xmledit.xsd.validate.NameWildcard;
import com.xmlmind.xmledit.xsd.validate.Particle;
import com.xmlmind.xmledit.xsd.validate.Schema;
import com.xmlmind.xmledit.xsd.validate.SequenceParticle;
import com.xmlmind.xmledit.xsd.validate.SimpleType;
import com.xmlmind.xmledit.xsd.validate.Type;
import com.xmlmind.xmledit.xsd.validate.Wildcard;
import com.xmlmind.xmledit.xsd.validate.WildcardParticle;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

final class ComplexTypeInfo
extends TypeInfo {
    public boolean abstract_ = false;
    public int block = 0;
    public int final_ = 0;
    public boolean mixed = false;
    public boolean isSimpleContent = false;
    public boolean isExtension = false;
    public Name base = null;
    public SimpleTypeInfo baseTypeInfo = null;
    public FacetInfo[] facetInfo = null;
    public Info particleInfo = null;
    public AttributeInfo[] attributeInfo = null;
    public AttributeGroupInfo[] attributeGroupInfo = null;
    public AnyAttributeInfo anyAttributeInfo = null;
    private static final Name[] NO_NAMES = new Name[0];
    private static final SequenceParticle EMPTY_SEQUENCE = new SequenceParticle(new Particle[0], 1, 1);
    private ComplexType created = null;
    private Name[] prohibitedAttributeNames = NO_NAMES;
    private Name[] referencedGlobalElementNames = NO_NAMES;
    private byte finished = (byte)-1;

    public ComplexTypeInfo(Info info) {
        super(info);
    }

    public void add(AttributeInfo attributeInfo) {
        if (this.attributeInfo == null) {
            this.attributeInfo = new AttributeInfo[]{attributeInfo};
            return;
        }
        AttributeInfo[] attributeInfoArray = new AttributeInfo[this.attributeInfo.length + 1];
        System.arraycopy(this.attributeInfo, 0, attributeInfoArray, 0, this.attributeInfo.length);
        attributeInfoArray[this.attributeInfo.length] = attributeInfo;
        this.attributeInfo = attributeInfoArray;
    }

    public void add(AttributeGroupInfo attributeGroupInfo) {
        if (this.attributeGroupInfo == null) {
            this.attributeGroupInfo = new AttributeGroupInfo[]{attributeGroupInfo};
            return;
        }
        AttributeGroupInfo[] attributeGroupInfoArray = new AttributeGroupInfo[this.attributeGroupInfo.length + 1];
        System.arraycopy(this.attributeGroupInfo, 0, attributeGroupInfoArray, 0, this.attributeGroupInfo.length);
        attributeGroupInfoArray[this.attributeGroupInfo.length] = attributeGroupInfo;
        this.attributeGroupInfo = attributeGroupInfoArray;
    }

    public void add(FacetInfo facetInfo) {
        if (this.facetInfo == null) {
            this.facetInfo = new FacetInfo[]{facetInfo};
            return;
        }
        FacetInfo[] facetInfoArray = new FacetInfo[this.facetInfo.length + 1];
        System.arraycopy(this.facetInfo, 0, facetInfoArray, 0, this.facetInfo.length);
        facetInfoArray[this.facetInfo.length] = facetInfo;
        this.facetInfo = facetInfoArray;
    }

    public void init(Element element, SchemaInfo schemaInfo, LoadContext loadContext, SchemaErrors schemaErrors, SchemaErrors schemaErrors2) {
        super.init(element, schemaInfo, loadContext, schemaErrors, schemaErrors2);
        this.name = Info.getNCNameAttribute(element, Info._NAME, schemaInfo.targetNamespace, null);
        this.abstract_ = Info.getBooleanAttribute(element, Info._ABSTRACT, false);
        this.block = Info.getBlockAttribute(element, Info._BLOCK, schemaInfo.blockDefault);
        this.final_ = Info.getFinalAttribute(element, Info._FINAL, schemaInfo.finalDefault);
        this.mixed = Info.getBooleanAttribute(element, Info._MIXED, false);
        boolean bl = true;
        Node node = element.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 4) {
                Element element2 = (Element)node;
                Name name = element2.getName();
                if (name == Info.XSD_SEQUENCE) {
                    this.particleInfo = new SequenceInfo(this);
                    this.particleInfo.init(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
                    break;
                }
                if (name == Info.XSD_CHOICE) {
                    this.particleInfo = new ChoiceInfo(this);
                    this.particleInfo.init(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
                    break;
                }
                if (name == Info.XSD_ALL) {
                    this.particleInfo = new AllInfo(this);
                    this.particleInfo.init(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
                    break;
                }
                if (name == Info.XSD_GROUP) {
                    this.particleInfo = new GroupInfo(this);
                    this.particleInfo.init(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
                    break;
                }
                if (name == Info.XSD_COMPLEX_CONTENT) {
                    bl = false;
                    this.isSimpleContent = false;
                    this.initComplexContent(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
                    break;
                }
                if (name == Info.XSD_SIMPLE_CONTENT) {
                    bl = false;
                    this.isSimpleContent = true;
                    this.initSimpleContent(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
                    break;
                }
            }
            node = node.getNextSibling();
        }
        if (bl) {
            this.isSimpleContent = false;
            this.isExtension = false;
            this.base = Info.XSD_ANY_TYPE;
            this.initAttributeUse(this, element, schemaInfo, loadContext, schemaErrors, schemaErrors2);
        }
    }

    private void initSimpleContent(Element element, SchemaInfo schemaInfo, LoadContext loadContext, SchemaErrors schemaErrors, SchemaErrors schemaErrors2) {
        SimpleContentInfo simpleContentInfo = new SimpleContentInfo(this);
        simpleContentInfo.init(element, schemaInfo, loadContext, schemaErrors, schemaErrors2);
        Element element2 = Info.getChild(element, Info.XSD_RESTRICTION);
        if (element2 != null) {
            this.isExtension = false;
            this.initSimpleRestriction(simpleContentInfo, element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
        } else {
            element2 = Info.getChild(element, Info.XSD_EXTENSION);
            if (element2 != null) {
                this.isExtension = true;
                this.initSimpleExtension(simpleContentInfo, element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
            }
        }
    }

    private void initSimpleRestriction(SimpleContentInfo simpleContentInfo, Element element, SchemaInfo schemaInfo, LoadContext loadContext, SchemaErrors schemaErrors, SchemaErrors schemaErrors2) {
        RestrictionInfo restrictionInfo = new RestrictionInfo(simpleContentInfo);
        restrictionInfo.init(element, schemaInfo, loadContext, schemaErrors, schemaErrors2);
        this.base = this.getQNameAttribute(element, Info._BASE, null);
        if (this.base != null) {
            this.checkImportedNamespaces(this.base, schemaInfo, schemaErrors2);
        }
        Node node = element.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 4) {
                Element element2 = (Element)node;
                Name name = element2.getName();
                if (name == Info.XSD_SIMPLE_TYPE) {
                    this.baseTypeInfo = new SimpleTypeInfo(restrictionInfo);
                    this.baseTypeInfo.init(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
                } else {
                    String string;
                    Info.NameToFacetEntry nameToFacetEntry = (Info.NameToFacetEntry)Info.nameToFacet.get(name);
                    if (nameToFacetEntry != null && (string = element2.getAttribute(Info._VALUE)) != null) {
                        boolean bl = Info.getBooleanAttribute(element2, Info._FIXED, false);
                        FacetInfo facetInfo = new FacetInfo(restrictionInfo, nameToFacetEntry.facet, string, bl);
                        facetInfo.init(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
                        this.add(facetInfo);
                    }
                }
            }
            node = node.getNextSibling();
        }
        this.initAttributeUse(restrictionInfo, element, schemaInfo, loadContext, schemaErrors, schemaErrors2);
    }

    private void initSimpleExtension(SimpleContentInfo simpleContentInfo, Element element, SchemaInfo schemaInfo, LoadContext loadContext, SchemaErrors schemaErrors, SchemaErrors schemaErrors2) {
        ExtensionInfo extensionInfo = new ExtensionInfo(simpleContentInfo);
        extensionInfo.init(element, schemaInfo, loadContext, schemaErrors, schemaErrors2);
        this.base = this.getQNameAttribute(element, Info._BASE, null);
        if (this.base != null) {
            this.checkImportedNamespaces(this.base, schemaInfo, schemaErrors2);
        }
        this.initAttributeUse(extensionInfo, element, schemaInfo, loadContext, schemaErrors, schemaErrors2);
    }

    private void initComplexContent(Element element, SchemaInfo schemaInfo, LoadContext loadContext, SchemaErrors schemaErrors, SchemaErrors schemaErrors2) {
        ComplexContentInfo complexContentInfo = new ComplexContentInfo(this);
        complexContentInfo.init(element, schemaInfo, loadContext, schemaErrors, schemaErrors2);
        this.mixed = Info.getBooleanAttribute(element, Info._MIXED, false);
        Element element2 = Info.getChild(element, Info.XSD_RESTRICTION);
        if (element2 != null) {
            this.isExtension = false;
            this.initComplexRestriction(complexContentInfo, element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
        } else {
            element2 = Info.getChild(element, Info.XSD_EXTENSION);
            if (element2 != null) {
                this.isExtension = true;
                this.initComplexExtension(complexContentInfo, element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
            }
        }
    }

    private void initComplexExtension(ComplexContentInfo complexContentInfo, Element element, SchemaInfo schemaInfo, LoadContext loadContext, SchemaErrors schemaErrors, SchemaErrors schemaErrors2) {
        ExtensionInfo extensionInfo = new ExtensionInfo(complexContentInfo);
        extensionInfo.init(element, schemaInfo, loadContext, schemaErrors, schemaErrors2);
        this.doInitComplexContent(extensionInfo, element, schemaInfo, loadContext, schemaErrors, schemaErrors2);
    }

    private void initComplexRestriction(ComplexContentInfo complexContentInfo, Element element, SchemaInfo schemaInfo, LoadContext loadContext, SchemaErrors schemaErrors, SchemaErrors schemaErrors2) {
        RestrictionInfo restrictionInfo = new RestrictionInfo(complexContentInfo);
        restrictionInfo.init(element, schemaInfo, loadContext, schemaErrors, schemaErrors2);
        this.doInitComplexContent(restrictionInfo, element, schemaInfo, loadContext, schemaErrors, schemaErrors2);
    }

    private void doInitComplexContent(Info info, Element element, SchemaInfo schemaInfo, LoadContext loadContext, SchemaErrors schemaErrors, SchemaErrors schemaErrors2) {
        this.base = this.getQNameAttribute(element, Info._BASE, null);
        if (this.base != null) {
            this.checkImportedNamespaces(this.base, schemaInfo, schemaErrors2);
        }
        Node node = element.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 4) {
                Element element2 = (Element)node;
                Name name = element2.getName();
                if (name == Info.XSD_SEQUENCE) {
                    this.particleInfo = new SequenceInfo(info);
                    this.particleInfo.init(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
                    break;
                }
                if (name == Info.XSD_CHOICE) {
                    this.particleInfo = new ChoiceInfo(info);
                    this.particleInfo.init(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
                    break;
                }
                if (name == Info.XSD_ALL) {
                    this.particleInfo = new AllInfo(info);
                    this.particleInfo.init(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
                    break;
                }
                if (name == Info.XSD_GROUP) {
                    this.particleInfo = new GroupInfo(info);
                    this.particleInfo.init(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
                    break;
                }
            }
            node = node.getNextSibling();
        }
        this.initAttributeUse(info, element, schemaInfo, loadContext, schemaErrors, schemaErrors2);
    }

    private void initAttributeUse(Info info, Element element, SchemaInfo schemaInfo, LoadContext loadContext, SchemaErrors schemaErrors, SchemaErrors schemaErrors2) {
        Node node = element.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 4) {
                Info info2;
                Element element2 = (Element)node;
                Name name = element2.getName();
                if (name == Info.XSD_ATTRIBUTE) {
                    info2 = new AttributeInfo(info);
                    ((AttributeInfo)info2).init(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
                    this.add((AttributeInfo)info2);
                } else if (name == Info.XSD_ATTRIBUTE_GROUP) {
                    info2 = new AttributeGroupInfo(info);
                    ((AttributeGroupInfo)info2).init(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
                    this.add((AttributeGroupInfo)info2);
                } else if (name == Info.XSD_ANY_ATTRIBUTE) {
                    this.anyAttributeInfo = new AnyAttributeInfo(info);
                    this.anyAttributeInfo.init(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
                    break;
                }
            }
            node = node.getNextSibling();
        }
    }

    public Type toType(LoadState loadState) {
        ComplexType complexType = this.toComplexType(loadState);
        if (complexType == null || !this.toComplexType2(complexType, loadState)) {
            return null;
        }
        loadState.localComplexTypes.addElement(this);
        loadState.localComplexTypes.addElement(complexType);
        return complexType;
    }

    public ComplexType toComplexType(LoadState loadState) {
        if (this.created == null) {
            this.created = this.toComplexType1(loadState);
        }
        return this.created;
    }

    private ComplexType toComplexType1(LoadState loadState) {
        Type type = loadState.getType(this.base, this, "ct-props-correct.1");
        if (type == null) {
            return null;
        }
        int n = 0;
        if ((this.final_ & 2) != 0) {
            n |= 2;
        }
        if ((this.final_ & 1) != 0) {
            n |= 1;
        }
        int n2 = 0;
        if ((this.block & 2) != 0) {
            n2 |= 2;
        }
        if ((this.block & 1) != 0) {
            n2 |= 1;
        }
        ComplexType complexType = new ComplexType(this.name, type, this.isExtension ? 1 : 2, this.abstract_, n, n2);
        if (this.isSimpleContent ? !this.setSimpleContentType(complexType, loadState) : !this.setComplexContentType(complexType, loadState)) {
            return null;
        }
        return complexType;
    }

    private boolean setSimpleContentType(ComplexType complexType, LoadState loadState) {
        Type type = complexType.getBaseType();
        boolean bl = type instanceof SimpleType;
        if (!bl && type.getDataType() == null) {
            loadState.errors.append(this, "src-ct.2", "baseTypeHasNoDataType", type.getName().format(false, this));
            return false;
        }
        if (bl && !this.isExtension) {
            loadState.errors.append(this, "ct-props-correct.2", "cannotBeDerivedByRestriction", type.getName().format(false, this));
            return false;
        }
        if (this.isExtension) {
            complexType.setContentType(type.getDataType());
        } else {
            SimpleType simpleType;
            DataType dataType = null;
            if (this.baseTypeInfo != null) {
                simpleType = (SimpleType)this.baseTypeInfo.toType(loadState);
                if (simpleType != null) {
                    dataType = simpleType.getDataType();
                }
            } else {
                dataType = type.getDataType();
            }
            if (dataType == null) {
                return false;
            }
            simpleType = new SimpleType(null, (SimpleType)dataType.getProperties(), 2, false, 0, 0);
            DataType dataType2 = this.deriveDataType(dataType, simpleType, loadState);
            if (dataType2 == null || dataType2 instanceof NOTATIONType && !TypeInfo.checkNotations(dataType2, this, "ct-props-correct.1", loadState)) {
                return false;
            }
            simpleType.setDataType(dataType2);
            complexType.setContentType(dataType2);
        }
        return true;
    }

    private DataType deriveDataType(DataType dataType, SimpleType simpleType, LoadState loadState) {
        Restriction restriction = new Restriction(dataType);
        DataType dataType2 = null;
        try {
            if (this.facetInfo != null) {
                TypeInfo.applyFacets(restriction, this.facetInfo);
            }
            dataType2 = restriction.derive(simpleType);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            loadState.errors.append(this, "ct-props-correct.1", "cannotDeriveByRestriction", illegalArgumentException.getMessage());
            return null;
        }
        catch (InvalidDataException invalidDataException) {
            loadState.errors.append(this, "ct-props-correct.1", "cannotDeriveByRestriction2", invalidDataException.getMessage(), invalidDataException.getConstraint());
            return null;
        }
        catch (InvalidTypeException invalidTypeException) {
            loadState.errors.append(this, "ct-props-correct.1", "cannotDeriveByRestriction2", invalidTypeException.getMessage(), invalidTypeException.getConstraint());
            return null;
        }
        return dataType2;
    }

    private boolean setComplexContentType(ComplexType complexType, LoadState loadState) {
        Object object;
        Type type = complexType.getBaseType();
        if (type instanceof SimpleType) {
            loadState.errors.append(this, "src-ct.1", "baseTypeIsSimple", type.getName().format(false, this));
            return false;
        }
        Object object2 = null;
        if (this.particleInfo != null) {
            object = new Particle[1];
            if (!this.particleInfo.toParticle((Particle[])object, 0, loadState)) {
                return false;
            }
            object2 = object[0];
            if (object2 != null) {
                object2 = ((Particle)object2).simplify();
            }
        }
        if (this.mixed && object2 == null) {
            object2 = EMPTY_SEQUENCE;
        }
        if (this.isExtension) {
            object = (ComplexType)type;
            int n = ((ComplexType)object).getContentType();
            if (object2 == null) {
                switch (n) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        complexType.setContentType(((ComplexType)object).getDataType());
                        break;
                    }
                    default: {
                        complexType.setContentType(((ComplexType)object).getParticle(), n == 3);
                        break;
                    }
                }
            } else {
                switch (n) {
                    case 0: 
                    case 1: {
                        complexType.setContentType((Particle)object2, this.mixed);
                        break;
                    }
                    default: {
                        SequenceParticle sequenceParticle = new SequenceParticle(new Particle[]{((ComplexType)object).getParticle(), object2}, 1, 1);
                        complexType.setContentType(sequenceParticle, this.mixed);
                        break;
                    }
                }
            }
        } else if (object2 != null) {
            complexType.setContentType((Particle)object2, this.mixed);
        }
        return true;
    }

    public boolean toComplexType2(ComplexType complexType, LoadState loadState) {
        if (this.particleInfo != null) {
            if (!this.checkAllModelGroup(complexType, loadState)) {
                return false;
            }
            Hashtable hashtable = new Hashtable();
            if (!this.particleInfo.toParticle2(hashtable, loadState)) {
                return false;
            }
            Vector<Name> vector = new Vector<Name>();
            Enumeration enumeration = hashtable.elements();
            while (enumeration.hasMoreElements()) {
                ElementDeclaration elementDeclaration = (ElementDeclaration)enumeration.nextElement();
                if (elementDeclaration.getType() == null) {
                    vector.addElement(elementDeclaration.getName());
                    continue;
                }
                complexType.addElementDeclaration(elementDeclaration);
            }
            int n = vector.size();
            if (n > 0) {
                this.referencedGlobalElementNames = new Name[n];
                vector.copyInto(this.referencedGlobalElementNames);
            }
        }
        return this.setAttributeUses(complexType, loadState) && this.setAttributeWildcard(complexType, loadState);
    }

    private boolean checkAllModelGroup(ComplexType complexType, LoadState loadState) {
        boolean bl = true;
        Particle particle = complexType.getParticle();
        if (particle != null) {
            boolean bl2 = false;
            switch (particle.getType()) {
                case 0: {
                    bl2 = ComplexTypeInfo.containsAnAllParticle(((SequenceParticle)particle).getParticles());
                    break;
                }
                case 1: {
                    bl2 = ComplexTypeInfo.containsAnAllParticle(((ChoiceParticle)particle).getParticles());
                    break;
                }
                case 2: {
                    if (particle.getMaxOccurs() != 1) {
                        loadState.errors.append(this, "cos-all-limited.1", "allGroupLimited2");
                        bl = false;
                    }
                    Particle[] particleArray = ((AllParticle)particle).getParticles();
                    int n = 0;
                    while (n < particleArray.length) {
                        if (particleArray[n].getMaxOccurs() != 1) {
                            loadState.errors.append(this, "cos-all-limited.2", "allGroupLimited3");
                            bl = false;
                        }
                        ++n;
                    }
                    bl2 = ComplexTypeInfo.containsAnAllParticle(particleArray);
                }
            }
            if (bl2) {
                loadState.errors.append(this, "cos-all-limited.1", "allGroupLimited1");
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean containsAnAllParticle(Particle[] particleArray) {
        int n = 0;
        while (n < particleArray.length) {
            Particle particle = particleArray[n];
            switch (particle.getType()) {
                case 0: {
                    if (!ComplexTypeInfo.containsAnAllParticle(((SequenceParticle)particle).getParticles())) break;
                    return true;
                }
                case 1: {
                    if (!ComplexTypeInfo.containsAnAllParticle(((ChoiceParticle)particle).getParticles())) break;
                    return true;
                }
                case 2: {
                    return true;
                }
            }
            ++n;
        }
        return false;
    }

    private boolean setAttributeUses(ComplexType complexType, LoadState loadState) {
        int n;
        if (this.attributeInfo == null && this.attributeGroupInfo == null) {
            return true;
        }
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        if (this.attributeInfo != null) {
            n = 0;
            while (n < this.attributeInfo.length) {
                if (!this.attributeInfo[n].toAttributeUse(vector, vector2, complexType, loadState)) {
                    return false;
                }
                ++n;
            }
        }
        if (this.attributeGroupInfo != null) {
            n = 0;
            while (n < this.attributeGroupInfo.length) {
                if (!this.attributeGroupInfo[n].toAttributeUse(vector, vector2, complexType, loadState)) {
                    return false;
                }
                ++n;
            }
        }
        this.prohibitedAttributeNames = new Name[vector2.size()];
        vector2.copyInto(this.prohibitedAttributeNames);
        Object[] objectArray = new AttributeUse[vector.size()];
        vector.copyInto(objectArray);
        complexType.setAttributeUses((AttributeUse[])objectArray);
        return this.checkDuplicateAttributes(complexType, loadState) && this.checkIDAttributes(complexType, loadState);
    }

    private boolean checkDuplicateAttributes(ComplexType complexType, LoadState loadState) {
        AttributeUse[] attributeUseArray = complexType.getAttributeUses();
        int n = 0;
        while (n < attributeUseArray.length) {
            AttributeUse attributeUse = attributeUseArray[n];
            Name name = attributeUse.getName();
            boolean bl = false;
            int n2 = n + 1;
            while (n2 < attributeUseArray.length) {
                if (name == attributeUseArray[n2].getName()) {
                    bl = true;
                    break;
                }
                ++n2;
            }
            if (bl) {
                loadState.errors.append(this, "ct-props-correct.4", "duplicateAttributeUse", name.format(false, this));
                return false;
            }
            ++n;
        }
        return true;
    }

    private boolean checkIDAttributes(ComplexType complexType, LoadState loadState) {
        AttributeUse[] attributeUseArray = complexType.getAttributeUses();
        Name name = null;
        int n = 0;
        while (n < attributeUseArray.length) {
            AttributeUse attributeUse = attributeUseArray[n];
            Name name2 = attributeUse.getName();
            AttributeDeclaration attributeDeclaration = complexType.getAttributeDeclaration(name2);
            if (attributeDeclaration == null) {
                attributeDeclaration = loadState.schema.getAttributeDeclaration(name2);
            }
            if (attributeDeclaration.getDataType() instanceof IDType) {
                if (name == null) {
                    name = name2;
                } else {
                    loadState.errors.append(this, "ct-props-correct.5", "severalIDAttributes", name2.format(false, this), name.format(false, this));
                    return false;
                }
            }
            ++n;
        }
        return true;
    }

    private boolean setAttributeWildcard(ComplexType complexType, LoadState loadState) {
        if (this.anyAttributeInfo == null && this.attributeGroupInfo == null) {
            return true;
        }
        Vector<Wildcard> vector = new Vector<Wildcard>();
        if (this.anyAttributeInfo != null) {
            vector.addElement(this.anyAttributeInfo.wildcard);
        }
        if (this.attributeGroupInfo != null) {
            int n = 0;
            while (n < this.attributeGroupInfo.length) {
                if (!this.attributeGroupInfo[n].toAttributeWildcard(vector, loadState)) {
                    return false;
                }
                ++n;
            }
        }
        Wildcard wildcard = null;
        int n = vector.size();
        if (n > 0) {
            NameWildcard nameWildcard = null;
            int n2 = -1;
            int n3 = 0;
            while (n3 < n) {
                Wildcard wildcard2 = (Wildcard)vector.elementAt(n3);
                if (nameWildcard == null) {
                    nameWildcard = wildcard2.getNameWildcard();
                    n2 = wildcard2.getProcessContents();
                } else {
                    nameWildcard = wildcard2.getNameWildcard().intersection(nameWildcard);
                    if (nameWildcard == null) break;
                }
                ++n3;
            }
            if (nameWildcard == null) {
                loadState.errors.append(this, "src-ct.4", "badAttributeWilcardIntersection");
                return false;
            }
            wildcard = new Wildcard(nameWildcard, n2);
        }
        if (wildcard != null) {
            complexType.setAttributeWildcard(wildcard);
        }
        return true;
    }

    public boolean toComplexType3(ComplexType complexType, LoadState loadState) {
        Object object;
        if (this.finished != -1) {
            return this.finished == 1;
        }
        Type type = complexType.getBaseType();
        if (type == ComplexType.ANY) {
            this.finished = 1;
            return true;
        }
        if (type instanceof ComplexType && ((object = (ComplexTypeInfo)loadState.getTypeInfo(this.base, this, "ct-props-correct.1")) == null || !((ComplexTypeInfo)object).toComplexType3((ComplexType)type, loadState))) {
            this.finished = 0;
            return false;
        }
        if ((type.getProhibitedDerivations() & complexType.getDerivationMethod()) != 0) {
            if (this.isExtension) {
                loadState.errors.append(this, "cos-ct-extends", "prohibitedExtension");
            } else {
                loadState.errors.append(this, "derivation-ok-restriction", "prohibitedRestriction");
            }
            this.finished = 0;
            return false;
        }
        if (type instanceof ComplexType) {
            object = (ComplexType)type;
            if (this.isExtension && !this.checkExtension(complexType, (ComplexType)object, loadState) || !this.isExtension && !this.checkRestriction(complexType, (ComplexType)object, loadState)) {
                this.finished = 0;
                return false;
            }
        }
        this.finished = 1;
        return true;
    }

    private boolean checkExtension(ComplexType complexType, ComplexType complexType2, LoadState loadState) {
        Wildcard wildcard;
        Serializable serializable;
        AttributeUse[] attributeUseArray;
        Object object;
        Serializable[] serializableArray;
        int n = complexType2.getContentType();
        if (complexType.getParticle() != null && n != 0 && (complexType2.getParticle() == null || n != complexType.getContentType())) {
            loadState.errors.append(this, "cos-ct-extends.1.4.2", "invalidExtension");
            return false;
        }
        switch (n) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                serializableArray = complexType2.getElementFields();
                int n2 = 0;
                while (n2 < serializableArray.length) {
                    object = serializableArray[n2];
                    attributeUseArray = complexType2.getElementDeclaration((Name)object);
                    serializable = complexType.getElementDeclaration((Name)object);
                    Object object2 = attributeUseArray == null ? new ElementDeclaration((Name)object, null, null, false, false, 0, false) : attributeUseArray;
                    Object object3 = serializable == null ? (ComplexTypeInfo.containsName(this.referencedGlobalElementNames, (Name)object) ? new ElementDeclaration((Name)object, null, null, false, false, 0, false) : object2) : serializable;
                    if (!ElementInfo.checkConsistent(this, (ElementDeclaration)object3, (ElementDeclaration)object2, loadState)) {
                        return false;
                    }
                    if (serializable == null && attributeUseArray != null) {
                        complexType.addElementDeclaration((ElementDeclaration)attributeUseArray);
                    }
                    ++n2;
                }
                break block0;
            }
        }
        serializableArray = complexType2.getAttributeUses();
        if (serializableArray.length > 0) {
            Enumeration enumeration = complexType2.getAttributeDeclarations();
            while (enumeration.hasMoreElements()) {
                object = (AttributeDeclaration)enumeration.nextElement();
                complexType.addAttributeDeclaration((AttributeDeclaration)object);
            }
            object = complexType.getAttributeUses();
            if (((AttributeUse[])object).length == 0) {
                complexType.setAttributeUses((AttributeUse[])serializableArray);
            } else {
                attributeUseArray = new AttributeUse[serializableArray.length + ((Object)object).length];
                System.arraycopy(serializableArray, 0, attributeUseArray, 0, serializableArray.length);
                System.arraycopy(object, 0, attributeUseArray, serializableArray.length, ((Object)object).length);
                complexType.setAttributeUses(attributeUseArray);
                if (!this.checkDuplicateAttributes(complexType, loadState) || !this.checkIDAttributes(complexType, loadState)) {
                    return false;
                }
            }
        }
        if ((wildcard = complexType2.getAttributeWildcard()) != null) {
            object = complexType.getAttributeWildcard();
            if (object == null) {
                complexType.setAttributeWildcard(wildcard);
            } else {
                int n3 = ((Wildcard)object).getProcessContents();
                serializable = ((Wildcard)object).getNameWildcard().union(wildcard.getNameWildcard());
                if (serializable == null) {
                    loadState.errors.append(this, "src-ct.4", "badAttributeWilcardUnion");
                    return false;
                }
                complexType.setAttributeWildcard(new Wildcard((NameWildcard)serializable, n3));
            }
        }
        return true;
    }

    private boolean checkRestriction(ComplexType complexType, ComplexType complexType2, LoadState loadState) {
        return this.checkRestrictionAttributes(complexType, complexType2, loadState) && this.checkRestrictionContent(complexType, complexType2, loadState);
    }

    private boolean checkRestrictionAttributes(ComplexType complexType, ComplexType complexType2, LoadState loadState) {
        Serializable serializable;
        Serializable serializable2;
        Serializable serializable3;
        Object object;
        AttributeUse attributeUse;
        Serializable serializable4;
        AttributeUse[] attributeUseArray = complexType2.getAttributeUses();
        Wildcard wildcard = complexType2.getAttributeWildcard();
        NameWildcard nameWildcard = wildcard == null ? null : wildcard.getNameWildcard();
        Object object2 = complexType.getAttributeUses();
        int n = 0;
        while (n < ((AttributeUse[])object2).length) {
            serializable4 = object2[n];
            Name name = ((AttributeUse)serializable4).getName();
            attributeUse = ComplexTypeInfo.findAttributeUse(attributeUseArray, name);
            if (attributeUse != null) {
                if (attributeUse.isRequired() && !((AttributeUse)serializable4).isRequired()) {
                    loadState.errors.append(this, "derivation-ok-restriction.2.1.1", "invalidRestriction1", name.format(false, this));
                    return false;
                }
                object = complexType2.getAttributeDeclaration(name);
                if (object == null) {
                    object = loadState.schema.getAttributeDeclaration(name);
                }
                serializable3 = (SimpleType)((AttributeDeclaration)object).getDataType().getProperties();
                serializable2 = complexType.getAttributeDeclaration(name);
                if (serializable2 == null) {
                    serializable2 = loadState.schema.getAttributeDeclaration(name);
                }
                if (!((SimpleType)(serializable = (SimpleType)((AttributeDeclaration)serializable2).getDataType().getProperties())).isValidDerivation((Type)serializable3, 0)) {
                    loadState.errors.append(this, "derivation-ok-restriction.2.1.2", "invalidRestriction2", name.format(false, this));
                    return false;
                }
                if (!(!((AttributeDeclaration)object).isFixedValue() || ((AttributeDeclaration)serializable2).getDefaultValue() != null && ((AttributeDeclaration)serializable2).isFixedValue() && ((AttributeDeclaration)object).getDefaultValue().equals(((AttributeDeclaration)serializable2).getDefaultValue()))) {
                    loadState.errors.append(this, "derivation-ok-restriction.2.1.3", "invalidRestriction3", name.format(false, this), ((AttributeDeclaration)object).getDefaultValue());
                    return false;
                }
            } else if (nameWildcard == null || !nameWildcard.match(name)) {
                loadState.errors.append(this, "derivation-ok-restriction.2.2", "invalidRestriction4", name.format(false, this));
                return false;
            }
            ++n;
        }
        serializable4 = new Vector();
        int n2 = 0;
        while (n2 < attributeUseArray.length) {
            attributeUse = attributeUseArray[n2];
            object = attributeUse.getName();
            if (!ComplexTypeInfo.containsName(this.prohibitedAttributeNames, (Name)object) && ComplexTypeInfo.findAttributeUse(object2, (Name)object) == null) {
                serializable3 = complexType2.getAttributeDeclaration((Name)object);
                if (serializable3 != null) {
                    complexType.addAttributeDeclaration((AttributeDeclaration)serializable3);
                }
                ((Vector)serializable4).addElement(attributeUse);
            }
            ++n2;
        }
        int n3 = ((Vector)serializable4).size();
        if (n3 > 0) {
            object = new AttributeUse[n3 + ((AttributeUse[])object2).length];
            ((Vector)serializable4).copyInto((Object[])object);
            System.arraycopy(object2, 0, object, n3, ((AttributeUse[])object2).length);
            complexType.setAttributeUses((AttributeUse[])object);
            if (!this.checkIDAttributes(complexType, loadState)) {
                return false;
            }
            object2 = object;
        }
        int n4 = 0;
        while (n4 < attributeUseArray.length) {
            serializable3 = attributeUseArray[n4];
            if (((AttributeUse)serializable3).isRequired() && ((serializable = ComplexTypeInfo.findAttributeUse(object2, (Name)(serializable2 = ((AttributeUse)serializable3).getName()))) == null || !((AttributeUse)serializable).isRequired())) {
                loadState.errors.append(this, "derivation-ok-restriction.3", "invalidRestriction5", ((Name)serializable2).format(false, this));
                return false;
            }
            ++n4;
        }
        serializable3 = complexType.getAttributeWildcard();
        Serializable serializable5 = serializable2 = serializable3 == null ? null : ((Wildcard)serializable3).getNameWildcard();
        if (!(serializable2 == null || nameWildcard != null && ((NameWildcard)serializable2).isSubsetOf(nameWildcard))) {
            loadState.errors.append(this, "derivation-ok-restriction.4", "invalidRestriction6");
            return false;
        }
        return true;
    }

    private static AttributeUse findAttributeUse(AttributeUse[] attributeUseArray, Name name) {
        int n = 0;
        while (n < attributeUseArray.length) {
            if (attributeUseArray[n].getName() == name) {
                return attributeUseArray[n];
            }
            ++n;
        }
        return null;
    }

    private static boolean containsName(Name[] nameArray, Name name) {
        int n = 0;
        while (n < nameArray.length) {
            if (nameArray[n] == name) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean checkRestrictionContent(ComplexType complexType, ComplexType complexType2, LoadState loadState) {
        int n = complexType2.getContentType();
        int n2 = complexType.getContentType();
        switch (n2) {
            case 1: {
                String string = "";
                switch (n) {
                    case 1: {
                        SimpleType simpleType = (SimpleType)complexType2.getDataType().getProperties();
                        SimpleType simpleType2 = (SimpleType)complexType.getDataType().getProperties();
                        string = ComplexTypeInfo.validateSimpleTypeRestriction(simpleType2, simpleType);
                        break;
                    }
                    case 3: {
                        string = complexType2.getParticle().isEmptiable() ? null : Msg.msg("baseTypeParticleNotEmptiable");
                    }
                }
                if (string == null) break;
                if (string.length() == 0) {
                    loadState.errors.append(this, "derivation-ok-restriction.5.1", "invalidRestriction7");
                } else {
                    loadState.errors.append(this, "derivation-ok-restriction.5.1", "invalidRestriction", string);
                }
                return false;
            }
            case 0: {
                String string = "";
                switch (n) {
                    case 0: {
                        string = null;
                        break;
                    }
                    case 2: 
                    case 3: {
                        string = complexType2.getParticle().isEmptiable() ? null : Msg.msg("baseTypeParticleNotEmptiable");
                    }
                }
                if (string == null) break;
                if (string.length() == 0) {
                    loadState.errors.append(this, "derivation-ok-restriction.5.2", "invalidRestriction8");
                } else {
                    loadState.errors.append(this, "derivation-ok-restriction.5.2", "invalidRestriction", string);
                }
                return false;
            }
            default: {
                Object object = "";
                if (n == 3 || n2 == 2) {
                    String string;
                    Particle particle = complexType.getParticle();
                    Particle particle2 = complexType2.getParticle();
                    object = particle2 == null ? Msg.msg("baseTypeHasNoParticle") : ((string = ComplexTypeInfo.checkParticleRestriction(particle, particle2, complexType, complexType2, loadState.schema)) == null ? null : (string.length() == 0 ? Msg.msg("forbiddenParticleRestriction", particle.getTypeName(), particle2.getTypeName()) : Msg.msg("invalidParticleRestriction", particle.getTypeName(), particle2.getTypeName(), string)));
                }
                if (object == null) break;
                if (((String)object).length() == 0) {
                    loadState.errors.append(this, "derivation-ok-restriction.5.3", "invalidRestriction9");
                } else {
                    loadState.errors.append(this, "derivation-ok-restriction.5.3", "invalidRestriction", object);
                }
                return false;
            }
        }
        return true;
    }

    private static String validateSimpleTypeRestriction(SimpleType simpleType, SimpleType simpleType2) {
        if (simpleType2 == SimpleType.ANY) {
            return null;
        }
        if ((simpleType2.getProhibitedDerivations() & 2) != 0) {
            return Msg.msg("prohibitedRestriction");
        }
        DataType dataType = simpleType.getDataType();
        DataType dataType2 = simpleType2.getDataType();
        if (dataType instanceof ListType) {
            if (!(dataType2 instanceof ListType)) {
                return Msg.msg("wrongVariety", "list");
            }
            String string = ComplexTypeInfo.findMissingFacet(dataType2, dataType);
            if (string != null) {
                return Msg.msg("missingFacet", string);
            }
        } else if (dataType instanceof UnionType) {
            if (!(dataType2 instanceof UnionType)) {
                return Msg.msg("wrongVariety", "union");
            }
            String string = ComplexTypeInfo.findMissingFacet(dataType2, dataType);
            if (string != null) {
                return Msg.msg("missingFacet", string);
            }
        } else {
            if (dataType2 instanceof ListType || dataType2 instanceof UnionType) {
                return Msg.msg("wrongVariety", "atomic");
            }
            String string = ComplexTypeInfo.findMissingFacet(dataType2, dataType);
            if (string != null) {
                return Msg.msg("missingFacet", string);
            }
        }
        return null;
    }

    private static String findMissingFacet(DataType dataType, DataType dataType2) {
        int[] nArray = DataType.facetMasks;
        int n = 0;
        while (n < nArray.length) {
            int n2 = nArray[n];
            if (dataType.hasFacet(n2) && !dataType2.hasFacet(n2)) {
                return DataType.getFacetName(n2);
            }
            ++n;
        }
        return null;
    }

    private static String checkParticleRestriction(Particle particle, Particle particle2, ComplexType complexType, ComplexType complexType2, Schema schema) {
        String string = ComplexTypeInfo.doCheckParticleRestriction(particle, false, particle2, complexType, complexType2, schema);
        if (string != null) {
            Particle particle3;
            SequenceParticle sequenceParticle = new SequenceParticle(new Particle[]{particle}, 1, 1);
            if (ComplexTypeInfo.doCheckParticleRestriction(sequenceParticle, true, particle2, complexType, complexType2, schema) == null) {
                return null;
            }
            switch (particle.getType()) {
                case 3: {
                    particle3 = new ElementParticle(((ElementParticle)particle).getElementName(), 1, 1);
                    break;
                }
                case 4: {
                    particle3 = new WildcardParticle(((WildcardParticle)particle).getWildcard(), 1, 1);
                    break;
                }
                case 2: {
                    particle3 = new AllParticle(((AllParticle)particle).getParticles(), 1, 1);
                    break;
                }
                case 1: {
                    particle3 = new ChoiceParticle(((ChoiceParticle)particle).getParticles(), 1, 1);
                    break;
                }
                case 0: {
                    particle3 = new SequenceParticle(((SequenceParticle)particle).getParticles(), 1, 1);
                    break;
                }
                default: {
                    throw new RuntimeException("internal error");
                }
            }
            sequenceParticle = new SequenceParticle(new Particle[]{particle3}, particle.getMinOccurs(), particle.getMaxOccurs());
            if (ComplexTypeInfo.doCheckParticleRestriction(sequenceParticle, true, particle2, complexType, complexType2, schema) == null) {
                return null;
            }
        }
        return string;
    }

    private static String doCheckParticleRestriction(Particle particle, boolean bl, Particle particle2, ComplexType complexType, ComplexType complexType2, Schema schema) {
        String string = null;
        block0 : switch (particle.getType()) {
            case 3: {
                switch (particle2.getType()) {
                    case 3: {
                        string = ComplexTypeInfo.nameAndTypeOK((ElementParticle)particle, (ElementParticle)particle2, complexType, complexType2, schema);
                        break block0;
                    }
                    case 4: {
                        string = ComplexTypeInfo.nsCompat((ElementParticle)particle, (WildcardParticle)particle2, complexType, complexType2, schema);
                        break block0;
                    }
                    case 0: 
                    case 1: 
                    case 2: {
                        string = ComplexTypeInfo.recurseAsIfGroup((ElementParticle)particle, particle2, complexType, complexType2, schema);
                        break block0;
                    }
                }
                throw new RuntimeException("internal error");
            }
            case 4: {
                switch (particle2.getType()) {
                    case 4: {
                        string = ComplexTypeInfo.nsSubset((WildcardParticle)particle, (WildcardParticle)particle2, complexType, complexType2, schema);
                        break block0;
                    }
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        string = "";
                        break block0;
                    }
                }
                throw new RuntimeException("internal error");
            }
            case 2: {
                switch (particle2.getType()) {
                    case 4: {
                        string = ComplexTypeInfo.nsRecurseCheckCardinality(particle, bl, (WildcardParticle)particle2, complexType, complexType2, schema);
                        break block0;
                    }
                    case 2: {
                        string = ComplexTypeInfo.recurse(particle, bl, particle2, false, complexType, complexType2, schema);
                        break block0;
                    }
                    case 0: 
                    case 1: 
                    case 3: {
                        string = "";
                        break block0;
                    }
                }
                throw new RuntimeException("internal error");
            }
            case 1: {
                switch (particle2.getType()) {
                    case 4: {
                        string = ComplexTypeInfo.nsRecurseCheckCardinality(particle, bl, (WildcardParticle)particle2, complexType, complexType2, schema);
                        break block0;
                    }
                    case 1: {
                        string = ComplexTypeInfo.recurse(particle, bl, particle2, true, complexType, complexType2, schema);
                        break block0;
                    }
                    case 0: 
                    case 2: 
                    case 3: {
                        string = "";
                        break block0;
                    }
                }
                throw new RuntimeException("internal error");
            }
            case 0: {
                switch (particle2.getType()) {
                    case 3: {
                        string = "";
                        break block0;
                    }
                    case 4: {
                        string = ComplexTypeInfo.nsRecurseCheckCardinality(particle, bl, (WildcardParticle)particle2, complexType, complexType2, schema);
                        break block0;
                    }
                    case 2: {
                        string = ComplexTypeInfo.recurseUnordered((SequenceParticle)particle, bl, (AllParticle)particle2, complexType, complexType2, schema);
                        break block0;
                    }
                    case 1: {
                        string = ComplexTypeInfo.mapAndSum((SequenceParticle)particle, bl, (ChoiceParticle)particle2, complexType, complexType2, schema);
                        break block0;
                    }
                    case 0: {
                        string = ComplexTypeInfo.recurse(particle, bl, particle2, false, complexType, complexType2, schema);
                        break block0;
                    }
                }
                throw new RuntimeException("internal error");
            }
            default: {
                throw new RuntimeException("internal error");
            }
        }
        return string;
    }

    private static String nameAndTypeOK(ElementParticle elementParticle, ElementParticle elementParticle2, ComplexType complexType, ComplexType complexType2, Schema schema) {
        Object object;
        ElementDeclaration elementDeclaration;
        Name name = elementParticle.getElementName();
        if (name != elementParticle2.getElementName()) {
            return "rcase-NameAndTypeOK.1";
        }
        ElementDeclaration elementDeclaration2 = complexType.getElementDeclaration(name);
        if (elementDeclaration2 == null) {
            elementDeclaration2 = schema.getElementDeclaration(name);
        }
        if ((elementDeclaration = complexType2.getElementDeclaration(name)) == null) {
            elementDeclaration = schema.getElementDeclaration(name);
        }
        if (!elementDeclaration.isNillable() && elementDeclaration2.isNillable()) {
            return "rcase-NameAndTypeOK.2";
        }
        if (!ComplexTypeInfo.occurenceRangeOK(elementParticle, elementParticle2)) {
            return "rcase-NameAndTypeOK.3";
        }
        if (elementDeclaration.isFixedValue() && !elementDeclaration2.isFixedValue()) {
            return "rcase-NameAndTypeOK.4";
        }
        Object object2 = elementDeclaration.getDefaultValue();
        if (!(object2 == null || (object = elementDeclaration2.getDefaultValue()) != null && object2.equals(object))) {
            return "rcase-NameAndTypeOK.4";
        }
        int n = elementDeclaration2.getDisallowedSubtitutions();
        if ((n | elementDeclaration.getDisallowedSubtitutions()) != n) {
            return "rcase-NameAndTypeOK.6";
        }
        if (!elementDeclaration2.getType().isValidDerivation(elementDeclaration.getType(), 13)) {
            return "rcase-NameAndTypeOK.7";
        }
        return null;
    }

    private static boolean occurenceRangeOK(Particle particle, Particle particle2) {
        return ComplexTypeInfo.occurenceRangeOK(particle.getMinOccurs(), particle.getMaxOccurs(), particle2.getMinOccurs(), particle2.getMaxOccurs());
    }

    private static boolean occurenceRangeOK(int n, int n2, int n3, int n4) {
        if (n < n3) {
            return false;
        }
        if (n4 == -1) {
            return true;
        }
        return n2 != -1 && n2 <= n4;
    }

    private static String nsCompat(ElementParticle elementParticle, WildcardParticle wildcardParticle, ComplexType complexType, ComplexType complexType2, Schema schema) {
        if (!wildcardParticle.getWildcard().getNameWildcard().match(elementParticle.getElementName())) {
            return "rcase-NSCompat.1";
        }
        if (!ComplexTypeInfo.occurenceRangeOK(elementParticle, wildcardParticle)) {
            return "rcase-NSCompat.2";
        }
        return null;
    }

    private static String recurseAsIfGroup(ElementParticle elementParticle, Particle particle, ComplexType complexType, ComplexType complexType2, Schema schema) {
        Particle particle2;
        switch (particle.getType()) {
            case 0: {
                particle2 = new SequenceParticle(new Particle[]{elementParticle}, 1, 1);
                break;
            }
            case 2: {
                particle2 = new AllParticle(new Particle[]{elementParticle}, 1, 1);
                break;
            }
            case 1: {
                particle2 = new ChoiceParticle(new Particle[]{elementParticle}, 1, 1);
                break;
            }
            default: {
                throw new RuntimeException("internal error");
            }
        }
        return ComplexTypeInfo.checkParticleRestriction(particle2, particle, complexType, complexType2, schema);
    }

    private static String nsSubset(WildcardParticle wildcardParticle, WildcardParticle wildcardParticle2, ComplexType complexType, ComplexType complexType2, Schema schema) {
        if (!ComplexTypeInfo.occurenceRangeOK(wildcardParticle, wildcardParticle2)) {
            return "rcase-NSSubset.1";
        }
        if (!wildcardParticle.getWildcard().getNameWildcard().isSubsetOf(wildcardParticle2.getWildcard().getNameWildcard())) {
            return "rcase-NSSubset.2";
        }
        return null;
    }

    private static String nsRecurseCheckCardinality(Particle particle, boolean bl, WildcardParticle wildcardParticle, ComplexType complexType, ComplexType complexType2, Schema schema) {
        int n;
        Particle[] particleArray;
        switch (particle.getType()) {
            case 0: {
                particleArray = ((SequenceParticle)particle).getParticles();
                break;
            }
            case 2: {
                particleArray = ((AllParticle)particle).getParticles();
                break;
            }
            case 1: {
                particleArray = ((ChoiceParticle)particle).getParticles();
                break;
            }
            default: {
                throw new RuntimeException("internal error");
            }
        }
        int n2 = 0;
        while (n2 < particleArray.length) {
            String string = bl ? ComplexTypeInfo.doCheckParticleRestriction(particleArray[n2], false, wildcardParticle, complexType, complexType2, schema) : ComplexTypeInfo.checkParticleRestriction(particleArray[n2], wildcardParticle, complexType, complexType2, schema);
            if (string != null) {
                return "rcase-NSRecurseCheckCardinality.1";
            }
            ++n2;
        }
        int n3 = particle.rangeMin();
        if (!ComplexTypeInfo.occurenceRangeOK(n3, n = particle.rangeMax(), wildcardParticle.getMinOccurs(), wildcardParticle.getMaxOccurs())) {
            return "rcase-NSRecurseCheckCardinality.2";
        }
        return null;
    }

    private static String recurse(Particle particle, boolean bl, Particle particle2, boolean bl2, ComplexType complexType, ComplexType complexType2, Schema schema) {
        Particle[] particleArray;
        Particle[] particleArray2;
        if (!ComplexTypeInfo.occurenceRangeOK(particle, particle2)) {
            return "rcase-Recurse.1";
        }
        switch (particle.getType()) {
            case 0: {
                particleArray2 = ((SequenceParticle)particle).getParticles();
                particleArray = ((SequenceParticle)particle2).getParticles();
                break;
            }
            case 2: {
                particleArray2 = ((AllParticle)particle).getParticles();
                particleArray = ((AllParticle)particle2).getParticles();
                break;
            }
            case 1: {
                particleArray2 = ((ChoiceParticle)particle).getParticles();
                particleArray = ((ChoiceParticle)particle2).getParticles();
                break;
            }
            default: {
                throw new RuntimeException("internal error");
            }
        }
        int n = 0;
        int n2 = 0;
        while (n2 < particleArray2.length) {
            Particle particle3 = particleArray2[n2];
            boolean bl3 = false;
            while (n < particleArray.length) {
                Particle particle4 = particleArray[n];
                String string = bl ? ComplexTypeInfo.doCheckParticleRestriction(particle3, false, particle4, complexType, complexType2, schema) : ComplexTypeInfo.checkParticleRestriction(particle3, particle4, complexType, complexType2, schema);
                if (string == null) {
                    bl3 = true;
                    ++n;
                    break;
                }
                if (!bl2 && !particle4.isEmptiable()) {
                    return "rcase-Recurse.2.2";
                }
                ++n;
            }
            if (!bl3) {
                return "rcase-Recurse.2.1";
            }
            ++n2;
        }
        if (!bl2) {
            while (n < particleArray.length) {
                if (!particleArray[n].isEmptiable()) {
                    return "rcase-Recurse.2.2";
                }
                ++n;
            }
        }
        return null;
    }

    private static String recurseUnordered(SequenceParticle sequenceParticle, boolean bl, AllParticle allParticle, ComplexType complexType, ComplexType complexType2, Schema schema) {
        int n;
        if (!ComplexTypeInfo.occurenceRangeOK(sequenceParticle, allParticle)) {
            return "rcase-RecurseUnordered.1";
        }
        Particle[] particleArray = sequenceParticle.getParticles();
        Particle[] particleArray2 = allParticle.getParticles();
        Vector<Particle> vector = new Vector<Particle>();
        int n2 = 0;
        while (n2 < particleArray2.length) {
            vector.addElement(particleArray2[n2]);
            ++n2;
        }
        int n3 = 0;
        while (n3 < particleArray.length) {
            Particle particle = particleArray[n3];
            n = 0;
            int n4 = vector.size();
            int n5 = 0;
            while (n5 < n4) {
                Particle particle2 = (Particle)vector.elementAt(n5);
                String string = bl ? ComplexTypeInfo.doCheckParticleRestriction(particle, false, particle2, complexType, complexType2, schema) : ComplexTypeInfo.checkParticleRestriction(particle, particle2, complexType, complexType2, schema);
                if (string == null) {
                    n = 1;
                    vector.removeElementAt(n5);
                    break;
                }
                ++n5;
            }
            if (n == 0) {
                return "rcase-RecurseUnordered.2.2";
            }
            ++n3;
        }
        int n6 = vector.size();
        n = 0;
        while (n < n6) {
            Particle particle = (Particle)vector.elementAt(n);
            if (!particle.isEmptiable()) {
                return "rcase-RecurseUnordered.2.3";
            }
            ++n;
        }
        return null;
    }

    private static String mapAndSum(SequenceParticle sequenceParticle, boolean bl, ChoiceParticle choiceParticle, ComplexType complexType, ComplexType complexType2, Schema schema) {
        int n;
        Particle[] particleArray = sequenceParticle.getParticles();
        Particle[] particleArray2 = choiceParticle.getParticles();
        int n2 = 0;
        while (n2 < particleArray.length) {
            Particle particle = particleArray[n2];
            n = 0;
            int n3 = 0;
            while (n3 < particleArray2.length) {
                Particle particle2 = particleArray2[n3];
                String string = bl ? ComplexTypeInfo.doCheckParticleRestriction(particle, false, particle2, complexType, complexType2, schema) : ComplexTypeInfo.checkParticleRestriction(particle, particle2, complexType, complexType2, schema);
                if (string == null) {
                    n = 1;
                    break;
                }
                ++n3;
            }
            if (n == 0) {
                return "rcase-MapAndSum.1";
            }
            ++n2;
        }
        int n4 = sequenceParticle.getMinOccurs() * particleArray.length;
        n = sequenceParticle.getMaxOccurs();
        if (n != -1) {
            n *= particleArray.length;
        }
        if (!ComplexTypeInfo.occurenceRangeOK(n4, n, choiceParticle.getMinOccurs(), choiceParticle.getMaxOccurs())) {
            return "rcase-MapAndSum.2";
        }
        return null;
    }
}

