/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.xsd.load;

import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doctype.DocumentType;
import com.xmlmind.xmledit.doctype.DocumentTypeError;
import com.xmlmind.xmledit.doctype.DocumentTypeLoader2;
import com.xmlmind.xmledit.util.Console;
import com.xmlmind.xmledit.xmlutil.NamespaceURLPair;
import com.xmlmind.xmledit.xsd.load.Msg;
import com.xmlmind.xmledit.xsd.load.SchemaError;
import com.xmlmind.xmledit.xsd.load.SchemaLoader;
import com.xmlmind.xmledit.xsd.validate.Schema;
import com.xmlmind.xmledit.xsd.validate.SchemaUtil;
import com.xmlmind.xmledit.xsd.validate.XMLSchema;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

public class DocumentTypeLoaderImpl
implements DocumentTypeLoader2 {
    private SchemaLoader loader = new SchemaLoader();
    private Console console = null;
    private static final SchemaError[] NO_ERRORS = new SchemaError[0];
    private SchemaError[] errors = NO_ERRORS;
    private SchemaError[] warnings = NO_ERRORS;

    public void setDocumentTypeLoadConsole(Console console) {
        this.console = console;
    }

    public Console getDocumentTypeLoadConsole() {
        return this.console;
    }

    public DocumentType loadDocumentType(URL uRL, String string, String string2) throws IOException {
        this.errors = NO_ERRORS;
        this.warnings = NO_ERRORS;
        XMLSchema xMLSchema = this.loader.load(uRL);
        SchemaError[] schemaErrorArray = this.loader.getErrors();
        if (schemaErrorArray.length > 0) {
            this.errors = (SchemaError[])schemaErrorArray.clone();
        }
        if ((schemaErrorArray = this.loader.getWarnings()).length > 0) {
            this.warnings = (SchemaError[])schemaErrorArray.clone();
        }
        return xMLSchema;
    }

    public DocumentType loadDocumentTypeForInstance(Document document) throws IOException {
        NamespaceURLPair[] namespaceURLPairArray;
        this.errors = NO_ERRORS;
        this.warnings = NO_ERRORS;
        try {
            namespaceURLPairArray = SchemaUtil.getSchemaLocations(document);
        }
        catch (MalformedURLException malformedURLException) {
            SchemaError schemaError = new SchemaError(document.getRootElement(), null, Msg.msg("invalidSchemaLocations", malformedURLException.getMessage()));
            this.errors = new SchemaError[]{schemaError};
            return null;
        }
        if (namespaceURLPairArray.length == 0) {
            return null;
        }
        if (this.console != null) {
            int n = 0;
            while (n < namespaceURLPairArray.length) {
                this.console.showMessage(Msg.msg("loadingSchema", namespaceURLPairArray[n].namespace.getURI(), namespaceURLPairArray[n].url), 0);
                ++n;
            }
        }
        Schema schema = namespaceURLPairArray.length == 1 ? this.loader.load(namespaceURLPairArray[0].url) : this.loader.load(namespaceURLPairArray);
        SchemaError[] schemaErrorArray = this.loader.getErrors();
        if (schemaErrorArray.length > 0) {
            this.errors = (SchemaError[])schemaErrorArray.clone();
        }
        if ((schemaErrorArray = this.loader.getWarnings()).length > 0) {
            this.warnings = (SchemaError[])schemaErrorArray.clone();
        }
        return schema;
    }

    public DocumentTypeError[] getDocumentTypeErrors() {
        return this.errors;
    }

    public DocumentTypeError[] getDocumentTypeWarnings() {
        return this.warnings;
    }

    public DocumentType loadAsDocumentType(Document document) {
        this.errors = NO_ERRORS;
        this.warnings = NO_ERRORS;
        XMLSchema xMLSchema = this.loader.load(document);
        SchemaError[] schemaErrorArray = this.loader.getErrors();
        if (schemaErrorArray.length > 0) {
            this.errors = (SchemaError[])schemaErrorArray.clone();
        }
        if ((schemaErrorArray = this.loader.getWarnings()).length > 0) {
            this.warnings = (SchemaError[])schemaErrorArray.clone();
        }
        return xMLSchema;
    }
}

