/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.xsd.load;

import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xmlutil.Namespace;
import com.xmlmind.xmledit.xsd.datatype.DataType;
import com.xmlmind.xmledit.xsd.datatype.IDType;
import com.xmlmind.xmledit.xsd.datatype.InvalidDataException;
import com.xmlmind.xmledit.xsd.load.ComplexTypeInfo;
import com.xmlmind.xmledit.xsd.load.IdentityConstraintInfo;
import com.xmlmind.xmledit.xsd.load.Info;
import com.xmlmind.xmledit.xsd.load.KeyInfo;
import com.xmlmind.xmledit.xsd.load.KeyrefInfo;
import com.xmlmind.xmledit.xsd.load.LoadContext;
import com.xmlmind.xmledit.xsd.load.LoadState;
import com.xmlmind.xmledit.xsd.load.RedefineInfo;
import com.xmlmind.xmledit.xsd.load.SchemaErrors;
import com.xmlmind.xmledit.xsd.load.SchemaInfo;
import com.xmlmind.xmledit.xsd.load.SimpleTypeInfo;
import com.xmlmind.xmledit.xsd.load.SubstitutionGroup;
import com.xmlmind.xmledit.xsd.load.TypeInfo;
import com.xmlmind.xmledit.xsd.load.UniqueInfo;
import com.xmlmind.xmledit.xsd.validate.ComplexType;
import com.xmlmind.xmledit.xsd.validate.ElementDeclaration;
import com.xmlmind.xmledit.xsd.validate.ElementParticle;
import com.xmlmind.xmledit.xsd.validate.IdentityConstraint;
import com.xmlmind.xmledit.xsd.validate.Particle;
import com.xmlmind.xmledit.xsd.validate.Type;
import java.io.Serializable;
import java.util.Hashtable;

final class ElementInfo
extends Info {
    public boolean abstract_ = false;
    public int block = 0;
    public int final_ = 0;
    public String default_ = null;
    public String fixed = null;
    public int minOccurs = 1;
    public int maxOccurs = 1;
    public boolean nillable;
    public Name ref = null;
    public Name substitutionGroup = null;
    public Name type = null;
    public TypeInfo typeInfo = null;
    public IdentityConstraintInfo[] identityConstraintInfo = null;

    public ElementInfo(Info info) {
        super(info);
    }

    public void add(IdentityConstraintInfo identityConstraintInfo) {
        if (this.identityConstraintInfo == null) {
            this.identityConstraintInfo = new IdentityConstraintInfo[]{identityConstraintInfo};
            return;
        }
        IdentityConstraintInfo[] identityConstraintInfoArray = new IdentityConstraintInfo[this.identityConstraintInfo.length + 1];
        System.arraycopy(this.identityConstraintInfo, 0, identityConstraintInfoArray, 0, this.identityConstraintInfo.length);
        identityConstraintInfoArray[this.identityConstraintInfo.length] = identityConstraintInfo;
        this.identityConstraintInfo = identityConstraintInfoArray;
    }

    public void init(Element element, SchemaInfo schemaInfo, LoadContext loadContext, SchemaErrors schemaErrors, SchemaErrors schemaErrors2) {
        super.init(element, schemaInfo, loadContext, schemaErrors, schemaErrors2);
        Namespace namespace = this.getTargetNamespace(element, false, schemaInfo);
        this.name = Info.getNCNameAttribute(element, Info._NAME, namespace, null);
        this.abstract_ = Info.getBooleanAttribute(element, Info._ABSTRACT, false);
        this.block = Info.getBlockAttribute(element, Info._BLOCK, schemaInfo.blockDefault);
        this.final_ = Info.getFinalAttribute(element, Info._FINAL, schemaInfo.finalDefault);
        this.default_ = element.getAttribute(Info._DEFAULT);
        this.fixed = element.getAttribute(Info._FIXED);
        this.minOccurs = Info.getNonNegativeIntAttribute(element, Info._MIN_OCCURS, 1);
        this.maxOccurs = Info.getMaxOccursAttribute(element, Info._MAX_OCCURS, 1);
        this.nillable = Info.getBooleanAttribute(element, Info._NILLABLE, false);
        this.ref = this.getQNameAttribute(element, Info._REF, null);
        if (this.ref != null) {
            this.checkImportedNamespaces(this.ref, schemaInfo, schemaErrors2);
        }
        this.substitutionGroup = this.getQNameAttribute(element, Info._SUBSTITUTION_GROUP, null);
        if (this.substitutionGroup == this.name) {
            this.substitutionGroup = null;
        }
        if (this.substitutionGroup != null) {
            this.checkImportedNamespaces(this.substitutionGroup, schemaInfo, schemaErrors2);
        }
        this.type = this.getQNameAttribute(element, Info._TYPE, null);
        if (this.type != null) {
            this.checkImportedNamespaces(this.type, schemaInfo, schemaErrors2);
        }
        Node node = element.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 4) {
                IdentityConstraintInfo identityConstraintInfo;
                Element element2 = (Element)node;
                Name name = element2.getName();
                if (name == Info.XSD_COMPLEX_TYPE) {
                    this.typeInfo = new ComplexTypeInfo(this);
                    this.typeInfo.init(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
                } else if (name == Info.XSD_SIMPLE_TYPE) {
                    this.typeInfo = new SimpleTypeInfo(this);
                    this.typeInfo.init(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
                } else if (name == Info.XSD_UNIQUE) {
                    identityConstraintInfo = new UniqueInfo(this);
                    identityConstraintInfo.init(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
                    this.add(identityConstraintInfo);
                } else if (name == Info.XSD_KEY) {
                    identityConstraintInfo = new KeyInfo(this);
                    identityConstraintInfo.init(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
                    this.add(identityConstraintInfo);
                } else if (name == Info.XSD_KEYREF) {
                    identityConstraintInfo = new KeyrefInfo(this);
                    ((KeyrefInfo)identityConstraintInfo).init(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
                    this.add(identityConstraintInfo);
                }
            }
            node = node.getNextSibling();
        }
        if (this.default_ != null && this.fixed != null) {
            schemaErrors2.append(this, "src-element.1", "inconsistentFixed");
        }
        if (!(this.parent instanceof SchemaInfo) && !(this.parent instanceof RedefineInfo)) {
            if (this.name == null && this.ref == null) {
                schemaErrors2.append(this, "src-element.2.1", "missingName");
            } else if (this.name != null && this.ref != null) {
                schemaErrors2.append(this, "src-element.2.1", "inconsistentName");
            }
            if (this.ref != null && (this.typeInfo != null || this.identityConstraintInfo != null || element.hasAttribute(Info._NILLABLE) || this.default_ != null || this.fixed != null || element.hasAttribute(Info._FORM) || element.hasAttribute(Info._BLOCK) || element.hasAttribute(Info._FINAL) || this.type != null)) {
                schemaErrors2.append(this, "src-element.2.2", "inconsistentForm2");
            }
        }
        if (this.type != null && this.typeInfo != null) {
            schemaErrors2.append(this, "src-element.3", "inconsistentType2");
        }
    }

    public ElementDeclaration toElementDeclaration(LoadState loadState) {
        Serializable serializable;
        Object object;
        Object object2;
        Type type = null;
        if (this.typeInfo != null) {
            type = this.typeInfo.toType(loadState);
        } else if (this.type != null) {
            type = loadState.getType(this.type, this, "e-props-correct.1");
        } else {
            type = ComplexType.ANY;
            if (this.substitutionGroup != null) {
                object2 = this.substitutionGroup;
                while (object2 != null) {
                    ElementInfo elementInfo = loadState.getElementInfo((Name)object2, this, "e-props-correct.1");
                    if (elementInfo == null) {
                        type = null;
                        break;
                    }
                    if (elementInfo == this) break;
                    if (elementInfo.typeInfo != null || elementInfo.type != null) {
                        object = loadState.getElementDeclaration((Name)object2, this, "e-props-correct.1");
                        if (object == null) {
                            type = null;
                            break;
                        }
                        type = ((ElementDeclaration)object).getType();
                        break;
                    }
                    object2 = elementInfo.substitutionGroup;
                }
            }
        }
        if (type == null) {
            return null;
        }
        object2 = null;
        boolean bl = false;
        if (this.default_ != null || this.fixed != null) {
            if (this.fixed != null) {
                object = this.fixed;
                bl = true;
            } else {
                object = this.default_;
            }
            serializable = type.getDataType();
            if (serializable == null) {
                ComplexType complexType = (ComplexType)type;
                if (complexType.getContentType() != 3) {
                    loadState.errors.append(this, "cos-valid-default.2.1", "cannotHaveAValueConstraint");
                    return null;
                }
                if (!complexType.getParticle().isEmptiable()) {
                    loadState.errors.append(this, "cos-valid-default.2.2.2", "mixedNotEmptiable");
                    return null;
                }
                object2 = object;
            } else {
                try {
                    object2 = ((DataType)serializable).valueOf((String)object, this);
                }
                catch (InvalidDataException invalidDataException) {
                    loadState.errors.append(this, "e-props-correct.2", "invalidValueConstraint", object, invalidDataException.getMessage(), invalidDataException.getConstraint());
                    return null;
                }
                if (serializable instanceof IDType) {
                    loadState.errors.append(this, "e-props-correct.4", "idWithDefault", "element");
                    return null;
                }
            }
        }
        int n = 0;
        if ((this.block & 1) != 0) {
            n |= 1;
        }
        if ((this.block & 2) != 0) {
            n |= 2;
        }
        serializable = new ElementDeclaration(this.name, type, object2, bl, this.nillable, n, this.abstract_);
        if (this.identityConstraintInfo != null) {
            int n2 = 0;
            while (n2 < this.identityConstraintInfo.length) {
                IdentityConstraint identityConstraint = this.identityConstraintInfo[n2].toIdentityConstraint(loadState);
                if (identityConstraint == null) {
                    return null;
                }
                ((ElementDeclaration)serializable).addIdentityConstraint(identityConstraint);
                ++n2;
            }
        }
        return serializable;
    }

    public boolean toElementDeclaration2(ElementDeclaration elementDeclaration, LoadState loadState) {
        if (this.substitutionGroup != null) {
            ElementDeclaration elementDeclaration2 = loadState.getElementDeclaration(this.substitutionGroup, this, "e-props-correct.1");
            if (elementDeclaration2 == null) {
                return false;
            }
            ElementInfo elementInfo = (ElementInfo)loadState.schemaInfo.elementInfo.get(this.substitutionGroup);
            int n = 0;
            if ((elementInfo.final_ & 1) != 0) {
                n |= 1;
            }
            if ((elementInfo.final_ & 2) != 0) {
                n |= 2;
            }
            if (!elementDeclaration.getType().isValidDerivation(elementDeclaration2.getType(), n)) {
                loadState.errors.append(this, "e-props-correct.3", "excludedFromSubstitutionGroup", this.substitutionGroup.format(false, this));
                return false;
            }
        }
        return true;
    }

    public boolean toParticle(Particle[] particleArray, int n, LoadState loadState) {
        if (!this.checkOccurs(this.minOccurs, this.maxOccurs, loadState)) {
            return false;
        }
        if (this.minOccurs == 0 && this.maxOccurs == 0) {
            particleArray[n] = null;
            return true;
        }
        if (this.ref == null) {
            particleArray[n] = new ElementParticle(this.name, this.minOccurs, this.maxOccurs);
        } else {
            ElementInfo elementInfo = loadState.getElementInfo(this.ref, this, "p-props-correct.1");
            if (elementInfo == null) {
                return false;
            }
            SubstitutionGroup substitutionGroup = loadState.getSubstitutionGroup(elementInfo);
            if (substitutionGroup != null) {
                particleArray[n] = substitutionGroup.toParticle(this.minOccurs, this.maxOccurs);
            } else if (!elementInfo.abstract_) {
                particleArray[n] = new ElementParticle(this.ref, this.minOccurs, this.maxOccurs);
            }
            if (particleArray[n] == null) {
                loadState.warnings.append(this, "x-p-props-correct", "abstractElementParticle");
            }
        }
        return true;
    }

    public boolean toParticle2(Hashtable hashtable, LoadState loadState) {
        if (this.minOccurs == 0 && this.maxOccurs == 0) {
            return true;
        }
        if (this.ref == null) {
            ElementDeclaration elementDeclaration = this.toElementDeclaration(loadState);
            if (elementDeclaration == null) {
                return false;
            }
            ElementDeclaration elementDeclaration2 = (ElementDeclaration)hashtable.get(this.name);
            if (elementDeclaration2 != null && !ElementInfo.checkConsistent(this, elementDeclaration2, elementDeclaration, loadState)) {
                return false;
            }
            hashtable.put(this.name, elementDeclaration);
        } else {
            ElementDeclaration elementDeclaration = new ElementDeclaration(this.ref, null, null, false, false, 0, false);
            ElementDeclaration elementDeclaration3 = (ElementDeclaration)hashtable.get(this.ref);
            if (elementDeclaration3 != null && !ElementInfo.checkConsistent(this, elementDeclaration3, elementDeclaration, loadState)) {
                return false;
            }
            hashtable.put(this.ref, elementDeclaration);
        }
        return true;
    }

    public static boolean checkConsistent(Info info, ElementDeclaration elementDeclaration, ElementDeclaration elementDeclaration2, LoadState loadState) {
        boolean bl;
        boolean bl2 = ElementInfo.inconsistent(elementDeclaration, elementDeclaration2);
        boolean bl3 = bl = !elementDeclaration.equals(elementDeclaration2);
        if (bl2 || bl) {
            if (bl2) {
                loadState.errors.append(info, "cos-element-consistent", "elementDeclarationInconsistent", elementDeclaration2.getName().format(false, info));
            } else {
                loadState.errors.append(info, "x-cos-element-consistent", "elementDeclarationInconsistent2", elementDeclaration2.getName().format(false, info));
            }
            return false;
        }
        return true;
    }

    private static final boolean inconsistent(ElementDeclaration elementDeclaration, ElementDeclaration elementDeclaration2) {
        Type type;
        if (elementDeclaration.getName() != elementDeclaration2.getName()) {
            return true;
        }
        Type type2 = elementDeclaration.getType();
        if (type2 == (type = elementDeclaration2.getType())) {
            return false;
        }
        return type2 != null && type != null;
    }
}

