/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.xsd.load;

import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xsd.load.AllInfo;
import com.xmlmind.xmledit.xsd.load.ChoiceInfo;
import com.xmlmind.xmledit.xsd.load.Info;
import com.xmlmind.xmledit.xsd.load.LoadContext;
import com.xmlmind.xmledit.xsd.load.LoadState;
import com.xmlmind.xmledit.xsd.load.ModelGroupInfo;
import com.xmlmind.xmledit.xsd.load.SchemaErrors;
import com.xmlmind.xmledit.xsd.load.SchemaInfo;
import com.xmlmind.xmledit.xsd.load.SequenceInfo;
import com.xmlmind.xmledit.xsd.validate.Particle;
import java.util.Hashtable;

final class GroupInfo
extends Info {
    public ModelGroupInfo modelGroupInfo = null;
    public Name ref = null;
    public int minOccurs = 1;
    public int maxOccurs = 1;

    public GroupInfo(Info info) {
        super(info);
    }

    public void init(Element element, SchemaInfo schemaInfo, LoadContext loadContext, SchemaErrors schemaErrors, SchemaErrors schemaErrors2) {
        super.init(element, schemaInfo, loadContext, schemaErrors, schemaErrors2);
        this.name = Info.getNCNameAttribute(element, Info._NAME, schemaInfo.targetNamespace, null);
        if (this.name == null) {
            this.ref = this.getQNameAttribute(element, Info._REF, null);
            if (this.ref != null) {
                this.checkImportedNamespaces(this.ref, schemaInfo, schemaErrors2);
            }
            this.minOccurs = Info.getNonNegativeIntAttribute(element, Info._MIN_OCCURS, 1);
            this.maxOccurs = Info.getMaxOccursAttribute(element, Info._MAX_OCCURS, 1);
        } else {
            Node node = element.getFirstChild();
            while (node != null) {
                if (node.getNodeType() == 4) {
                    Element element2 = (Element)node;
                    Name name = element2.getName();
                    if (name == Info.XSD_SEQUENCE) {
                        this.modelGroupInfo = new SequenceInfo(this);
                        this.modelGroupInfo.init(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
                        break;
                    }
                    if (name == Info.XSD_CHOICE) {
                        this.modelGroupInfo = new ChoiceInfo(this);
                        this.modelGroupInfo.init(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
                        break;
                    }
                    if (name == Info.XSD_ALL) {
                        this.modelGroupInfo = new AllInfo(this);
                        this.modelGroupInfo.init(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
                        break;
                    }
                }
                node = node.getNextSibling();
            }
        }
    }

    public boolean toParticle(Particle[] particleArray, int n, LoadState loadState) {
        if (!this.checkOccurs(this.minOccurs, this.maxOccurs, loadState)) {
            return false;
        }
        if (this.minOccurs == 0 && this.maxOccurs == 0) {
            particleArray[n] = null;
            return true;
        }
        GroupInfo groupInfo = loadState.getGroupInfo(this.ref, this, "p-props-correct.1");
        if (groupInfo == null) {
            return false;
        }
        if (loadState.detectCircularComponent(3, this.ref, this, "p-props-correct.1")) {
            return false;
        }
        boolean bl = groupInfo.modelGroupInfo.toParticle(particleArray, n, loadState);
        loadState.undetectCircularComponent(3, this.ref);
        if (bl && particleArray[n] != null) {
            particleArray[n].setOccurs(this.minOccurs, this.maxOccurs);
        }
        return bl;
    }

    public boolean toParticle2(Hashtable hashtable, LoadState loadState) {
        if (this.minOccurs == 0 && this.maxOccurs == 0) {
            return true;
        }
        GroupInfo groupInfo = loadState.getGroupInfo(this.ref, this, "p-props-correct.1");
        if (groupInfo == null) {
            return false;
        }
        return groupInfo.modelGroupInfo.toParticle2(hashtable, loadState);
    }
}

