/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.xsd.load;

import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.xsd.load.Info;
import com.xmlmind.xmledit.xsd.load.LoadContext;
import com.xmlmind.xmledit.xsd.load.SchemaErrors;
import com.xmlmind.xmledit.xsd.load.SchemaInfo;
import java.io.IOException;
import java.net.URL;

final class IncludeInfo
extends Info {
    public URL schemaLocation = null;

    public IncludeInfo(Info info) {
        super(info);
    }

    public void init(Element element, SchemaInfo schemaInfo, LoadContext loadContext, SchemaErrors schemaErrors, SchemaErrors schemaErrors2) {
        super.init(element, schemaInfo, loadContext, schemaErrors, schemaErrors2);
        this.schemaLocation = Info.getResolvedURLAttribute(element, Info._SCHEMA_LOCATION, this.getLocation(), null);
        if (this.schemaLocation == null) {
            schemaErrors2.append(this, "x-src-include.1", "invalidSchemaLocation");
            return;
        }
        if (loadContext.isSchemaBeingLoaded(this.schemaLocation)) {
            return;
        }
        SchemaInfo schemaInfo2 = null;
        try {
            schemaInfo2 = Info.loadSchema(this.schemaLocation, schemaInfo.targetNamespace, loadContext, schemaErrors, schemaErrors2);
        }
        catch (IOException iOException) {
            schemaErrors2.append(this, "x-src-include.1", "cannotLoadSchema", this.schemaLocation, iOException.getMessage());
            return;
        }
        if (schemaInfo2 != null) {
            if (schemaInfo2.targetNamespace != schemaInfo.targetNamespace) {
                schemaErrors2.append(this, "src-include.2", "unexpectedTargetNamespace", schemaInfo.targetNamespace, this.schemaLocation, schemaInfo2.targetNamespace);
            } else {
                Info.moveInfo(schemaInfo2, schemaInfo, schemaErrors2);
            }
        }
    }
}

