/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.xsd.load;

import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.DocumentLoader;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.util.FileUtil;
import com.xmlmind.xmledit.xmlutil.Namespace;
import com.xmlmind.xmledit.xsd.load.Info;
import com.xmlmind.xmledit.xsd.load.LoadContext;
import com.xmlmind.xmledit.xsd.load.Msg;
import com.xmlmind.xmledit.xsd.load.SchemaError;
import com.xmlmind.xmledit.xsd.load.SchemaErrors;
import com.xmlmind.xmledit.xsd.load.SchemaInfo;
import com.xmlmind.xmledit.xsd.validate.ValidationError;
import com.xmlmind.xmledit.xsd.validate.XMLSchemaForSchemas;
import java.io.File;
import java.io.IOException;
import java.net.URL;

final class InfoLoader {
    private SchemaError[] warningList;
    private SchemaError[] errorList;

    InfoLoader() {
    }

    public SchemaInfo load(File file, Namespace namespace, LoadContext loadContext) throws IOException {
        return this.load(FileUtil.fileToURL(file), namespace, loadContext);
    }

    public SchemaInfo load(URL uRL, Namespace namespace, LoadContext loadContext) throws IOException {
        DocumentLoader documentLoader = InfoLoader.createDocumentLoader();
        Document document = documentLoader.load(uRL);
        return this.load(document, namespace, loadContext);
    }

    public static DocumentLoader createDocumentLoader() {
        DocumentLoader documentLoader = new DocumentLoader();
        documentLoader.setNamespaceMode(1);
        documentLoader.setAddedProperties(7);
        return documentLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SchemaInfo load(Document document, Namespace namespace, LoadContext loadContext) {
        URL uRL = document.getLocation();
        if (uRL != null) {
            loadContext.pushSchemaBeingLoaded(uRL);
        }
        SchemaInfo schemaInfo = null;
        try {
            schemaInfo = this.doLoad(document, namespace, loadContext);
            Object var7_6 = null;
            if (uRL != null) {
                loadContext.popSchemaBeingLoaded();
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (uRL != null) {
                loadContext.popSchemaBeingLoaded();
            }
            throw throwable;
        }
        return schemaInfo;
    }

    private SchemaInfo doLoad(Document document, Namespace namespace, LoadContext loadContext) {
        Object object;
        this.warningList = SchemaErrors.NO_ERRORS;
        this.errorList = SchemaErrors.NO_ERRORS;
        XMLSchemaForSchemas xMLSchemaForSchemas = XMLSchemaForSchemas.getInstance();
        if (xMLSchemaForSchemas != null && ((ValidationError[])(object = xMLSchemaForSchemas.validate(document))).length > 0) {
            this.errorList = new SchemaError[((ValidationError[])object).length];
            int n = 0;
            while (n < ((ValidationError[])object).length) {
                ValidationError validationError = object[n];
                this.errorList[n] = new SchemaError(validationError.element, validationError.constraint, validationError.message);
                ++n;
            }
            return null;
        }
        object = new SchemaErrors();
        SchemaErrors schemaErrors = new SchemaErrors();
        SchemaInfo schemaInfo = new SchemaInfo(namespace == null ? Namespace.NONE : namespace);
        Element element = document.getRootElement();
        if (element.getName() == Info.XSD_SCHEMA) {
            schemaInfo.init(element, schemaInfo, loadContext, (SchemaErrors)object, schemaErrors);
        } else {
            schemaErrors.append(new SchemaError(element, null, Msg.msg("notASchemaElement")));
        }
        this.warningList = ((SchemaErrors)object).toArray();
        this.errorList = schemaErrors.toArray();
        if (this.errorList.length > 0) {
            schemaInfo = null;
        }
        schemaErrors = null;
        return schemaInfo;
    }

    public SchemaError[] getWarnings() {
        return this.warningList;
    }

    public SchemaError[] getErrors() {
        return this.errorList;
    }
}

