/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.xsd.load;

import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xmlutil.PrefixToNamespace;
import com.xmlmind.xmledit.xsd.datatype.DataType;
import com.xmlmind.xmledit.xsd.datatype.InvalidDataException;
import com.xmlmind.xmledit.xsd.datatype.InvalidTypeException;
import com.xmlmind.xmledit.xsd.datatype.Pattern;
import com.xmlmind.xmledit.xsd.datatype.QNameValue;
import com.xmlmind.xmledit.xsd.datatype.Restriction;
import com.xmlmind.xmledit.xsd.datatype.Value;
import com.xmlmind.xmledit.xsd.load.FacetInfo;
import com.xmlmind.xmledit.xsd.load.Info;
import com.xmlmind.xmledit.xsd.load.LoadState;
import com.xmlmind.xmledit.xsd.load.Msg;
import com.xmlmind.xmledit.xsd.validate.Type;
import com.xmlmind.xmledit.xsd.validate.XMLSchema;
import java.util.Vector;

abstract class TypeInfo
extends Info {
    protected TypeInfo(Info info) {
        super(info);
    }

    public abstract Type toType(LoadState var1);

    protected static boolean checkNotations(DataType dataType, Info info, String string, LoadState loadState) {
        boolean bl = true;
        XMLSchema xMLSchema = loadState.schema;
        Value[] valueArray = dataType.getEnumeration();
        int n = 0;
        while (n < valueArray.length) {
            Name name = ((QNameValue)valueArray[n]).getName();
            if (xMLSchema.getNotation(name) == null) {
                bl = false;
                loadState.errors.append(info, string, "undeclaredNotation", name.format(false, info));
            }
            ++n;
        }
        return bl;
    }

    protected static void applyFacets(Restriction restriction, FacetInfo[] facetInfoArray) throws InvalidDataException, InvalidTypeException {
        Object[] objectArray;
        StringBuffer stringBuffer = null;
        Vector<Value> vector = null;
        int n = 0;
        while (n < facetInfoArray.length) {
            objectArray = facetInfoArray[n];
            switch (objectArray.facet) {
                case 1: {
                    restriction.setLength(TypeInfo.parseNonNegativeInt(objectArray.value, "length"), objectArray.fixed);
                    break;
                }
                case 2: {
                    restriction.setMinLength(TypeInfo.parseNonNegativeInt(objectArray.value, "minLength"), objectArray.fixed);
                    break;
                }
                case 4: {
                    restriction.setMaxLength(TypeInfo.parseNonNegativeInt(objectArray.value, "maxLength"), objectArray.fixed);
                    break;
                }
                case 8: {
                    int n2 = objectArray.value.length();
                    if (n2 == 0) break;
                    if (stringBuffer == null) {
                        stringBuffer = new StringBuffer();
                    } else {
                        stringBuffer.append('|');
                    }
                    stringBuffer.append('(');
                    stringBuffer.append(objectArray.value);
                    stringBuffer.append(')');
                    break;
                }
                case 16: {
                    if (vector == null) {
                        vector = new Vector<Value>();
                    }
                    vector.addElement(restriction.getBaseType().valueOf(objectArray.value, (PrefixToNamespace)objectArray));
                    break;
                }
                case 32: {
                    restriction.setWhiteSpace(TypeInfo.parseWhiteSpace(objectArray.value), objectArray.fixed);
                    break;
                }
                case 64: {
                    restriction.setMaxInclusive(objectArray.value, (PrefixToNamespace)objectArray, null, objectArray.fixed);
                    break;
                }
                case 128: {
                    restriction.setMaxExclusive(objectArray.value, (PrefixToNamespace)objectArray, null, objectArray.fixed);
                    break;
                }
                case 256: {
                    restriction.setMinExclusive(objectArray.value, (PrefixToNamespace)objectArray, null, objectArray.fixed);
                    break;
                }
                case 512: {
                    restriction.setMinInclusive(objectArray.value, (PrefixToNamespace)objectArray, null, objectArray.fixed);
                    break;
                }
                case 1024: {
                    restriction.setTotalDigits(TypeInfo.parseNonNegativeInt(objectArray.value, "totalDigits"), objectArray.fixed);
                    break;
                }
                case 2048: {
                    restriction.setFractionDigits(TypeInfo.parseNonNegativeInt(objectArray.value, "fractionDigits"), objectArray.fixed);
                }
            }
            ++n;
        }
        if (stringBuffer != null) {
            try {
                objectArray = new Pattern(stringBuffer.toString());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalArgumentException(Msg.msg("invalidFacet2", stringBuffer.toString(), "pattern", illegalArgumentException.getMessage()));
            }
            restriction.setPattern((Pattern)objectArray);
        }
        if (vector != null) {
            objectArray = new Value[vector.size()];
            vector.copyInto(objectArray);
            restriction.setEnumeration((Value[])objectArray);
        }
    }

    protected static int parseWhiteSpace(String string) {
        if ((string = string.trim()).equals("preserve")) {
            return 0;
        }
        if (string.equals("replace")) {
            return 1;
        }
        if (string.equals("collapse")) {
            return 2;
        }
        throw new IllegalArgumentException(Msg.msg("invalidFacet", string, "whiteSpace"));
    }

    protected static int parseNonNegativeInt(String string, String string2) {
        int n;
        string = string.trim();
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            n = -1;
        }
        if (n < 0) {
            throw new IllegalArgumentException(Msg.msg("invalidFacet", string, string2));
        }
        return n;
    }
}

