/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.xsd.validate;

import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doctype.AttributeType;
import com.xmlmind.xmledit.doctype.Data;
import com.xmlmind.xmledit.doctype.DataType;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xsd.datatype.InvalidDataException;
import com.xmlmind.xmledit.xsd.datatype.Value;
import com.xmlmind.xmledit.xsd.validate.Msg;
import com.xmlmind.xmledit.xsd.validate.Schema;
import com.xmlmind.xmledit.xsd.validate.ValidationError;
import com.xmlmind.xmledit.xsd.validate.ValidationErrors;
import java.io.Serializable;

public class AttributeDeclaration
implements Serializable,
AttributeType {
    private Name name;
    private com.xmlmind.xmledit.xsd.datatype.DataType dataType;
    private Value defaultValue;
    private boolean isFixedValue;

    public AttributeDeclaration(Name name, com.xmlmind.xmledit.xsd.datatype.DataType dataType, Value value, boolean bl) {
        this.name = name;
        this.dataType = dataType;
        this.defaultValue = value;
        this.isFixedValue = bl;
    }

    public Name getName() {
        return this.name;
    }

    public com.xmlmind.xmledit.xsd.datatype.DataType getDataType() {
        return this.dataType;
    }

    public Value getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isFixedValue() {
        return this.isFixedValue;
    }

    public ValidationError validate(String string, Element element, Schema schema) {
        ValidationErrors validationErrors = new ValidationErrors();
        Value value = this.validate(string, element, schema, validationErrors);
        if (value == null) {
            return validationErrors.getLast();
        }
        return null;
    }

    public Value validate(String string, Element element, Schema schema, ValidationErrors validationErrors) {
        Value value;
        try {
            value = this.dataType.valueOf(string, element);
        }
        catch (InvalidDataException invalidDataException) {
            validationErrors.append(null, "cvc-attribute.3", Msg.msg("attributeHasInvalidValue", this.name.format(true, element), string, invalidDataException.getMessage(), invalidDataException.getConstraint()));
            return null;
        }
        if (this.isFixedValue && !this.defaultValue.equals(value)) {
            validationErrors.append(null, "cvc-attribute.4", Msg.msg("attributeDifferentFromFixedValue", this.name.format(true, element), value, this.defaultValue));
            return null;
        }
        return value;
    }

    public DataType getAttributeDataType() {
        return this.dataType;
    }

    public Data getAttributeDefaultValue() {
        return this.defaultValue;
    }

    public Data getAttributeFixedValue() {
        return this.isFixedValue ? this.defaultValue : null;
    }
}

