/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.xsd.validate;

import com.xmlmind.xmledit.doctype.DocumentType;
import com.xmlmind.xmledit.doctype.DocumentationGeneratorBase;
import com.xmlmind.xmledit.doctype.ElementType;
import com.xmlmind.xmledit.util.FileUtil;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xmlutil.Namespace;
import com.xmlmind.xmledit.xmlutil.PrefixEntry;
import com.xmlmind.xmledit.xmlutil.XMLUtil;
import com.xmlmind.xmledit.xsd.datatype.DataType;
import com.xmlmind.xmledit.xsd.datatype.Pattern;
import com.xmlmind.xmledit.xsd.datatype.Value;
import com.xmlmind.xmledit.xsd.validate.AllParticle;
import com.xmlmind.xmledit.xsd.validate.AttributeDeclaration;
import com.xmlmind.xmledit.xsd.validate.AttributeUse;
import com.xmlmind.xmledit.xsd.validate.ChoiceParticle;
import com.xmlmind.xmledit.xsd.validate.ComplexType;
import com.xmlmind.xmledit.xsd.validate.ElementDeclaration;
import com.xmlmind.xmledit.xsd.validate.ElementParticle;
import com.xmlmind.xmledit.xsd.validate.ElementTypeImpl;
import com.xmlmind.xmledit.xsd.validate.Msg;
import com.xmlmind.xmledit.xsd.validate.NameWildcard;
import com.xmlmind.xmledit.xsd.validate.Particle;
import com.xmlmind.xmledit.xsd.validate.Schema;
import com.xmlmind.xmledit.xsd.validate.SchemaUtil;
import com.xmlmind.xmledit.xsd.validate.SequenceParticle;
import com.xmlmind.xmledit.xsd.validate.SimpleType;
import com.xmlmind.xmledit.xsd.validate.Type;
import com.xmlmind.xmledit.xsd.validate.Wildcard;
import com.xmlmind.xmledit.xsd.validate.WildcardParticle;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class DocumentationGenerator
extends DocumentationGeneratorBase {
    private Schema schema;
    private HashMap entries;
    private HashMap pageNameToElementDecl;
    private HashMap childToParentEntries;
    private Entry probe = new Entry();
    private HashMap wildcards = new HashMap();
    private static final AttributeUse[] NO_ATTRIBUTE_USES = new AttributeUse[0];
    private static final PrefixEntry[] EXTRA_PREFIX_ENTRIES = new PrefixEntry[]{new PrefixEntry("xsi", Namespace.XSI)};
    private static final NameComparator nameComparator = new NameComparator();
    private static final AttributeUseComparator attributeUseComparator = new AttributeUseComparator();

    public DocumentationGenerator(Schema schema) {
        Object[] objectArray;
        Object object;
        Object object2;
        this.schema = schema;
        this.entries = new HashMap();
        this.pageNameToElementDecl = new HashMap();
        this.childToParentEntries = new HashMap();
        Enumeration enumeration = schema.getElementDeclarations();
        while (enumeration.hasMoreElements()) {
            object2 = (ElementDeclaration)enumeration.nextElement();
            if (this.containsEntry((ElementDeclaration)object2)) continue;
            this.add((ElementDeclaration)object2);
        }
        object2 = this.sortEntries();
        Object[] objectArray2 = null;
        int n = 1;
        int n2 = 0;
        while (n2 < ((Entry[])object2).length) {
            object = object2[n2];
            objectArray = ((Entry)object).getName();
            if (objectArray != objectArray2) {
                n = 1;
                ((Entry)object).occurrenceOfName = 1;
            } else {
                ((Entry)object).occurrenceOfName = ++n;
            }
            objectArray2 = objectArray;
            ++n2;
        }
        object = this.childToParentEntries.values().iterator();
        while (object.hasNext()) {
            objectArray = (Entry[])object.next();
            if (objectArray.length <= 1) continue;
            Arrays.sort(objectArray);
        }
    }

    private boolean containsEntry(ElementDeclaration elementDeclaration) {
        this.probe.decl = elementDeclaration;
        return this.entries.containsKey(this.probe);
    }

    private Entry getEntry(ElementDeclaration elementDeclaration) {
        this.probe.decl = elementDeclaration;
        return (Entry)this.entries.get(this.probe);
    }

    private void add(ElementDeclaration elementDeclaration) {
        Entry entry = new Entry(elementDeclaration);
        this.entries.put(entry, entry);
        this.pageNameToElementDecl.put(entry.toPageName(), elementDeclaration);
        Type type = elementDeclaration.getType();
        if (!(type instanceof ComplexType)) {
            return;
        }
        ComplexType complexType = (ComplexType)type;
        Name[] nameArray = complexType.getElementFields();
        int n = 0;
        while (n < nameArray.length) {
            Name name = nameArray[n];
            ElementDeclaration elementDeclaration2 = complexType.getElementDeclaration(name);
            if (elementDeclaration2 == null) {
                elementDeclaration2 = this.schema.getElementDeclaration(name);
            }
            if (elementDeclaration2 != null) {
                this.addParent(elementDeclaration2, entry);
                if (!this.containsEntry(elementDeclaration2)) {
                    this.add(elementDeclaration2);
                }
            }
            ++n;
        }
    }

    private void addParent(ElementDeclaration elementDeclaration, Entry entry) {
        Entry[] entryArray = this.getParentEntries(elementDeclaration);
        if (entryArray == null) {
            this.childToParentEntries.put(new Entry(elementDeclaration), new Entry[]{entry});
        } else {
            boolean bl = false;
            int n = 0;
            while (n < entryArray.length) {
                if (entryArray[n].equals(entry)) {
                    bl = true;
                    break;
                }
                ++n;
            }
            if (!bl) {
                Entry[] entryArray2 = new Entry[entryArray.length + 1];
                System.arraycopy(entryArray, 0, entryArray2, 0, entryArray.length);
                entryArray2[entryArray.length] = entry;
                this.childToParentEntries.put(new Entry(elementDeclaration), entryArray2);
            }
        }
    }

    private Entry[] getParentEntries(ElementDeclaration elementDeclaration) {
        this.probe.decl = elementDeclaration;
        return (Entry[])this.childToParentEntries.get(this.probe);
    }

    public Schema getSchema() {
        return this.schema;
    }

    public void generateAll(File file) throws IOException {
        DocumentationGeneratorBase.PageInfo pageInfo = new DocumentationGeneratorBase.PageInfo();
        Iterator iterator = this.entries.values().iterator();
        while (iterator.hasNext()) {
            Entry entry = (Entry)iterator.next();
            this.generateElementPage(entry, pageInfo);
            FileUtil.saveString(pageInfo.html, new File(file, pageInfo.name), this.charset);
        }
        this.generateIndexPage(pageInfo);
        FileUtil.saveString(pageInfo.html, new File(file, pageInfo.name), this.charset);
        if (!this.schema.isDTD()) {
            this.generateNamespacesPage(pageInfo);
            FileUtil.saveString(pageInfo.html, new File(file, pageInfo.name), this.charset);
        }
    }

    public void generateIndexPage(DocumentationGeneratorBase.PageInfo pageInfo) {
        Entry[] entryArray = this.sortEntries();
        StringBuffer stringBuffer = new StringBuffer();
        this.appendPageStart(stringBuffer);
        stringBuffer.append("<title>");
        String string = DocumentationGeneratorBase.indexPageTitle;
        XMLUtil.escapeXML(string, stringBuffer);
        stringBuffer.append("</title>\n");
        this.appendPageMiddle(false, true, stringBuffer);
        stringBuffer.append("<h1>");
        XMLUtil.escapeXML(string, stringBuffer);
        stringBuffer.append("</h1>\n");
        if (entryArray.length > 0) {
            boolean bl = this.schema.isDTD();
            Namespace namespace = null;
            char c = '\u0000';
            int n = 0;
            while (n < entryArray.length) {
                Entry entry = entryArray[n];
                Name name = entry.getName();
                Namespace namespace2 = name.getNamespace();
                char c2 = name.getLocalPart().charAt(0);
                if (namespace2 != namespace && !bl) {
                    stringBuffer.append("<h2>");
                    if (namespace2 == Namespace.NONE) {
                        XMLUtil.escapeXML(Msg.msg("DG.noNamespaceHead"), stringBuffer);
                    } else {
                        XMLUtil.escapeXML(Msg.msg("DG.namespaceHead", namespace2), stringBuffer);
                    }
                    stringBuffer.append("</h2>\n");
                }
                if (!Character.isLetter(c2)) {
                    c2 = '_';
                }
                if (c2 != c) {
                    stringBuffer.append("<h3>");
                    if (Character.isLetter(c2)) {
                        XMLUtil.escapeXML(Character.toString(c2), stringBuffer);
                    } else {
                        stringBuffer.append("&#160;");
                    }
                    stringBuffer.append("</h3>\n");
                }
                this.appendLink(entry, stringBuffer);
                stringBuffer.append("<br>\n");
                namespace = namespace2;
                c = c2;
                ++n;
            }
        }
        this.appendPageEnd(false, true, stringBuffer);
        pageInfo.html = stringBuffer.toString();
        pageInfo.name = "index.html";
        pageInfo.title = string;
    }

    private Entry[] sortEntries() {
        Entry[] entryArray = new Entry[this.entries.size()];
        this.entries.values().toArray(entryArray);
        Arrays.sort(entryArray, new Comparator(){

            public int compare(Object object, Object object2) {
                Entry entry = (Entry)object;
                Entry entry2 = (Entry)object2;
                int n = entry.getName().compareTo(entry2.getName());
                if (n == 0) {
                    Entry[] entryArray = (Entry[])DocumentationGenerator.this.childToParentEntries.get(entry);
                    Entry[] entryArray2 = (Entry[])DocumentationGenerator.this.childToParentEntries.get(entry2);
                    int n2 = entryArray == null ? 0 : entryArray.length;
                    int n3 = entryArray2 == null ? 0 : entryArray2.length;
                    return -(n2 - n3);
                }
                return n;
            }
        });
        return entryArray;
    }

    public void generateNamespacesPage(DocumentationGeneratorBase.PageInfo pageInfo) {
        this.generateNamespacesPage(EXTRA_PREFIX_ENTRIES, pageInfo);
    }

    public ElementDeclaration getElementDeclaration(String string) {
        return (ElementDeclaration)this.pageNameToElementDecl.get(string);
    }

    public boolean generateElementPage(ElementDeclaration elementDeclaration, DocumentationGeneratorBase.PageInfo pageInfo) {
        this.probe.decl = elementDeclaration;
        Entry entry = (Entry)this.entries.get(this.probe);
        if (entry == null) {
            return false;
        }
        this.generateElementPage(entry, pageInfo);
        return true;
    }

    private void generateElementPage(Entry entry, DocumentationGeneratorBase.PageInfo pageInfo) {
        Name[] nameArray;
        int n;
        Entry[] entryArray;
        StringBuffer stringBuffer = new StringBuffer();
        this.appendPageStart(stringBuffer);
        stringBuffer.append("<title>");
        String string = this.entryName(entry);
        String string2 = Msg.msg("DG.elementPageTitle", string);
        XMLUtil.escapeXML(string2, stringBuffer);
        stringBuffer.append("</title>\n");
        this.appendPageMiddle(true, true, stringBuffer);
        stringBuffer.append("<h1>");
        XMLUtil.escapeXML(string2, stringBuffer);
        stringBuffer.append("</h1>\n");
        ElementDeclaration elementDeclaration = entry.getElementDeclaration();
        Value value = (Value)elementDeclaration.getDefaultValue();
        boolean bl2 = elementDeclaration.isFixedValue();
        Type type = entry.getType();
        ComplexType complexType = null;
        SimpleType simpleType = null;
        if (type instanceof ComplexType) {
            complexType = (ComplexType)type;
        } else {
            simpleType = (SimpleType)type;
        }
        DataType dataType = type.getDataType();
        stringBuffer.append("<h2>");
        XMLUtil.escapeXML(Msg.msg("DG.contentModelHead"), stringBuffer);
        stringBuffer.append("</h2>\n");
        if (simpleType != null) {
            this.appendDataContent(dataType, value, bl2, stringBuffer);
        } else {
            int bl = complexType.getContentType();
            switch (bl) {
                case 1: {
                    this.appendDataContent(dataType, value, bl2, stringBuffer);
                    break;
                }
                case 0: {
                    stringBuffer.append("<p>");
                    XMLUtil.escapeXML(Msg.msg("DG.emptyContent"), stringBuffer);
                    stringBuffer.append("</p>\n");
                    break;
                }
                case 3: {
                    stringBuffer.append("<p>");
                    XMLUtil.escapeXML(Msg.msg("DG.mixedContentBlurb", string), stringBuffer);
                    stringBuffer.append(".</p>\n");
                }
                default: {
                    this.appendComplexContent(complexType, stringBuffer);
                }
            }
        }
        boolean bl = elementDeclaration.isNillable();
        AttributeUse[] attributeUseArray = NO_ATTRIBUTE_USES;
        Wildcard wildcard = null;
        if (complexType != null) {
            attributeUseArray = complexType.getAttributeUses();
            wildcard = complexType.getAttributeWildcard();
        }
        if (bl || attributeUseArray.length > 0 || wildcard != null) {
            this.appendAttributesSection(bl, complexType, attributeUseArray, wildcard, stringBuffer);
        }
        if ((entryArray = this.getParentEntries(entry.getElementDeclaration())) != null) {
            stringBuffer.append("<h2>");
            XMLUtil.escapeXML(Msg.msg("DG.parentsHead"), stringBuffer);
            stringBuffer.append("</h2>\n");
            stringBuffer.append("<p>");
            XMLUtil.escapeXML(Msg.msg("DG.parentsBlurb", this.entryName(entry)), stringBuffer);
            stringBuffer.append(": ");
            boolean nameArray2 = true;
            n = 0;
            while (n < entryArray.length) {
                if (nameArray2) {
                    nameArray2 = false;
                } else {
                    stringBuffer.append(",\n");
                }
                this.appendLink(entryArray[n], stringBuffer);
                ++n;
            }
            stringBuffer.append(".</p>\n");
        }
        if (complexType != null && (nameArray = complexType.getElementFields()).length > 0) {
            if (nameArray.length > 1) {
                nameArray = (Name[])nameArray.clone();
                Arrays.sort(nameArray, nameComparator);
            }
            stringBuffer.append("<h2>");
            XMLUtil.escapeXML(Msg.msg("DG.childrenHead"), stringBuffer);
            stringBuffer.append("</h2>\n");
            stringBuffer.append("<p>");
            XMLUtil.escapeXML(Msg.msg("DG.childrenBlurb", this.entryName(entry)), stringBuffer);
            stringBuffer.append(": ");
            n = 1;
            int n2 = 0;
            while (n2 < nameArray.length) {
                Entry entry2;
                Name name = nameArray[n2];
                ElementDeclaration elementDeclaration2 = complexType.getElementDeclaration(name);
                if (elementDeclaration2 == null) {
                    elementDeclaration2 = this.schema.getElementDeclaration(name);
                }
                if (elementDeclaration2 != null && (entry2 = this.getEntry(elementDeclaration2)) != null) {
                    if (n != 0) {
                        n = 0;
                    } else {
                        stringBuffer.append(",\n");
                    }
                    this.appendLink(entry2, stringBuffer);
                }
                ++n2;
            }
            stringBuffer.append(".</p>\n");
        }
        this.appendPageEnd(true, true, stringBuffer);
        pageInfo.html = stringBuffer.toString();
        pageInfo.name = entry.toPageName();
        pageInfo.title = string2;
    }

    private void appendLink(Entry entry, StringBuffer stringBuffer) {
        stringBuffer.append("<a href='");
        XMLUtil.escapeXML(entry.toPageName(), stringBuffer);
        stringBuffer.append("'>");
        XMLUtil.escapeXML(this.entryName(entry), stringBuffer);
        stringBuffer.append("</a>");
    }

    private String entryName(Entry entry) {
        int n = entry.getOccurrenceOfName();
        String string = entry.getName().format(false, this);
        if (n == 1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append('#');
        stringBuffer.append(Integer.toString(n));
        return stringBuffer.toString();
    }

    private void appendComplexContent(ComplexType complexType, StringBuffer stringBuffer) {
        Particle particle = complexType.getParticle();
        if (DocumentationGenerator.isEmptyParticle(particle)) {
            return;
        }
        this.wildcards.clear();
        int n = 0;
        stringBuffer.append("<pre>");
        this.appendParticle(particle, n, this.wildcards, complexType, stringBuffer);
        stringBuffer.append("</pre>\n");
        if (this.wildcards.size() > 0) {
            Map.Entry[] entryArray = new Map.Entry[this.wildcards.size()];
            this.wildcards.entrySet().toArray(entryArray);
            Arrays.sort(entryArray, new Comparator(){

                public int compare(Object object, Object object2) {
                    Integer n = (Integer)((Map.Entry)object).getValue();
                    Integer n2 = (Integer)((Map.Entry)object2).getValue();
                    return n - n2;
                }
            });
            stringBuffer.append("<p></p>\n");
            stringBuffer.append("<table border='0'>\n");
            int n2 = 0;
            while (n2 < entryArray.length) {
                Map.Entry entry = entryArray[n2];
                Integer n3 = (Integer)entry.getValue();
                stringBuffer.append("<tr valign='top'>\n");
                stringBuffer.append("<td nowrap><a name='__wc__");
                stringBuffer.append(n3.toString());
                stringBuffer.append("'>[");
                stringBuffer.append(n3.toString());
                stringBuffer.append("]</a></td>\n");
                stringBuffer.append("<td>");
                this.appendWildcard((NameWildcard)entry.getKey(), false, stringBuffer);
                stringBuffer.append("</td>\n");
                stringBuffer.append("</tr>\n");
                ++n2;
            }
            stringBuffer.append("</table>\n");
        }
    }

    private static final boolean isEmptyParticle(Particle particle) {
        return particle instanceof SequenceParticle && ((SequenceParticle)particle).getParticles().length == 0;
    }

    private void appendParticle(Particle particle, int n, HashMap hashMap, ComplexType complexType, StringBuffer stringBuffer) {
        switch (particle.getType()) {
            case 0: {
                SequenceParticle sequenceParticle = (SequenceParticle)particle;
                this.appendParticle(',', sequenceParticle.getParticles(), sequenceParticle.getMinOccurs(), sequenceParticle.getMaxOccurs(), n, hashMap, complexType, stringBuffer);
                break;
            }
            case 1: {
                ChoiceParticle choiceParticle = (ChoiceParticle)particle;
                this.appendParticle('|', choiceParticle.getParticles(), choiceParticle.getMinOccurs(), choiceParticle.getMaxOccurs(), n, hashMap, complexType, stringBuffer);
                break;
            }
            case 2: {
                AllParticle allParticle = (AllParticle)particle;
                this.appendParticle('&', allParticle.getParticles(), allParticle.getMinOccurs(), allParticle.getMaxOccurs(), n, hashMap, complexType, stringBuffer);
                break;
            }
            case 3: {
                this.appendElementParticle((ElementParticle)particle, complexType, stringBuffer);
                break;
            }
            case 4: {
                this.appendWildcardParticle((WildcardParticle)particle, hashMap, stringBuffer);
            }
        }
    }

    private void appendParticle(char c, Particle[] particleArray, int n, int n2, int n3, HashMap hashMap, ComplexType complexType, StringBuffer stringBuffer) {
        boolean bl = true;
        int n4 = 0;
        block3: while (n4 < particleArray.length) {
            switch (particleArray[n4].getType()) {
                case 0: 
                case 1: 
                case 2: {
                    bl = false;
                    break block3;
                }
                default: {
                    ++n4;
                }
            }
        }
        stringBuffer.append('(');
        int n5 = 0;
        while (n5 < particleArray.length) {
            if (n5 > 0) {
                stringBuffer.append(' ');
                stringBuffer.append(c);
                stringBuffer.append(' ');
                if (bl && n5 % 5 == 0 || !bl) {
                    stringBuffer.append('\n');
                    DocumentationGenerator.appendIndent(n3 + 1, stringBuffer);
                }
            }
            this.appendParticle(particleArray[n5], n3 + 1, hashMap, complexType, stringBuffer);
            ++n5;
        }
        stringBuffer.append(')');
        DocumentationGenerator.appendOccurs(n, n2, stringBuffer);
    }

    private static final void appendIndent(int n, StringBuffer stringBuffer) {
        while (n > 0) {
            stringBuffer.append(' ');
            --n;
        }
    }

    private void appendElementParticle(ElementParticle elementParticle, ComplexType complexType, StringBuffer stringBuffer) {
        Name name = elementParticle.getElementName();
        ElementDeclaration elementDeclaration = complexType.getElementDeclaration(name);
        if (elementDeclaration == null) {
            elementDeclaration = this.schema.getElementDeclaration(name);
        }
        if (elementDeclaration == null) {
            return;
        }
        Entry entry = this.getEntry(elementDeclaration);
        this.appendLink(entry, stringBuffer);
        DocumentationGenerator.appendOccurs(elementParticle.getMinOccurs(), elementParticle.getMaxOccurs(), stringBuffer);
    }

    private void appendWildcardParticle(WildcardParticle wildcardParticle, HashMap hashMap, StringBuffer stringBuffer) {
        NameWildcard nameWildcard = wildcardParticle.getWildcard().getNameWildcard();
        Integer n = (Integer)hashMap.get(nameWildcard);
        if (n == null) {
            n = new Integer(1 + hashMap.size());
            hashMap.put(nameWildcard, n);
        }
        stringBuffer.append("<a href='#__wc__");
        stringBuffer.append(n.toString());
        stringBuffer.append("'>[");
        stringBuffer.append(n.toString());
        stringBuffer.append("]</a>");
        DocumentationGenerator.appendOccurs(wildcardParticle.getMinOccurs(), wildcardParticle.getMaxOccurs(), stringBuffer);
    }

    private static final void appendOccurs(int n, int n2, StringBuffer stringBuffer) {
        if (n == 0 && n2 == 1) {
            stringBuffer.append('?');
        } else if (n == 0 && n2 == -1) {
            stringBuffer.append('*');
        } else if (n == 1 && n2 == -1) {
            stringBuffer.append('+');
        } else if (n != 1 && n2 != 1) {
            stringBuffer.append('{');
            stringBuffer.append(Integer.toString(n));
            stringBuffer.append(',');
            if (n2 != -1) {
                stringBuffer.append(Integer.toString(n2));
            }
            stringBuffer.append('}');
        }
    }

    private void appendDataContent(DataType dataType, Value value, boolean bl, StringBuffer stringBuffer) {
        stringBuffer.append("<table border='1'>");
        stringBuffer.append("<tr align='center'>\n");
        stringBuffer.append("<th>");
        XMLUtil.escapeXML(Msg.msg("DG.elementDataType"), stringBuffer);
        stringBuffer.append("</th>\n");
        stringBuffer.append("<th>");
        XMLUtil.escapeXML(Msg.msg("DG.elementDefaultValue"), stringBuffer);
        stringBuffer.append("</th>\n");
        stringBuffer.append("</tr>\n");
        stringBuffer.append("<tr valign='top'>\n");
        stringBuffer.append("<td>");
        this.appendDataType(dataType, stringBuffer);
        stringBuffer.append("</td>\n");
        stringBuffer.append("<td>");
        this.appendDefaultValue(value, bl, dataType, false, stringBuffer);
        stringBuffer.append("</td>\n");
        stringBuffer.append("</tr>\n");
        stringBuffer.append("</table>\n");
    }

    private void appendAttributesSection(boolean bl, ComplexType complexType, AttributeUse[] attributeUseArray, Wildcard wildcard, StringBuffer stringBuffer) {
        stringBuffer.append("<h2>");
        XMLUtil.escapeXML(Msg.msg("DG.attributesHead"), stringBuffer);
        stringBuffer.append("</h2>\n");
        if (bl || attributeUseArray.length > 0) {
            if (attributeUseArray.length > 1) {
                attributeUseArray = (AttributeUse[])attributeUseArray.clone();
                Arrays.sort(attributeUseArray, attributeUseComparator);
            }
            stringBuffer.append("<table border='1'>\n");
            stringBuffer.append("<tr align='center'>\n");
            stringBuffer.append("<th>");
            XMLUtil.escapeXML(Msg.msg("DG.attributeName"), stringBuffer);
            stringBuffer.append("</th>\n");
            stringBuffer.append("<th>");
            XMLUtil.escapeXML(Msg.msg("DG.attributeDataType"), stringBuffer);
            stringBuffer.append("</th>\n");
            stringBuffer.append("<th>");
            XMLUtil.escapeXML(Msg.msg("DG.attributeDefaultValue"), stringBuffer);
            stringBuffer.append("</th>\n");
            stringBuffer.append("</tr>\n");
            int n = 0;
            while (n < attributeUseArray.length) {
                AttributeUse attributeUse = attributeUseArray[n];
                Name name = attributeUse.getName();
                AttributeDeclaration attributeDeclaration = complexType.getAttributeDeclaration(name);
                if (attributeDeclaration == null) {
                    attributeDeclaration = this.schema.getAttributeDeclaration(name);
                }
                if (attributeDeclaration != null) {
                    DataType dataType = attributeDeclaration.getDataType();
                    Value value = attributeDeclaration.getDefaultValue();
                    boolean bl2 = attributeDeclaration.isFixedValue();
                    stringBuffer.append("<tr valign='top'>\n");
                    stringBuffer.append("<td>");
                    if (attributeUse.isRequired()) {
                        stringBuffer.append("<b>");
                    } else if (bl2) {
                        stringBuffer.append("<b><i>");
                    }
                    XMLUtil.escapeXML(name.format(true, this), stringBuffer);
                    if (attributeUse.isRequired()) {
                        stringBuffer.append("</b>");
                    } else if (bl2) {
                        stringBuffer.append("</i></b>");
                    }
                    stringBuffer.append("</td>\n");
                    stringBuffer.append("<td>");
                    this.appendDataType(dataType, stringBuffer);
                    stringBuffer.append("</td>\n");
                    stringBuffer.append("<td>");
                    this.appendDefaultValue(value, bl2, dataType, attributeUse.isRequired(), stringBuffer);
                    stringBuffer.append("</td>\n");
                    stringBuffer.append("</tr>\n");
                }
                ++n;
            }
            if (bl) {
                stringBuffer.append("<tr valign='top'>\n");
                stringBuffer.append("<td>xsi:nil</td>\n");
                stringBuffer.append("<td>boolean</td>\n");
                stringBuffer.append("<td>\"false\"</td>\n");
                stringBuffer.append("</tr>\n");
            }
            stringBuffer.append("</table>\n");
        }
        if (wildcard != null) {
            stringBuffer.append("<p></p>\n");
            stringBuffer.append("<p><b>");
            XMLUtil.escapeXML(Msg.msg("DG.attributeWildcardBlurb"), stringBuffer);
            stringBuffer.append(":</b><br>\n");
            this.appendWildcard(wildcard.getNameWildcard(), true, stringBuffer);
            stringBuffer.append("</p>\n");
        }
    }

    private void appendWildcard(NameWildcard nameWildcard, boolean bl, StringBuffer stringBuffer) {
        Namespace namespace = nameWildcard.getExcludedNamespace();
        if (namespace != null) {
            if (namespace == Namespace.NONE) {
                XMLUtil.escapeXML(Msg.msg(bl ? "DG.attributeWildcard1" : "DG.elementWildcard1"), stringBuffer);
            } else {
                XMLUtil.escapeXML(Msg.msg(bl ? "DG.attributeWildcard2" : "DG.elementWildcard2"), stringBuffer);
                stringBuffer.append(": \"");
                XMLUtil.escapeXML(namespace.getURI(), stringBuffer);
                stringBuffer.append('\"');
            }
        } else {
            Namespace[] namespaceArray = nameWildcard.getIncludedNamespaces();
            if (namespaceArray != null) {
                boolean bl2 = true;
                boolean bl3 = false;
                int n = 0;
                while (n < namespaceArray.length) {
                    if (namespaceArray[n] == Namespace.NONE) {
                        bl3 = true;
                    } else {
                        if (bl2) {
                            bl2 = false;
                            XMLUtil.escapeXML(Msg.msg(bl ? "DG.attributeWildcard3" : "DG.elementWildcard3"), stringBuffer);
                            stringBuffer.append(": ");
                        } else {
                            stringBuffer.append(", ");
                        }
                        stringBuffer.append('\"');
                        XMLUtil.escapeXML(namespaceArray[n].getURI(), stringBuffer);
                        stringBuffer.append('\"');
                    }
                    ++n;
                }
                if (bl3) {
                    if (namespaceArray.length > 1) {
                        stringBuffer.append("<br>\n");
                    }
                    XMLUtil.escapeXML(Msg.msg(bl ? "DG.attributeWildcard4" : "DG.elementWildcard4"), stringBuffer);
                }
            } else {
                XMLUtil.escapeXML(Msg.msg(bl ? "DG.attributeWildcard5" : "DG.elementWildcard5"), stringBuffer);
            }
        }
    }

    private void appendDataType(DataType dataType, StringBuffer stringBuffer) {
        int n;
        Serializable[] serializableArray;
        DataType dataType2 = dataType.getRootType();
        XMLUtil.escapeXML(dataType.getDataTypeLabel(this), stringBuffer);
        if (DocumentationGenerator.hasFacet(dataType, dataType2, 1)) {
            stringBuffer.append("<br>\n");
            XMLUtil.escapeXML(Msg.msg("DG.length"), stringBuffer);
            stringBuffer.append(": ");
            stringBuffer.append(Integer.toString(dataType.getLength()));
        }
        if (DocumentationGenerator.hasFacet(dataType, dataType2, 2)) {
            stringBuffer.append("<br>\n");
            XMLUtil.escapeXML(Msg.msg("DG.minLength"), stringBuffer);
            stringBuffer.append(": ");
            stringBuffer.append(Integer.toString(dataType.getMinLength()));
        }
        if (DocumentationGenerator.hasFacet(dataType, dataType2, 4)) {
            stringBuffer.append("<br>\n");
            XMLUtil.escapeXML(Msg.msg("DG.maxLength"), stringBuffer);
            stringBuffer.append(": ");
            stringBuffer.append(Integer.toString(dataType.getMaxLength()));
        }
        if (DocumentationGenerator.hasFacet(dataType, dataType2, 8)) {
            stringBuffer.append("<br>\n");
            XMLUtil.escapeXML(Msg.msg("DG.pattern"), stringBuffer);
            stringBuffer.append(": ");
            serializableArray = dataType.getPattern();
            n = 0;
            while (n < serializableArray.length) {
                if (n > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append('\"');
                DocumentationGenerator.appendLongLine(((Pattern)serializableArray[n]).toString(), stringBuffer);
                stringBuffer.append('\"');
                ++n;
            }
        }
        if (DocumentationGenerator.hasFacet(dataType, dataType2, 16)) {
            stringBuffer.append("<br>\n");
            XMLUtil.escapeXML(Msg.msg("DG.enumeration"), stringBuffer);
            stringBuffer.append(": ");
            serializableArray = dataType.getEnumeration();
            n = 0;
            while (n < serializableArray.length) {
                if (n > 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append('\"');
                DocumentationGenerator.appendLongLine(((Value)serializableArray[n]).toString(this), stringBuffer);
                stringBuffer.append('\"');
                ++n;
            }
        }
        if (DocumentationGenerator.hasFacet(dataType, dataType2, 32)) {
            stringBuffer.append("<br>\n");
            XMLUtil.escapeXML(Msg.msg("DG.whiteSpace"), stringBuffer);
            stringBuffer.append(": ");
            XMLUtil.escapeXML(DataType.getWhiteSpaceName(dataType.getWhiteSpace()), stringBuffer);
        }
        if (DocumentationGenerator.hasFacet(dataType, dataType2, 64)) {
            stringBuffer.append("<br>\n");
            XMLUtil.escapeXML(Msg.msg("DG.maxInclusive"), stringBuffer);
            stringBuffer.append(": ");
            XMLUtil.escapeXML(dataType.getMaxInclusive().toString(this), stringBuffer);
        }
        if (DocumentationGenerator.hasFacet(dataType, dataType2, 128)) {
            stringBuffer.append("<br>\n");
            XMLUtil.escapeXML(Msg.msg("DG.maxExclusive"), stringBuffer);
            stringBuffer.append(": ");
            XMLUtil.escapeXML(dataType.getMaxExclusive().toString(this), stringBuffer);
        }
        if (DocumentationGenerator.hasFacet(dataType, dataType2, 256)) {
            stringBuffer.append("<br>\n");
            XMLUtil.escapeXML(Msg.msg("DG.minExclusive"), stringBuffer);
            stringBuffer.append(": ");
            XMLUtil.escapeXML(dataType.getMinExclusive().toString(this), stringBuffer);
        }
        if (DocumentationGenerator.hasFacet(dataType, dataType2, 512)) {
            stringBuffer.append("<br>\n");
            XMLUtil.escapeXML(Msg.msg("DG.minInclusive"), stringBuffer);
            stringBuffer.append(": ");
            XMLUtil.escapeXML(dataType.getMinInclusive().toString(this), stringBuffer);
        }
        if (DocumentationGenerator.hasFacet(dataType, dataType2, 1024)) {
            stringBuffer.append("<br>\n");
            XMLUtil.escapeXML(Msg.msg("DG.totalDigits"), stringBuffer);
            stringBuffer.append(": ");
            stringBuffer.append(Integer.toString(dataType.getTotalDigits()));
        }
        if (DocumentationGenerator.hasFacet(dataType, dataType2, 2048)) {
            stringBuffer.append("<br>\n");
            XMLUtil.escapeXML(Msg.msg("DG.fractionDigits"), stringBuffer);
            stringBuffer.append(": ");
            stringBuffer.append(Integer.toString(dataType.getFractionDigits()));
        }
    }

    private static final boolean hasFacet(DataType dataType, DataType dataType2, int n) {
        return dataType.hasFacet(n) && !dataType2.hasFacet(n);
    }

    private static final void appendLongLine(String string, StringBuffer stringBuffer) {
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            int n3 = Math.min(n2, n + 80);
            if (n > 0) {
                stringBuffer.append("<br>\n");
            }
            XMLUtil.escapeXML(string.substring(n, n3), stringBuffer);
            n = n3;
        }
    }

    private void appendDefaultValue(Value value, boolean bl, DataType dataType, boolean bl2, StringBuffer stringBuffer) {
        if (value == null) {
            if (bl2) {
                XMLUtil.escapeXML(Msg.msg("DG.requiredValue"), stringBuffer);
            } else {
                stringBuffer.append("&#160;");
            }
            return;
        }
        if (bl) {
            XMLUtil.escapeXML(Msg.msg("DG.fixedValue"), stringBuffer);
            stringBuffer.append(": ");
        }
        stringBuffer.append('\"');
        DocumentationGenerator.appendLongLine(value.toString(this), stringBuffer);
        stringBuffer.append('\"');
    }

    public DocumentType getDocumentType() {
        return this.schema;
    }

    public ElementType getElementType(String string) {
        ElementDeclaration elementDeclaration = this.getElementDeclaration(string);
        if (elementDeclaration == null) {
            return null;
        }
        return new ElementTypeImpl(this.schema, elementDeclaration, null);
    }

    public boolean generateElementPage(ElementType elementType, DocumentationGeneratorBase.PageInfo pageInfo) {
        return this.generateElementPage(((ElementTypeImpl)elementType).getElementDeclaration(), pageInfo);
    }

    protected Namespace[] getTargetNamespaces() {
        return SchemaUtil.getTargetNamespaces(this.schema);
    }

    private static final class AttributeUseComparator
    implements Comparator {
        private AttributeUseComparator() {
        }

        public int compare(Object object, Object object2) {
            return ((AttributeUse)object).getName().compareTo(((AttributeUse)object2).getName());
        }
    }

    private static final class NameComparator
    implements Comparator {
        private NameComparator() {
        }

        public int compare(Object object, Object object2) {
            return ((Name)object).compareTo((Name)object2);
        }
    }

    private static final class Entry
    implements Comparable {
        private ElementDeclaration decl;
        private int occurrenceOfName;

        public Entry(ElementDeclaration elementDeclaration) {
            this.decl = elementDeclaration;
        }

        private Entry() {
        }

        public ElementDeclaration getElementDeclaration() {
            return this.decl;
        }

        public Name getName() {
            return this.decl.getName();
        }

        public Type getType() {
            return this.decl.getType();
        }

        public int getOccurrenceOfName() {
            return this.occurrenceOfName;
        }

        public int hashCode() {
            return System.identityHashCode(this.decl.getName()) ^ System.identityHashCode(this.decl.getType());
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof Entry)) {
                return false;
            }
            Entry entry = (Entry)object;
            return this.decl.getName() == entry.decl.getName() && this.decl.getType() == entry.decl.getType();
        }

        public String toPageName() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.decl.getName().getLocalPart());
            stringBuffer.append("__");
            stringBuffer.append(Integer.toString(System.identityHashCode(this.decl), 36));
            stringBuffer.append(".html");
            return stringBuffer.toString();
        }

        public int compareTo(Object object) {
            Name name;
            Entry entry = (Entry)object;
            Name name2 = this.getName();
            if (name2 == (name = entry.getName())) {
                return this.occurrenceOfName - entry.occurrenceOfName;
            }
            return name2.compareTo(name);
        }
    }
}

