/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.xsd.validate;

import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.doc.Text;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xsd.datatype.Value;
import com.xmlmind.xmledit.xsd.validate.IdentityConstraint;
import com.xmlmind.xmledit.xsd.validate.Msg;
import com.xmlmind.xmledit.xsd.validate.Schema;
import com.xmlmind.xmledit.xsd.validate.Type;
import com.xmlmind.xmledit.xsd.validate.ValidationError;
import com.xmlmind.xmledit.xsd.validate.ValidationErrors;
import java.io.Serializable;

public class ElementDeclaration
implements Serializable {
    private Name name;
    private Type type;
    private Object defaultValue;
    private boolean isFixedValue;
    private boolean nillable;
    private byte disallowedSubstitutions;
    private boolean isAbstract;
    private static final IdentityConstraint[] NO_IDENTITY_CONSTRAINTS = new IdentityConstraint[0];
    private IdentityConstraint[] identityConstraints = NO_IDENTITY_CONSTRAINTS;

    public ElementDeclaration(Name name, Type type, Object object, boolean bl, boolean bl2, int n, boolean bl3) {
        this.name = name;
        this.type = type;
        this.defaultValue = object;
        this.isFixedValue = bl;
        this.nillable = bl2;
        this.disallowedSubstitutions = (byte)n;
        this.isAbstract = bl3;
    }

    public void addIdentityConstraint(IdentityConstraint identityConstraint) {
        IdentityConstraint[] identityConstraintArray = new IdentityConstraint[this.identityConstraints.length + 1];
        if (this.identityConstraints.length > 0) {
            System.arraycopy(this.identityConstraints, 0, identityConstraintArray, 0, this.identityConstraints.length);
        }
        identityConstraintArray[this.identityConstraints.length] = identityConstraint;
        this.identityConstraints = identityConstraintArray;
    }

    public Name getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isFixedValue() {
        return this.isFixedValue;
    }

    public boolean isNillable() {
        return this.nillable;
    }

    public int getDisallowedSubtitutions() {
        return this.disallowedSubstitutions;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public IdentityConstraint[] getIdentityConstraints() {
        return this.identityConstraints;
    }

    public IdentityConstraint getIdentityConstraint(Name name) {
        int n = 0;
        while (n < this.identityConstraints.length) {
            if (this.identityConstraints[n].getName() == name) {
                return this.identityConstraints[n];
            }
            ++n;
        }
        return null;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof ElementDeclaration)) {
            return false;
        }
        ElementDeclaration elementDeclaration = (ElementDeclaration)object;
        if (!(this.name == elementDeclaration.name && this.type == elementDeclaration.type && (this.defaultValue == null && elementDeclaration.defaultValue == null || this.defaultValue != null && this.defaultValue.equals(elementDeclaration.defaultValue)) && this.isFixedValue == elementDeclaration.isFixedValue && this.nillable == elementDeclaration.nillable && this.disallowedSubstitutions == elementDeclaration.disallowedSubstitutions && this.isAbstract == elementDeclaration.isAbstract)) {
            return false;
        }
        if (this.identityConstraints.length != elementDeclaration.identityConstraints.length) {
            return false;
        }
        int n = 0;
        while (n < this.identityConstraints.length) {
            IdentityConstraint identityConstraint = this.identityConstraints[n];
            IdentityConstraint[] identityConstraintArray = elementDeclaration.identityConstraints;
            boolean bl = false;
            int n2 = 0;
            while (n2 < identityConstraintArray.length) {
                if (identityConstraint.equals(identityConstraintArray[n2])) {
                    bl = true;
                    break;
                }
                ++n2;
            }
            if (!bl) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public ValidationError[] validate(Element element, boolean bl, Schema schema) {
        ValidationErrors validationErrors = new ValidationErrors();
        this.validate(element, bl, schema, validationErrors);
        return validationErrors.toArray();
    }

    public Object validate(Element element, boolean bl, Schema schema, ValidationErrors validationErrors) {
        Object object;
        if (this.isAbstract) {
            validationErrors.append(element, "cvc-elt.2", Msg.msg("elementIsAbstract"));
            return null;
        }
        boolean bl2 = ElementDeclaration.isEmpty(element);
        boolean bl3 = false;
        String string = element.getAttribute(Name.XSI_NIL);
        if (this.nillable) {
            boolean bl4;
            if (string == null) {
                bl4 = false;
            } else if ((string = string.trim()).equals("1") || string.equals("true")) {
                bl4 = true;
            } else if (string.equals("0") || string.equals("false")) {
                bl4 = false;
            } else {
                validationErrors.append(element, "cvc-elt.3.2", Msg.msg("nilNotABoolean", string));
                return null;
            }
            if (bl4) {
                if (!bl2) {
                    validationErrors.append(element, "cvc-elt.3.2.1", Msg.msg("nilElementNotEmpty"));
                    return null;
                }
                if (this.isFixedValue) {
                    validationErrors.append(element, "cvc-elt.3.2.2", Msg.msg("nilElementHasFixedValue"));
                    return null;
                }
                bl3 = true;
            }
        } else if (string != null) {
            validationErrors.append(element, "cvc-elt.3.1", Msg.msg("nonNillableElementHasNil"));
            return null;
        }
        Type type = this.type;
        String string2 = element.getAttribute(Name.XSI_TYPE);
        if (string2 != null) {
            object = Name.parse(string2, false, element);
            if (object == null) {
                validationErrors.append(element, "cvc-elt.4.1", Msg.msg("typeNotAQName", string2));
                return null;
            }
            type = schema.findType((Name)object);
            if (type == null) {
                validationErrors.append(element, "cvc-elt.4.2", Msg.msg("typeNotDeclared", ((Name)object).format(false, element)));
                return null;
            }
            int n = this.disallowedSubstitutions | this.type.getProhibitedSubstitutions();
            if (!type.isValidDerivation(this.type, n)) {
                validationErrors.append(element, "cvc-elt.4.3", Msg.msg("typeIncompatibleWithElementDecl", ((Name)object).format(false, element)));
                return null;
            }
        }
        if (this.defaultValue != null && bl2 && !bl3) {
            String string3 = this.defaultValue instanceof Value ? ((Value)this.defaultValue).toString(element) : this.defaultValue.toString();
            object = type.validate(element, string3, bl, schema, validationErrors);
            if (object == null) {
                return null;
            }
        } else {
            object = type.validate(element, bl, schema, validationErrors);
            if (object == null) {
                return null;
            }
            if (this.isFixedValue && !bl3) {
                if (element.hasChildElements()) {
                    validationErrors.append(element, "cvc-elt.5.2.2.1", Msg.msg("elementHasChildElements"));
                    return null;
                }
                if (object != Type.VALID && !this.defaultValue.equals(object)) {
                    validationErrors.append(element, "cvc-elt.5.2.2.2", Msg.msg("elementDifferentFromFixedValue", object, this.defaultValue));
                    return null;
                }
            }
        }
        return object;
    }

    private static final boolean isEmpty(Element element) {
        Node node = element.getFirstChild();
        while (node != null) {
            switch (node.getNodeType()) {
                case 1: 
                case 2: {
                    break;
                }
                case 0: {
                    if (((Text)node).getTextLength() <= 0) break;
                    return false;
                }
                default: {
                    return false;
                }
            }
            node = node.getNextSibling();
        }
        return true;
    }
}

