/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.xsd.validate;

import com.xmlmind.xmledit.doctype.Field;
import com.xmlmind.xmledit.doctype.NameClass;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xmlutil.Namespace;
import com.xmlmind.xmledit.xmlutil.NamespaceToPrefixes;
import com.xmlmind.xmledit.xsd.validate.Msg;
import com.xmlmind.xmledit.xsd.validate.NameWildcard;

final class FieldImpl
implements Field {
    public Name name;
    public NameWildcard nameWildcard;
    public boolean required;

    public FieldImpl(Name name) {
        this.name = name;
    }

    public FieldImpl(NameWildcard nameWildcard) {
        this.nameWildcard = nameWildcard;
    }

    public FieldImpl(Name name, boolean bl) {
        this.name = name;
        this.required = bl;
    }

    public FieldImpl(NameWildcard nameWildcard, boolean bl) {
        this.nameWildcard = nameWildcard;
        this.required = bl;
    }

    public Name getFieldName() {
        return this.name;
    }

    public NameClass getFieldNameClass() {
        return this.nameWildcard;
    }

    public String getFieldLabel(boolean bl, NamespaceToPrefixes namespaceToPrefixes) {
        if (this.name != null) {
            return this.name.format(bl, namespaceToPrefixes);
        }
        Namespace namespace = this.nameWildcard.getExcludedNamespace();
        if (namespace != null) {
            if (namespace == Namespace.NONE) {
                return Msg.msg("anyQualified");
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(Msg.msg("not"));
            stringBuffer.append(' ');
            stringBuffer.append(FieldImpl.formatWildcard(namespace, namespaceToPrefixes));
            return stringBuffer.toString();
        }
        Namespace[] namespaceArray = this.nameWildcard.getIncludedNamespaces();
        if (namespaceArray == null) {
            return "*";
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string = null;
        int n = 0;
        while (n < namespaceArray.length) {
            namespace = namespaceArray[n];
            if (stringBuffer.length() > 0) {
                stringBuffer.append(' ');
                if (string == null) {
                    string = Msg.msg("or");
                }
                stringBuffer.append(string);
                stringBuffer.append(' ');
            }
            if (namespace == Namespace.NONE) {
                stringBuffer.append(Msg.msg("anyUnqualified"));
            } else {
                stringBuffer.append(FieldImpl.formatWildcard(namespace, namespaceToPrefixes));
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private static String formatWildcard(Namespace namespace, NamespaceToPrefixes namespaceToPrefixes) {
        String string = Name.get(namespace, "x").format(true, namespaceToPrefixes);
        int n = string.length();
        if (n == 1) {
            return "*";
        }
        return string.substring(0, n - 1) + "*";
    }
}

