/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.xsd.validate;

import com.xmlmind.xmledit.doc.Attribute;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.XNode;
import com.xmlmind.xmledit.doc.XPath;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xmlutil.PrefixToNamespace;
import com.xmlmind.xmledit.xsd.datatype.DataType;
import com.xmlmind.xmledit.xsd.datatype.InvalidDataException;
import com.xmlmind.xmledit.xsd.datatype.Value;
import com.xmlmind.xmledit.xsd.validate.AttributeDeclaration;
import com.xmlmind.xmledit.xsd.validate.ElementDeclaration;
import com.xmlmind.xmledit.xsd.validate.ElementHandler;
import com.xmlmind.xmledit.xsd.validate.IdentityConstraint;
import com.xmlmind.xmledit.xsd.validate.KeySequence;
import com.xmlmind.xmledit.xsd.validate.Msg;
import com.xmlmind.xmledit.xsd.validate.Schema;
import com.xmlmind.xmledit.xsd.validate.Type;
import com.xmlmind.xmledit.xsd.validate.ValidationErrors;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;

final class IdentityConstraintChecker
extends ElementHandler {
    private ValidationErrors errors;
    private HashMap uniques;
    private HashMap definedKeysByName;
    private ArrayList keyrefRecords;
    private boolean checked;

    public IdentityConstraintChecker(Schema schema) {
        super(schema);
    }

    public boolean check(Element element, ValidationErrors validationErrors) {
        this.errors = validationErrors;
        this.uniques = new HashMap();
        this.definedKeysByName = new HashMap();
        this.keyrefRecords = new ArrayList();
        this.checked = true;
        this.traverse(element);
        int n = this.keyrefRecords.size();
        int n2 = 0;
        while (n2 < n) {
            KeyrefRecord keyrefRecord = (KeyrefRecord)this.keyrefRecords.get(n2);
            KeySequence[] keySequenceArray = keyrefRecord.keySequences;
            HashMap hashMap = (HashMap)this.definedKeysByName.get(keyrefRecord.referencedKey);
            int n3 = 0;
            while (n3 < keySequenceArray.length) {
                KeySequence keySequence = keySequenceArray[n3];
                if (hashMap == null || !hashMap.containsKey(keySequence)) {
                    validationErrors.append(keySequence.selected, "cvc-identity-constraint.4.3", Msg.msg("badKeyref", keySequence.toString()));
                    this.checked = false;
                }
                ++n3;
            }
            ++n2;
        }
        this.errors = null;
        this.uniques = null;
        this.definedKeysByName = null;
        this.keyrefRecords = null;
        return this.checked;
    }

    protected Object handleElement(Element element, ElementDeclaration elementDeclaration, Type type) {
        IdentityConstraint[] identityConstraintArray;
        if (elementDeclaration == null || (identityConstraintArray = elementDeclaration.getIdentityConstraints()) == null || identityConstraintArray.length == 0) {
            return null;
        }
        int n = 0;
        while (n < identityConstraintArray.length) {
            IdentityConstraint identityConstraint = identityConstraintArray[n];
            KeySequence[] keySequenceArray = this.apply(identityConstraint, element);
            switch (identityConstraint.getType()) {
                case 0: {
                    this.checkUnique(identityConstraint.getName(), keySequenceArray);
                    break;
                }
                case 1: {
                    this.checkKey(identityConstraint.getName(), keySequenceArray);
                    break;
                }
                case 2: {
                    this.recordKeyref(identityConstraint.getReferencedKey(), keySequenceArray);
                    break;
                }
                default: {
                    throw new RuntimeException("unknown IdentityConstraint type " + identityConstraint.getType());
                }
            }
            ++n;
        }
        return null;
    }

    private KeySequence[] apply(IdentityConstraint identityConstraint, Element element) {
        XNode[] xNodeArray = identityConstraint.getSelector().select(element);
        KeySequence[] keySequenceArray = new KeySequence[xNodeArray.length];
        XPath[] xPathArray = identityConstraint.getFields();
        int n = 0;
        while (n < xNodeArray.length) {
            Element element2 = (Element)xNodeArray[n];
            Value[] valueArray = new Value[xPathArray.length];
            int n2 = 0;
            while (n2 < xPathArray.length) {
                XNode[] xNodeArray2 = xPathArray[n2].select(element2, true);
                valueArray[n2] = null;
                if (xNodeArray2.length != 0) {
                    boolean bl = false;
                    boolean bl2 = false;
                    int n3 = 0;
                    while (n3 < xNodeArray2.length) {
                        Value value;
                        Serializable serializable;
                        XNode xNode;
                        DataType dataType = null;
                        Value value2 = null;
                        if (xNodeArray2[n3] instanceof Attribute) {
                            xNode = (Attribute)xNodeArray2[n3];
                            serializable = this.schema.findAttributeDeclaration(((Attribute)xNode).element, ((Attribute)xNode).name);
                            if (serializable == null) {
                                dataType = null;
                                value2 = null;
                                if (((Attribute)xNode).value != null) {
                                    bl = true;
                                }
                            } else {
                                dataType = ((AttributeDeclaration)serializable).getDataType();
                                if (((Attribute)xNode).value == null) {
                                    value = ((AttributeDeclaration)serializable).getDefaultValue();
                                } else {
                                    try {
                                        value = dataType.valueOf(((Attribute)xNode).value, ((Attribute)xNode).element);
                                    }
                                    catch (InvalidDataException invalidDataException) {
                                        value = null;
                                        bl = true;
                                    }
                                }
                                value2 = value;
                            }
                        } else {
                            xNode = (Element)xNodeArray2[n3];
                            serializable = this.schema.findElementDeclaration((Element)xNode);
                            if (serializable == null) {
                                dataType = null;
                                value2 = null;
                                bl = true;
                            } else {
                                dataType = ((ElementDeclaration)serializable).getType().getDataType();
                                String string = ((Element)xNode).getText();
                                if (string == null) {
                                    value = null;
                                    bl = true;
                                } else if (dataType == null) {
                                    value = null;
                                    bl = true;
                                } else if (string.trim().length() == 0) {
                                    value = (Value)((ElementDeclaration)serializable).getDefaultValue();
                                } else {
                                    try {
                                        value = dataType.valueOf(string, (PrefixToNamespace)((Object)xNode));
                                    }
                                    catch (InvalidDataException invalidDataException) {
                                        value = null;
                                        bl = true;
                                    }
                                }
                                value2 = value;
                            }
                        }
                        if (value2 != null) {
                            if (valueArray[n2] == null) {
                                valueArray[n2] = value2;
                            } else {
                                bl2 = true;
                                break;
                            }
                        }
                        ++n3;
                    }
                    if (bl) {
                        this.errors.append(element2, "cvc-identity-constraint.3", Msg.msg("badField1", xPathArray[n2].toString(element2), identityConstraint.getName().format(false, element2)));
                        this.checked = false;
                    } else if (bl2) {
                        this.errors.append(element2, "cvc-identity-constraint.3", Msg.msg("badField2", xPathArray[n2].toString(element2), identityConstraint.getName().format(false, element2)));
                        this.checked = false;
                    }
                }
                ++n2;
            }
            keySequenceArray[n] = new KeySequence(element2, valueArray);
            ++n;
        }
        return keySequenceArray;
    }

    private void checkUnique(Name name, KeySequence[] keySequenceArray) {
        this.uniques.clear();
        int n = 0;
        while (n < keySequenceArray.length) {
            KeySequence keySequence = keySequenceArray[n];
            if (keySequence.isComplete()) {
                HashMap<KeySequence, KeySequence> hashMap;
                if (this.uniques.put(keySequence, keySequence) != null) {
                    this.errors.append(keySequence.selected, "cvc-identity-constraint.4.1", Msg.msg("notUnique", keySequence.toString()));
                    this.checked = false;
                }
                if ((hashMap = (HashMap<KeySequence, KeySequence>)this.definedKeysByName.get(name)) == null) {
                    hashMap = new HashMap<KeySequence, KeySequence>();
                    this.definedKeysByName.put(name, hashMap);
                }
                hashMap.put(keySequence, keySequence);
            }
            ++n;
        }
    }

    private void checkKey(Name name, KeySequence[] keySequenceArray) {
        this.uniques.clear();
        int n = 0;
        while (n < keySequenceArray.length) {
            KeySequence keySequence = keySequenceArray[n];
            if (!keySequence.isComplete()) {
                this.errors.append(keySequence.selected, "cvc-identity-constraint.4.2.1", Msg.msg("badKey", name.format(false, keySequence.selected)));
                this.checked = false;
            } else {
                HashMap<KeySequence, KeySequence> hashMap;
                if (this.uniques.put(keySequence, keySequence) != null) {
                    this.errors.append(keySequence.selected, "cvc-identity-constraint.4.2.2", Msg.msg("notAKey", keySequence.toString()));
                    this.checked = false;
                }
                if ((hashMap = (HashMap<KeySequence, KeySequence>)this.definedKeysByName.get(name)) == null) {
                    hashMap = new HashMap<KeySequence, KeySequence>();
                    this.definedKeysByName.put(name, hashMap);
                }
                hashMap.put(keySequence, keySequence);
            }
            ++n;
        }
    }

    private void recordKeyref(Name name, KeySequence[] keySequenceArray) {
        KeySequence[] keySequenceArray2;
        KeySequence[] keySequenceArray3 = new KeySequence[keySequenceArray.length];
        int n = 0;
        int n2 = 0;
        while (n2 < keySequenceArray.length) {
            keySequenceArray2 = keySequenceArray[n2];
            if (keySequenceArray2.isComplete()) {
                keySequenceArray3[n++] = keySequenceArray2;
            }
            ++n2;
        }
        if (n == 0) {
            return;
        }
        if (n != keySequenceArray3.length) {
            keySequenceArray2 = new KeySequence[n];
            System.arraycopy(keySequenceArray3, 0, keySequenceArray2, 0, n);
            keySequenceArray3 = keySequenceArray2;
        }
        this.keyrefRecords.add(new KeyrefRecord(name, keySequenceArray3));
    }

    private static final class KeyrefRecord {
        public Name referencedKey;
        public KeySequence[] keySequences;

        public KeyrefRecord(Name name, KeySequence[] keySequenceArray) {
            this.referencedKey = name;
            this.keySequences = keySequenceArray;
        }
    }
}

