/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.xsd.validate;

import com.xmlmind.xmledit.doctype.NameClass;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xmlutil.Namespace;
import java.io.Serializable;

public class NameWildcard
implements NameClass,
Serializable {
    public static final NameWildcard ANY = new NameWildcard();
    public static final NameWildcard NAMESPACE_NOT_NONE = new NameWildcard(Namespace.NONE);
    private Namespace excludedNamespace;
    private Namespace[] includedNamespaces;

    public NameWildcard() {
        this.excludedNamespace = null;
        this.includedNamespaces = null;
    }

    public NameWildcard(Namespace namespace) {
        this.excludedNamespace = namespace;
        this.includedNamespaces = null;
    }

    public NameWildcard(Namespace[] namespaceArray) {
        this.includedNamespaces = namespaceArray;
        this.excludedNamespace = null;
    }

    public Namespace getExcludedNamespace() {
        return this.excludedNamespace;
    }

    public Namespace[] getIncludedNamespaces() {
        return this.includedNamespaces;
    }

    public int getSpecificity() {
        if (this.excludedNamespace != null) {
            return 1;
        }
        if (this.includedNamespaces != null) {
            return Integer.MAX_VALUE - this.includedNamespaces.length;
        }
        return 0;
    }

    public boolean match(Name name) {
        if (this.excludedNamespace != null) {
            Namespace namespace = name.getNamespace();
            return namespace != this.excludedNamespace && namespace != Namespace.NONE;
        }
        if (this.includedNamespaces != null) {
            Namespace namespace = name.getNamespace();
            int n = 0;
            while (n < this.includedNamespaces.length) {
                if (namespace == this.includedNamespaces[n]) {
                    return true;
                }
                ++n;
            }
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.excludedNamespace != null) {
            return System.identityHashCode(this.excludedNamespace);
        }
        if (this.includedNamespaces != null) {
            int n = 0;
            int n2 = 0;
            while (n2 < this.includedNamespaces.length) {
                n ^= System.identityHashCode(this.includedNamespaces[n2]);
                ++n2;
            }
            return n;
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof NameWildcard)) {
            return false;
        }
        NameWildcard nameWildcard = (NameWildcard)object;
        if (this.excludedNamespace != null) {
            return nameWildcard.excludedNamespace == this.excludedNamespace;
        }
        if (this.includedNamespaces != null) {
            if (nameWildcard.includedNamespaces == null || nameWildcard.includedNamespaces.length != this.includedNamespaces.length) {
                return false;
            }
            int n = this.includedNamespaces.length;
            int n2 = 0;
            while (n2 < n) {
                Namespace namespace = this.includedNamespaces[n2];
                boolean bl = false;
                int n3 = 0;
                while (n3 < n) {
                    if (nameWildcard.includedNamespaces[n3] == namespace) {
                        bl = true;
                        break;
                    }
                    ++n3;
                }
                if (!bl) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        return nameWildcard.excludedNamespace == null && nameWildcard.includedNamespaces == null;
    }

    public NameWildcard union(NameWildcard nameWildcard) {
        if (this.equals(nameWildcard)) {
            return this;
        }
        if (this.excludedNamespace == null && this.includedNamespaces == null || nameWildcard.excludedNamespace == null && nameWildcard.includedNamespaces == null) {
            return ANY;
        }
        if (this.includedNamespaces != null && nameWildcard.includedNamespaces != null) {
            Namespace[] namespaceArray;
            Namespace[] namespaceArray2 = new Namespace[this.includedNamespaces.length + nameWildcard.includedNamespaces.length];
            int n = this.includedNamespaces.length;
            System.arraycopy(this.includedNamespaces, 0, namespaceArray2, 0, n);
            int n2 = 0;
            while (n2 < nameWildcard.includedNamespaces.length) {
                namespaceArray = nameWildcard.includedNamespaces[n2];
                boolean bl = false;
                int n3 = 0;
                while (n3 < this.includedNamespaces.length) {
                    if (namespaceArray == this.includedNamespaces[n3]) {
                        bl = true;
                        break;
                    }
                    ++n3;
                }
                if (!bl) {
                    namespaceArray2[n++] = namespaceArray;
                }
                ++n2;
            }
            if (n != namespaceArray2.length) {
                namespaceArray = new Namespace[n];
                System.arraycopy(namespaceArray2, 0, namespaceArray, 0, n);
                namespaceArray2 = namespaceArray;
            }
            return new NameWildcard(namespaceArray2);
        }
        if (this.excludedNamespace != null && nameWildcard.excludedNamespace != null) {
            return NAMESPACE_NOT_NONE;
        }
        if (this.excludedNamespace != null && nameWildcard.includedNamespaces != null || this.includedNamespaces != null && nameWildcard.excludedNamespace != null) {
            NameWildcard nameWildcard2;
            NameWildcard nameWildcard3;
            if (this.excludedNamespace != null) {
                nameWildcard3 = this;
                nameWildcard2 = nameWildcard;
            } else {
                nameWildcard3 = nameWildcard;
                nameWildcard2 = this;
            }
            if (nameWildcard3.excludedNamespace != Namespace.NONE) {
                boolean bl = false;
                boolean bl2 = false;
                int n = 0;
                while (n < nameWildcard2.includedNamespaces.length) {
                    Namespace namespace = nameWildcard2.includedNamespaces[n];
                    if (nameWildcard3.excludedNamespace == namespace) {
                        bl = true;
                    } else if (Namespace.NONE == namespace) {
                        bl2 = true;
                    }
                    ++n;
                }
                if (bl) {
                    if (bl2) {
                        return ANY;
                    }
                    return NAMESPACE_NOT_NONE;
                }
                if (bl2) {
                    return null;
                }
                return nameWildcard3;
            }
            boolean bl = false;
            int n = 0;
            while (n < nameWildcard2.includedNamespaces.length) {
                if (Namespace.NONE == nameWildcard2.includedNamespaces[n]) {
                    bl = true;
                    break;
                }
                ++n;
            }
            return bl ? ANY : NAMESPACE_NOT_NONE;
        }
        return null;
    }

    public NameWildcard intersection(NameWildcard nameWildcard) {
        if (this.equals(nameWildcard)) {
            return this;
        }
        if (this.excludedNamespace == null && this.includedNamespaces == null) {
            return nameWildcard;
        }
        if (nameWildcard.excludedNamespace == null && nameWildcard.includedNamespaces == null) {
            return this;
        }
        if (this.excludedNamespace != null && nameWildcard.includedNamespaces != null || this.includedNamespaces != null && nameWildcard.excludedNamespace != null) {
            Namespace[] namespaceArray;
            NameWildcard nameWildcard2;
            NameWildcard nameWildcard3;
            if (this.excludedNamespace != null) {
                nameWildcard3 = this;
                nameWildcard2 = nameWildcard;
            } else {
                nameWildcard3 = nameWildcard;
                nameWildcard2 = this;
            }
            Namespace[] namespaceArray2 = new Namespace[nameWildcard2.includedNamespaces.length];
            int n = 0;
            int n2 = 0;
            while (n2 < nameWildcard2.includedNamespaces.length) {
                namespaceArray = nameWildcard2.includedNamespaces[n2];
                if (namespaceArray != nameWildcard3.excludedNamespace && namespaceArray != Namespace.NONE) {
                    namespaceArray2[n++] = namespaceArray;
                }
                ++n2;
            }
            if (n != namespaceArray2.length) {
                namespaceArray = new Namespace[n];
                System.arraycopy(namespaceArray2, 0, namespaceArray, 0, n);
                namespaceArray2 = namespaceArray;
            }
            return new NameWildcard(namespaceArray2);
        }
        if (this.includedNamespaces != null && nameWildcard.includedNamespaces != null) {
            Namespace[] namespaceArray;
            Namespace[] namespaceArray3 = new Namespace[Math.min(this.includedNamespaces.length, nameWildcard.includedNamespaces.length)];
            int n = 0;
            int n3 = 0;
            while (n3 < nameWildcard.includedNamespaces.length) {
                namespaceArray = nameWildcard.includedNamespaces[n3];
                boolean bl = false;
                int n4 = 0;
                while (n4 < this.includedNamespaces.length) {
                    if (namespaceArray == this.includedNamespaces[n4]) {
                        bl = true;
                        break;
                    }
                    ++n4;
                }
                if (bl) {
                    namespaceArray3[n++] = namespaceArray;
                }
                ++n3;
            }
            if (n != namespaceArray3.length) {
                namespaceArray = new Namespace[n];
                System.arraycopy(namespaceArray3, 0, namespaceArray, 0, n);
                namespaceArray3 = namespaceArray;
            }
            return new NameWildcard(namespaceArray3);
        }
        if (this.excludedNamespace != null && this.excludedNamespace != Namespace.NONE && nameWildcard.excludedNamespace == Namespace.NONE) {
            return this;
        }
        if (nameWildcard.excludedNamespace != null && nameWildcard.excludedNamespace != Namespace.NONE && this.excludedNamespace == Namespace.NONE) {
            return nameWildcard;
        }
        return null;
    }

    public boolean isSubsetOf(NameWildcard nameWildcard) {
        if (nameWildcard.excludedNamespace == null && nameWildcard.includedNamespaces == null) {
            return true;
        }
        if (this.excludedNamespace != null && this.excludedNamespace == nameWildcard.excludedNamespace) {
            return true;
        }
        if (this.includedNamespaces != null) {
            if (nameWildcard.includedNamespaces != null) {
                int n = 0;
                while (n < this.includedNamespaces.length) {
                    Namespace namespace = this.includedNamespaces[n];
                    boolean bl = false;
                    int n2 = 0;
                    while (n2 < nameWildcard.includedNamespaces.length) {
                        if (namespace == nameWildcard.includedNamespaces[n2]) {
                            bl = true;
                            break;
                        }
                        ++n2;
                    }
                    if (!bl) {
                        return false;
                    }
                    ++n;
                }
            } else {
                int n = 0;
                while (n < this.includedNamespaces.length) {
                    Namespace namespace = this.includedNamespaces[n];
                    if (nameWildcard.excludedNamespace == namespace || Namespace.NONE == namespace) {
                        return false;
                    }
                    ++n;
                }
            }
            return true;
        }
        return false;
    }

    public boolean containsName(Name name) {
        return this.match(name);
    }

    public boolean containsAnyName() {
        return this.excludedNamespace == null && this.includedNamespaces == null;
    }
}

