/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.xsd.validate;

import com.xmlmind.xmledit.util.LinearHashtable;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xmlutil.XMLUtil;
import com.xmlmind.xmledit.xsd.validate.AllParticle;
import com.xmlmind.xmledit.xsd.validate.ChoiceParticle;
import com.xmlmind.xmledit.xsd.validate.ElementParticle;
import com.xmlmind.xmledit.xsd.validate.Msg;
import com.xmlmind.xmledit.xsd.validate.Particle;
import com.xmlmind.xmledit.xsd.validate.SequenceParticle;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.StringTokenizer;

public final class ParticleParser {
    private boolean strictSyntax;
    private String lookahead;
    private static final int PARENTHESE = 0;
    private static final int CONNECTOR_OR_PARENTHESE = 1;
    private static final int PCDATA = 2;
    private static final int NAME = 3;
    private static final int TERM = 4;
    private static final int OCCUR = 5;
    private static final int END = 6;
    private static final int OCCUR_OR_END = 7;
    private static final Particle[] NO_PARTICLES = new Particle[0];

    public ParticleParser(boolean bl) {
        this.strictSyntax = bl;
    }

    public boolean isStrictSyntax() {
        return this.strictSyntax;
    }

    public Particle parseMixedContent(String string) throws ParseException {
        Particle[] particleArray;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "(|)*", true);
        int n = 0;
        LinearHashtable linearHashtable = new LinearHashtable();
        boolean bl = false;
        while (stringTokenizer.hasMoreTokens()) {
            particleArray = stringTokenizer.nextToken();
            switch (n) {
                case 0: {
                    if (!particleArray.equals("(")) {
                        throw new ParseException(Msg.msg("PP.unexpectedToken", "(", particleArray));
                    }
                    n = 2;
                    break;
                }
                case 1: {
                    char c;
                    if (particleArray.length() != 1 || (c = particleArray.charAt(0)) != '|' && c != ')') {
                        throw new ParseException(Msg.msg("PP.unexpectedToken", "|)", particleArray));
                    }
                    n = c == '|' ? 3 : (bl ? 5 : 7);
                    break;
                }
                case 5: {
                    if (!particleArray.equals("*")) {
                        throw new ParseException(Msg.msg("PP.unexpectedToken", "*", particleArray));
                    }
                    n = 6;
                    break;
                }
                case 2: {
                    if (!particleArray.equals("#PCDATA")) {
                        throw new ParseException(Msg.msg("PP.unexpectedToken", "#PCDATA", particleArray));
                    }
                    n = 1;
                    break;
                }
                case 3: {
                    if (!XMLUtil.isName((String)particleArray)) {
                        throw new ParseException(Msg.msg("PP.unexpectedToken", Msg.msg("PP.elementName"), particleArray));
                    }
                    Name name = Name.get((String)particleArray);
                    if (linearHashtable.put(name, name) != null) {
                        throw new ParseException(Msg.msg("PP.duplicateElementName", particleArray));
                    }
                    bl = true;
                    n = 1;
                    break;
                }
                case 7: {
                    if (!particleArray.equals("*")) {
                        throw new ParseException(Msg.msg("PP.unexpectedToken", "*", particleArray));
                    }
                    n = 6;
                    break;
                }
                case 6: {
                    throw new ParseException(Msg.msg("PP.unexpectedToken", Msg.msg("PP.endOfSpec"), particleArray));
                }
                default: {
                    throw new RuntimeException("internal error: unknown state " + n);
                }
            }
        }
        switch (n) {
            case 6: 
            case 7: {
                break;
            }
            default: {
                throw new ParseException(Msg.msg("PP.unexpectedEndOfSpec"));
            }
        }
        if (!bl) {
            return new SequenceParticle(NO_PARTICLES, 1, 1);
        }
        particleArray = new Particle[linearHashtable.size()];
        Enumeration enumeration = linearHashtable.elements();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            particleArray[n2++] = new ElementParticle((Name)enumeration.nextElement(), 1, 1);
        }
        return new ChoiceParticle(particleArray, 0, -1);
    }

    public Particle parseElementContent(String string) throws ParseException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "(|,&)?*+{}", true);
        this.lookahead = stringTokenizer.nextToken();
        Particle particle = this.parseElementContent(stringTokenizer);
        if (this.lookahead != null) {
            throw new ParseException(Msg.msg("PP.unexpectedToken", Msg.msg("PP.endOfSpec"), this.lookahead));
        }
        return particle;
    }

    private Particle parseElementContent(StringTokenizer stringTokenizer) throws ParseException {
        int n;
        int n2;
        int n3;
        Name name = null;
        Particle[] particleArray = null;
        if (this.lookahead.charAt(0) == '(') {
            n3 = 4;
            this.lookahead = ParticleParser.nextToken(stringTokenizer);
            n2 = 0;
            ArrayList<Particle> arrayList = new ArrayList<Particle>();
            block29: while (true) {
                switch (n3) {
                    case 4: {
                        arrayList.add(this.parseElementContent(stringTokenizer));
                        n3 = 1;
                        if (this.lookahead != null) continue block29;
                        throw new ParseException(Msg.msg("PP.unexpectedToken", "|,&)", Msg.msg("PP.endOfSpec")));
                    }
                    case 1: {
                        if (this.lookahead.length() != 1) {
                            throw new ParseException(Msg.msg("PP.unexpectedToken", "|,&)", this.lookahead));
                        }
                        int n4 = this.lookahead.charAt(0);
                        switch (n4) {
                            case 38: 
                            case 44: 
                            case 124: {
                                if (n2 == 0) {
                                    n2 = n4;
                                } else if (n4 != n2) {
                                    throw new ParseException(Msg.msg("PP.unexpectedToken", (char)n2 + ")", this.lookahead));
                                }
                                n3 = 4;
                                this.lookahead = ParticleParser.nextToken(stringTokenizer);
                                continue block29;
                            }
                            case 41: {
                                n3 = 6;
                                break block29;
                            }
                        }
                        throw new ParseException(Msg.msg("PP.unexpectedToken", "|,&)", this.lookahead));
                    }
                    default: {
                        throw new RuntimeException("internal error: unknown state " + n3);
                    }
                }
                break;
            }
            if (n3 != 6) {
                throw new ParseException(Msg.msg("PP.unexpectedEndOfSpec"));
            }
            switch (n2) {
                case 124: {
                    n = 1;
                    break;
                }
                case 38: {
                    if (this.strictSyntax) {
                        throw new ParseException(Msg.msg("PP.strictSyntaxError", "&"));
                    }
                    n = 2;
                    break;
                }
                case 44: {
                    n = 0;
                    break;
                }
                case 0: {
                    Particle particle = (Particle)arrayList.get(0);
                    if (particle.getMinOccurs() == 1 && particle.getMaxOccurs() == 1 && particle instanceof ElementParticle) {
                        name = ((ElementParticle)particle).getElementName();
                        n = 3;
                        break;
                    }
                    n = 0;
                    break;
                }
                default: {
                    throw new RuntimeException("internal error: unknown connector " + (char)n2);
                }
            }
            if (n != 3) {
                particleArray = new Particle[arrayList.size()];
                arrayList.toArray(particleArray);
            }
        } else {
            if (!XMLUtil.isName(this.lookahead)) {
                throw new ParseException(Msg.msg("PP.unexpectedToken", Msg.msg("PP.elementName"), this.lookahead));
            }
            name = Name.get(this.lookahead);
            n = 3;
        }
        n3 = 1;
        n2 = 1;
        this.lookahead = ParticleParser.nextTokenIfAny(stringTokenizer);
        if (this.lookahead != null) {
            switch (this.lookahead.charAt(0)) {
                case '?': {
                    n3 = 0;
                    n2 = 1;
                    this.lookahead = ParticleParser.nextTokenIfAny(stringTokenizer);
                    break;
                }
                case '*': {
                    n3 = 0;
                    n2 = -1;
                    this.lookahead = ParticleParser.nextTokenIfAny(stringTokenizer);
                    break;
                }
                case '+': {
                    n3 = 1;
                    n2 = -1;
                    this.lookahead = ParticleParser.nextTokenIfAny(stringTokenizer);
                    break;
                }
                case '{': {
                    if (this.strictSyntax) {
                        throw new ParseException(Msg.msg("PP.strictSyntaxError", "{m,n}"));
                    }
                    this.lookahead = ParticleParser.nextToken(stringTokenizer);
                    n3 = ParticleParser.parseOccur(this.lookahead);
                    this.lookahead = ParticleParser.nextToken(stringTokenizer);
                    switch (this.lookahead.charAt(0)) {
                        case ',': {
                            this.lookahead = ParticleParser.nextToken(stringTokenizer);
                            if (this.lookahead.charAt(0) == '}') {
                                n2 = -1;
                                break;
                            }
                            n2 = ParticleParser.parseOccur(this.lookahead);
                            this.lookahead = ParticleParser.nextToken(stringTokenizer);
                            if (this.lookahead.charAt(0) == '}') break;
                            throw new ParseException(Msg.msg("PP.unexpectedToken", "}", this.lookahead));
                        }
                        case '}': {
                            n2 = n3;
                            break;
                        }
                        default: {
                            throw new ParseException(Msg.msg("PP.unexpectedToken", ",}", this.lookahead));
                        }
                    }
                    if (n2 == 0 || n2 != -1 && n3 > n2) {
                        throw new ParseException(Msg.msg("PP.invalidMinMaxOccurs"));
                    }
                    this.lookahead = ParticleParser.nextTokenIfAny(stringTokenizer);
                }
            }
        }
        if (n == 3) {
            return new ElementParticle(name, n3, n2);
        }
        if (particleArray.length == 1 && n3 == 1 && n2 == 1) {
            return particleArray[0];
        }
        switch (n) {
            case 1: {
                return new ChoiceParticle(particleArray, n3, n2);
            }
            case 0: {
                return new SequenceParticle(particleArray, n3, n2);
            }
            case 2: {
                return new AllParticle(particleArray, n3, n2);
            }
        }
        throw new RuntimeException("internal error: unknown particle type " + n);
    }

    private static String nextTokenIfAny(StringTokenizer stringTokenizer) {
        return stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : null;
    }

    private static String nextToken(StringTokenizer stringTokenizer) throws ParseException {
        if (!stringTokenizer.hasMoreTokens()) {
            throw new ParseException(Msg.msg("PP.unexpectedEndOfSpec"));
        }
        return stringTokenizer.nextToken();
    }

    private static int parseOccur(String string) throws ParseException {
        int n;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            n = -1;
        }
        if (n < 0) {
            throw new ParseException(Msg.msg("PP.unexpectedToken", Msg.msg("PP.occur"), string));
        }
        return n;
    }

    public static class ParseException
    extends Exception {
        public ParseException(String string) {
            super(string);
        }
    }
}

