/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.xsd.validate;

import com.xmlmind.xmledit.doc.AttributeDefaultValue;
import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.InclusionInfo;
import com.xmlmind.xmledit.doc.Tree;
import com.xmlmind.xmledit.doctype.Diagnostic;
import com.xmlmind.xmledit.doctype.DocumentType;
import com.xmlmind.xmledit.doctype.ElementType;
import com.xmlmind.xmledit.doctype.IdEntry;
import com.xmlmind.xmledit.doctype.IdRefItem;
import com.xmlmind.xmledit.util.URLUtil;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xmlutil.PrefixEntry;
import com.xmlmind.xmledit.xsd.datatype.Value;
import com.xmlmind.xmledit.xsd.validate.AttributeDeclaration;
import com.xmlmind.xmledit.xsd.validate.BuiltInType;
import com.xmlmind.xmledit.xsd.validate.ComplexType;
import com.xmlmind.xmledit.xsd.validate.ElementDeclaration;
import com.xmlmind.xmledit.xsd.validate.ElementTypeImpl;
import com.xmlmind.xmledit.xsd.validate.IdCollector;
import com.xmlmind.xmledit.xsd.validate.IdFinder;
import com.xmlmind.xmledit.xsd.validate.IdentityConstraintChecker;
import com.xmlmind.xmledit.xsd.validate.Msg;
import com.xmlmind.xmledit.xsd.validate.Notation;
import com.xmlmind.xmledit.xsd.validate.SimpleType;
import com.xmlmind.xmledit.xsd.validate.Type;
import com.xmlmind.xmledit.xsd.validate.ValidationError;
import com.xmlmind.xmledit.xsd.validate.ValidationErrors;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Schema
implements Serializable,
DocumentType {
    private Hashtable elementDeclarations = new Hashtable();
    private Hashtable attributeDeclarations = new Hashtable();
    private Hashtable types = new Hashtable();
    private Hashtable notations = new Hashtable();
    private PrefixEntry[] preferredPrefixes = null;
    private transient URL[] sourceURLs = new URL[0];

    public void addElementDeclaration(ElementDeclaration elementDeclaration) {
        this.elementDeclarations.put(elementDeclaration.getName(), elementDeclaration);
    }

    public void addAttributeDeclaration(AttributeDeclaration attributeDeclaration) {
        this.attributeDeclarations.put(attributeDeclaration.getName(), attributeDeclaration);
    }

    public void addType(Type type) {
        this.types.put(type.getName(), type);
    }

    public void addNotation(Notation notation) {
        this.notations.put(notation.getName(), notation);
    }

    public void setPreferredPrefixes(PrefixEntry[] prefixEntryArray) {
        this.preferredPrefixes = prefixEntryArray;
    }

    public void setSourceURLs(URL[] uRLArray) {
        this.sourceURLs = uRLArray == null ? new URL[]{} : uRLArray;
    }

    public ElementDeclaration getElementDeclaration(Name name) {
        return (ElementDeclaration)this.elementDeclarations.get(name);
    }

    public int getElementDeclarationCount() {
        return this.elementDeclarations.size();
    }

    public Enumeration getElementDeclarations() {
        return this.elementDeclarations.elements();
    }

    public AttributeDeclaration getAttributeDeclaration(Name name) {
        return (AttributeDeclaration)this.attributeDeclarations.get(name);
    }

    public int getAttributeDeclarationCount() {
        return this.attributeDeclarations.size();
    }

    public Enumeration getAttributeDeclarations() {
        return this.attributeDeclarations.elements();
    }

    public Type findType(Name name) {
        Type type = BuiltInType.get(name);
        if (type != null) {
            return type;
        }
        return (Type)this.types.get(name);
    }

    public Type getType(Name name) {
        return (Type)this.types.get(name);
    }

    public int getTypeCount() {
        return this.types.size();
    }

    public Enumeration getTypes() {
        return this.types.elements();
    }

    public Notation getNotation(Name name) {
        return (Notation)this.notations.get(name);
    }

    public int getNotationCount() {
        return this.notations.size();
    }

    public Enumeration getNotations() {
        return this.notations.elements();
    }

    public ValidationError[] validate(Document document) {
        ValidationErrors validationErrors = new ValidationErrors();
        this.validate(document, validationErrors);
        return validationErrors.toArray();
    }

    public Object validate(Document document, ValidationErrors validationErrors) {
        Element element = document.getRootElement();
        Object object = this.validate(element, true, validationErrors);
        if (object != null && !this.checkIds(element, validationErrors)) {
            object = null;
        }
        if (object != null && !this.checkIdentityConstraints(element, validationErrors)) {
            object = null;
        }
        return object;
    }

    protected boolean checkIds(Element element, ValidationErrors validationErrors) {
        Object object;
        Object object2;
        HashMap hashMap = new HashMap();
        ArrayList arrayList = new ArrayList();
        new IdCollector(this).collect(element, hashMap, arrayList);
        boolean bl = true;
        Iterator iterator = hashMap.values().iterator();
        while (iterator.hasNext()) {
            IdEntry idEntry = (IdEntry)iterator.next();
            if (idEntry.elements.length <= 1) continue;
            Element[] elementArray = idEntry.elements;
            object2 = elementArray[0];
            object = Schema.findInclusionInfo((Element)object2);
            String string = null;
            int n = 1;
            while (n < elementArray.length) {
                InclusionInfo inclusionInfo;
                Element element2 = elementArray[n];
                String string2 = "cvc-id.2";
                String string3 = Msg.msg("multiplyDefinedID", idEntry.id);
                if (object != null && (inclusionInfo = Schema.findInclusionInfo(element2)) != null && Schema.sameIncludedElement(inclusionInfo, element2, (InclusionInfo)object, (Element)object2)) {
                    if (string == null) {
                        string = URLUtil.toDisplayForm(((InclusionInfo)object).getDocumentLocation((Element)object2));
                        String string4 = ((InclusionInfo)object).getXIncludeXPointer();
                        if (string4 != null) {
                            string = string + "#" + string4;
                        }
                    }
                    string3 = string3 + " (" + Msg.msg("sameIncludedElement", string) + ")";
                }
                validationErrors.append(element2, string2, string3);
                bl = false;
                ++n;
            }
        }
        int n = arrayList.size();
        if (n > 0) {
            int n2 = 0;
            while (n2 < n) {
                object2 = (IdRefItem)arrayList.get(n2);
                object = ((IdRefItem)object2).idRefs;
                int n3 = 0;
                while (n3 < ((String[])object).length) {
                    if (!hashMap.containsKey(object[n3])) {
                        validationErrors.append(((IdRefItem)object2).element, "cvc-id.1", Msg.msg("referenceToUndefinedID", object[n3]));
                        bl = false;
                    }
                    ++n3;
                }
                ++n2;
            }
        }
        return bl;
    }

    private static final InclusionInfo findInclusionInfo(Element element) {
        while (element != null) {
            InclusionInfo inclusionInfo = (InclusionInfo)element.getProperty("INCLUSION_INFO");
            if (inclusionInfo != null) {
                return inclusionInfo;
            }
            element = element.getParentElement();
        }
        return null;
    }

    private static final boolean sameIncludedElement(InclusionInfo inclusionInfo, Element element, InclusionInfo inclusionInfo2, Element element2) {
        URL uRL = inclusionInfo.getDocumentLocation(element);
        URL uRL2 = inclusionInfo2.getDocumentLocation(element2);
        if (uRL == null || uRL2 == null || !uRL.equals(uRL2)) {
            return false;
        }
        String string = inclusionInfo.getXIncludeXPointer();
        String string2 = inclusionInfo2.getXIncludeXPointer();
        return string == null && string2 == null || string != null && string.equals(string2);
    }

    protected boolean checkIdentityConstraints(Element element, ValidationErrors validationErrors) {
        return new IdentityConstraintChecker(this).check(element, validationErrors);
    }

    public ValidationError[] validate(Element element, boolean bl) {
        ValidationErrors validationErrors = new ValidationErrors();
        this.validate(element, bl, validationErrors);
        return validationErrors.toArray();
    }

    public Object validate(Element element, boolean bl, ValidationErrors validationErrors) {
        Type type = this.findElementType(element);
        if (type == null) {
            validationErrors.append(element, "cvc-type.1", Msg.msg("elementTypeNotFound"));
            return null;
        }
        return type.validate(element, bl, this, validationErrors);
    }

    public Type findElementType(Element element) {
        Object object;
        int n = 0;
        Tree tree = element;
        while (tree != null) {
            ++n;
            tree = tree.getParent();
        }
        Element[] elementArray = new Element[n];
        n = 0;
        Type type = null;
        tree = element;
        while (tree instanceof Element) {
            object = tree;
            elementArray[n++] = object;
            type = this.getElementLocalType((Element)object);
            if (type != null) break;
            tree = tree.getParent();
        }
        if (type == null) {
            object = this.getElementDeclaration(elementArray[n - 1].getName());
            if (object == null) {
                return null;
            }
            type = ((ElementDeclaration)object).getType();
        }
        int n2 = n - 1;
        while (n2 >= 1) {
            Name name;
            ComplexType complexType;
            ElementDeclaration elementDeclaration = null;
            if (type instanceof ComplexType && (complexType = (ComplexType)type).containsElementField(name = elementArray[n2 - 1].getName()) && (elementDeclaration = complexType.getElementDeclaration(name)) == null) {
                elementDeclaration = this.getElementDeclaration(name);
            }
            if (elementDeclaration == null) {
                return null;
            }
            type = elementDeclaration.getType();
            --n2;
        }
        return type;
    }

    public Type getElementLocalType(Element element) {
        String string = element.getAttribute(Name.XSI_TYPE);
        if (string == null) {
            return null;
        }
        Name name = Name.parse(string, false, element);
        return name == null ? null : this.findType(name);
    }

    public ElementDeclaration findElementDeclaration(Element element) {
        Name name = element.getName();
        Tree tree = element.getParent();
        if (tree == null) {
            return null;
        }
        if (tree instanceof Document) {
            return this.getElementDeclaration(name);
        }
        Type type = this.findElementType((Element)tree);
        if (type == null || type instanceof SimpleType) {
            return null;
        }
        ComplexType complexType = (ComplexType)type;
        ElementDeclaration elementDeclaration = null;
        if (complexType.containsElementField(name) && (elementDeclaration = complexType.getElementDeclaration(name)) == null) {
            elementDeclaration = this.getElementDeclaration(name);
        }
        return elementDeclaration;
    }

    public AttributeDeclaration findAttributeDeclaration(Element element, Name name) {
        Type type = this.findElementType(element);
        if (type == null || type instanceof SimpleType) {
            return null;
        }
        ComplexType complexType = (ComplexType)type;
        AttributeDeclaration attributeDeclaration = null;
        if (complexType.containsAttributeField(name) && (attributeDeclaration = complexType.getAttributeDeclaration(name)) == null) {
            attributeDeclaration = this.getAttributeDeclaration(name);
        }
        return attributeDeclaration;
    }

    public URL[] getSourceURLs() {
        return this.sourceURLs;
    }

    public PrefixEntry[] getPreferredPrefixes() {
        return this.preferredPrefixes;
    }

    public boolean isDTD() {
        return false;
    }

    public Diagnostic[] checkDocument(Document document) {
        return this.validate(document);
    }

    public ElementType getElementType(Element element) {
        ElementDeclaration elementDeclaration = this.findElementDeclaration(element);
        if (elementDeclaration == null) {
            return null;
        }
        return new ElementTypeImpl(this, elementDeclaration, this.getElementLocalType(element));
    }

    public String getElementAttribute(Element element, Name name, AttributeDefaultValue attributeDefaultValue) {
        Value value;
        AttributeDeclaration attributeDeclaration;
        String string = element.getAttribute(name, attributeDefaultValue);
        if (string == null && (attributeDeclaration = this.findAttributeDeclaration(element, name)) != null && (value = attributeDeclaration.getDefaultValue()) != null) {
            string = value.toString(element);
        }
        return string;
    }

    public String lookupElementAttribute(Element element, Name name, AttributeDefaultValue attributeDefaultValue) {
        Object object;
        Object object2 = element.getAttribute(name, attributeDefaultValue);
        if (object2 != null) {
            return object2;
        }
        int n = 0;
        Tree tree = element;
        while (tree != null) {
            ++n;
            tree = tree.getParent();
        }
        Element[] elementArray = new Element[n];
        n = 0;
        tree = element;
        while (tree instanceof Element) {
            elementArray[n++] = tree;
            tree = tree.getParent();
        }
        Type type = this.getElementLocalType(elementArray[n - 1]);
        if (type == null) {
            object = this.getElementDeclaration(elementArray[n - 1].getName());
            type = object == null ? ComplexType.ANY : ((ElementDeclaration)object).getType();
        }
        int n2 = n - 1;
        while (n2 >= 1) {
            Type type2;
            object = this.getAttributeDefaulted(elementArray[n2], name, attributeDefaultValue, type);
            if (object != null) {
                object2 = object;
            }
            if ((type2 = this.getElementLocalType(elementArray[n2 - 1])) == null) {
                if (type instanceof SimpleType) {
                    type = ComplexType.ANY;
                }
                ComplexType complexType = (ComplexType)type;
                Name name2 = elementArray[n2 - 1].getName();
                ElementDeclaration elementDeclaration = null;
                if (complexType.containsElementField(name2) && (elementDeclaration = complexType.getElementDeclaration(name2)) == null) {
                    elementDeclaration = this.getElementDeclaration(name2);
                }
                type2 = elementDeclaration == null ? ComplexType.ANY : elementDeclaration.getType();
            }
            type = type2;
            --n2;
        }
        object = this.getAttributeDefaulted(element, name, attributeDefaultValue, type);
        if (object != null) {
            object2 = object;
        }
        return object2;
    }

    private final String getAttributeDefaulted(Element element, Name name, AttributeDefaultValue attributeDefaultValue, Type type) {
        String string = element.getAttribute(name, attributeDefaultValue);
        if (string == null && type instanceof ComplexType) {
            Value value;
            ComplexType complexType = (ComplexType)type;
            AttributeDeclaration attributeDeclaration = null;
            if (complexType.getAttributeUse(name) != null && (attributeDeclaration = complexType.getAttributeDeclaration(name)) == null) {
                attributeDeclaration = this.getAttributeDeclaration(name);
            }
            if (attributeDeclaration != null && (value = attributeDeclaration.getDefaultValue()) != null) {
                string = value.toString(element);
            }
        }
        return string;
    }

    public Element findElementById(Element element, String string, boolean bl) {
        return new IdFinder(this).find(element, string, bl);
    }

    public void collectIds(Element element, Map map) {
        if (!map.isEmpty()) {
            map.clear();
        }
        new IdCollector(this).collect(element, map, null);
    }

    public void collectIdRefs(Element element, List list) {
        if (!list.isEmpty()) {
            list.clear();
        }
        new IdCollector(this).collect(element, null, list);
    }
}

