/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.xsd.validate;

import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.util.LinearHashtable;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xmlutil.Namespace;
import com.xmlmind.xmledit.xmlutil.NamespaceURLPair;
import com.xmlmind.xmledit.xmlutil.XMLCatalogs;
import com.xmlmind.xmledit.xmlutil.XMLUtil;
import com.xmlmind.xmledit.xsd.validate.MultiXMLSchema;
import com.xmlmind.xmledit.xsd.validate.Schema;
import com.xmlmind.xmledit.xsd.validate.XMLSchema;
import java.net.MalformedURLException;
import java.net.URL;

public final class SchemaUtil {
    public static Namespace[] getTargetNamespaces(Schema schema) {
        if (schema instanceof XMLSchema) {
            return new Namespace[]{((XMLSchema)schema).getTargetNamespace()};
        }
        if (schema instanceof MultiXMLSchema) {
            return ((MultiXMLSchema)schema).getTargetNamespaces();
        }
        return new Namespace[0];
    }

    public static NamespaceURLPair[] getSchemaLocations(Document document) throws MalformedURLException {
        return SchemaUtil.getSchemaLocations(document.getRootElement());
    }

    public static NamespaceURLPair[] getSchemaLocations(Element element) throws MalformedURLException {
        URL uRL = element.getLocation();
        LinearHashtable linearHashtable = new LinearHashtable();
        SchemaUtil.addSchemaLocations(element, uRL, linearHashtable);
        Object[] objectArray = new NamespaceURLPair[linearHashtable.size()];
        linearHashtable.copyElementsInto(objectArray);
        return objectArray;
    }

    private static void addSchemaLocations(Element element, URL uRL, LinearHashtable linearHashtable) throws MalformedURLException {
        Object object;
        String string = element.getAttribute(Name.XSI_SCHEMA_LOCATION);
        if (string != null) {
            object = XMLUtil.splitList(string);
            int n = 2 * (((String[])object).length / 2);
            int n2 = 0;
            while (n2 < n) {
                String string2 = object[n2];
                String string3 = object[n2 + 1];
                URL uRL2 = XMLCatalogs.resolveURI(string3, uRL);
                NamespaceURLPair namespaceURLPair = new NamespaceURLPair(Namespace.get(string2), uRL2);
                linearHashtable.put(namespaceURLPair.namespace, namespaceURLPair);
                n2 += 2;
            }
        }
        if ((string = element.getAttribute(Name.XSI_NO_NAMESPACE_SCHEMA_LOCATION)) != null) {
            object = XMLCatalogs.resolveURI(string.trim(), uRL);
            NamespaceURLPair namespaceURLPair = new NamespaceURLPair(Namespace.NONE, (URL)object);
            linearHashtable.put(namespaceURLPair.namespace, namespaceURLPair);
        }
    }

    public static final URL[] mergeURLs(URL[] uRLArray, URL[] uRLArray2) {
        URL[] uRLArray3;
        if (uRLArray == null || uRLArray.length == 0) {
            return uRLArray2;
        }
        if (uRLArray2 == null || uRLArray2.length == 0) {
            return uRLArray;
        }
        URL[] uRLArray4 = new URL[uRLArray.length + uRLArray2.length];
        System.arraycopy(uRLArray, 0, uRLArray4, 0, uRLArray.length);
        int n = uRLArray.length;
        int n2 = 0;
        while (n2 < uRLArray2.length) {
            uRLArray3 = uRLArray2[n2];
            boolean bl = true;
            int n3 = 0;
            while (n3 < uRLArray.length) {
                if (uRLArray[n3].equals(uRLArray3)) {
                    bl = false;
                    break;
                }
                ++n3;
            }
            if (bl) {
                uRLArray4[n++] = uRLArray3;
            }
            ++n2;
        }
        if (n != uRLArray4.length) {
            uRLArray3 = new URL[n];
            System.arraycopy(uRLArray4, 0, uRLArray3, 0, n);
            uRLArray4 = uRLArray3;
        }
        return uRLArray4;
    }
}

