/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.xsd.validate;

import com.xmlmind.xmledit.doc.Attribute;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.doc.Text;
import com.xmlmind.xmledit.doc.XNode;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xmlutil.Namespace;
import com.xmlmind.xmledit.xsd.datatype.AnyStringType;
import com.xmlmind.xmledit.xsd.datatype.DataType;
import com.xmlmind.xmledit.xsd.datatype.InvalidDataException;
import com.xmlmind.xmledit.xsd.datatype.InvalidTypeException;
import com.xmlmind.xmledit.xsd.datatype.ListType;
import com.xmlmind.xmledit.xsd.datatype.Restriction;
import com.xmlmind.xmledit.xsd.datatype.UnionType;
import com.xmlmind.xmledit.xsd.datatype.Value;
import com.xmlmind.xmledit.xsd.validate.BuiltInType;
import com.xmlmind.xmledit.xsd.validate.ComplexType;
import com.xmlmind.xmledit.xsd.validate.Msg;
import com.xmlmind.xmledit.xsd.validate.Schema;
import com.xmlmind.xmledit.xsd.validate.Type;
import com.xmlmind.xmledit.xsd.validate.ValidationError;
import com.xmlmind.xmledit.xsd.validate.ValidationErrors;
import java.io.ObjectStreamException;

public class SimpleType
extends Type {
    public static final Name XSD_ANY_SIMPLE_TYPE = Name.get(Namespace.XSD, "anySimpleType");
    public static final SimpleType ANY = SimpleType.createAnySimpleType();
    private DataType dataType;

    private static final SimpleType createAnySimpleType() {
        DataType dataType;
        SimpleType simpleType = new SimpleType(XSD_ANY_SIMPLE_TYPE, ComplexType.ANY, 2, false, 0, 0);
        Restriction restriction = new Restriction(AnyStringType.BASE);
        try {
            dataType = restriction.derive(simpleType);
        }
        catch (InvalidTypeException invalidTypeException) {
            invalidTypeException.printStackTrace();
            dataType = null;
        }
        simpleType.setDataType(dataType);
        return simpleType;
    }

    public SimpleType(Name name, Type type, int n, boolean bl, int n2, int n3) {
        super(name, type, n, bl, n2, n3);
    }

    public void setDataType(DataType dataType) {
        if (dataType == null || dataType.getProperties() != this) {
            throw new IllegalArgumentException("bad dataType " + dataType);
        }
        this.dataType = dataType;
    }

    private Object readResolve() throws ObjectStreamException {
        if (this.name == null) {
            return this;
        }
        Type type = BuiltInType.get(this.name);
        return type == null ? this : type;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public ValidationError validate(String string, Element element, Schema schema) {
        ValidationErrors validationErrors = new ValidationErrors();
        Value value = this.validate(string, element, schema, validationErrors);
        if (value == null) {
            return validationErrors.getLast();
        }
        return null;
    }

    public Value validate(String string, Element element, Schema schema, ValidationErrors validationErrors) {
        try {
            return this.dataType.valueOf(string, element);
        }
        catch (InvalidDataException invalidDataException) {
            validationErrors.append(null, invalidDataException.getConstraint(), invalidDataException.getMessage());
            return null;
        }
    }

    protected Object validate(Element element, String string, boolean bl, Schema schema, ValidationErrors validationErrors) {
        Object object;
        XNode xNode;
        Object object2;
        if (this.isAbstract) {
            validationErrors.append(element, "cvc-type.2", Msg.msg("typeIsAbstract"));
            return null;
        }
        if (element.getAttributeCount() > 0) {
            object2 = element.getAttributes();
            while (object2.hasMoreElements()) {
                xNode = (Attribute)object2.nextElement();
                object = ((Attribute)xNode).name;
                if (object == Name.XSI_TYPE || object == Name.XSI_NIL || object == Name.XSI_SCHEMA_LOCATION || object == Name.XSI_NO_NAMESPACE_SCHEMA_LOCATION) continue;
                validationErrors.append(element, "cvc-type.3.1.1", Msg.msg("elementHasAttributes"));
                return null;
            }
        }
        object2 = null;
        xNode = element.getFirstChild();
        while (xNode != null) {
            switch (((Node)xNode).getNodeType()) {
                case 1: 
                case 2: {
                    break;
                }
                case 0: {
                    if (object2 == null) {
                        object2 = new StringBuffer();
                    }
                    ((StringBuffer)object2).append(((Text)xNode).getTextChars());
                    break;
                }
                default: {
                    validationErrors.append(element, "cvc-type.3.1.2", Msg.msg("elementHasChildElements"));
                    return null;
                }
            }
            xNode = ((Node)xNode).getNextSibling();
        }
        if (Type.isNilled(element)) {
            return Type.VALID;
        }
        object = object2 == null || ((StringBuffer)object2).length() == 0 ? (string == null ? "" : string) : ((StringBuffer)object2).toString();
        try {
            return this.dataType.valueOf((String)object, element);
        }
        catch (InvalidDataException invalidDataException) {
            validationErrors.append(element, "cvc-type.3.1.3", Msg.msg("elementContainsInvalidData", invalidDataException.getMessage(), invalidDataException.getConstraint()));
            return null;
        }
    }

    public boolean isValidDerivation(Type type, int n) {
        if (this == type) {
            return true;
        }
        Type type2 = this.baseType;
        if ((n & 2) != 0 || (type2.prohibitedDerivations & 2) != 0) {
            return false;
        }
        if (type2 == type) {
            return true;
        }
        if (type2 != ComplexType.ANY && type2.isValidDerivation(type, n)) {
            return true;
        }
        DataType dataType = this.getDataType();
        if ((dataType instanceof ListType || dataType instanceof UnionType) && type == ANY) {
            return true;
        }
        DataType dataType2 = type.getDataType();
        if (dataType2 instanceof UnionType) {
            DataType[] dataTypeArray = ((UnionType)dataType2).getMemberTypes();
            int n2 = 0;
            while (n2 < dataTypeArray.length) {
                SimpleType simpleType = (SimpleType)dataTypeArray[n2].getProperties();
                if (this.isValidDerivation(simpleType, n)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }
}

