/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmledit.xsd.validate;

import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xsd.datatype.DataType;
import com.xmlmind.xmledit.xsd.validate.Schema;
import com.xmlmind.xmledit.xsd.validate.ValidationError;
import com.xmlmind.xmledit.xsd.validate.ValidationErrors;
import java.io.Serializable;

public abstract class Type
implements Serializable {
    public static final Object VALID = new Object();
    public static final int EXTENSION = 1;
    public static final int RESTRICTION = 2;
    public static final int LIST = 4;
    public static final int UNION = 8;
    protected Name name;
    protected Type baseType;
    protected byte derivationMethod;
    protected boolean isAbstract;
    protected byte prohibitedDerivations;
    protected byte prohibitedSubstitutions;

    protected Type(Name name, Type type, int n, boolean bl, int n2, int n3) {
        this.name = name;
        this.baseType = type;
        this.derivationMethod = (byte)n;
        this.isAbstract = bl;
        this.prohibitedDerivations = (byte)n2;
        this.prohibitedSubstitutions = (byte)n3;
    }

    public Type getBaseType() {
        return this.baseType;
    }

    public int getDerivationMethod() {
        return this.derivationMethod;
    }

    public Name getName() {
        return this.name;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public int getProhibitedDerivations() {
        return this.prohibitedDerivations;
    }

    public int getProhibitedSubstitutions() {
        return this.prohibitedSubstitutions;
    }

    public abstract DataType getDataType();

    public ValidationError[] validate(Element element, boolean bl, Schema schema) {
        ValidationErrors validationErrors = new ValidationErrors();
        this.validate(element, bl, schema, validationErrors);
        return validationErrors.toArray();
    }

    public Object validate(Element element, boolean bl, Schema schema, ValidationErrors validationErrors) {
        return this.validate(element, null, bl, schema, validationErrors);
    }

    protected abstract Object validate(Element var1, String var2, boolean var3, Schema var4, ValidationErrors var5);

    protected static final boolean isNilled(Element element) {
        String string = element.getAttribute(Name.XSI_NIL);
        if (string == null) {
            return false;
        }
        return (string = string.trim()).equals("1") || string.equals("true");
    }

    public abstract boolean isValidDerivation(Type var1, int var2);
}

