/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.xhtml.form;

import com.xmlmind.xmledit.doc.DocumentEvent;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.edit.DocumentUtil;
import com.xmlmind.xmledit.edit.EditUtil;
import com.xmlmind.xmledit.gadget.ComponentWrapper;
import com.xmlmind.xmledit.gadget.WrappedComponent;
import com.xmlmind.xmledit.guiutil.DialogUtil;
import com.xmlmind.xmledit.guiutil.ImageResource;
import com.xmlmind.xmledit.imagetoolkit.ImageToolkits;
import com.xmlmind.xmledit.styledgadget.Icon;
import com.xmlmind.xmledit.styledgadget.Style;
import com.xmlmind.xmledit.styledgadget.TextLines;
import com.xmlmind.xmledit.styledview.ComponentFactory;
import com.xmlmind.xmledit.styledview.CustomViewManager;
import com.xmlmind.xmledit.styledview.StyledViewFactory;
import com.xmlmind.xmledit.stylesheet.StyleValue;
import com.xmlmind.xmledit.view.ViewFactory;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xmlutil.Namespace;
import com.xmlmind.xmleditapp.xhtml.form.ButtonGroupUtil;
import com.xmlmind.xmleditapp.xhtml.form.LimitedDocument;
import com.xmlmind.xmleditapp.xmlapputil.ComponentUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;

public class Input
implements ComponentFactory {
    private static final Name TYPE = Name.get((Namespace)Namespace.NONE, (String)"type");
    private static final Name NAME = Name.get((Namespace)Namespace.NONE, (String)"name");
    private static final Name VALUE = Name.get((Namespace)Namespace.NONE, (String)"value");
    private static final Name CHECKED = Name.get((Namespace)Namespace.NONE, (String)"checked");
    private static final Name SRC = Name.get((Namespace)Namespace.NONE, (String)"src");
    private static final Name SIZE = Name.get((Namespace)Namespace.NONE, (String)"size");
    private static final Name MAXLENGTH = Name.get((Namespace)Namespace.NONE, (String)"maxlength");
    private static final Name READONLY = Name.get((Namespace)Namespace.NONE, (String)"readonly");
    private static final Name DISABLED = Name.get((Namespace)Namespace.NONE, (String)"disabled");
    private static final Insets NO_MARGIN = new Insets(0, 0, 0, 0);

    public Component createComponent(Element element, Style style, StyleValue[] styleValueArray, StyledViewFactory styledViewFactory, boolean[] blArray) {
        styledViewFactory.addDependency(null, "input", Namespace.NONE, "type");
        JComponent jComponent = null;
        String string = element.getAttribute(TYPE);
        if (string == null) {
            string = "text";
        }
        if ("text".equals(string)) {
            jComponent = new XHTMLText(element);
        } else if ("password".equals(string)) {
            jComponent = new XHTMLPassword(element);
        } else if ("file".equals(string)) {
            jComponent = new XHTMLFile(element);
        } else if ("checkbox".equals(string)) {
            jComponent = new XHTMLCheckbox(element);
        } else if ("radio".equals(string)) {
            jComponent = new XHTMLRadio(element, styledViewFactory);
        } else if ("button".equals(string)) {
            jComponent = new XHTMLButton(element);
        } else if ("submit".equals(string)) {
            jComponent = new XHTMLSubmit(element);
        } else if ("reset".equals(string)) {
            jComponent = new XHTMLReset(element);
        } else if ("image".equals(string)) {
            jComponent = new XHTMLImage(element);
        }
        if (jComponent != null) {
            styledViewFactory.getCustomViewManager().add((CustomViewManager.BasicElementEditor)jComponent, element);
            ComponentUtil.addFocusGainedListener((Component)jComponent, (Element)element, (ViewFactory)styledViewFactory);
        }
        return jComponent;
    }

    private static final void refreshXHTMLText(JTextField jTextField, Element element, ComponentWrapper componentWrapper) {
        String string;
        LimitedDocument limitedDocument;
        int n = element.getIntAttribute(MAXLENGTH, -1);
        if (n <= 0) {
            n = Integer.MAX_VALUE;
        }
        if ((limitedDocument = (LimitedDocument)jTextField.getDocument()).getMaxLength() != n) {
            limitedDocument.setMaxLength(n);
        }
        if ((string = element.getAttribute(VALUE)) == null) {
            string = "";
        }
        jTextField.setText(string);
        int n2 = element.getIntAttribute(SIZE, -1);
        if (n2 <= 0) {
            n2 = 20;
        }
        if (jTextField.getColumns() != n2) {
            jTextField.setColumns(n2);
            if (componentWrapper != null) {
                componentWrapper.refresh();
            }
        }
        jTextField.setEditable(!element.hasAttribute(READONLY));
        jTextField.setEnabled(!element.hasAttribute(DISABLED));
    }

    private static final void refreshXHTMLToggle(JToggleButton jToggleButton, Element element, ComponentWrapper componentWrapper) {
        Dimension dimension;
        int n;
        boolean bl;
        Dimension dimension2 = jToggleButton.getPreferredSize();
        boolean bl2 = element.hasAttribute(CHECKED);
        if (bl2 != (bl = jToggleButton.isSelected())) {
            ButtonGroupUtil.setSelected(jToggleButton, bl2);
        }
        if ((n = element.getIntAttribute(SIZE, -1)) > 0) {
            jToggleButton.setPreferredSize(null);
            dimension = jToggleButton.getPreferredSize();
            dimension.width = n;
            jToggleButton.setPreferredSize(dimension);
        } else {
            jToggleButton.setPreferredSize(null);
            dimension = jToggleButton.getPreferredSize();
        }
        if (!dimension.equals(dimension2) && componentWrapper != null) {
            componentWrapper.refresh();
        }
        jToggleButton.setEnabled(!element.hasAttribute(DISABLED));
    }

    static /* synthetic */ Name access$700() {
        return CHECKED;
    }

    private static class XHTMLImage
    extends XHTMLSubmit {
        public XHTMLImage(Element element) {
            super(element);
        }

        public int getFirstBaseLine() {
            return -1;
        }

        protected String getDefaultLabel() {
            return null;
        }

        protected javax.swing.Icon getIconLabel() {
            Image image = null;
            String string = this.element.getAttribute(SRC);
            if (string != null) {
                URL uRL = null;
                try {
                    uRL = new URL(this.element.getLocation(), string.trim());
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
                if (uRL != null) {
                    try {
                        image = ImageToolkits.createImage(uRL);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (image == null) {
                image = Icon.get((String)"image");
            }
            return new ImageIcon(image);
        }
    }

    private static class XHTMLReset
    extends XHTMLButton {
        public XHTMLReset(Element element) {
            super(element);
        }

        protected String getDefaultLabel() {
            return "Reset";
        }

        protected javax.swing.Icon getIconLabel() {
            return null;
        }
    }

    private static class XHTMLSubmit
    extends XHTMLButton {
        public XHTMLSubmit(Element element) {
            super(element);
        }

        public boolean isDefaultButton() {
            return true;
        }

        protected String getDefaultLabel() {
            return "Submit";
        }

        protected javax.swing.Icon getIconLabel() {
            return null;
        }
    }

    private static class XHTMLButton
    extends JButton
    implements WrappedComponent,
    TextLines,
    CustomViewManager.BasicElementEditor {
        protected Element element;
        protected ComponentWrapper componentWrapper;

        public XHTMLButton(Element element) {
            this.element = element;
        }

        public void setComponentWrapper(ComponentWrapper componentWrapper) {
            this.componentWrapper = componentWrapper;
        }

        public ComponentWrapper getComponentWrapper() {
            return this.componentWrapper;
        }

        public int getFirstBaseLine() {
            return ComponentUtil.getFirstBaseLine((Component)this);
        }

        public int getLastBaseLine() {
            return this.getFirstBaseLine();
        }

        public void customViewAdded() {
            this.elementChanged(null);
        }

        public void customViewRemoved() {
        }

        public void commitChanges() {
        }

        public void elementChanged(DocumentEvent[] documentEventArray) {
            Object object;
            Dimension dimension = this.getPreferredSize();
            javax.swing.Icon icon = this.getIconLabel();
            if (icon != null) {
                this.setIcon(icon);
            } else {
                object = this.element.getAttribute(VALUE);
                if (object == null) {
                    object = this.getDefaultLabel();
                    if (object == null) {
                        object = "";
                    }
                } else {
                    object = ((String)object).trim();
                }
                this.setText((String)object);
            }
            int n = this.element.getIntAttribute(SIZE, -1);
            if (n > 0) {
                this.setPreferredSize(null);
                object = this.getPreferredSize();
                ((Dimension)object).width = n;
                this.setPreferredSize((Dimension)object);
            } else {
                this.setPreferredSize(null);
                object = this.getPreferredSize();
            }
            if (!((Dimension)object).equals(dimension) && this.componentWrapper != null) {
                this.componentWrapper.refresh();
            }
            this.setEnabled(!this.element.hasAttribute(DISABLED));
        }

        protected String getDefaultLabel() {
            return null;
        }

        protected javax.swing.Icon getIconLabel() {
            return null;
        }
    }

    private static class XHTMLRadio
    extends JRadioButton
    implements WrappedComponent,
    TextLines,
    CustomViewManager.BasicElementEditor {
        private Element element;
        private Object radioGroupNamespace;
        private String radioGroupName;
        private ComponentWrapper componentWrapper;
        private boolean refreshing;

        public XHTMLRadio(Element element, Object object) {
            this.element = element;
            this.radioGroupNamespace = object;
            this.radioGroupName = null;
            this.setHorizontalAlignment(0);
            this.setMargin(NO_MARGIN);
            this.setOpaque(false);
            this.addItemListener(new ItemListener(this){
                private final /* synthetic */ XHTMLRadio this$0;
                {
                    this.this$0 = xHTMLRadio;
                }

                public void itemStateChanged(ItemEvent itemEvent) {
                    if (XHTMLRadio.access$1000(this.this$0)) {
                        return;
                    }
                    boolean bl = this.this$0.isSelected();
                    boolean bl2 = XHTMLRadio.access$1100(this.this$0).hasAttribute(Input.access$700());
                    if (bl && !bl2) {
                        EditUtil.putAttribute((Element)XHTMLRadio.access$1100(this.this$0), (Name)Input.access$700(), (String)"checked");
                    } else if (!bl && bl2) {
                        EditUtil.removeAttribute((Element)XHTMLRadio.access$1100(this.this$0), (Name)Input.access$700());
                    }
                }
            });
        }

        public void setComponentWrapper(ComponentWrapper componentWrapper) {
            this.componentWrapper = componentWrapper;
        }

        public ComponentWrapper getComponentWrapper() {
            return this.componentWrapper;
        }

        public int getFirstBaseLine() {
            return ComponentUtil.getFirstBaseLine((Component)this);
        }

        public int getLastBaseLine() {
            return this.getFirstBaseLine();
        }

        public void customViewAdded() {
            this.elementChanged(null);
        }

        public void customViewRemoved() {
            if (this.radioGroupName != null) {
                ButtonGroupUtil.removeFromButtonGroup(this, this.radioGroupNamespace, this.radioGroupName);
                this.radioGroupName = null;
            }
        }

        public void commitChanges() {
        }

        public void elementChanged(DocumentEvent[] documentEventArray) {
            this.refreshing = true;
            String string = this.element.getAttribute(NAME);
            if (string == null && this.radioGroupName != null || string != null && !string.equals(this.radioGroupName)) {
                if (this.radioGroupName != null) {
                    ButtonGroupUtil.removeFromButtonGroup(this, this.radioGroupNamespace, this.radioGroupName);
                    this.radioGroupName = null;
                }
                if (string != null) {
                    ButtonGroupUtil.addToButtonGroup(this, this.radioGroupNamespace, string);
                    this.radioGroupName = string;
                }
            }
            Input.refreshXHTMLToggle(this, this.element, this.componentWrapper);
            this.refreshing = false;
        }

        static /* synthetic */ boolean access$1000(XHTMLRadio xHTMLRadio) {
            return xHTMLRadio.refreshing;
        }

        static /* synthetic */ Element access$1100(XHTMLRadio xHTMLRadio) {
            return xHTMLRadio.element;
        }
    }

    private static class XHTMLCheckbox
    extends JCheckBox
    implements WrappedComponent,
    TextLines,
    CustomViewManager.BasicElementEditor {
        private Element element;
        private ComponentWrapper componentWrapper;

        public XHTMLCheckbox(Element element) {
            this.element = element;
            this.setHorizontalAlignment(0);
            this.setMargin(NO_MARGIN);
            this.setOpaque(false);
            this.addActionListener(new ActionListener(this){
                private final /* synthetic */ XHTMLCheckbox this$0;
                {
                    this.this$0 = xHTMLCheckbox;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (XHTMLCheckbox.access$800(this.this$0).hasAttribute(Input.access$700())) {
                        EditUtil.removeAttribute((Element)XHTMLCheckbox.access$800(this.this$0), (Name)Input.access$700());
                    } else {
                        EditUtil.putAttribute((Element)XHTMLCheckbox.access$800(this.this$0), (Name)Input.access$700(), (String)"checked");
                    }
                }
            });
        }

        public void setComponentWrapper(ComponentWrapper componentWrapper) {
            this.componentWrapper = componentWrapper;
        }

        public ComponentWrapper getComponentWrapper() {
            return this.componentWrapper;
        }

        public int getFirstBaseLine() {
            return ComponentUtil.getFirstBaseLine((Component)this);
        }

        public int getLastBaseLine() {
            return this.getFirstBaseLine();
        }

        public void customViewAdded() {
            this.elementChanged(null);
        }

        public void customViewRemoved() {
        }

        public void commitChanges() {
        }

        public void elementChanged(DocumentEvent[] documentEventArray) {
            Input.refreshXHTMLToggle(this, this.element, this.componentWrapper);
        }

        static /* synthetic */ Element access$800(XHTMLCheckbox xHTMLCheckbox) {
            return xHTMLCheckbox.element;
        }
    }

    private static class XHTMLFile
    extends JPanel
    implements WrappedComponent,
    TextLines,
    CustomViewManager.BasicElementEditor,
    ActionListener {
        private XHTMLText field;
        private JButton button;

        public XHTMLFile(Element element) {
            this.setOpaque(false);
            FlowLayout flowLayout = (FlowLayout)this.getLayout();
            flowLayout.setHgap(0);
            flowLayout.setVgap(0);
            this.field = new XHTMLText(element);
            this.add(this.field);
            this.button = new JButton(new ImageIcon(ImageResource.get(this.getClass(), (String)"browse.gif")));
            DialogUtil.setIconic((AbstractButton)this.button);
            this.button.setToolTipText("Select a file...");
            this.button.addActionListener(this);
            this.add(this.button);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = this.selectOpenFile();
            if (string == null) {
                return;
            }
            this.field.setText(string);
            this.field.commit();
        }

        private String selectOpenFile() {
            Object object;
            Object object2;
            File file = new File(this.field.getText());
            File file2 = file.getParentFile();
            if (file2 == null || !file2.isDirectory()) {
                file = null;
            }
            if (file == null) {
                object2 = System.getProperty("user.home");
                object = object2 != null ? (String)object2 + File.separatorChar + "any" : "any";
                file = new File((String)object);
            }
            object = file.getAbsoluteFile().getParentFile();
            object2 = new JFileChooser((File)object);
            ((JFileChooser)object2).setFileSelectionMode(0);
            int n = ((JFileChooser)object2).showOpenDialog(this);
            if (n == 0) {
                return ((JFileChooser)object2).getSelectedFile().getAbsolutePath();
            }
            return null;
        }

        public void setComponentWrapper(ComponentWrapper componentWrapper) {
            this.field.setComponentWrapper(componentWrapper);
        }

        public ComponentWrapper getComponentWrapper() {
            return this.field.getComponentWrapper();
        }

        public int getFirstBaseLine() {
            return ComponentUtil.getFirstBaseLine((Component)this);
        }

        public int getLastBaseLine() {
            return this.getFirstBaseLine();
        }

        public void customViewAdded() {
            this.elementChanged(null);
        }

        public void customViewRemoved() {
        }

        public void commitChanges() {
            this.field.commitChanges();
        }

        public void elementChanged(DocumentEvent[] documentEventArray) {
            this.field.elementChanged(documentEventArray);
            this.button.setEnabled(!this.field.element.hasAttribute(DISABLED));
        }
    }

    private static class XHTMLPassword
    extends JPasswordField
    implements WrappedComponent,
    TextLines,
    CustomViewManager.BasicElementEditor {
        private Element element;
        private ComponentWrapper componentWrapper;
        private boolean needCommit;

        public XHTMLPassword(Element element) {
            this.element = element;
            this.setColumns(20);
            this.getDocument().addDocumentListener(new DocumentListener(this, element){
                private final /* synthetic */ Element val$element;
                private final /* synthetic */ XHTMLPassword this$0;
                {
                    this.this$0 = xHTMLPassword;
                    this.val$element = element;
                }

                public void insertUpdate(javax.swing.event.DocumentEvent documentEvent) {
                    this.needCommit();
                }

                public void removeUpdate(javax.swing.event.DocumentEvent documentEvent) {
                    this.needCommit();
                }

                private void needCommit() {
                    if (!XHTMLPassword.access$300(this.this$0)) {
                        XHTMLPassword.access$302(this.this$0, true);
                        DocumentUtil.pendingChanges((com.xmlmind.xmledit.doc.Document)this.val$element.getDocument());
                    }
                }

                public void changedUpdate(javax.swing.event.DocumentEvent documentEvent) {
                }
            });
            this.addActionListener(new ActionListener(this){
                private final /* synthetic */ XHTMLPassword this$0;
                {
                    this.this$0 = xHTMLPassword;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    XHTMLPassword.access$400(this.this$0);
                }
            });
            Keymap keymap = JTextComponent.addKeymap(null, this.getKeymap());
            keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(27, 0), new AbstractAction(this){
                private final /* synthetic */ XHTMLPassword this$0;
                {
                    this.this$0 = xHTMLPassword;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (XHTMLPassword.access$300(this.this$0)) {
                        this.this$0.elementChanged(null);
                    }
                }
            });
            this.setKeymap(keymap);
            this.addFocusListener(new FocusAdapter(this){
                private final /* synthetic */ XHTMLPassword this$0;
                {
                    this.this$0 = xHTMLPassword;
                }

                public void focusLost(FocusEvent focusEvent) {
                    XHTMLPassword.access$400(this.this$0);
                }
            });
        }

        protected Document createDefaultModel() {
            return new LimitedDocument();
        }

        private void commit() {
            if (this.needCommit) {
                EditUtil.putAttribute((Element)this.element, (Name)VALUE, (String)new String(this.getPassword()));
            }
        }

        public void setComponentWrapper(ComponentWrapper componentWrapper) {
            this.componentWrapper = componentWrapper;
        }

        public ComponentWrapper getComponentWrapper() {
            return this.componentWrapper;
        }

        public int getFirstBaseLine() {
            return ComponentUtil.getFirstBaseLine((Component)this);
        }

        public int getLastBaseLine() {
            return this.getFirstBaseLine();
        }

        public void customViewAdded() {
            this.elementChanged(null);
        }

        public void customViewRemoved() {
        }

        public void commitChanges() {
            this.commit();
        }

        public void elementChanged(DocumentEvent[] documentEventArray) {
            this.needCommit = true;
            Input.refreshXHTMLText(this, this.element, this.componentWrapper);
            this.needCommit = false;
        }

        static /* synthetic */ boolean access$300(XHTMLPassword xHTMLPassword) {
            return xHTMLPassword.needCommit;
        }

        static /* synthetic */ boolean access$302(XHTMLPassword xHTMLPassword, boolean bl) {
            xHTMLPassword.needCommit = bl;
            return xHTMLPassword.needCommit;
        }

        static /* synthetic */ void access$400(XHTMLPassword xHTMLPassword) {
            xHTMLPassword.commit();
        }
    }

    private static class XHTMLText
    extends JTextField
    implements WrappedComponent,
    TextLines,
    CustomViewManager.BasicElementEditor {
        Element element;
        private ComponentWrapper componentWrapper;
        private boolean needCommit;

        public XHTMLText(Element element) {
            this.element = element;
            this.setColumns(20);
            this.getDocument().addDocumentListener(new DocumentListener(this, element){
                private final /* synthetic */ Element val$element;
                private final /* synthetic */ XHTMLText this$0;
                {
                    this.this$0 = xHTMLText;
                    this.val$element = element;
                }

                public void insertUpdate(javax.swing.event.DocumentEvent documentEvent) {
                    this.needCommit();
                }

                public void removeUpdate(javax.swing.event.DocumentEvent documentEvent) {
                    this.needCommit();
                }

                private void needCommit() {
                    if (!XHTMLText.access$000(this.this$0)) {
                        XHTMLText.access$002(this.this$0, true);
                        DocumentUtil.pendingChanges((com.xmlmind.xmledit.doc.Document)this.val$element.getDocument());
                    }
                }

                public void changedUpdate(javax.swing.event.DocumentEvent documentEvent) {
                }
            });
            this.addActionListener(new ActionListener(this){
                private final /* synthetic */ XHTMLText this$0;
                {
                    this.this$0 = xHTMLText;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    this.this$0.commit();
                }
            });
            Keymap keymap = JTextComponent.addKeymap(null, this.getKeymap());
            keymap.addActionForKeyStroke(KeyStroke.getKeyStroke(27, 0), new AbstractAction(this){
                private final /* synthetic */ XHTMLText this$0;
                {
                    this.this$0 = xHTMLText;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    if (XHTMLText.access$000(this.this$0)) {
                        this.this$0.elementChanged(null);
                    }
                }
            });
            this.setKeymap(keymap);
            this.addFocusListener(new FocusAdapter(this){
                private final /* synthetic */ XHTMLText this$0;
                {
                    this.this$0 = xHTMLText;
                }

                public void focusLost(FocusEvent focusEvent) {
                    this.this$0.commit();
                }
            });
        }

        protected Document createDefaultModel() {
            return new LimitedDocument();
        }

        void commit() {
            if (this.needCommit) {
                EditUtil.putAttribute((Element)this.element, (Name)VALUE, (String)this.getText());
            }
        }

        public void setComponentWrapper(ComponentWrapper componentWrapper) {
            this.componentWrapper = componentWrapper;
        }

        public ComponentWrapper getComponentWrapper() {
            return this.componentWrapper;
        }

        public int getFirstBaseLine() {
            return ComponentUtil.getFirstBaseLine((Component)this);
        }

        public int getLastBaseLine() {
            return this.getFirstBaseLine();
        }

        public void customViewAdded() {
            this.elementChanged(null);
        }

        public void customViewRemoved() {
        }

        public void commitChanges() {
            this.commit();
        }

        public void elementChanged(DocumentEvent[] documentEventArray) {
            this.needCommit = true;
            Input.refreshXHTMLText(this, this.element, this.componentWrapper);
            this.needCommit = false;
        }

        static /* synthetic */ boolean access$000(XHTMLText xHTMLText) {
            return xHTMLText.needCommit;
        }

        static /* synthetic */ boolean access$002(XHTMLText xHTMLText, boolean bl) {
            xHTMLText.needCommit = bl;
            return xHTMLText.needCommit;
        }
    }
}

