/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.xfc;

import com.xmlmind.fo.converter.Driver;
import com.xmlmind.fo.converter.ErrorHandler;
import com.xmlmind.xmledit.util.Console;
import com.xmlmind.xmledit.util.FileUtil;
import com.xmlmind.xmleditapp.process.FOProcessor;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.xml.sax.InputSource;

public class XFC
implements FOProcessor {
    public String getName() {
        return "XFC";
    }

    public String getDescription() {
        return "XMLmind FO Converter Personal Edition v2.2p1, converts XSL-FO to RTF and WordprocessingML (MS-Word 2003).\nSee http://www.xmlmind.com/foconverter/.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processFO(File file, File file2, String[] stringArray, final Console console) throws Exception {
        Driver driver = new Driver();
        driver.setErrorHandler(new ErrorHandler(){

            public void error(Exception exception) throws Exception {
                console.showMessage("XFC error: " + this.reason(exception), 1);
            }

            public void warning(Exception exception) throws Exception {
                console.showMessage("XFC warning: " + this.reason(exception), 2);
            }

            private String reason(Exception exception) {
                String string = exception.getMessage();
                if (string == null) {
                    string = exception.getClass().getName();
                }
                return string;
            }
        });
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                driver.setProperty(stringArray[n], stringArray[n + 1]);
                n += 2;
            }
        }
        FileInputStream fileInputStream = null;
        OutputStream outputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            InputSource inputSource = new InputSource(fileInputStream);
            inputSource.setSystemId(FileUtil.fileToURL((File)file).toExternalForm());
            driver.setInput(inputSource);
            outputStream = new BufferedOutputStream(new FileOutputStream(file2));
            driver.setOutput(outputStream);
            driver.convert();
            outputStream.flush();
        }
        finally {
            if (fileInputStream != null) {
                ((InputStream)fileInputStream).close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }
}

