/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.app;

import com.xmlmind.xmledit.command.DeclareNamespace;
import com.xmlmind.xmledit.edit.Commands;
import com.xmlmind.xmledit.edit.StyleSheetInfo;
import com.xmlmind.xmledit.gadget.UserInput;
import com.xmlmind.xmledit.guiutil.Alert;
import com.xmlmind.xmledit.guiutil.DialogUtil;
import com.xmlmind.xmledit.guiutil.MultiSplitPane;
import com.xmlmind.xmledit.guiutil.Tab;
import com.xmlmind.xmledit.guiutil.TabbedSplitPane;
import com.xmlmind.xmledit.util.FileUtil;
import com.xmlmind.xmledit.util.PlatformUtil;
import com.xmlmind.xmledit.util.Preferences;
import com.xmlmind.xmledit.view.BindingSpec;
import com.xmlmind.xmledit.xmlutil.XMLCatalogs;
import com.xmlmind.xmleditapp.app.HelpSupport;
import com.xmlmind.xmleditapp.app.Msg;
import com.xmlmind.xmleditapp.app.OpenedDocTab;
import com.xmlmind.xmleditapp.app.SingleInstanceSupport;
import com.xmlmind.xmleditapp.command.PasteInclusionEnabled;
import com.xmlmind.xmleditapp.command.XPathSearch;
import com.xmlmind.xmleditapp.config.Configuration;
import com.xmlmind.xmleditapp.config.WindowLayoutInfo;
import com.xmlmind.xmleditapp.dialog.AuthenticatorImpl;
import com.xmlmind.xmleditapp.dndview.FileDropHandler;
import com.xmlmind.xmleditapp.dndview.FileDropSupport;
import com.xmlmind.xmleditapp.kit.App;
import com.xmlmind.xmleditapp.kit.AppAction;
import com.xmlmind.xmleditapp.kit.AppPart;
import com.xmlmind.xmleditapp.kit.DnDEditor;
import com.xmlmind.xmleditapp.kit.Editor;
import com.xmlmind.xmleditapp.kit.OpenDocumentAction;
import com.xmlmind.xmleditapp.kit.OpenedDocument;
import com.xmlmind.xmleditapp.kit.URLHistory;
import com.xmlmind.xmleditapp.kit.gui.GUISpec;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.reflect.Constructor;
import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Locale;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;

public class Application
extends App {
    protected String guiSpecLocation;
    protected SingleInstanceSupport singleInstanceSupport;
    protected AuthenticatorImpl authenticator;
    protected JFrame frame;
    protected TabbedSplitPane openedDocumentTabs;
    protected boolean selectingTab;
    protected GUISpec.LayoutInfo guiLayoutInfo;
    protected OpenedDocInfo[] openedDocInfos = new OpenedDocInfo[0];
    protected int activeOpenedDocIndex = -1;
    protected Editor activeEditor = null;
    protected OpenedDocument[] allOpenedDocuments = null;
    static /* synthetic */ Class class$com$xmlmind$xmleditapp$kit$App;
    static /* synthetic */ Class class$com$xmlmind$xmleditapp$app$Application;

    public Application(HashMap hashMap) {
        super(hashMap);
        this.guiSpecLocation = (String)hashMap.get("guiSpecLocation");
        if (this.guiSpecLocation != null) {
            this.initGUISpecLocation(this.guiSpecLocation);
        }
    }

    public Application() {
    }

    public void initGUISpecLocation(String string) {
        if (this.initialized) {
            throw new IllegalStateException();
        }
        if (string != null && (string = string.trim()).length() == 0) {
            string = null;
        }
        this.guiSpecLocation = string;
    }

    public String getGUISpecLocation() {
        return this.guiSpecLocation;
    }

    protected void doInitialize1(HashMap hashMap, HashMap hashMap2) {
        this.initUserDir();
        this.doInitialize1a(hashMap, hashMap2);
        this.applyLocalePreferences();
        this.authenticator = new AuthenticatorImpl();
        this.authenticator.loadPasswords(this.preferences);
        Authenticator.setDefault(this.authenticator);
        URLConnection.setDefaultAllowUserInteraction(true);
        this.singleInstanceSupport = new SingleInstanceSupport(this);
        if (this.commandLineArguments.length > 0) {
            this.singleInstanceSupport.openUsingRunningApp(this.commandLineArguments);
        }
        this.doInitialize1b(hashMap, hashMap2);
        this.doInitialize1c(hashMap, hashMap2);
        this.applyGUIPreferences();
        this.doInitialize1d(hashMap, hashMap2);
        this.doInitialize1e(hashMap, hashMap2);
        this.authenticator.setDialogParent(this.frame);
    }

    protected void doInitialize2(HashMap hashMap, HashMap hashMap2) {
        this.waitCursor(true);
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        this.guiLayoutInfo.applyLayoutPreferences(this.preferences);
        this.doInitialize2a(hashMap, hashMap2);
        this.doInitialize2b(hashMap, hashMap2);
        boolean bl = false;
        Preferences.Map map = this.preferences.getMap();
        if (map instanceof Preferences.MapImpl) {
            File file = ((Preferences.MapImpl)map).getFile();
            boolean bl2 = bl = file != null && !file.isFile();
        }
        if (bl) {
            this.defaultLastOpenedFiles();
        }
        this.addPlatformDependentSupport();
        this.doInitialize2c(hashMap, hashMap2);
        this.waitCursor(false);
        if (this.commandLineArguments.length > 0) {
            this.openFiles(this.commandLineArguments);
        }
    }

    protected void initUserDir() {
        if (this.userPreferencesDirectory == null) {
            return;
        }
        if (!this.userPreferencesDirectory.isDirectory()) {
            FileUtil.removeFile(this.userPreferencesDirectory, true);
            if (!this.userPreferencesDirectory.mkdirs()) {
                this.userPreferencesDirectory = null;
                return;
            }
        }
        String[] stringArray = new String[]{"addon", "ser", "spell"};
        int n = 0;
        while (n < stringArray.length) {
            File file = new File(this.userPreferencesDirectory, stringArray[n]);
            if (!file.isDirectory()) {
                FileUtil.removeFile(file, true);
                file.mkdir();
            }
            ++n;
        }
    }

    protected Preferences loadPreferences() {
        String[] stringArray;
        Preferences preferences = new Preferences(this.userPreferencesDirectory == null ? null : new File(this.userPreferencesDirectory, "preferences.properties"), this.getDefaultTitle());
        int n = 0;
        while (n < this.commandLineArguments.length) {
            stringArray = this.commandLineArguments[n];
            if ("-putpref".equals(stringArray)) {
                if (n + 2 >= this.commandLineArguments.length) break;
                preferences.putString(this.commandLineArguments[n + 1], this.commandLineArguments[n + 2]);
                n += 2;
            } else {
                if (!"-delpref".equals(stringArray) || n + 1 >= this.commandLineArguments.length) break;
                preferences.remove(this.commandLineArguments[n + 1]);
                ++n;
            }
            ++n;
        }
        if (n > 0) {
            stringArray = new String[this.commandLineArguments.length - n];
            System.arraycopy(this.commandLineArguments, n, stringArray, 0, stringArray.length);
            this.commandLineArguments = stringArray;
        }
        return preferences;
    }

    protected void applyLocalePreferences() {
        String string = this.preferences.getString("locale", "-");
        if (!"-".equals(string)) {
            Locale[] localeArray = Locale.getAvailableLocales();
            Locale locale = null;
            int n = 0;
            while (n < localeArray.length) {
                if (localeArray[n].toString().equals(string)) {
                    locale = localeArray[n];
                    break;
                }
                ++n;
            }
            if (locale != null) {
                Locale.setDefault(locale);
                Msg.reset();
            }
        }
    }

    protected void registerCommands() {
        super.registerCommands();
        Commands.register("paste", new PasteInclusionEnabled());
    }

    protected BindingSpec[] getExtraBindingSpecs() {
        int n = PlatformUtil.IS_MAC_OS ? 4 : 2;
        BindingSpec[] bindingSpecArray = new BindingSpec[]{new BindingSpec(UserInput.get(67, 1 | n), "copyAsInclusion", "[implicitElement]"), new BindingSpec(UserInput.get(89, 1 | n), "showColumnRowLabels", "on"), new BindingSpec(UserInput.get(90, 1 | n), "showColumnRowLabels", "off"), new BindingSpec(UserInput.get(73, 1 | n), "setFormula", null), new BindingSpec(UserInput.get(82, 1 | n), "spreadsheet", "recalc"), new BindingSpec("file-drop", "XXE.open", "%{url}")};
        return bindingSpecArray;
    }

    protected void initHelp() {
        HelpSupport.initialize();
        DialogUtil.setHelpBroker(HelpSupport.getHelpBroker());
        DeclareNamespace.setDialogHasHelp(true);
        XPathSearch.setDialogHasHelp(true);
    }

    protected void applyGUIPreferences() {
        int n;
        String[] stringArray;
        FontUIResource fontUIResource;
        int n2;
        String string = this.preferences.getString("lookAndFeelClassName", "-");
        if ("-".equals(string)) {
            string = Application.getDefaultLAFClassName();
        }
        boolean bl = false;
        try {
            UIManager.setLookAndFeel(string);
            bl = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!bl) {
            string = UIManager.getSystemLookAndFeelClassName();
            try {
                UIManager.setLookAndFeel(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!string.equals(UIManager.getSystemLookAndFeelClassName())) {
            UIManager.getLookAndFeelDefaults().put("ClassLoader", (class$com$xmlmind$xmleditapp$kit$App == null ? (class$com$xmlmind$xmleditapp$kit$App = Application.class$("com.xmlmind.xmleditapp.kit.App")) : class$com$xmlmind$xmleditapp$kit$App).getClassLoader());
        }
        if ((n2 = this.preferences.getInt("fontSize", -1)) >= 10 && n2 <= 20 && (fontUIResource = (FontUIResource)UIManager.get((stringArray = new String[]{"Button.font", "CheckBox.font", "CheckBoxMenuItem.font", "ColorChooser.font", "ComboBox.font", "DesktopIcon.font", "EditorPane.font", "FormattedTextField.font", "InternalFrameTitlePane.font", "Label.font", "List.font", "Menu.font", "MenuBar.font", "MenuItem.font", "OptionPane.font", "Panel.font", "PasswordField.font", "PopupMenu.font", "ProgressBar.font", "RadioButton.font", "RadioButtonMenuItem.font", "ScrollPane.font", "Spinner.font", "TabbedPane.font", "Table.font", "TableHeader.font", "TextArea.font", "TextField.font", "TextPane.font", "TitledBorder.font", "ToggleButton.font", "ToolBar.font", "ToolTip.font", "Tree.font", "Viewport.font"})[0])) != null && (n = n2 - fontUIResource.getSize()) != 0) {
            int n3 = 0;
            while (n3 < stringArray.length) {
                String string2 = stringArray[n3];
                fontUIResource = (FontUIResource)UIManager.get(string2);
                if (fontUIResource != null) {
                    FontUIResource fontUIResource2 = new FontUIResource(fontUIResource.getFamily(), fontUIResource.getStyle(), fontUIResource.getSize() + n);
                    UIManager.put(string2, fontUIResource2);
                }
                ++n3;
            }
        }
    }

    private static final String getDefaultLAFClassName() {
        switch (PlatformUtil.PLATFORM) {
            case 1: {
                String string = System.getProperty("java.version");
                if (string != null && string.startsWith("1.4")) {
                    return "com.incors.plaf.kunststoff.KunststoffLookAndFeel";
                }
                return UIManager.getCrossPlatformLookAndFeelClassName();
            }
        }
        return UIManager.getSystemLookAndFeelClassName();
    }

    protected void createGUI(HashMap hashMap) {
        this.frame = new JFrame(this.getTitle());
        this.frame.setIconImage(this.getIcon());
        this.frame.setDefaultCloseOperation(0);
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                AppAction appAction = (AppAction)Application.this.getPart("quitAction");
                if (appAction != null) {
                    appAction.doIt();
                } else {
                    try {
                        Application.this.dispose();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    System.exit(0);
                }
            }
        });
        this.frame.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                this.updatePreferences();
            }

            public void componentMoved(ComponentEvent componentEvent) {
                this.updatePreferences();
            }

            private void updatePreferences() {
                if (Application.this.frame.getExtendedState() == 0) {
                    Application.this.preferences.putRectangle("geometry", Application.this.frame.getBounds());
                }
            }
        });
        this.initGlassPane();
        new FileDropSupport(new FileDropHandler(){

            public boolean handleFileDrop(URL uRL, Point point) {
                OpenDocumentAction openDocumentAction = Application.this.getOpenDocumentAction();
                if (openDocumentAction == null) {
                    return false;
                }
                openDocumentAction.openDocument(uRL);
                return true;
            }
        }, this.frame);
        this.openedDocumentTabs = this.createOpenedDocumentTabs();
        this.openedDocumentTabs.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                int n;
                if (Application.this.selectingTab) {
                    return;
                }
                Tab tab = null;
                switch (itemEvent.getStateChange()) {
                    case 1: {
                        tab = (Tab)itemEvent.getItem();
                        break;
                    }
                    case 2: {
                        Tab[] tabArray = Application.this.openedDocumentTabs.getSelectedTabs();
                        if (tabArray.length != 1) break;
                        tab = tabArray[0];
                    }
                }
                if (tab != null && (n = Application.this.openedDocumentTabs.indexOfTab(tab)) >= 0 && n < Application.this.openedDocInfos.length) {
                    Application.this.setActiveOpenedDocument(Application.this.openedDocInfos[n].openedDoc);
                }
            }
        });
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        keyboardFocusManager.addPropertyChangeListener("permanentFocusOwner", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Editor editor = null;
                Component component = (Component)propertyChangeEvent.getNewValue();
                while (component != null) {
                    if (component instanceof Editor) {
                        editor = (Editor)component;
                        break;
                    }
                    component = component.getParent();
                }
                if (editor != null) {
                    Application.this.changeActiveEditor(editor);
                }
            }
        });
        this.loadGUI(this.getGUISpecURL(), hashMap);
        if (this.guiLayoutInfo.label != null) {
            this.title = this.guiLayoutInfo.label;
            this.frame.setTitle(this.title);
        }
        if (this.guiLayoutInfo.icon != null) {
            this.icon = this.guiLayoutInfo.icon;
            this.frame.setIconImage(this.icon);
        }
        this.applyGeometryPreferences();
        this.frame.setVisible(true);
        this.applyWindowPreferences();
    }

    protected void initGlassPane() {
        Component component = this.frame.getGlassPane();
        component.setCursor(Cursor.getPredefinedCursor(3));
        component.addMouseListener(new MouseAdapter(){});
        component.addMouseMotionListener(new MouseMotionAdapter(){});
        component.addKeyListener(new KeyAdapter(){});
    }

    protected TabbedSplitPane createOpenedDocumentTabs() {
        TabbedSplitPane tabbedSplitPane = new TabbedSplitPane();
        tabbedSplitPane.setTabPlacement(0);
        tabbedSplitPane.setVerticalSplit(this.preferences.getBoolean("verticalSplit", false));
        tabbedSplitPane.setHorizontalRatio(0.5);
        tabbedSplitPane.setVerticalRatio(0.5);
        tabbedSplitPane.setEndTabAtOppositeSide(true);
        return tabbedSplitPane;
    }

    protected URL getGUISpecURL() {
        URL uRL = null;
        URL uRL2 = (class$com$xmlmind$xmleditapp$app$Application == null ? (class$com$xmlmind$xmleditapp$app$Application = Application.class$("com.xmlmind.xmleditapp.app.Application")) : class$com$xmlmind$xmleditapp$app$Application).getResource("/gui/app/default.xxe_gui");
        if (uRL2 != null) {
            String string = uRL2.toExternalForm();
            string = string.substring(0, string.length() - 19);
            XMLCatalogs.addRewriteURIEntry("xxe-gui:", string);
        }
        if (this.guiSpecLocation != null) {
            try {
                uRL = XMLCatalogs.resolveURI(this.guiSpecLocation, FileUtil.fileToURL("."));
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (uRL == null) {
            uRL = uRL2;
        }
        return uRL;
    }

    protected void loadGUI(URL uRL, HashMap hashMap) {
        GUISpec gUISpec = new GUISpec();
        GUISpec.Error[] errorArray = null;
        if (uRL != null && (errorArray = gUISpec.load(uRL)).length > 0) {
            Application.addGUIErrors(errorArray, hashMap);
            gUISpec = new GUISpec();
        }
        this.guiLayoutInfo = new GUISpec.LayoutInfo();
        errorArray = gUISpec.layout(this.frame, this.openedDocumentTabs, this, this.guiLayoutInfo);
        if (errorArray.length > 0) {
            Application.addGUIErrors(errorArray, hashMap);
        }
    }

    protected static final void addGUIErrors(GUISpec.Error[] errorArray, HashMap hashMap) {
        int n = 0;
        while (n < errorArray.length) {
            GUISpec.Error error = errorArray[n];
            App.addError(hashMap, error.systemId, error.getMessageWithLocation());
            ++n;
        }
    }

    protected void applyGeometryPreferences() {
        if (this.guiLayoutInfo.width <= 0 || this.guiLayoutInfo.height <= 0) {
            this.guiLayoutInfo.width = 850;
            this.guiLayoutInfo.height = 650;
        }
        Rectangle rectangle = new Rectangle(0, 0, this.guiLayoutInfo.width, this.guiLayoutInfo.height);
        Rectangle rectangle2 = this.preferences.getRectangle("geometry", rectangle);
        Rectangle rectangle3 = this.frame.getGraphicsConfiguration().getBounds();
        if (rectangle2.width <= 0) {
            rectangle2.width = 800;
        }
        if (rectangle2.width > rectangle3.width) {
            rectangle2.width = rectangle3.width;
        }
        if (rectangle2.height <= 0) {
            rectangle2.height = 600;
        }
        if (rectangle2.height > rectangle3.height) {
            rectangle2.height = rectangle3.height;
        }
        if (rectangle2.x < rectangle3.x) {
            rectangle2.x = rectangle3.x;
        } else if (rectangle2.x + rectangle2.width > rectangle3.x + rectangle3.width) {
            rectangle2.x = rectangle3.x + rectangle3.width - rectangle2.width;
        }
        if (rectangle2.y < rectangle3.y) {
            rectangle2.y = rectangle3.y;
        } else if (rectangle2.y + rectangle2.height > rectangle3.y + rectangle3.height) {
            rectangle2.y = rectangle3.y + rectangle3.height - rectangle2.height;
        }
        this.frame.setBounds(rectangle2);
        this.preferences.putRectangle("geometry", rectangle2);
    }

    protected void applyWindowPreferences() {
        String string = this.preferences.getString("maximized", "no");
        int n = "both".equals(string) ? 6 : ("vertical".equals(string) ? 4 : ("horizontal".equals(string) ? 2 : 0));
        if (n != 0) {
            this.frame.setExtendedState(n);
        }
    }

    protected void applyPreferences() {
        super.applyPreferences();
        this.singleInstanceSupport.applyPreferences();
    }

    protected void defaultLastOpenedFiles() {
        URLHistory uRLHistory = (URLHistory)this.getProperty("lastOpenedFiles");
        if (uRLHistory == null) {
            return;
        }
        String[] stringArray = new String[]{"doc" + File.separator + "user" + File.separator + "userguide.xml", "doc" + File.separator + "user" + File.separator + "userguide.xhtml", "demo" + File.separator + "bugreport.xml", "demo" + File.separator + "bugreport" + File.separator + "bugreport.xsd", "demo" + File.separator + "docbook-table.xml", "demo" + File.separator + "docbook-image.xml", "demo" + File.separator + "xhtml-table.xhtml", "demo" + File.separator + "xhtml-form.xhtml", "demo" + File.separator + "spreadsheet-demo.xhtml", "demo" + File.separator + "bugreport_rng.xml", "demo" + File.separator + "bugreport" + File.separator + "bugreport.rng", "demo" + File.separator + "slides-demo.xml"};
        int n = stringArray.length - 1;
        while (n >= 0) {
            File file = new File(this.installDirectory, stringArray[n]);
            if (file.isFile()) {
                uRLHistory.add(FileUtil.fileToURL(file));
            }
            --n;
        }
    }

    protected void addPlatformDependentSupport() {
        block2: {
            if (!PlatformUtil.IS_MAC_OS) break block2;
            try {
                Class[] classArray = new Class[]{class$com$xmlmind$xmleditapp$kit$App == null ? (class$com$xmlmind$xmleditapp$kit$App = Application.class$("com.xmlmind.xmleditapp.kit.App")) : class$com$xmlmind$xmleditapp$kit$App};
                Object[] objectArray = new Object[]{this};
                Class<?> clazz = Class.forName("MacApplicationListener");
                Constructor<?> constructor = clazz.getConstructor(classArray);
                constructor.newInstance(objectArray);
            }
            catch (Exception exception) {}
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void openFiles(String[] var1_1) {
        var2_2 = this.getOpenDocumentAction();
        if (var2_2 == null) {
            return;
        }
        var3_3 = var1_1.length - 1;
        while (var3_3 >= 0) {
            var4_4 = var1_1[var3_3];
            var5_5 = null;
            try {
                var5_5 = new URL(var4_4);
            }
            catch (MalformedURLException var6_7) {
                // empty catch block
            }
            if (var5_5 != null) ** GOTO lbl19
            var6_6 = new File(var4_4);
            if (!var6_6.isFile()) {
                Alert.showError(this.getDialogParent(), Msg.msg("usage", var4_4));
            } else {
                var5_5 = FileUtil.fileToURL(var6_6);
lbl19:
                // 2 sources

                var2_2.openDocument(var5_5);
            }
            --var3_3;
        }
    }

    public SingleInstanceSupport getSingleInstanceSupport() {
        return this.singleInstanceSupport;
    }

    public void addOpenedDocument(OpenedDocument openedDocument) {
        Object object;
        Object object2;
        int n = this.indexOfOpenedDocument(openedDocument);
        if (n >= 0) {
            return;
        }
        StyleSheetInfo[] styleSheetInfoArray = openedDocument.getStyleSheetInfo();
        if (styleSheetInfoArray != null && styleSheetInfoArray.length == 0) {
            styleSheetInfoArray = null;
        }
        WindowLayoutInfo.Pane[] paneArray = null;
        Configuration configuration = openedDocument.getConfiguration();
        if (configuration != null && (object2 = (Editor[])configuration.get("windowLayout")) != null && (paneArray = ((WindowLayoutInfo)object2).getPanes(styleSheetInfoArray)) != null && paneArray.length == 0) {
            paneArray = null;
        }
        if (paneArray == null && styleSheetInfoArray != null && this.preferences.getBoolean("showBothViews", false)) {
            paneArray = new WindowLayoutInfo.Pane[2];
            object2 = styleSheetInfoArray[0];
            paneArray[0] = new WindowLayoutInfo.Pane(0, ((StyleSheetInfo)object2).getLabel(), 1.0);
            paneArray[0].setStyleSheetInfo((StyleSheetInfo)object2);
            int n2 = this.preferences.getBoolean("treeViewAtRight", false) ? 2 : 4;
            double d = (double)this.preferences.getInt("treeViewPercent", 10, 90, 33) / 100.0;
            paneArray[1] = new WindowLayoutInfo.Pane(n2, null, d);
        }
        if (paneArray == null) {
            paneArray = new WindowLayoutInfo.Pane[1];
            if (styleSheetInfoArray == null) {
                paneArray[0] = new WindowLayoutInfo.Pane(0, null, 1.0);
            } else {
                object2 = styleSheetInfoArray[0];
                paneArray[0] = new WindowLayoutInfo.Pane(0, ((StyleSheetInfo)object2).getLabel(), 1.0);
                paneArray[0].setStyleSheetInfo((StyleSheetInfo)object2);
            }
        }
        object2 = new Editor[paneArray.length];
        OpenedDocInfo openedDocInfo = new OpenedDocInfo();
        openedDocInfo.openedDoc = openedDocument;
        openedDocInfo.editors = object2;
        openedDocInfo.activeEditorIndex = 0;
        MultiSplitPane multiSplitPane = this.createEditorsPane();
        int n3 = 0;
        while (n3 < paneArray.length) {
            WindowLayoutInfo.Pane pane = paneArray[n3];
            object = this.createEditor();
            ((Editor)object).open(openedDocument, pane.getStyleSheetInfo());
            object2[n3] = object;
            this.addingEditor((Editor)object);
            switch (pane.getPosition()) {
                case 1: {
                    multiSplitPane.add((Component)object, new MultiSplitPane.Constraints(1, pane.getSize()));
                    break;
                }
                case 3: {
                    multiSplitPane.add((Component)object, new MultiSplitPane.Constraints(3, pane.getSize()));
                    break;
                }
                case 4: {
                    multiSplitPane.add((Component)object, new MultiSplitPane.Constraints(4, pane.getSize()));
                    break;
                }
                case 2: {
                    multiSplitPane.add((Component)object, new MultiSplitPane.Constraints(2, pane.getSize()));
                    break;
                }
                default: {
                    openedDocInfo.activeEditorIndex = n3;
                    multiSplitPane.add((Component)object, new MultiSplitPane.Constraints(0, 1.0));
                }
            }
            ++n3;
        }
        this.openedDocInfos = Application.add(this.openedDocInfos, openedDocInfo);
        this.allOpenedDocuments = null;
        this.selectingTab = true;
        this.openedDocumentTabs.addTab(this.createOpenedDocumentTab(openedDocument, multiSplitPane));
        this.selectingTab = false;
        this.setActiveOpenedDocument(openedDocument);
        int n4 = 0;
        while (n4 < ((Object)object2).length) {
            object = object2[n4];
            this.editorAdded((Editor)object);
            ++n4;
        }
    }

    protected MultiSplitPane createEditorsPane() {
        return new MultiSplitPane();
    }

    protected Tab createOpenedDocumentTab(OpenedDocument openedDocument, MultiSplitPane multiSplitPane) {
        return new OpenedDocTab(openedDocument, multiSplitPane);
    }

    public void removeOpenedDocument(OpenedDocument openedDocument) {
        int n = this.indexOfOpenedDocument(openedDocument);
        if (n < 0) {
            return;
        }
        this.removeOpenedDocument(n);
    }

    protected void removeOpenedDocument(int n) {
        if (this.openedDocInfos.length == 1) {
            this.removeAllOpenedDocuments();
            return;
        }
        OpenedDocInfo openedDocInfo = this.openedDocInfos[n];
        Editor[] editorArray = openedDocInfo.editors;
        int n2 = editorArray.length - 1;
        while (n2 >= 0) {
            Editor editor = editorArray[n2];
            this.removingEditor(editor);
            --n2;
        }
        this.openedDocInfos = Application.remove(this.openedDocInfos, n);
        this.allOpenedDocuments = null;
        int n3 = this.activeOpenedDocIndex;
        if (n <= this.activeOpenedDocIndex && n3 > 0) {
            --n3;
        }
        OpenedDocument openedDocument = this.openedDocInfos[n3].openedDoc;
        this.selectingTab = true;
        this.openedDocumentTabs.removeTab(n);
        this.selectingTab = false;
        this.setActiveOpenedDocument(openedDocument);
        int n4 = editorArray.length - 1;
        while (n4 >= 0) {
            Editor editor = editorArray[n4];
            this.editorRemoved(editor);
            editor.dispose();
            --n4;
        }
        openedDocInfo.openedDoc.closed(2);
        openedDocInfo.openedDoc.dispose();
    }

    public void removeAllOpenedDocuments() {
        Object object;
        if (this.openedDocInfos.length <= 0) {
            return;
        }
        OpenedDocInfo[] openedDocInfoArray = this.openedDocInfos;
        int n = openedDocInfoArray.length - 1;
        while (n >= 0) {
            OpenedDocInfo openedDocInfo = openedDocInfoArray[n];
            object = openedDocInfo.editors;
            int n2 = ((Editor[])object).length - 1;
            while (n2 >= 0) {
                Editor editor = object[n2];
                this.removingEditor(editor);
                --n2;
            }
            --n;
        }
        this.openedDocInfos = new OpenedDocInfo[0];
        this.activeOpenedDocIndex = -1;
        this.allOpenedDocuments = null;
        this.updateActiveEditor();
        this.openedDocumentTabs.removeAllTabs();
        int n3 = openedDocInfoArray.length - 1;
        while (n3 >= 0) {
            object = openedDocInfoArray[n3];
            Editor[] editorArray = object.editors;
            int n4 = editorArray.length - 1;
            while (n4 >= 0) {
                Editor editor = editorArray[n4];
                this.editorRemoved(editor);
                editor.dispose();
                --n4;
            }
            object.openedDoc.closed(2);
            object.openedDoc.dispose();
            --n3;
        }
        Commands.resetAllCommands();
    }

    public int getOpenedDocumentCount() {
        return this.openedDocInfos.length;
    }

    public OpenedDocument[] getOpenedDocuments() {
        if (this.allOpenedDocuments == null) {
            this.allOpenedDocuments = new OpenedDocument[this.openedDocInfos.length];
            int n = 0;
            while (n < this.openedDocInfos.length) {
                this.allOpenedDocuments[n] = this.openedDocInfos[n].openedDoc;
                ++n;
            }
        }
        return this.allOpenedDocuments;
    }

    public void setActiveOpenedDocument(OpenedDocument openedDocument) {
        if (openedDocument == null) {
            return;
        }
        int n = this.indexOfOpenedDocument(openedDocument);
        if (n < 0) {
            return;
        }
        OpenedDocInfo openedDocInfo = this.openedDocInfos[n];
        this.setActiveEditor(openedDocInfo.editors[openedDocInfo.activeEditorIndex]);
    }

    protected int indexOfOpenedDocument(OpenedDocument openedDocument) {
        int n = 0;
        while (n < this.openedDocInfos.length) {
            if (this.openedDocInfos[n].openedDoc == openedDocument) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    protected static final OpenedDocInfo[] add(OpenedDocInfo[] openedDocInfoArray, OpenedDocInfo openedDocInfo) {
        int n = openedDocInfoArray.length;
        OpenedDocInfo[] openedDocInfoArray2 = new OpenedDocInfo[n + 1];
        System.arraycopy(openedDocInfoArray, 0, openedDocInfoArray2, 0, n);
        openedDocInfoArray2[n] = openedDocInfo;
        return openedDocInfoArray2;
    }

    protected static final OpenedDocInfo[] remove(OpenedDocInfo[] openedDocInfoArray, int n) {
        int n2;
        int n3;
        int n4 = openedDocInfoArray.length;
        OpenedDocInfo[] openedDocInfoArray2 = new OpenedDocInfo[n4 - 1];
        if (n > 0) {
            System.arraycopy(openedDocInfoArray, 0, openedDocInfoArray2, 0, n);
        }
        if ((n3 = n4 - (n2 = n + 1)) > 0) {
            System.arraycopy(openedDocInfoArray, n2, openedDocInfoArray2, n, n3);
        }
        return openedDocInfoArray2;
    }

    public Editor createEditor() {
        return new DnDEditor(this);
    }

    public void addEditor(Editor editor, Object object) {
        int[] nArray = this.indexOfEditor(editor);
        if (nArray[0] < 0 || nArray[1] >= 0) {
            return;
        }
        Tab tab = this.openedDocumentTabs.getTab(nArray[0]);
        MultiSplitPane multiSplitPane = (MultiSplitPane)tab.getComponent();
        try {
            multiSplitPane.add((Component)editor, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        this.addingEditor(editor);
        OpenedDocInfo openedDocInfo = this.openedDocInfos[nArray[0]];
        openedDocInfo.editors = Application.add(openedDocInfo.editors, editor);
        this.setActiveEditor(editor);
        this.editorAdded(editor);
    }

    public void removeEditor(Editor editor) {
        int[] nArray = this.indexOfEditor(editor);
        if (nArray[1] < 0) {
            return;
        }
        OpenedDocInfo openedDocInfo = this.openedDocInfos[nArray[0]];
        if (openedDocInfo.editors.length == 1) {
            this.removeOpenedDocument(nArray[0]);
            return;
        }
        this.removingEditor(editor);
        openedDocInfo.editors = Application.remove(openedDocInfo.editors, nArray[1]);
        openedDocInfo.activeEditorIndex = 0;
        Tab tab = this.openedDocumentTabs.getTab(nArray[0]);
        MultiSplitPane multiSplitPane = (MultiSplitPane)tab.getComponent();
        multiSplitPane.remove(editor);
        if (editor == this.activeEditor) {
            this.setActiveEditor(openedDocInfo.editors[0]);
        }
        this.editorRemoved(editor);
        editor.dispose();
    }

    public int getEditorCount() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.openedDocInfos.length) {
            n += this.openedDocInfos[n2].editors.length;
            ++n2;
        }
        return n;
    }

    public Editor[] getEditors() {
        Editor[] editorArray = new Editor[this.getEditorCount()];
        int n = 0;
        int n2 = 0;
        while (n2 < this.openedDocInfos.length) {
            Editor[] editorArray2 = this.openedDocInfos[n2].editors;
            System.arraycopy(editorArray2, 0, editorArray, n, editorArray2.length);
            n += editorArray2.length;
            ++n2;
        }
        return editorArray;
    }

    public Editor[] getEditors(OpenedDocument openedDocument) {
        int n = this.indexOfOpenedDocument(openedDocument);
        if (n < 0) {
            return new Editor[0];
        }
        return this.openedDocInfos[n].editors;
    }

    public void setActiveEditor(final Editor editor) {
        if (!this.changeActiveEditor(editor)) {
            return;
        }
        this.selectingTab = true;
        this.openedDocumentTabs.selectTab(this.activeOpenedDocIndex);
        this.selectingTab = false;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                editor.getDocumentView().requestFocus();
            }
        });
    }

    protected boolean changeActiveEditor(Editor editor) {
        if (editor == null || editor == this.activeEditor) {
            return false;
        }
        int[] nArray = this.indexOfEditor(editor);
        if (nArray[1] < 0) {
            return false;
        }
        this.activeOpenedDocIndex = nArray[0];
        this.openedDocInfos[this.activeOpenedDocIndex].activeEditorIndex = nArray[1];
        this.updateActiveEditor();
        return true;
    }

    public Editor getActiveEditor() {
        return this.activeEditor;
    }

    protected void updateActiveEditor() {
        if (this.activeEditor != null) {
            this.editorDeactivated(this.activeEditor);
            this.activeEditor = null;
        }
        if (this.activeOpenedDocIndex >= 0) {
            OpenedDocInfo openedDocInfo = this.openedDocInfos[this.activeOpenedDocIndex];
            this.activeEditor = openedDocInfo.editors[openedDocInfo.activeEditorIndex];
            this.editorActivated(this.activeEditor);
        }
        this.activeEditorChanged();
    }

    protected void activeEditorChanged() {
        this.updateTitle();
        super.activeEditorChanged();
    }

    protected void updateTitle() {
        String string;
        Editor editor = this.getActiveEditor();
        if (editor == null) {
            string = this.getTitle();
        } else {
            OpenedDocument openedDocument = editor.getOpenedDocument();
            string = openedDocument.getLabel();
            if (openedDocument.isSaveNeeded()) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(string);
                stringBuffer.append(" (");
                stringBuffer.append(Msg.msg("modified"));
                stringBuffer.append(")");
                string = stringBuffer.toString();
            }
        }
        this.frame.setTitle(string);
    }

    protected int[] indexOfEditor(Editor editor) {
        int[] nArray = new int[]{-1, -1};
        OpenedDocument openedDocument = editor.getOpenedDocument();
        int n = 0;
        block0: while (n < this.openedDocInfos.length) {
            OpenedDocInfo openedDocInfo = this.openedDocInfos[n];
            if (openedDocInfo.openedDoc == openedDocument) {
                nArray[0] = n;
                Editor[] editorArray = openedDocInfo.editors;
                int n2 = 0;
                while (n2 < editorArray.length) {
                    if (editorArray[n2] == editor) {
                        nArray[1] = n2;
                        break block0;
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return nArray;
    }

    protected static final Editor[] add(Editor[] editorArray, Editor editor) {
        int n = editorArray.length;
        Editor[] editorArray2 = new Editor[n + 1];
        System.arraycopy(editorArray, 0, editorArray2, 0, n);
        editorArray2[n] = editor;
        return editorArray2;
    }

    protected static final Editor[] remove(Editor[] editorArray, int n) {
        int n2;
        int n3;
        int n4 = editorArray.length;
        Editor[] editorArray2 = new Editor[n4 - 1];
        if (n > 0) {
            System.arraycopy(editorArray, 0, editorArray2, 0, n);
        }
        if ((n3 = n4 - (n2 = n + 1)) > 0) {
            System.arraycopy(editorArray, n2, editorArray2, n, n3);
        }
        return editorArray2;
    }

    public void ensurePartIsVisible(AppPart appPart) {
        if (this.guiLayoutInfo.leftTabs != null) {
            this.selectTab(this.guiLayoutInfo.leftTabs, appPart);
        }
        if (this.guiLayoutInfo.rightTabs != null) {
            this.selectTab(this.guiLayoutInfo.rightTabs, appPart);
        }
    }

    protected void selectTab(TabbedSplitPane tabbedSplitPane, AppPart appPart) {
        Tab[] tabArray = tabbedSplitPane.getAllTabs();
        int n = 0;
        while (n < tabArray.length) {
            Tab tab = tabArray[n];
            if (tab.getComponent() == appPart) {
                if (tab.isSelected()) break;
                tabbedSplitPane.selectTab(n);
                break;
            }
            ++n;
        }
    }

    public Component getDialogParent() {
        return this.frame;
    }

    public void waitCursor(boolean bl) {
        Component component = this.frame.getGlassPane();
        if (bl && !component.isVisible()) {
            component.setVisible(true);
        } else if (!bl && component.isVisible()) {
            component.setVisible(false);
        }
    }

    public TabbedSplitPane getOpenedDocumentTabs() {
        return this.openedDocumentTabs;
    }

    public void addHelpSet(String string) {
        HelpSupport.addHelpSet(string);
    }

    public void setHelpId(Component component, String string) {
        HelpSupport.setHelpId(component, string);
    }

    public void saveStateChanged(OpenedDocument openedDocument) {
        this.openedDocumentTabs.doLayout();
        this.openedDocumentTabs.repaintAllTabs();
        if (openedDocument == this.getActiveOpenedDocument()) {
            this.updateTitle();
        }
        super.saveStateChanged(openedDocument);
    }

    public void dispose() {
        this.singleInstanceSupport.stopOpenService();
        super.dispose();
    }

    public void flushPreferences() {
        this.authenticator.savePasswords(this.preferences);
        this.guiLayoutInfo.saveLayoutPreferences(this.preferences);
        int n = this.frame.getExtendedState();
        String string = (n & 2) != 0 ? ((n & 4) != 0 ? "both" : "horizontal") : ((n & 4) != 0 ? "vertical" : "no");
        this.preferences.putString("maximized", string);
        super.flushPreferences();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected static final class OpenedDocInfo {
        public OpenedDocument openedDoc;
        public Editor[] editors;
        public int activeEditorIndex;

        protected OpenedDocInfo() {
        }
    }
}

