/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.app;

import com.xmlmind.xmledit.guiutil.ImageResource;
import com.xmlmind.xmledit.guiutil.TearOffTab;
import com.xmlmind.xmleditapp.config.Configuration;
import com.xmlmind.xmleditapp.kit.App;
import com.xmlmind.xmleditapp.kit.CloseDocumentAction;
import com.xmlmind.xmleditapp.kit.OpenedDocument;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;

public class OpenedDocTab
extends TearOffTab {
    protected OpenedDocument openedDoc;
    protected int closeButtonX;
    protected int closeButtonY;
    protected static Image closeButtonImage = null;
    protected static int closeButtonWidth = -1;
    protected static int closeButtonHeight = -1;
    protected static final int SAVE_MARK_SIZE = 7;
    protected static final int SAVE_MARK_GAP = 1;
    protected static final int CLOSE_BUTTON_GAP = 4;
    static /* synthetic */ Class class$com$xmlmind$xmleditapp$app$OpenedDocTab;

    public OpenedDocTab(OpenedDocument openedDocument, Component component) {
        super("", null, component, true);
        this.openedDoc = openedDocument;
        this.closeButtonY = -1;
        this.closeButtonX = -1;
        if (closeButtonImage == null) {
            closeButtonImage = ImageResource.get(class$com$xmlmind$xmleditapp$app$OpenedDocTab == null ? (class$com$xmlmind$xmleditapp$app$OpenedDocTab = OpenedDocTab.class$("com.xmlmind.xmleditapp.app.OpenedDocTab")) : class$com$xmlmind$xmleditapp$app$OpenedDocTab, "close.gif");
            closeButtonWidth = closeButtonImage.getWidth(null);
            closeButtonHeight = closeButtonImage.getHeight(null);
        }
    }

    public String getLabel() {
        return this.openedDoc.getName();
    }

    public String getToolTip() {
        String string = this.openedDoc.getLabel();
        Configuration configuration = this.openedDoc.getConfiguration();
        if (configuration == null) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(" : ");
        stringBuffer.append(configuration.getName());
        return stringBuffer.toString();
    }

    protected boolean showLabel() {
        return true;
    }

    protected int getLabelWidth(FontMetrics fontMetrics) {
        String string = this.openedDoc.getName();
        int n = 8 + fontMetrics.stringWidth(string);
        if (this.selected) {
            n += 4 + closeButtonWidth;
        }
        return n;
    }

    protected int getLabelHeight(FontMetrics fontMetrics) {
        int n = Math.max(7, fontMetrics.getAscent() + fontMetrics.getDescent());
        n = Math.max(n, closeButtonHeight);
        return n;
    }

    protected void paintLabel(Graphics graphics, int n, int n2, int n3, Font font, FontMetrics fontMetrics, Color color) {
        String string = this.openedDoc.getName();
        graphics.setColor(color);
        if (this.openedDoc.isSaveNeeded()) {
            graphics.fillOval(n, n2 + (n3 - 7) / 2, 7, 7);
        }
        graphics.setFont(font);
        graphics.drawString(string, n += 8, n2 + n3 / 2 + (fontMetrics.getAscent() - fontMetrics.getDescent()) / 2);
        if (this.selected) {
            this.closeButtonX = n += fontMetrics.stringWidth(string) + 4;
            this.closeButtonY = n2 + (n3 - closeButtonHeight) / 2;
            graphics.drawImage(closeButtonImage, this.closeButtonX, this.closeButtonY, null);
        } else {
            this.closeButtonY = -1;
            this.closeButtonX = -1;
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.selected) {
            App app;
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            if (n >= this.closeButtonX && n < this.closeButtonX + closeButtonWidth && n2 >= this.closeButtonY && n2 < this.closeButtonY + closeButtonHeight) {
                CloseDocumentAction closeDocumentAction = this.openedDoc.getApp().getCloseDocumentAction();
                if (closeDocumentAction != null) {
                    closeDocumentAction.closeDocument(this.openedDoc);
                }
                return;
            }
            if (!this.insideTearOff(n, n2) && (app = this.openedDoc.getApp()).getActiveOpenedDocument() != this.openedDoc) {
                app.setActiveOpenedDocument(this.openedDoc);
                return;
            }
        }
        super.mousePressed(mouseEvent);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

