/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.app;

import com.xmlmind.xmledit.util.FileUtil;
import com.xmlmind.xmledit.util.MiscUtil;
import com.xmlmind.xmledit.util.Preferences;
import com.xmlmind.xmledit.util.StringUtil;
import com.xmlmind.xmleditapp.app.Msg;
import com.xmlmind.xmleditapp.kit.App;
import com.xmlmind.xmleditapp.kit.OpenDocumentAction;
import java.awt.Frame;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class SingleInstanceSupport
implements Runnable {
    private App app;
    private ServerSocket serverSocket = null;
    private Thread openServiceThread = null;
    public static final boolean SINGLE_INSTANCE_DEFAULT_VALUE = false;
    public static final int SINGLE_INSTANCE_DEFAULT_PORT = 49987;

    public SingleInstanceSupport(App app) {
        this.app = app;
    }

    public void openUsingRunningApp(String[] stringArray) {
        String string;
        Preferences preferences = this.app.getPreferences();
        if (!preferences.getBoolean("singleInstance", false)) {
            return;
        }
        String string2 = SingleInstanceSupport.formatOpenRequest(stringArray);
        int n = preferences.getInt("singleInstancePort", 49987);
        InetSocketAddress inetSocketAddress = new InetSocketAddress("127.0.0.1", n);
        boolean bl = false;
        Socket socket = new Socket();
        try {
            socket.setReuseAddress(true);
            socket.setSoLinger(false, -1);
            socket.setSoTimeout(10000);
            socket.setTcpNoDelay(true);
            socket.connect(inetSocketAddress, 1000);
            bl = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!bl) {
            SingleInstanceSupport.closeSocket(socket);
            return;
        }
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(socket.getOutputStream(), "UTF8");
            outputStreamWriter.write(string2);
            ((Writer)outputStreamWriter).flush();
            LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader(socket.getInputStream(), "UTF8"));
            string = lineNumberReader.readLine();
            if (string.length() == 0) {
                string = null;
            }
        }
        catch (Exception exception) {
            string = MiscUtil.reason(exception);
        }
        SingleInstanceSupport.closeSocket(socket);
        if (string == null) {
            System.exit(0);
        } else {
            JOptionPane.showMessageDialog(null, Msg.msg("cannotOpenUsingRunningApp", string), Msg.msg("error"), 0);
            preferences.putBoolean("singleInstance", false);
            SingleInstanceSupport.quickSavePreferences(preferences);
            System.exit(1);
        }
    }

    private static final String formatOpenRequest(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("open");
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                URL uRL;
                String string = stringArray[n];
                try {
                    uRL = new URL(string);
                }
                catch (MalformedURLException malformedURLException) {
                    uRL = null;
                }
                if (uRL == null) {
                    File file = new File(string);
                    if (!file.isFile()) {
                        JOptionPane.showMessageDialog(null, Msg.msg("usage", string), Msg.msg("error"), 0);
                        System.exit(1);
                    }
                    uRL = FileUtil.fileToURL(file);
                }
                stringBuffer.append(" \"");
                stringBuffer.append(uRL.toExternalForm());
                stringBuffer.append('\"');
                ++n;
            }
        }
        stringBuffer.append('\n');
        return stringBuffer.toString();
    }

    private static final void closeSocket(Socket socket) {
        try {
            socket.close();
        }
        catch (IOException iOException) {}
    }

    private static final void quickSavePreferences(Preferences preferences) {
        preferences.getMap().save();
    }

    public void applyPreferences() {
        int n;
        Preferences preferences = this.app.getPreferences();
        boolean bl = preferences.getBoolean("singleInstance", false);
        int n2 = preferences.getInt("singleInstancePort", 49987);
        boolean bl2 = this.serverSocket != null;
        int n3 = n = bl2 ? this.serverSocket.getLocalPort() : n2;
        if (bl != bl2 || n2 != n) {
            this.stopOpenService();
            if (bl && !this.startOpenService(n2)) {
                preferences.putBoolean("singleInstance", false);
            }
            SingleInstanceSupport.quickSavePreferences(preferences);
        }
    }

    public void stopOpenService() {
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.serverSocket = null;
        }
        if (this.openServiceThread != null) {
            if (this.openServiceThread.isAlive()) {
                this.openServiceThread.interrupt();
                try {
                    this.openServiceThread.join(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.openServiceThread = null;
        }
    }

    private boolean startOpenService(int n) {
        String string = null;
        try {
            this.serverSocket = new ServerSocket();
            this.serverSocket.bind(new InetSocketAddress("127.0.0.1", n));
        }
        catch (IOException iOException) {
            string = MiscUtil.reason(iOException);
        }
        if (string != null) {
            if (this.serverSocket != null) {
                try {
                    this.serverSocket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.serverSocket = null;
            }
            JOptionPane.showMessageDialog(this.app.getDialogParent(), Msg.msg("cannotStartOpenService", string), Msg.msg("error"), 0);
            return false;
        }
        this.openServiceThread = new Thread((Runnable)this, "XXE.openServiceThread");
        this.openServiceThread.start();
        return true;
    }

    public void run() {
        while (true) {
            Socket socket;
            try {
                socket = this.serverSocket.accept();
            }
            catch (Exception exception) {
                socket = null;
            }
            if (socket == null || Thread.interrupted()) break;
            ServiceThread serviceThread = new ServiceThread(socket);
            serviceThread.start();
        }
    }

    private final class ServiceThread
    extends Thread {
        private Socket socket;
        private URL[] inURLs;

        public ServiceThread(Socket socket) {
            this.socket = socket;
        }

        public void run() {
            Object object;
            Object object2;
            String string = null;
            try {
                this.socket.setSoTimeout(1000);
                this.socket.setTcpNoDelay(true);
                object2 = new LineNumberReader(new InputStreamReader(this.socket.getInputStream(), "UTF8"));
                object = ((LineNumberReader)object2).readLine();
                string = this.parseRequest((String)object);
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter(this.socket.getOutputStream(), "UTF8");
                if (string == null) {
                    ((Writer)outputStreamWriter).write(10);
                } else {
                    outputStreamWriter.write(string + '\n');
                }
                ((Writer)outputStreamWriter).flush();
            }
            catch (Exception exception) {
                string = MiscUtil.reason(exception);
            }
            SingleInstanceSupport.closeSocket(this.socket);
            if (string != null) {
                return;
            }
            object2 = SingleInstanceSupport.this.app.getDialogParent();
            if (object2 instanceof Frame) {
                object = (Frame)object2;
                int n = ((Frame)object).getExtendedState();
                if ((n & 1) != 0) {
                    ((Frame)object).setExtendedState(n & 0xFFFFFFFE);
                }
                ((Window)object).toFront();
            }
            if (this.inURLs.length > 0 && (object = SingleInstanceSupport.this.app.getOpenDocumentAction()) != null) {
                int n = this.inURLs.length - 1;
                while (n >= 0) {
                    URL uRL = this.inURLs[n];
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(this, (OpenDocumentAction)object, uRL){
                            private final /* synthetic */ OpenDocumentAction val$openDocumentAction;
                            private final /* synthetic */ URL val$inURL;
                            private final /* synthetic */ ServiceThread this$1;
                            {
                                this.this$1 = serviceThread;
                                this.val$openDocumentAction = openDocumentAction;
                                this.val$inURL = uRL;
                            }

                            public void run() {
                                this.val$openDocumentAction.openDocument(this.val$inURL);
                            }
                        });
                    }
                    catch (Exception exception) {
                        break;
                    }
                    --n;
                }
            }
        }

        private String parseRequest(String string) {
            String string2 = null;
            String[] stringArray = StringUtil.splitArguments(string);
            if (stringArray.length == 0 || !stringArray[0].equals("open")) {
                this.inURLs = null;
                string2 = "usage: open ?URL? ... ?URL?";
            } else {
                this.inURLs = new URL[stringArray.length - 1];
                int n = 1;
                while (n < stringArray.length) {
                    try {
                        this.inURLs[n - 1] = new URL(stringArray[n]);
                    }
                    catch (MalformedURLException malformedURLException) {
                        this.inURLs = null;
                        string2 = "'" + stringArray[n] + "' not an URL";
                        break;
                    }
                    ++n;
                }
            }
            return string2;
        }
    }
}

