/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.app.part;

import com.xmlmind.xmledit.guiutil.ImageResource;
import com.xmlmind.xmleditapp.kit.AppMenuItems;
import com.xmlmind.xmleditapp.kit.OpenedDocument;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public final class WindowListMenuItems
extends AppMenuItems
implements MenuListener {
    private ImageIcon activeIcon;
    private int firstWindowItem;
    static /* synthetic */ Class class$com$xmlmind$xmleditapp$app$part$WindowListMenuItems;

    public WindowListMenuItems() {
        Image image = ImageResource.get(class$com$xmlmind$xmleditapp$app$part$WindowListMenuItems == null ? (class$com$xmlmind$xmleditapp$app$part$WindowListMenuItems = WindowListMenuItems.class$("com.xmlmind.xmleditapp.app.part.WindowListMenuItems")) : class$com$xmlmind$xmleditapp$app$part$WindowListMenuItems, "active.gif");
        this.activeIcon = new ImageIcon(image);
    }

    public void initMenu(JMenu jMenu) {
        super.initMenu(jMenu);
        this.firstWindowItem = jMenu.getItemCount();
        jMenu.addMenuListener(this);
    }

    public void menuSelected(MenuEvent menuEvent) {
        JMenu jMenu = (JMenu)menuEvent.getSource();
        int n = jMenu.getItemCount() - 1;
        while (n >= this.firstWindowItem) {
            jMenu.remove(n);
            --n;
        }
        OpenedDocument[] openedDocumentArray = this.app.getOpenedDocuments();
        if (openedDocumentArray.length == 0) {
            return;
        }
        OpenedDocument openedDocument = this.app.getActiveOpenedDocument();
        if (this.firstWindowItem > 0) {
            jMenu.addSeparator();
        }
        int n2 = Math.min(25, openedDocumentArray.length);
        int n3 = 0;
        while (n3 < n2) {
            final OpenedDocument openedDocument2 = openedDocumentArray[n3];
            StringBuffer stringBuffer = new StringBuffer();
            if (n3 < 9) {
                stringBuffer.append(Integer.toString(1 + n3));
                stringBuffer.append(' ');
            } else {
                stringBuffer.append("\u00a0 ");
            }
            stringBuffer.append(openedDocument2.getShortLabel());
            JMenuItem jMenuItem = jMenu.add(stringBuffer.toString());
            if (openedDocument == openedDocumentArray[n3]) {
                jMenuItem.setIcon(this.activeIcon);
            } else {
                AppMenuItems.setNonIconic(jMenuItem);
            }
            if (n3 < 9) {
                jMenuItem.setMnemonic(stringBuffer.charAt(0));
                jMenuItem.setDisplayedMnemonicIndex(0);
            }
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    WindowListMenuItems.this.app.setActiveOpenedDocument(openedDocument2);
                }
            });
            ++n3;
        }
    }

    public void menuDeselected(MenuEvent menuEvent) {
    }

    public void menuCanceled(MenuEvent menuEvent) {
    }

    public void activeEditorChanged() {
        if (this.firstWindowItem == 0) {
            this.menu.setEnabled(this.app.getOpenedDocumentCount() > 0);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

