/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.app.prefsheet;

import com.xmlmind.xmledit.guiutil.HintLabel;
import com.xmlmind.xmledit.guiutil.LabeledValue;
import com.xmlmind.xmledit.util.Preferences;
import com.xmlmind.xmleditapp.app.Application;
import com.xmlmind.xmleditapp.app.prefsheet.Msg;
import com.xmlmind.xmleditapp.dialog.PreferencesSheetPane;
import com.xmlmind.xmleditapp.kit.App;
import com.xmlmind.xmleditapp.kit.AppPreferencesSheet;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Arrays;
import java.util.Locale;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class GeneralOptions
extends AppPreferencesSheet {
    private JCheckBox singleInstance;
    private JTextField singleInstancePort;
    private LabeledValue[] fontSizeItems;
    private JComboBox fontSize;
    private LabeledValue[] localeItems;
    private JComboBox locale;
    private LabeledValue[] lafItems;
    private JComboBox laf;
    private App app;

    public GeneralOptions() {
        super("general", Msg.msg("gen.title"));
    }

    protected PreferencesSheetPane createPane() {
        Object object;
        Object[] objectArray;
        PreferencesSheetPane preferencesSheetPane = new PreferencesSheetPane(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.insets.right = 5;
        gridBagConstraints.anchor = 17;
        JPanel jPanel = new JPanel(new FlowLayout(0, 5, 5));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        preferencesSheetPane.add((Component)jPanel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(new TitledBorder(new EtchedBorder(), Msg.msg("gen.userInterface")));
        gridBagConstraints.insets.top = 20;
        gridBagConstraints.insets.bottom = 5;
        ++gridBagConstraints.gridy;
        preferencesSheetPane.add((Component)jPanel2, gridBagConstraints);
        this.singleInstance = new JCheckBox(Msg.msg("gen.singleInstance"));
        jPanel.add(this.singleInstance);
        JLabel jLabel = new JLabel(Msg.msg("gen.singleInstancePort"));
        jPanel.add(jLabel);
        this.singleInstancePort = new JTextField(6);
        jPanel.add(this.singleInstancePort);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.anchor = 17;
        String string = Msg.msg("gen.defaultValue");
        jLabel = new JLabel(Msg.msg("gen.fontSize"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel2.add((Component)jLabel, gridBagConstraints);
        this.fontSizeItems = new LabeledValue[12];
        int n = 0;
        this.fontSizeItems[n++] = new LabeledValue(string, -1);
        int n2 = 10;
        while (n2 <= 20) {
            this.fontSizeItems[n++] = new LabeledValue(Integer.toString(n2), n2);
            ++n2;
        }
        this.fontSize = new JComboBox<LabeledValue>(this.fontSizeItems);
        ++gridBagConstraints.gridx;
        gridBagConstraints.insets.right = 5;
        jPanel2.add((Component)this.fontSize, gridBagConstraints);
        jLabel = new JLabel(Msg.msg("gen.locale"));
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.right = 0;
        jPanel2.add((Component)jLabel, gridBagConstraints);
        Locale[] localeArray = Locale.getAvailableLocales();
        this.localeItems = new LabeledValue[1 + localeArray.length];
        n = 0;
        this.localeItems[n++] = new LabeledValue(string, "-");
        int n3 = 0;
        while (n3 < localeArray.length) {
            objectArray = localeArray[n3];
            this.localeItems[n++] = new LabeledValue(objectArray.getDisplayName((Locale)objectArray), objectArray.toString());
            ++n3;
        }
        if (this.localeItems.length != n) {
            objectArray = new LabeledValue[n];
            System.arraycopy(this.localeItems, 0, objectArray, 0, n);
            this.localeItems = objectArray;
        }
        Arrays.sort(this.localeItems, 1, this.localeItems.length, LabeledValue.compareByLabel);
        this.locale = new JComboBox<LabeledValue>(this.localeItems);
        ++gridBagConstraints.gridx;
        gridBagConstraints.insets.right = 5;
        jPanel2.add((Component)this.locale, gridBagConstraints);
        jLabel = new JLabel(Msg.msg("gen.laf"));
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.right = 0;
        jPanel2.add((Component)jLabel, gridBagConstraints);
        objectArray = UIManager.getInstalledLookAndFeels();
        this.lafItems = new LabeledValue[1 + objectArray.length];
        n = 0;
        this.lafItems[n++] = new LabeledValue(string, "-");
        int n4 = 0;
        while (n4 < objectArray.length) {
            object = objectArray[n4];
            this.lafItems[n++] = new LabeledValue(object.getName(), object.getClassName());
            ++n4;
        }
        if (this.lafItems.length != n) {
            object = new LabeledValue[n];
            System.arraycopy(this.lafItems, 0, object, 0, n);
            this.lafItems = object;
        }
        Arrays.sort(this.lafItems, 1, this.lafItems.length, LabeledValue.compareByLabel);
        this.laf = new JComboBox<LabeledValue>(this.lafItems);
        ++gridBagConstraints.gridx;
        gridBagConstraints.insets.right = 5;
        jPanel2.add((Component)this.laf, gridBagConstraints);
        object = new HintLabel(Msg.msg("needAppRestart"));
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets.bottom = 5;
        jPanel2.add((Component)object, gridBagConstraints);
        return preferencesSheetPane;
    }

    public void focusPane() {
        this.singleInstance.requestFocus();
    }

    public void fillPane(Preferences preferences) {
        this.singleInstance.setSelected(preferences.getBoolean("singleInstance", false));
        this.singleInstancePort.setText(Integer.toString(preferences.getInt("singleInstancePort", 49987)));
        int n = preferences.getInt("fontSize", -1);
        this.fontSize.setSelectedIndex(LabeledValue.indexOfValue(this.fontSizeItems, n));
        String string = preferences.getString("locale", "-");
        this.locale.setSelectedIndex(LabeledValue.indexOfValue(this.localeItems, string));
        string = preferences.getString("lookAndFeelClassName", "-");
        this.laf.setSelectedIndex(LabeledValue.indexOfValue(this.lafItems, string));
    }

    public boolean validatePane(Preferences preferences) {
        int n = this.checkIntField(this.singleInstancePort, 1000, 65535, -1);
        if (n < 0) {
            return false;
        }
        preferences.putInt("singleInstancePort", n);
        preferences.putBoolean("singleInstance", this.singleInstance.isSelected());
        LabeledValue labeledValue = (LabeledValue)this.fontSize.getSelectedItem();
        preferences.putInt("fontSize", (Integer)labeledValue.value);
        labeledValue = (LabeledValue)this.locale.getSelectedItem();
        preferences.putString("locale", (String)labeledValue.value);
        labeledValue = (LabeledValue)this.laf.getSelectedItem();
        preferences.putString("lookAndFeelClassName", (String)labeledValue.value);
        return true;
    }

    public void applyPreferences(Preferences preferences) {
        ((Application)this.app).getSingleInstanceSupport().applyPreferences();
    }

    public void initApp(App app) {
        this.app = app;
    }

    public App getApp() {
        return this.app;
    }
}

