/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.app.prefsheet;

import com.xmlmind.xmledit.guiutil.MultiLineJLabel;
import com.xmlmind.xmledit.util.Preferences;
import com.xmlmind.xmleditapp.app.prefsheet.Msg;
import com.xmlmind.xmleditapp.dialog.PreferencesSheet;
import com.xmlmind.xmleditapp.dialog.PreferencesSheetPane;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.EtchedBorder;

public class WindowOptions
extends PreferencesSheet {
    private JCheckBox showBothViews;
    private JCheckBox treeViewAtRight;
    private JSlider treeViewPercent;

    public WindowOptions() {
        super("window", Msg.msg("win.title"));
    }

    protected PreferencesSheetPane createPane() {
        PreferencesSheetPane preferencesSheetPane = new PreferencesSheetPane(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.insets.right = 5;
        gridBagConstraints.anchor = 17;
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new EtchedBorder());
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets.bottom = 5;
        preferencesSheetPane.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.insets.right = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        this.showBothViews = new JCheckBox(Msg.msg("win.showBothViews"));
        this.showBothViews.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WindowOptions.this.enableBothViewsFrame();
            }
        });
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        jPanel.add((Component)this.showBothViews, gridBagConstraints);
        this.treeViewAtRight = new JCheckBox(Msg.msg("win.treeViewAtRight"));
        ++gridBagConstraints.gridy;
        jPanel.add((Component)this.treeViewAtRight, gridBagConstraints);
        MultiLineJLabel multiLineJLabel = new MultiLineJLabel(Msg.msg("win.treeViewPercent"));
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.insets.bottom = 5;
        jPanel.add((Component)multiLineJLabel, gridBagConstraints);
        this.treeViewPercent = new JSlider(0, 10, 90, 33);
        this.treeViewPercent.setLabelTable(this.treeViewPercent.createStandardLabels(80, 10));
        this.treeViewPercent.setPaintLabels(true);
        this.treeViewPercent.setMajorTickSpacing(10);
        this.treeViewPercent.setPaintTicks(true);
        ++gridBagConstraints.gridx;
        gridBagConstraints.insets.right = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.treeViewPercent, gridBagConstraints);
        return preferencesSheetPane;
    }

    private void enableBothViewsFrame() {
        boolean bl = this.showBothViews.isSelected();
        this.treeViewAtRight.setEnabled(bl);
        this.treeViewPercent.setEnabled(bl);
    }

    public void focusPane() {
        this.showBothViews.requestFocus();
    }

    public void fillPane(Preferences preferences) {
        this.showBothViews.setSelected(preferences.getBoolean("showBothViews", false));
        this.treeViewAtRight.setSelected(preferences.getBoolean("treeViewAtRight", false));
        this.treeViewPercent.setValue(preferences.getInt("treeViewPercent", 10, 90, 33));
        this.enableBothViewsFrame();
    }

    public boolean validatePane(Preferences preferences) {
        preferences.putBoolean("showBothViews", this.showBothViews.isSelected());
        preferences.putBoolean("treeViewAtRight", this.treeViewAtRight.isSelected());
        preferences.putInt("treeViewPercent", this.treeViewPercent.getValue());
        return true;
    }
}

