/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.applet;

import com.xmlmind.xmledit.edit.Commands;
import com.xmlmind.xmledit.edit.StyleSheetInfo;
import com.xmlmind.xmledit.guiutil.Tab;
import com.xmlmind.xmledit.guiutil.TabbedSplitPane;
import com.xmlmind.xmledit.util.Preferences;
import com.xmlmind.xmledit.xmlutil.XMLCatalogs;
import com.xmlmind.xmleditapp.kit.App;
import com.xmlmind.xmleditapp.kit.AppPart;
import com.xmlmind.xmleditapp.kit.DnDEditor;
import com.xmlmind.xmleditapp.kit.Editor;
import com.xmlmind.xmleditapp.kit.OpenedDocument;
import com.xmlmind.xmleditapp.kit.gui.GUISpec;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.KeyAdapter;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseMotionAdapter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Properties;
import javax.swing.JApplet;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class XMLEditor
extends App {
    protected JApplet applet;
    protected String guiSpecLocation;
    protected Properties preferenceProperties;
    protected Runnable autoRun;
    protected JPanel editorPane;
    protected GUISpec.LayoutInfo guiLayoutInfo;
    protected Editor activeEditor;
    protected Editor[] singleEditor = new Editor[1];
    protected OpenedDocument[] singleOpenedDocument = new OpenedDocument[1];
    protected static final Editor[] NO_EDITORS = new Editor[0];
    protected static final OpenedDocument[] NO_OPENED_DOCUMENTS = new OpenedDocument[0];
    static /* synthetic */ Class class$com$xmlmind$xmleditapp$applet$XMLEditor;

    public XMLEditor(JApplet jApplet) {
        this.applet = jApplet;
    }

    public JApplet getApplet() {
        return this.applet;
    }

    public void initGUISpecLocation(String string) {
        if (this.initialized) {
            throw new IllegalStateException();
        }
        if (string != null && (string = string.trim()).length() == 0) {
            string = null;
        }
        this.guiSpecLocation = string;
    }

    public String getGUISpecLocation() {
        return this.guiSpecLocation;
    }

    public void initPreferenceProperties(Properties properties) {
        if (this.initialized) {
            throw new IllegalStateException();
        }
        this.preferenceProperties = properties;
    }

    public Properties getPreferenceProperties() {
        return this.preferenceProperties;
    }

    public void initAutoRun(Runnable runnable) {
        if (this.initialized) {
            throw new IllegalStateException();
        }
        this.autoRun = runnable;
    }

    public Runnable getAutoRun() {
        return this.autoRun;
    }

    protected Preferences loadPreferences() {
        Preferences preferences = new Preferences();
        if (this.preferenceProperties != null) {
            preferences.putAll(this.preferenceProperties);
        }
        return preferences;
    }

    protected void createGUI(HashMap hashMap) {
        this.initGlassPane();
        this.loadGUI(this.getGUISpecURL(), hashMap);
    }

    protected void initGlassPane() {
        Component component = this.applet.getGlassPane();
        component.setCursor(Cursor.getPredefinedCursor(3));
        component.addMouseListener(new MouseAdapter(){});
        component.addMouseMotionListener(new MouseMotionAdapter(){});
        component.addKeyListener(new KeyAdapter(){});
    }

    protected URL getGUISpecURL() {
        URL uRL = null;
        URL uRL2 = (class$com$xmlmind$xmleditapp$applet$XMLEditor == null ? (class$com$xmlmind$xmleditapp$applet$XMLEditor = XMLEditor.class$("com.xmlmind.xmleditapp.applet.XMLEditor")) : class$com$xmlmind$xmleditapp$applet$XMLEditor).getResource("/gui/applet/default.xxe_gui");
        if (uRL2 != null) {
            String string = uRL2.toExternalForm();
            string = string.substring(0, string.length() - 22);
            XMLCatalogs.addRewriteURIEntry("xxe-gui:", string);
        }
        if (this.guiSpecLocation != null) {
            try {
                uRL = XMLCatalogs.resolveURI(this.guiSpecLocation, this.applet.getCodeBase());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (uRL == null) {
            uRL = uRL2;
        }
        return uRL;
    }

    protected void loadGUI(URL uRL, HashMap hashMap) {
        GUISpec gUISpec = new GUISpec();
        GUISpec.Error[] errorArray = null;
        if (uRL != null && (errorArray = gUISpec.load(uRL)).length > 0) {
            XMLEditor.addGUIErrors(errorArray, hashMap);
            gUISpec = new GUISpec();
        }
        this.editorPane = new JPanel(new BorderLayout());
        this.guiLayoutInfo = new GUISpec.LayoutInfo();
        errorArray = gUISpec.layout(this.applet, this.editorPane, this, this.guiLayoutInfo);
        if (errorArray.length > 0) {
            XMLEditor.addGUIErrors(errorArray, hashMap);
        }
    }

    protected static final void addGUIErrors(GUISpec.Error[] errorArray, HashMap hashMap) {
        int n = 0;
        while (n < errorArray.length) {
            GUISpec.Error error = errorArray[n];
            App.addError(hashMap, error.systemId, error.getMessageWithLocation());
            ++n;
        }
    }

    protected void doInitialize2a(HashMap hashMap, HashMap hashMap2) {
        this.guiLayoutInfo.applyLayoutPreferences(this.preferences);
        super.doInitialize2a(hashMap, hashMap2);
    }

    protected void doInitialize2(HashMap hashMap, HashMap hashMap2) {
        super.doInitialize2(hashMap, hashMap2);
        if (this.autoRun != null) {
            this.autoRun.run();
        }
    }

    public void addOpenedDocument(OpenedDocument openedDocument) {
        this.closeActiveEditor();
        StyleSheetInfo[] styleSheetInfoArray = openedDocument.getStyleSheetInfo();
        this.openActiveEditor(openedDocument, styleSheetInfoArray == null || styleSheetInfoArray.length == 0 ? null : styleSheetInfoArray[0]);
    }

    protected void closeActiveEditor() {
        if (this.activeEditor == null) {
            return;
        }
        Editor editor = this.activeEditor;
        this.removingEditor(editor);
        this.editorPane.remove(editor);
        this.activeEditor = null;
        this.editorDeactivated(editor);
        this.activeEditorChanged();
        this.editorRemoved(editor);
        OpenedDocument openedDocument = editor.getOpenedDocument();
        editor.dispose();
        openedDocument.closed(2);
        openedDocument.dispose();
        Commands.resetAllCommands();
    }

    protected void openActiveEditor(OpenedDocument openedDocument, StyleSheetInfo styleSheetInfo) {
        if (this.activeEditor != null) {
            return;
        }
        final Editor editor = this.createEditor();
        editor.open(openedDocument, styleSheetInfo);
        this.addingEditor(editor);
        this.editorPane.add((Component)editor, "Center");
        this.activeEditor = editor;
        this.editorActivated(editor);
        this.activeEditorChanged();
        this.editorAdded(editor);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                editor.getDocumentView().requestFocus();
            }
        });
    }

    public void removeOpenedDocument(OpenedDocument openedDocument) {
        if (this.activeEditor == null || this.activeEditor.getOpenedDocument() != openedDocument) {
            return;
        }
        this.closeActiveEditor();
    }

    public OpenedDocument[] getOpenedDocuments() {
        if (this.activeEditor == null) {
            return NO_OPENED_DOCUMENTS;
        }
        this.singleOpenedDocument[0] = this.activeEditor.getOpenedDocument();
        return this.singleOpenedDocument;
    }

    public Editor createEditor() {
        return new DnDEditor(this);
    }

    public void addEditor(Editor editor, Object object) {
        if (editor == this.activeEditor) {
            return;
        }
        this.closeActiveEditor();
        this.openActiveEditor(editor.getOpenedDocument(), editor.getStyleSheetInfo());
    }

    public void removeEditor(Editor editor) {
        if (editor != this.activeEditor) {
            return;
        }
        this.closeActiveEditor();
    }

    public Editor[] getEditors() {
        if (this.activeEditor == null) {
            return NO_EDITORS;
        }
        this.singleEditor[0] = this.activeEditor;
        return this.singleEditor;
    }

    public void setActiveEditor(Editor editor) {
    }

    public Editor getActiveEditor() {
        return this.activeEditor;
    }

    public void ensurePartIsVisible(AppPart appPart) {
        if (this.guiLayoutInfo.leftTabs != null) {
            this.selectTab(this.guiLayoutInfo.leftTabs, appPart);
        }
        if (this.guiLayoutInfo.rightTabs != null) {
            this.selectTab(this.guiLayoutInfo.rightTabs, appPart);
        }
    }

    protected void selectTab(TabbedSplitPane tabbedSplitPane, AppPart appPart) {
        Tab[] tabArray = tabbedSplitPane.getAllTabs();
        int n = 0;
        while (n < tabArray.length) {
            Tab tab = tabArray[n];
            if (tab.getComponent() == appPart) {
                if (tab.isSelected()) break;
                tabbedSplitPane.selectTab(n);
                break;
            }
            ++n;
        }
    }

    public Component getDialogParent() {
        return this.applet;
    }

    public void waitCursor(boolean bl) {
        Component component = this.applet.getGlassPane();
        if (bl && !component.isVisible()) {
            component.setVisible(true);
        } else if (!bl && component.isVisible()) {
            component.setVisible(false);
        }
    }

    protected void doShowStatus(String string) {
        if (this.statusWindow != null) {
            this.statusWindow.showStatus(string == null ? "" : string);
        } else {
            this.applet.showStatus(string == null ? "" : string);
        }
    }

    public void flushPreferences() {
        this.guiLayoutInfo.saveLayoutPreferences(this.preferences);
        super.flushPreferences();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

