/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.applet;

import com.xmlmind.xmledit.doc.Attribute;
import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.ProcessingInstruction;
import com.xmlmind.xmledit.doctype.Diagnostic;
import com.xmlmind.xmledit.edit.DocumentResource;
import com.xmlmind.xmledit.edit.DocumentUtil;
import com.xmlmind.xmledit.edit.UndoManager;
import com.xmlmind.xmledit.guiutil.Alert;
import com.xmlmind.xmledit.util.FileUtil;
import com.xmlmind.xmledit.util.MiscUtil;
import com.xmlmind.xmledit.util.PlatformUtil;
import com.xmlmind.xmledit.util.StringUtil;
import com.xmlmind.xmledit.util.URIUtil;
import com.xmlmind.xmledit.util.URLPathUtil;
import com.xmlmind.xmledit.util.URLUtil;
import com.xmlmind.xmledit.util.ZipUtil;
import com.xmlmind.xmleditapp.applet.Base64;
import com.xmlmind.xmleditapp.applet.Msg;
import com.xmlmind.xmleditapp.applet.XMLEditor;
import com.xmlmind.xmleditapp.kit.EditorEvent;
import com.xmlmind.xmleditapp.kit.EditorListener;
import com.xmlmind.xmleditapp.kit.OpenedDocument;
import com.xmlmind.xmleditapp.kit.OpenedDocumentHook;
import com.xmlmind.xmleditapp.kit.SaveDocument;
import com.xmlmind.xmleditapp.kit.part.CloseAction;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.FileLock;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.swing.JApplet;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class XMLEditorApplet
extends JApplet
implements EditorListener,
OpenedDocumentHook {
    protected long millisBeforeDeletingLocalCopy;
    protected static final int HOURS_BEFORE_DELETING_LOCAL_COPY = 48;
    protected File userDir;
    protected File workDir;
    protected File lockFile;
    protected XMLEditor xmlEditor;
    protected OpenedDocument targetDoc;
    protected Object docSource;
    protected int docSourceFormat;
    protected FileOutputStream locked;
    protected FileLock lock;
    protected String openError;
    protected File docDir;
    protected File docFile;
    protected ProgressMonitor openMonitor;
    protected OpenThread openThread;
    protected Timer openTimer;
    protected static final int FORMAT_ZIP_ARCHIVE = 1;
    protected static final int FORMAT_GZIP_COMPRESSED = 2;
    protected static final int FORMAT_BASE64_ENCODED = 4;
    public boolean trace = true;
    protected Object[] invokeResult = new Object[1];
    protected static final String LOCK_NAME = "LOCK";
    protected static final SimpleDateFormat DOC_DIR_PREFIX_FORMAT = new SimpleDateFormat("yy-MM-dd_HH-mm-ss");
    protected static final String[] EXCLUDED_EXTENSIONS = new String[]{"txt", "tex", "ps", "eps", "epsf", "pdf", "tiff", "tif", "gif", "png", "jpeg", "jpg", "jpe", "bmp", "wbmp", "ico", "ppm", "pgm", "pbm", "pnm", "xbm", "xpm", "xwd", "svg", "svgz"};
    protected static final String[] POSSIBLE_EXTENSIONS = new String[]{"xml", "xhtml", "html", "docb", "sdocb"};
    protected static final Attributes.Name MASTER_DOCUMENT_ATTR = new Attributes.Name("Master-Document");
    protected static final Attributes.Name CREATION_DATE_ATTR = new Attributes.Name("Creation-Date");
    protected static final String DOC_DIR_PROP = "DOCUMENT_DIRECTORY";
    static /* synthetic */ Class class$com$xmlmind$xmleditapp$applet$XMLEditorApplet;

    public void init() {
        String[] stringArray;
        Serializable serializable;
        ArrayList<String> arrayList = new ArrayList<String>();
        this.millisBeforeDeletingLocalCopy = this.parseMillis("hoursBeforeDeletingLocalCopy", 48, arrayList);
        String string = this.getParameter("formatPluginClassNames");
        String[] stringArray2 = string == null ? new String[]{} : StringUtil.split(string, ';');
        string = this.getParameter("foProcessorPluginClassNames");
        String[] stringArray3 = string == null ? new String[]{} : StringUtil.split(string, ';');
        string = this.getParameter("imageToolkitPluginClassNames");
        String[] stringArray4 = string == null ? new String[]{} : StringUtil.split(string, ';');
        URL uRL = (class$com$xmlmind$xmleditapp$applet$XMLEditorApplet == null ? (class$com$xmlmind$xmleditapp$applet$XMLEditorApplet = XMLEditorApplet.class$("com.xmlmind.xmleditapp.applet.XMLEditorApplet")) : class$com$xmlmind$xmleditapp$applet$XMLEditorApplet).getResource("/addon/");
        URL[] uRLArray = this.parseURLs("configurations", uRL, arrayList);
        URL[] uRLArray2 = this.parseURLs("catalogs", uRL, arrayList);
        String string2 = this.getParameter("guiSpecification");
        if (string2 != null && !string2.startsWith("xxe-gui:")) {
            serializable = this.resolveURL(string2, uRL);
            if (serializable == null) {
                arrayList.add(Msg.msg("badParam", "guiSpecification", string2));
                string2 = null;
            } else {
                string2 = ((URL)serializable).toExternalForm();
            }
        }
        serializable = this.loadPreferenceProperties(uRL, arrayList);
        int n = 0;
        while (n < 20) {
            string = this.getParameter("preference" + n);
            if (string != null) {
                int n2 = string.indexOf(61);
                if (n2 <= 0) {
                    arrayList.add(Msg.msg("badParam", "preference" + n, string));
                } else {
                    stringArray = string.substring(0, n2);
                    String string3 = string.substring(n2 + 1);
                    if (serializable == null) {
                        serializable = new Properties();
                    }
                    ((Properties)serializable).setProperty((String)stringArray, string3);
                }
            }
            ++n;
        }
        Runnable runnable = null;
        string = this.getParameter("openLocation");
        if (string != null) {
            stringArray = null;
            int n3 = 0;
            try {
                stringArray = new URL(this.getDocumentBase(), string);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            if (stringArray == null) {
                arrayList.add(Msg.msg("badParam", "openLocation", string));
            } else {
                string = this.getParameter("openFlags");
                if (string != null) {
                    try {
                        n3 = this.parseFlags(string);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        arrayList.add(Msg.msg("badParam", "openFlags", string));
                    }
                }
            }
            if (stringArray != null) {
                String[] stringArray5 = stringArray;
                int n4 = n3;
                runnable = new Runnable((URL)stringArray5, n4){
                    private final /* synthetic */ URL val$source;
                    private final /* synthetic */ int val$sourceFormat;
                    {
                        this.val$source = uRL;
                        this.val$sourceFormat = n;
                    }

                    public void run() {
                        XMLEditorApplet.this.open(XMLEditorApplet.this.newDocument(), this.val$source, this.val$sourceFormat);
                    }
                };
            }
        }
        try {
            this.initUserDir();
        }
        catch (IOException iOException) {
            this.lockFile = null;
            this.workDir = null;
            this.userDir = null;
            arrayList.add(Msg.msg("cannotInitUserDir", MiscUtil.reason(iOException)));
        }
        stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        this.xmlEditor = this.createXMLEditor();
        this.xmlEditor.initUserPreferencesDirectory(this.userDir);
        this.xmlEditor.initFormatPluginClassNames(stringArray2);
        this.xmlEditor.initFOProcessorPluginClassNames(stringArray3);
        this.xmlEditor.initImageToolkitPluginClassNames(stringArray4);
        this.xmlEditor.initConfigurationURLs(uRLArray);
        this.xmlEditor.initXMLCatalogURLs(uRLArray2);
        this.xmlEditor.initGUISpecLocation(string2);
        this.xmlEditor.initPreferenceProperties((Properties)serializable);
        this.xmlEditor.initAutoRun(runnable);
        this.xmlEditor.initStartErrors(stringArray);
        this.xmlEditor.initialize();
        this.xmlEditor.addEditorListener(this);
        this.xmlEditor.addOpenedDocumentHook(this);
    }

    protected long parseMillis(String string, int n, ArrayList arrayList) {
        int n2 = -1;
        String string2 = this.getParameter(string);
        if (string2 == null) {
            n2 = n;
        } else {
            try {
                n2 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (n2 <= 0) {
                n2 = n;
                arrayList.add(Msg.msg("badParam", string, string2));
            }
        }
        return (long)n2 * 3600L * 1000L;
    }

    protected URL[] parseURLs(String string, URL uRL, ArrayList arrayList) {
        URL[] uRLArray;
        String string2 = this.getParameter(string);
        if (string2 == null) {
            uRLArray = new URL[]{};
        } else {
            ArrayList<URL> arrayList2 = new ArrayList<URL>();
            String[] stringArray = StringUtil.split(string2, ';');
            int n = 0;
            while (n < stringArray.length) {
                String string3 = stringArray[n];
                URL uRL2 = this.resolveURL(string3, uRL);
                if (uRL2 == null) {
                    arrayList.add(Msg.msg("badParam", string, string3));
                } else {
                    arrayList2.add(uRL2);
                }
                ++n;
            }
            uRLArray = new URL[arrayList2.size()];
            arrayList2.toArray(uRLArray);
        }
        return uRLArray;
    }

    protected URL resolveURL(String string, URL uRL) {
        URL uRL2;
        block5: {
            block4: {
                uRL2 = null;
                if (!string.startsWith("addon:")) break block4;
                if (string.length() <= 6 || uRL == null) break block5;
                try {
                    uRL2 = new URL(uRL, string.substring(6));
                }
                catch (MalformedURLException malformedURLException) {}
                break block5;
            }
            try {
                uRL2 = new URL(this.getCodeBase(), string);
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return uRL2;
    }

    protected Properties loadPreferenceProperties(URL uRL, ArrayList arrayList) {
        String string = this.getParameter("preferences");
        if (string == null) {
            return null;
        }
        Properties properties = null;
        URL uRL2 = this.resolveURL(string, uRL);
        if (uRL2 != null) {
            try {
                URLConnection uRLConnection = uRL2.openConnection();
                uRLConnection.setUseCaches(false);
                uRLConnection.setIfModifiedSince(0L);
                InputStream inputStream = uRLConnection.getInputStream();
                properties = new Properties();
                properties.load(inputStream);
                inputStream.close();
            }
            catch (IOException iOException) {
                properties = null;
            }
        }
        if (properties == null) {
            arrayList.add(Msg.msg("badParam", "preferences", string));
        }
        return properties;
    }

    protected int parseFlags(String string) throws IllegalArgumentException {
        int n = 0;
        if (string != null && string.length() > 0) {
            String[] stringArray = StringUtil.split(string, ',');
            int n2 = 0;
            while (n2 < stringArray.length) {
                String string2 = stringArray[n2].trim();
                if ("zip".equals(string2)) {
                    n |= 1;
                } else if ("gzip".equals(string2)) {
                    n |= 2;
                } else if ("base64".equals(string2)) {
                    n |= 4;
                } else {
                    throw new IllegalArgumentException("unknown flag '" + string2 + "'");
                }
                ++n2;
            }
        }
        return n;
    }

    protected void initUserDir() throws IOException {
        this.userDir = this.userDir();
        if (this.userDir == null) {
            throw new IOException(Msg.msg("cannotDetermineUserDir"));
        }
        if (!this.userDir.isDirectory()) {
            FileUtil.removeFile(this.userDir, true);
            if (!this.userDir.mkdirs()) {
                throw new IOException(Msg.msg("cannotCreateDir", this.userDir));
            }
        }
        String[] stringArray = new String[]{"work", "ser", "spell"};
        int n = 0;
        while (n < stringArray.length) {
            File file = new File(this.userDir, stringArray[n]);
            if (!file.isDirectory()) {
                FileUtil.removeFile(file, true);
                if (!file.mkdir()) {
                    throw new IOException(Msg.msg("cannotCreateDir", file));
                }
            }
            if (n == 0) {
                this.workDir = file;
            }
            ++n;
        }
        this.lockFile = new File(this.workDir, LOCK_NAME);
        if (!this.lockFile.isFile()) {
            FileUtil.removeFile(this.lockFile, true);
            if (!this.lockFile.createNewFile()) {
                throw new IOException(Msg.msg("cannotCreateLockFile", this.lockFile));
            }
        }
    }

    protected File userDir() {
        String string = PlatformUtil.homeDir();
        if (string == null) {
            return null;
        }
        String string2 = PlatformUtil.IS_WINDOWS ? string + "\\Application Data\\XMLmind\\XMLEditorApplet" : string + "/.xxe_applet";
        File file = new File(string2);
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            file = null;
        }
        return file;
    }

    protected XMLEditor createXMLEditor() {
        return new XMLEditor(this);
    }

    public void start() {
    }

    public void stop() {
    }

    public void destroy() {
        this.xmlEditor.dispose();
    }

    public String getAppletInfo() {
        StringBuffer stringBuffer = new StringBuffer("XMLmind XML Editor ");
        stringBuffer.append("Professional");
        stringBuffer.append(" Edition ");
        stringBuffer.append("V3.0p1");
        return stringBuffer.toString();
    }

    public String[][] getParameterInfo() {
        String[][] stringArray = new String[][]{{"hoursBeforeDeletingLocalCopy", "number of hours (>= 1)", "The local copy of a document is deleted after specified number of hours following its last modification."}, {"formatPluginClassNames", "List of class names separated by ';'", "Specifies the non-XML format plug-ins to be registered by the applet."}, {"foProcessorPluginClassNames", "List of class names separated by ';'", "Specifies the FO processor plug-ins to be registered by the applet."}, {"imageToolkitPluginClassNames", "List of class names separated by ';'", "Specifies the image toolkit plug-ins to be registered by the applet."}, {"configurations", "List of URLs separated by ';'", "Specifies the XMLmind XML Editor configurations to be used by the applet."}, {"catalogs", "List of URLs separated by ';'", "Specifies the XML catalogs to be used by the applet."}, {"guiSpecification", "URL of a GUI specification file", "Specifies the GUI. Default: xxe-gui:applet/default.xxe_gui"}, {"preferences", "URL of a Java[tm] property file", "Specifies custom default values for user preferences such as 'maxUndo', 'indent', 'encoding', etc."}, {"preference0-19", "key=value", "Each preference0, ..., preference19 specifies a single user preference. Example: 'encoding=ISO-8859-1'. Overrides user preferences specified using preferences."}, {"openLocation", "URL", "Specifies the URL of a document to be automatically opened after applet start-up."}, {"openFlags", "a combination of 'zip', 'gzip', 'base64' separated by ','", "Specifies the ``format'' of the file downloaded using the value of parameter 'openLocation'. Ignored unless parameter 'openLocation' is specified."}};
        return stringArray;
    }

    public boolean openText(String string) {
        return this.openText(this.newDocument(), string);
    }

    public boolean openBinary(String string, String string2) throws IllegalArgumentException {
        return this.openBinary(this.newDocument(), string, string2);
    }

    public boolean openLocation(String string, String string2) throws IllegalArgumentException {
        return this.openLocation(this.newDocument(), string, string2);
    }

    public OpenedDocument newDocument() {
        return this.xmlEditor.createOpenedDocument();
    }

    public boolean openText(final OpenedDocument openedDocument, final String string) {
        this.invokeResult[0] = Boolean.FALSE;
        XMLEditorApplet.invokeAndWait(new Runnable(){

            public void run() {
                boolean bl = XMLEditorApplet.this.open(openedDocument, string, 0);
                XMLEditorApplet.this.invokeResult[0] = bl ? Boolean.TRUE : Boolean.FALSE;
            }
        });
        return (Boolean)this.invokeResult[0];
    }

    public boolean openBinary(final OpenedDocument openedDocument, final String string, String string2) throws IllegalArgumentException {
        final int n = this.parseFlags(string2);
        this.invokeResult[0] = Boolean.FALSE;
        XMLEditorApplet.invokeAndWait(new Runnable(){

            public void run() {
                boolean bl = XMLEditorApplet.this.open(openedDocument, string, n | 4);
                XMLEditorApplet.this.invokeResult[0] = bl ? Boolean.TRUE : Boolean.FALSE;
            }
        });
        return (Boolean)this.invokeResult[0];
    }

    public boolean openLocation(final OpenedDocument openedDocument, String string, String string2) throws IllegalArgumentException {
        URL uRL = null;
        try {
            uRL = new URL(this.getDocumentBase(), string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException("'" + string + "' invalid location: " + MiscUtil.reason(malformedURLException));
        }
        final int n = this.parseFlags(string2);
        final URL uRL2 = uRL;
        this.invokeResult[0] = Boolean.FALSE;
        XMLEditorApplet.invokeAndWait(new Runnable(){

            public void run() {
                boolean bl = XMLEditorApplet.this.open(openedDocument, uRL2, n);
                XMLEditorApplet.this.invokeResult[0] = bl ? Boolean.TRUE : Boolean.FALSE;
            }
        });
        return (Boolean)this.invokeResult[0];
    }

    protected static final void invokeAndWait(Runnable runnable) {
        block3: {
            try {
                if (SwingUtilities.isEventDispatchThread()) {
                    runnable.run();
                    break block3;
                }
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (Exception exception) {
                Exception exception2 = exception instanceof InvocationTargetException ? ((InvocationTargetException)exception).getCause() : exception;
                System.err.println("internal error in XMLEditorApplet:");
                System.err.println(MiscUtil.detailedReason(exception2));
            }
        }
    }

    public String getSaveText() {
        OpenedDocument openedDocument = this.getOpenedDocument();
        if (openedDocument == null) {
            return "";
        }
        return this.getSaveText(openedDocument);
    }

    public Object getSaveBinary(String string) throws IllegalArgumentException {
        OpenedDocument openedDocument = this.getOpenedDocument();
        if (openedDocument == null) {
            return "";
        }
        return this.getSaveBinary(openedDocument, string);
    }

    public boolean hasOpenedDocument() {
        return this.xmlEditor.getActiveOpenedDocument() != null;
    }

    public OpenedDocument getOpenedDocument() {
        return this.xmlEditor.getActiveOpenedDocument();
    }

    public String getSaveText(final OpenedDocument openedDocument) {
        this.invokeResult[0] = null;
        XMLEditorApplet.invokeAndWait(new Runnable(){

            public void run() {
                XMLEditorApplet.this.invokeResult[0] = XMLEditorApplet.this.doGetSaveText(openedDocument);
            }
        });
        return this.invokeResult[0] == null ? "" : (String)this.invokeResult[0];
    }

    public Object getSaveBinary(final OpenedDocument openedDocument, String string) throws IllegalArgumentException {
        final int n = this.parseFlags(string);
        this.invokeResult[0] = null;
        XMLEditorApplet.invokeAndWait(new Runnable(){

            public void run() {
                byte[] byArray = XMLEditorApplet.this.doGetSaveBinary(openedDocument, n);
                if (byArray != null && (n & 4) != 0) {
                    try {
                        XMLEditorApplet.this.invokeResult[0] = new String(byArray, "US-ASCII");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {}
                } else {
                    XMLEditorApplet.this.invokeResult[0] = byArray;
                }
            }
        });
        return this.invokeResult[0] == null ? "" : this.invokeResult[0];
    }

    public boolean close() {
        OpenedDocument openedDocument = this.getOpenedDocument();
        if (openedDocument == null) {
            return true;
        }
        return this.close(openedDocument);
    }

    public boolean close(final OpenedDocument openedDocument) {
        this.invokeResult[0] = Boolean.FALSE;
        XMLEditorApplet.invokeAndWait(new Runnable(){

            public void run() {
                boolean bl = XMLEditorApplet.this.doClose(openedDocument);
                XMLEditorApplet.this.invokeResult[0] = bl ? Boolean.TRUE : Boolean.FALSE;
            }
        });
        return (Boolean)this.invokeResult[0];
    }

    protected boolean open(OpenedDocument openedDocument, Object object, int n) {
        if (this.workDir == null) {
            return false;
        }
        if (this.targetDoc != null) {
            return false;
        }
        OpenedDocument openedDocument2 = this.xmlEditor.getActiveOpenedDocument();
        if (openedDocument2 != null && !this.doClose(openedDocument2)) {
            return false;
        }
        this.beginOpen(openedDocument, object, n);
        return true;
    }

    protected void beginOpen(OpenedDocument openedDocument, Object object, int n) {
        this.xmlEditor.waitCursor(true);
        this.targetDoc = openedDocument;
        this.docSource = object;
        this.docSourceFormat = n;
        this.locked = null;
        this.lock = null;
        this.openError = null;
        this.docDir = null;
        this.docFile = null;
        this.openMonitor = new ProgressMonitor(this, Msg.msg("openingDoc"), Msg.msg("lockingWorkDir"), 0, 100);
        this.openMonitor.setMillisToDecideToPopup(3000);
        this.openMonitor.setMillisToPopup(0);
        this.openThread = new OpenThread();
        this.openThread.start();
        this.openTimer = new Timer(250, new OpenTimerAction());
        this.openTimer.setRepeats(true);
        this.openTimer.setCoalesce(true);
        this.openTimer.start();
    }

    protected void setProgressMessage(final String string) {
        if (this.openMonitor != null && !this.openMonitor.isCanceled()) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.openMonitor.setNote(string);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        XMLEditorApplet.this.openMonitor.setNote(string);
                    }
                });
            }
        }
    }

    protected void endOpen(boolean bl) {
        String[] stringArray = new String[4];
        int n = 0;
        if (this.openError != null) {
            bl = true;
            stringArray[n++] = this.openError;
            this.openError = null;
        }
        if (bl) {
            if (this.docDir != null && !FileUtil.removeFile(this.docDir, true)) {
                stringArray[n++] = Msg.msg("cannotDeleteDir", this.docDir);
            }
        } else {
            this.targetDoc.putProperty(DOC_DIR_PROP, this.docDir);
        }
        if (this.lock != null) {
            try {
                this.lock.release();
            }
            catch (IOException iOException) {
                stringArray[n++] = Msg.msg("cannotReleaseLock", MiscUtil.reason(iOException));
            }
            this.lock = null;
        }
        if (this.locked != null) {
            try {
                this.locked.close();
            }
            catch (IOException iOException) {
                stringArray[n++] = Msg.msg("cannotCloseLockFile", MiscUtil.reason(iOException));
            }
            this.locked = null;
        }
        this.docDir = null;
        this.docFile = null;
        this.docSourceFormat = 0;
        this.docSource = null;
        this.targetDoc = null;
        this.xmlEditor.waitCursor(false);
        if (n > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            while (n2 < n) {
                if (n2 > 0) {
                    stringBuffer.append('\n');
                }
                stringBuffer.append("  - ");
                stringBuffer.append(stringArray[n2]);
                ++n2;
            }
            Alert.showError(this, Msg.msg("openErrors", stringBuffer.toString()));
        }
    }

    protected void sweepWorkDir() throws IOException {
        long l = System.currentTimeMillis();
        String[] stringArray = new String[2];
        String[] stringArray2 = this.workDir.list();
        int n = 0;
        while (n < stringArray2.length) {
            String string = stringArray2[n];
            if (!LOCK_NAME.equals(string)) {
                File file = new File(this.workDir, string);
                if (!file.isDirectory()) {
                    file.delete();
                } else {
                    File file2 = new File(file, "META-INF" + File.separatorChar + "MANIFEST.MF");
                    if (!file2.isFile()) {
                        FileUtil.removeFile(file, true);
                    } else {
                        File file3 = null;
                        long l2 = -1L;
                        boolean bl = false;
                        try {
                            this.getManifestInfo(file2, stringArray);
                            bl = true;
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        if (bl) {
                            if (stringArray[0] != null) {
                                if (File.separatorChar != '/') {
                                    stringArray[0] = stringArray[0].replace('/', File.separatorChar);
                                }
                                if (!(file3 = new File(file, stringArray[0])).isFile()) {
                                    file3 = null;
                                }
                            }
                            if (stringArray[1] != null) {
                                try {
                                    l2 = Long.parseLong(stringArray[1]);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                            boolean bl2 = bl = file3 != null && l2 >= 0L;
                        }
                        if (!bl) {
                            FileUtil.removeFile(file, true);
                        } else if (l >= file3.lastModified() + this.millisBeforeDeletingLocalCopy) {
                            FileUtil.removeFile(file, true);
                        }
                    }
                }
            }
            ++n;
        }
    }

    protected File createDocDir(OpenedDocument openedDocument, Object object) throws IOException {
        String string = this.baseName(openedDocument, object);
        string = string == null ? "" : this.filterBaseName(string);
        StringBuffer stringBuffer = new StringBuffer();
        DOC_DIR_PREFIX_FORMAT.format(new Date(), stringBuffer, new FieldPosition(0));
        stringBuffer.append('_');
        stringBuffer.append(string);
        String string2 = stringBuffer.toString();
        string2 = XMLEditorApplet.uniqueName(string2, this.workDir);
        File file = new File(this.workDir, string2);
        if (!file.mkdir()) {
            throw new IOException(Msg.msg("cannotCreateDir", file));
        }
        return file;
    }

    protected String baseName(OpenedDocument openedDocument, Object object) {
        int n;
        URL uRL;
        String string = openedDocument.getName();
        if (string == null && object instanceof URL && (string = URLUtil.getRawBaseName(uRL = (URL)object)) != null) {
            string = URIUtil.unescape(string);
        }
        if (string != null && (n = string.indexOf(46)) > 0) {
            string = string.substring(0, n);
        }
        return string;
    }

    protected String filterBaseName(String string) {
        char[] cArray = string.toCharArray();
        char[] cArray2 = new char[cArray.length];
        int n = 0;
        int n2 = 0;
        while (n2 < cArray.length) {
            char c = cArray[n2];
            if (Character.isLetterOrDigit(c)) {
                cArray2[n++] = c;
            }
            ++n2;
        }
        return new String(cArray2, 0, n);
    }

    protected File dumpDoc(Object object, int n, File file) throws IOException {
        File file2;
        block5: {
            file2 = null;
            try {
                if (object instanceof String) {
                    file2 = this.doDumpDoc((String)object, n, file);
                    break block5;
                }
                if (object instanceof byte[]) {
                    file2 = this.doDumpDoc((byte[])object, n, file);
                    break block5;
                }
                if (object instanceof URL) {
                    file2 = this.doDumpDoc((URL)object, n, file);
                    break block5;
                }
                throw new IllegalArgumentException("expected source to be a String, byte[] or URL, found " + object);
            }
            catch (Exception exception) {
                throw new IOException(Msg.msg("cannotCreateDocFile", file, MiscUtil.reason(exception)));
            }
        }
        return file2;
    }

    protected File doDumpDoc(String string, int n, File file) throws IOException {
        if ((n & 4) != 0) {
            return this.doDumpDoc(new ByteArrayInputStream(string.getBytes("US-ASCII")), n, file);
        }
        File file2 = new File(file, "doc.xml");
        String string2 = XMLEditorApplet.findEncoding(string);
        if (string2 == null) {
            string2 = "UTF-8";
        }
        FileUtil.saveString(string, file2, string2);
        return file2;
    }

    protected static final String findEncoding(String string) {
        int n = string.indexOf("<?xml");
        if (n != 0) {
            return null;
        }
        n = string.indexOf("?>");
        if (n < 0) {
            return null;
        }
        String[] stringArray = ProcessingInstruction.parsePseudoAttributes(string.substring(5, n));
        if (stringArray == null) {
            return null;
        }
        String string2 = null;
        int n2 = 0;
        while (n2 < stringArray.length) {
            String string3 = stringArray[n2];
            String string4 = stringArray[n2 + 1];
            if (string3.equals("encoding")) {
                string2 = string4;
                break;
            }
            n2 += 2;
        }
        return string2;
    }

    protected File doDumpDoc(byte[] byArray, int n, File file) throws IOException {
        return this.doDumpDoc(new ByteArrayInputStream(byArray), n, file);
    }

    protected File doDumpDoc(URL uRL, int n, File file) throws IOException {
        String string;
        String string2;
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setUseCaches(false);
        uRLConnection.setIfModifiedSince(0L);
        InputStream inputStream = uRLConnection.getInputStream();
        if (n == 0 && (string2 = uRLConnection.getContentType()) != null && (string = FileUtil.contentTypeToMediaType(string2)) != null) {
            String string3;
            if ("application/zip".equals(string)) {
                n = 1;
            }
            if ("application/x-gzip".equals(string) || "application/x-gunzip".equals(string)) {
                n = 2;
            }
            if ("application/octet-stream".equals(string)) {
                String string4 = URLUtil.getRawExtension(uRL);
                if (string4 != null) {
                    if ("gz".equals(string4 = URIUtil.unescape(string4).toLowerCase())) {
                        n = 2;
                    } else if ("zip".equals(string4)) {
                        n = 1;
                    }
                }
            } else if (string.startsWith("text/") && (string3 = FileUtil.contentTypeToCharsetName(string2)) != null) {
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream, string3);
                CharArrayWriter charArrayWriter = new CharArrayWriter();
                XMLEditorApplet.copyChars(inputStreamReader, charArrayWriter);
                return this.doDumpDoc(((Object)charArrayWriter).toString(), 0, file);
            }
        }
        return this.doDumpDoc(inputStream, n, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static final void copyChars(Reader reader, Writer writer) throws IOException {
        char[] cArray = new char[8192];
        try {
            try {
                int n;
                while ((n = reader.read(cArray, 0, cArray.length)) != -1) {
                    writer.write(cArray, 0, n);
                }
                writer.flush();
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                writer.close();
                throw throwable;
            }
            writer.close();
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            reader.close();
            throw throwable;
        }
        reader.close();
    }

    protected File doDumpDoc(InputStream inputStream, int n, File file) throws IOException {
        File file2;
        if ((n & 4) != 0) {
            inputStream = new Base64.InputStream(inputStream);
        }
        if ((n & 2) != 0) {
            inputStream = new GZIPInputStream(inputStream);
        }
        if ((n & 1) != 0) {
            XMLEditorApplet.unzip(inputStream, file);
            file2 = this.findUnzippedDocFile(file);
        } else {
            file2 = new File(file, "doc.xml");
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            FileUtil.copy(inputStream, fileOutputStream);
        }
        return file2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static final void unzip(InputStream inputStream, File file) throws IOException {
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        try {
            ZipUtil.unzip(zipInputStream, file);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            zipInputStream.close();
            throw throwable;
        }
        zipInputStream.close();
    }

    protected File findUnzippedDocFile(File file) throws IOException {
        Object object;
        Object object2;
        Object object3;
        File file2 = null;
        File file3 = new File(file, "META-INF");
        if (file3.exists()) {
            if (file3.isDirectory() && ((File)(object3 = new File(file3, "MANIFEST.MF"))).isFile()) {
                object2 = null;
                object = new String[2];
                try {
                    this.getManifestInfo((File)object3, (String[])object);
                    object2 = object[0];
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (object2 != null) {
                    if (File.separatorChar != '/') {
                        object2 = ((String)object2).replace('/', File.separatorChar);
                    }
                    file2 = !(file2 = new File(file, (String)object2)).isFile() ? null : file2.getCanonicalFile();
                }
            }
            FileUtil.removeFile(file3, true);
        }
        if (file2 == null) {
            String[] stringArray;
            object3 = new FilenameFilter(){

                public boolean accept(File file, String string) {
                    return string.lastIndexOf(46) > 0 && new File(file, string).isFile();
                }
            };
            object2 = file.list((FilenameFilter)object3);
            String[] stringArray2 = this.getPossibleExtensionsForAMasterDocument();
            object = null;
            int n = 0;
            while (n < ((String[])object2).length) {
                stringArray = object2[n];
                String string = FileUtil.fileExtension((String)stringArray).toLowerCase();
                if (StringUtil.contains(stringArray2, string)) {
                    if (object != null) {
                        object = null;
                        break;
                    }
                    object = stringArray;
                }
                ++n;
            }
            if (object != null) {
                file2 = new File(file, (String)object);
            }
            if (file2 == null) {
                stringArray = this.getExtensionsExcludedForAMasterDocument();
                object = null;
                int n2 = 0;
                while (n2 < ((Object)object2).length) {
                    Object object4 = object2[n2];
                    String string = FileUtil.fileExtension((String)object4).toLowerCase();
                    if (!StringUtil.contains(stringArray, string)) {
                        if (object != null) {
                            object = null;
                            break;
                        }
                        object = object4;
                    }
                    ++n2;
                }
                if (object != null) {
                    file2 = new File(file, (String)object);
                }
            }
        }
        if (file2 == null) {
            throw new IOException(Msg.msg("dontFindUnzippedDocFile", file));
        }
        return file2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getManifestInfo(File file, String[] stringArray) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            Manifest manifest = new Manifest(fileInputStream);
            Attributes attributes = manifest.getMainAttributes();
            stringArray[0] = (String)attributes.get(MASTER_DOCUMENT_ATTR);
            stringArray[1] = (String)attributes.get(CREATION_DATE_ATTR);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            ((InputStream)fileInputStream).close();
            throw throwable;
        }
        ((InputStream)fileInputStream).close();
    }

    protected String[] getExtensionsExcludedForAMasterDocument() {
        return EXCLUDED_EXTENSIONS;
    }

    protected String[] getPossibleExtensionsForAMasterDocument() {
        return POSSIBLE_EXTENSIONS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createManifest(File file, File file2) throws IOException {
        Manifest manifest = new Manifest();
        Attributes attributes = manifest.getMainAttributes();
        attributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        int n = file.getPath().length();
        String string = file2.getPath().substring(n + 1);
        if (File.separatorChar != '/') {
            string = string.replace(File.separatorChar, '/');
        }
        attributes.put(MASTER_DOCUMENT_ATTR, string);
        attributes.put(CREATION_DATE_ATTR, Long.toString(file2.lastModified()));
        File file3 = new File(file, "META-INF");
        if (!file3.mkdir()) {
            throw new IOException(Msg.msg("cannotCreateDir", file3));
        }
        File file4 = new File(file3, "MANIFEST.MF");
        FileOutputStream fileOutputStream = new FileOutputStream(file4);
        try {
            manifest.write(fileOutputStream);
            fileOutputStream.flush();
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            ((OutputStream)fileOutputStream).close();
            throw throwable;
        }
        ((OutputStream)fileOutputStream).close();
    }

    protected boolean openDoc(OpenedDocument openedDocument, File file) {
        URL uRL = FileUtil.fileToURL(file);
        if (!openedDocument.opening(uRL) || !openedDocument.open(uRL)) {
            return false;
        }
        this.xmlEditor.addOpenedDocument(openedDocument);
        if (openedDocument.canCheckValidity()) {
            openedDocument.checkValidity();
        }
        return true;
    }

    protected String doGetSaveText(OpenedDocument openedDocument) {
        byte[] byArray = this.doGetSaveBinary(openedDocument, 0);
        if (byArray == null) {
            return null;
        }
        SaveDocument saveDocument = new SaveDocument(this.xmlEditor, openedDocument.getStructuredFormat(), openedDocument.getConfiguration());
        String string = null;
        try {
            string = new String(byArray, saveDocument.getEncoding());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        return string;
    }

    protected byte[] doGetSaveBinary(OpenedDocument openedDocument, int n) {
        Object object;
        if (openedDocument.isSaveAsNeeded()) {
            return null;
        }
        URL uRL = openedDocument.getLocation();
        File file = FileUtil.urlToFile(uRL);
        if (file == null) {
            return null;
        }
        if (!"Professional".equals("Applet")) {
            Alert.showInfo(this, Msg.msg("requiresAppletEdition"));
            return null;
        }
        Document document = openedDocument.getDocument();
        DocumentUtil.commitChanges(document);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(file.getName());
        DocumentResource[] documentResourceArray = (DocumentResource[])document.getProperty("DOCUMENT_RESOURCES");
        if (documentResourceArray != null && !this.checkResources(document, documentResourceArray, uRL, file, arrayList)) {
            return null;
        }
        if (openedDocument.isSaveNeeded()) {
            object = openedDocument.getLabel();
            this.xmlEditor.showStatus(Msg.msg("savingDocument", object), false);
            if (!openedDocument.saving() || !openedDocument.save()) {
                this.xmlEditor.showStatus("", true);
                return null;
            }
            this.xmlEditor.showStatus(Msg.msg("documentSaved", object), true);
        }
        object = null;
        try {
            object = this.readSavedDoc(file, arrayList, n);
        }
        catch (IOException iOException) {
            Alert.showError(this, Msg.msg("cannotReadSavedDoc", file, MiscUtil.reason(iOException)));
        }
        return object;
    }

    protected boolean checkResources(Document document, DocumentResource[] documentResourceArray, URL uRL, File file, ArrayList arrayList) {
        Object object;
        Element element = document.getRootElement();
        HashMap<URL, String> hashMap = new HashMap<URL, String>();
        boolean bl = false;
        boolean bl2 = true;
        int n = 0;
        while (n < documentResourceArray.length) {
            object = documentResourceArray[n].getSelector().select(element);
            int n2 = 0;
            while (n2 < ((Object)object).length) {
                block21: {
                    String string;
                    URL uRL2;
                    Element element2;
                    Attribute attribute;
                    block22: {
                        Object object2;
                        block20: {
                            object2 = object[n2];
                            attribute = null;
                            element2 = null;
                            uRL2 = null;
                            string = null;
                            if (!(object2 instanceof Attribute)) break block20;
                            attribute = (Attribute)object2;
                            if (!XMLEditorApplet.insideDocumentEntity(attribute.element)) break block21;
                            string = attribute.value;
                            uRL2 = attribute.element.getLocation();
                            if (uRL2 == null) {
                                uRL2 = uRL;
                            }
                            break block22;
                        }
                        if (!(object2 instanceof Element)) break block22;
                        element2 = (Element)object2;
                        if (!XMLEditorApplet.insideDocumentEntity(element2)) break block21;
                        string = element2.getText();
                        uRL2 = element2.getLocation();
                        if (uRL2 == null) {
                            uRL2 = uRL;
                        }
                    }
                    if (string != null && ((string = string.trim()).length() == 0 || string.equals("???"))) {
                        string = null;
                    }
                    if (string != null) {
                        File file2;
                        URL uRL3 = null;
                        try {
                            uRL3 = new URL(uRL2, string);
                        }
                        catch (MalformedURLException malformedURLException) {
                            // empty catch block
                        }
                        if (uRL3 != null && (file2 = FileUtil.urlToFile(uRL3)) != null) {
                            String string2 = (String)hashMap.get(uRL3);
                            if (string2 == null) {
                                try {
                                    string2 = this.copyResource(file2, file);
                                }
                                catch (IOException iOException) {
                                    Alert.showError(this, Msg.msg("cannotCopyResource", file2, file, MiscUtil.reason(iOException)));
                                    bl2 = false;
                                    break;
                                }
                                hashMap.put(uRL3, string2);
                                arrayList.add(string2);
                            }
                            if (!string2.equals(string)) {
                                if (!bl) {
                                    bl = true;
                                    document.beginBatchEditing();
                                }
                                if (attribute != null) {
                                    attribute.element.putAttribute(attribute.name, string2);
                                } else {
                                    element2.setText(string2);
                                }
                            }
                        }
                    }
                }
                ++n2;
            }
            ++n;
        }
        if (bl) {
            document.endBatchEditing();
            object = (UndoManager)document.getProperty("UNDO_MANAGER");
            if (object != null) {
                ((UndoManager)object).reset();
            }
        }
        return bl2;
    }

    private static final boolean insideDocumentEntity(Element element) {
        return element.lookupProperty("INCLUSION_INFO") == null;
    }

    protected String copyResource(File file, File file2) throws IOException {
        String string;
        File file3 = file2.getParentFile();
        String string2 = file3.getPath() + File.separatorChar;
        if (file.getPath().startsWith(string2)) {
            string = file.getPath().substring(string2.length());
        } else {
            String string3 = file2.getName();
            string3 = URLPathUtil.trimExtension(string3);
            File file4 = new File(file3, string3 = string3 + "_resources");
            if (!file4.isDirectory() && !file4.mkdir()) {
                throw new IOException(Msg.msg("cannotCreateDir", file4));
            }
            String string4 = XMLEditorApplet.uniqueName(file.getName(), file4);
            File file5 = new File(file4, string4);
            FileUtil.copyFile(file, file5);
            string = string3 + File.separatorChar + string4;
        }
        return string;
    }

    protected static final String uniqueName(String string, File file) {
        CharSequence charSequence;
        String string2 = URLPathUtil.extension(string);
        String string3 = URLPathUtil.trimExtension(string);
        int n = string3.length();
        int n2 = -1;
        String[] stringArray = file.list();
        int n3 = 0;
        while (n3 < stringArray.length) {
            charSequence = stringArray[n3];
            String string4 = URLPathUtil.extension((String)charSequence);
            String string5 = URLPathUtil.trimExtension((String)charSequence);
            if (string5.startsWith(string3) && string4.equals(string2)) {
                int n4 = -1;
                if (string5.length() == n) {
                    n4 = 1;
                } else {
                    int n5 = string5.lastIndexOf(95);
                    if (n5 == n) {
                        try {
                            n4 = Integer.parseInt(string5.substring(n5 + 1));
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                }
                if (n4 > n2) {
                    n2 = n4;
                }
            }
            ++n3;
        }
        if (n2 > 0) {
            charSequence = new StringBuffer();
            ((StringBuffer)charSequence).append(string3);
            ((StringBuffer)charSequence).append('_');
            ((StringBuffer)charSequence).append(Integer.toString(n2 + 1));
            if (string2.length() > 0) {
                ((StringBuffer)charSequence).append('.');
                ((StringBuffer)charSequence).append(string2);
            }
            return ((StringBuffer)charSequence).toString();
        }
        return string;
    }

    protected byte[] readSavedDoc(File file, ArrayList arrayList, int n) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream;
        OutputStream outputStream = byteArrayOutputStream = new ByteArrayOutputStream();
        if ((n & 4) != 0) {
            outputStream = new Base64.OutputStream(outputStream);
        }
        if ((n & 2) != 0) {
            outputStream = new GZIPOutputStream(outputStream);
        }
        if ((n & 1) != 0) {
            Manifest manifest = new Manifest();
            Attributes attributes = manifest.getMainAttributes();
            attributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
            attributes.put(MASTER_DOCUMENT_ATTR, file.getName());
            JarOutputStream jarOutputStream = new JarOutputStream(outputStream, manifest);
            XMLEditorApplet.zip(arrayList, file.getParentFile(), jarOutputStream);
        } else {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            FileUtil.copy(bufferedInputStream, outputStream);
        }
        return byteArrayOutputStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static final void zip(ArrayList arrayList, File file, ZipOutputStream zipOutputStream) throws IOException {
        ZipUtil.Archive archive = new ZipUtil.Archive(zipOutputStream);
        try {
            int n = arrayList.size();
            int n2 = 0;
            while (n2 < n) {
                File file2 = new File(file, (String)arrayList.get(n2));
                archive.add(file2, file);
                ++n2;
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            archive.close();
            throw throwable;
        }
        archive.close();
    }

    protected boolean doClose(OpenedDocument openedDocument) {
        if (openedDocument == null) {
            return true;
        }
        if (!openedDocument.hasProperty(DOC_DIR_PROP) && openedDocument.isSaveNeeded() && !CloseAction.canDiscardChanges(openedDocument)) {
            return false;
        }
        if (!openedDocument.closing()) {
            return false;
        }
        this.xmlEditor.removeOpenedDocument(openedDocument);
        return true;
    }

    public void addingEditor(EditorEvent editorEvent) {
        this.trace("addingEditor " + editorEvent.getEditor());
    }

    public void editorAdded(EditorEvent editorEvent) {
        this.trace("editorAdded " + editorEvent.getEditor());
    }

    public void editorActivated(EditorEvent editorEvent) {
        this.trace("editorActivated " + editorEvent.getEditor());
    }

    public void editorDeactivated(EditorEvent editorEvent) {
        this.trace("editorDeactivated " + editorEvent.getEditor());
    }

    public void removingEditor(EditorEvent editorEvent) {
        this.trace("removingEditor " + editorEvent.getEditor());
    }

    public void editorRemoved(EditorEvent editorEvent) {
        File file;
        this.trace("editorRemoved " + editorEvent.getEditor());
        OpenedDocument openedDocument = editorEvent.getEditor().getOpenedDocument();
        if (openedDocument != null && (file = (File)openedDocument.getProperty(DOC_DIR_PROP)) != null && openedDocument.isSaveNeeded() && !openedDocument.isSaveAsNeeded()) {
            String string = openedDocument.getLabel();
            this.xmlEditor.showStatus(Msg.msg("savingDocument", string), false);
            if (!openedDocument.saving() || !openedDocument.save()) {
                this.xmlEditor.showStatus("", true);
            } else {
                this.xmlEditor.showStatus(Msg.msg("documentSaved", string), true);
            }
        }
    }

    public void editorDisposed(EditorEvent editorEvent) {
        this.trace("editorDisposed " + editorEvent.getEditor());
    }

    protected void trace(String string) {
        if (this.trace) {
            System.err.println(string);
        }
    }

    public boolean creatingDocument(OpenedDocument openedDocument, boolean bl, URL uRL) {
        this.trace("creatingDocument " + openedDocument.getLabel());
        return true;
    }

    public void documentCreated(OpenedDocument openedDocument, int n) {
        this.trace("documentCreated " + openedDocument.getLabel() + " status=" + n);
    }

    public boolean openingDocument(OpenedDocument openedDocument, URL uRL, OpenedDocument openedDocument2) {
        this.trace("openingDocument " + openedDocument.getLabel());
        return true;
    }

    public void documentOpened(OpenedDocument openedDocument, int n) {
        this.trace("documentOpened " + openedDocument.getLabel() + " status=" + n);
    }

    public boolean savingDocument(OpenedDocument openedDocument) {
        this.trace("savingDocument " + openedDocument.getLabel());
        return true;
    }

    public void documentSaved(OpenedDocument openedDocument, int n) {
        this.trace("documentSaved " + openedDocument.getLabel() + " status=" + n);
    }

    public boolean savingDocumentAs(OpenedDocument openedDocument, URL uRL) {
        this.trace("savingDocumentAs " + openedDocument.getLabel());
        return true;
    }

    public void documentSavedAs(OpenedDocument openedDocument, int n) {
        this.trace("documentSavedAs " + openedDocument.getLabel() + " status=" + n);
    }

    public boolean savingDocumentCopy(OpenedDocument openedDocument, Document document, URL uRL) {
        this.trace("savingDocumentCopy " + openedDocument.getLabel());
        return true;
    }

    public void documentCopySaved(OpenedDocument openedDocument, int n) {
        this.trace("documentCopySaved " + openedDocument.getLabel() + " status=" + n);
    }

    public boolean checkingDocument(OpenedDocument openedDocument) {
        this.trace("checkingDocument " + openedDocument.getLabel());
        return true;
    }

    public Diagnostic[] documentChecked(OpenedDocument openedDocument, int n, Diagnostic[] diagnosticArray) {
        this.trace("documentChecked " + openedDocument.getLabel() + " status=" + n);
        return diagnosticArray;
    }

    public boolean closingDocument(OpenedDocument openedDocument) {
        this.trace("closingDocument " + openedDocument.getLabel());
        return true;
    }

    public void documentClosed(OpenedDocument openedDocument, int n) {
        File file;
        this.trace("documentClosed " + openedDocument.getLabel() + " status=" + n);
        if (n == 2 && (file = (File)openedDocument.getProperty(DOC_DIR_PROP)) != null && !openedDocument.isModified()) {
            FileUtil.removeFile(file, true);
        }
    }

    public void documentDisposed(OpenedDocument openedDocument) {
        this.trace("documentDisposed " + openedDocument.getLabel());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class OpenTimerAction
    implements ActionListener {
        private long start = System.currentTimeMillis();

        protected OpenTimerAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl;
            boolean bl2 = XMLEditorApplet.this.openMonitor.isCanceled();
            boolean bl3 = bl = !XMLEditorApplet.this.openThread.isAlive() || bl2;
            if (bl) {
                XMLEditorApplet.this.openThread.cancel = true;
                XMLEditorApplet.this.openThread.interrupt();
                XMLEditorApplet.this.openMonitor.close();
                XMLEditorApplet.this.openMonitor = null;
                XMLEditorApplet.this.openTimer.stop();
                XMLEditorApplet.this.openTimer = null;
                try {
                    XMLEditorApplet.this.openThread.join(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                XMLEditorApplet.this.openThread.stop();
                XMLEditorApplet.this.openThread = null;
                if (XMLEditorApplet.this.openError != null || bl2) {
                    XMLEditorApplet.this.endOpen(true);
                } else {
                    SwingUtilities.invokeLater(new Runnable(this){
                        private final /* synthetic */ OpenTimerAction this$1;
                        {
                            this.this$1 = openTimerAction;
                        }

                        public void run() {
                            boolean bl = OpenTimerAction.access$000(this.this$1).openDoc(OpenTimerAction.access$000((OpenTimerAction)this.this$1).targetDoc, OpenTimerAction.access$000((OpenTimerAction)this.this$1).docFile);
                            OpenTimerAction.access$000(this.this$1).endOpen(!bl);
                        }
                    });
                }
            } else {
                int n = (int)((System.currentTimeMillis() - this.start) / 1000L);
                int n2 = n < 10 ? n * 50 / 10 : (n < 100 ? 50 + n * 30 / 100 : (n < 1000 ? 80 + n * 15 / 1000 : (n < 10000 ? 95 + n * 4 / 10000 : 99)));
                XMLEditorApplet.this.openMonitor.setProgress(n2);
            }
        }

        static /* synthetic */ XMLEditorApplet access$000(OpenTimerAction openTimerAction) {
            return openTimerAction.XMLEditorApplet.this;
        }
    }

    protected class OpenThread
    extends Thread {
        public boolean cancel;

        protected OpenThread() {
        }

        public void run() {
            block10: while (true) {
                try {
                    while (true) {
                        if (this.cancel) {
                            return;
                        }
                        try {
                            XMLEditorApplet.this.locked = new FileOutputStream(XMLEditorApplet.this.lockFile);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        if (XMLEditorApplet.this.locked != null) {
                            try {
                                XMLEditorApplet.this.lock = XMLEditorApplet.this.locked.getChannel().tryLock();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if (XMLEditorApplet.this.lock != null) break block10;
                            try {
                                XMLEditorApplet.this.locked.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            XMLEditorApplet.this.locked = null;
                        }
                        if (this.cancel) {
                            return;
                        }
                        Thread.sleep(250L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
            try {
                if (this.cancel) {
                    return;
                }
                XMLEditorApplet.this.setProgressMessage(Msg.msg("sweepingWorkDir"));
                XMLEditorApplet.this.sweepWorkDir();
                if (this.cancel) {
                    return;
                }
                XMLEditorApplet.this.setProgressMessage(Msg.msg("creatingDocDir"));
                XMLEditorApplet.this.docDir = XMLEditorApplet.this.createDocDir(XMLEditorApplet.this.targetDoc, XMLEditorApplet.this.docSource);
                if (this.cancel) {
                    return;
                }
                XMLEditorApplet.this.setProgressMessage(Msg.msg("dumpingDoc"));
                XMLEditorApplet.this.docFile = XMLEditorApplet.this.dumpDoc(XMLEditorApplet.this.docSource, XMLEditorApplet.this.docSourceFormat, XMLEditorApplet.this.docDir);
                if (this.cancel) {
                    return;
                }
                XMLEditorApplet.this.setProgressMessage(Msg.msg("creatingManifest"));
                XMLEditorApplet.this.createManifest(XMLEditorApplet.this.docDir, XMLEditorApplet.this.docFile);
            }
            catch (Exception exception) {
                XMLEditorApplet.this.openError = MiscUtil.reason(exception);
            }
        }
    }
}

