/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.applet.part;

import com.xmlmind.xmledit.doc.Attribute;
import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.doc.XNode;
import com.xmlmind.xmledit.edit.MarkManager;
import com.xmlmind.xmledit.edit.UndoManager;
import com.xmlmind.xmledit.guiutil.Alert;
import com.xmlmind.xmledit.guiutil.ChooseFile;
import com.xmlmind.xmledit.util.FileUtil;
import com.xmlmind.xmledit.util.MiscUtil;
import com.xmlmind.xmledit.util.Preferences;
import com.xmlmind.xmleditapp.applet.part.Msg;
import com.xmlmind.xmleditapp.kit.LengthyAction;
import com.xmlmind.xmleditapp.kit.OpenedDocument;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.Enumeration;
import javax.swing.JOptionPane;

public class RecoverAction
extends LengthyAction {
    protected File srcFile;

    protected boolean init() {
        OpenedDocument openedDocument = this.app.getActiveOpenedDocument();
        if (openedDocument == null) {
            return false;
        }
        File file = FileUtil.urlToFile(openedDocument.getLocation());
        if (file == null) {
            return false;
        }
        File file2 = file.getParentFile();
        if (file2 != null) {
            file2 = file2.getParentFile();
        }
        this.srcFile = ChooseFile.chooseOpenFile(this.app.getDialogParent(), new File(file2, "any"));
        if (this.srcFile == null) {
            return false;
        }
        File file3 = file.getParentFile();
        File file4 = this.srcFile.getParentFile();
        try {
            file3 = file3.getCanonicalFile();
            file4 = file4.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (file4.equals(file3)) {
            Alert.showError(this.app.getDialogParent(), Msg.msg("cannotRecoverFromSameDir", file4));
            return false;
        }
        return true;
    }

    protected void exec() {
        XNode xNode;
        Serializable serializable;
        int n;
        OpenedDocument openedDocument = this.app.getActiveOpenedDocument();
        if (openedDocument == null) {
            return;
        }
        if (openedDocument.isSaveNeeded() && (n = JOptionPane.showConfirmDialog(this.app.getDialogParent(), Msg.msg("confirmDiscardChanges", openedDocument.getLabel()), Msg.msg("confirm"), 2)) != 0) {
            return;
        }
        File file = FileUtil.urlToFile(openedDocument.getLocation());
        if (file == null) {
            return;
        }
        File file2 = file.getParentFile();
        File file3 = this.srcFile.getParentFile();
        int n2 = JOptionPane.showConfirmDialog(this.app.getDialogParent(), Msg.msg("confirmRecovery", file2, file3, file, this.srcFile), Msg.msg("confirm"), 2);
        if (n2 != 0) {
            return;
        }
        this.app.showStatus(Msg.msg("recovering", openedDocument.getName(), this.srcFile), false);
        OpenedDocument openedDocument2 = this.app.createOpenedDocument();
        URL uRL = FileUtil.fileToURL(this.srcFile);
        if (!this.open(openedDocument2, uRL)) {
            this.app.showStatus("", true);
            return;
        }
        Document document = openedDocument2.getDocument();
        Element element = document.getRootElement();
        Document document2 = openedDocument.getDocument();
        Element element2 = document2.getRootElement();
        if (element.getName() != element2.getName()) {
            Alert.showError(this.app.getDialogParent(), Msg.msg("differentRoots", openedDocument.getName(), element2.getName().format(false, element2), element.getName().format(false, element2)));
            this.app.showStatus("", true);
            openedDocument2.dispose();
            return;
        }
        openedDocument2.dispose();
        byte[] byArray = null;
        try {
            byArray = RecoverAction.loadManifest(file2);
        }
        catch (IOException iOException) {
            Alert.showError(this.app.getDialogParent(), Msg.msg("cannotLoadManifest", file2, MiscUtil.reason(iOException)));
            this.app.showStatus("", true);
            return;
        }
        if (!FileUtil.emptyDirectory(file2)) {
            Alert.showError(this.app.getDialogParent(), Msg.msg("cannotEmptyDir", file2));
            this.app.showStatus("", true);
            return;
        }
        try {
            RecoverAction.copyAllFiles(file3, file2);
        }
        catch (IOException iOException) {
            Alert.showError(this.app.getDialogParent(), Msg.msg("cannotCopyAllFiles", file3, file2, MiscUtil.reason(iOException)));
            this.app.showStatus("", true);
            return;
        }
        if (!this.srcFile.getName().equals(file.getName()) && !(serializable = new File(file2, this.srcFile.getName())).renameTo(file)) {
            Alert.showError(this.app.getDialogParent(), Msg.msg("cannotRenameFile", serializable, file));
            this.app.showStatus("", true);
            return;
        }
        if (byArray != null) {
            try {
                RecoverAction.saveManifest(byArray, file2);
            }
            catch (IOException iOException) {
                Alert.showError(this.app.getDialogParent(), Msg.msg("cannotSaveManifest", file2, MiscUtil.reason(iOException)));
                this.app.showStatus("", true);
                return;
            }
        }
        if (!this.open(openedDocument2 = this.app.createOpenedDocument(), (URL)(serializable = FileUtil.fileToURL(file)))) {
            this.app.showStatus("", true);
            return;
        }
        document = openedDocument2.getDocument();
        element = document.getRootElement();
        MarkManager markManager = (MarkManager)document2.getProperty("MARK_MANAGER");
        markManager.beginBatchMarking();
        document2.beginBatchEditing();
        element2.removeAllChildren();
        Attribute[] attributeArray = element2.getAllAttributes();
        int n3 = 0;
        while (n3 < attributeArray.length) {
            element2.removeAttribute(attributeArray[n3].name);
            ++n3;
        }
        element2.removeProperty("LOCATION_INFO");
        document2.removeProperty("LOCATION_INFO");
        Object object = document.getProperty("LOCATION_INFO");
        if (object != null) {
            document2.putProperty("LOCATION_INFO", object);
        }
        if ((object = element2.getProperty("LOCATION_INFO")) != null) {
            element2.putProperty("LOCATION_INFO", object);
        }
        Enumeration enumeration = element.getAttributes();
        while (enumeration.hasMoreElements()) {
            xNode = (Attribute)enumeration.nextElement();
            element2.putAttribute(((Attribute)xNode).name, ((Attribute)xNode).value);
        }
        xNode = element.getFirstChild();
        while (xNode != null) {
            element2.appendChild(((Node)xNode).copy());
            xNode = ((Node)xNode).getNextSibling();
        }
        document2.endBatchEditing();
        markManager.remove("SELECTED2");
        markManager.remove("MARK");
        markManager.set("SELECTED", element2);
        this.app.getActiveDocumentView().moveDotInto(element2);
        markManager.endBatchMarking();
        UndoManager undoManager = (UndoManager)document2.getProperty("UNDO_MANAGER");
        undoManager.reset();
        this.app.showStatus(Msg.msg("recovered", openedDocument.getName()), true);
        openedDocument2.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean open(OpenedDocument openedDocument, URL uRL) {
        boolean bl;
        Preferences preferences = this.app.getPreferences();
        boolean bl2 = preferences.getBoolean("warnAboutLossOfPhysicalStructure", true);
        boolean bl3 = preferences.getBoolean("infoAboutReadOnlyInclusions", true);
        preferences.putBoolean("warnAboutLossOfPhysicalStructure", false);
        preferences.putBoolean("infoAboutReadOnlyInclusions", false);
        try {
            bl = openedDocument.open(uRL);
            Object var8_7 = null;
            preferences.putBoolean("warnAboutLossOfPhysicalStructure", bl2);
            preferences.putBoolean("infoAboutReadOnlyInclusions", bl3);
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            preferences.putBoolean("warnAboutLossOfPhysicalStructure", bl2);
            preferences.putBoolean("infoAboutReadOnlyInclusions", bl3);
            throw throwable;
        }
        return bl;
    }

    protected static final void copyAllFiles(File file, File file2) throws IOException {
        String[] stringArray = file.list();
        if (stringArray == null) {
            throw new IOException("cannot list directory '" + file + "'");
        }
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            File file3 = new File(file, string);
            File file4 = new File(file2, string);
            if (file3.isDirectory()) {
                if (!file4.mkdir()) {
                    throw new IOException("cannot create directory '" + file4 + "'");
                }
                RecoverAction.copyAllFiles(file3, file4);
            } else {
                FileUtil.copyFile(file3, file4);
            }
            ++n;
        }
    }

    protected static final byte[] loadManifest(File file) throws IOException {
        File file2 = new File(file, "META-INF" + File.separatorChar + "MANIFEST.MF");
        if (!file2.isFile()) {
            return null;
        }
        return FileUtil.loadBytes(file2);
    }

    protected static final void saveManifest(byte[] byArray, File file) throws IOException {
        if ((file = new File(file, "META-INF")).exists()) {
            FileUtil.removeFile(file, true);
        }
        if (!file.mkdir()) {
            throw new IOException("cannot create directory '" + file + "'");
        }
        FileUtil.saveBytes(byArray, new File(file, "MANIFEST.MF"));
    }

    public void updateEnabled() {
        this.setEnabled(this.app.getActiveOpenedDocument() != null);
    }
}

