/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.command;

import com.xmlmind.xmledit.guiutil.DialogUtil;
import com.xmlmind.xmledit.xmlutil.NamespacePrefixMap;
import com.xmlmind.xmledit.xpath.ExprParser;
import com.xmlmind.xmledit.xpath.NodeSetExpr;
import com.xmlmind.xmledit.xpath.ParseException;
import com.xmlmind.xmleditapp.command.Msg;
import com.xmlmind.xmleditapp.command.XSearchFormInfo;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class AdvancedXSearchForm
extends JPanel {
    private JComboBox expression;

    public AdvancedXSearchForm() {
        super(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.insets.right = 5;
        gridBagConstraints.anchor = 17;
        String string = Msg.msg("AXSF.expression");
        JLabel jLabel = new JLabel(DialogUtil.buttonLabel(string));
        DialogUtil.setDisplayedMnemonic(jLabel, string);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.add((Component)jLabel, gridBagConstraints);
        this.expression = new JComboBox();
        Font font = this.expression.getFont();
        this.expression.setFont(new Font("Monospaced", 0, Math.max(12, font.getSize() - 2)));
        this.expression.setEditable(true);
        JTextField jTextField = this.getExpressionField();
        jTextField.setColumns(60);
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.top = 1;
        gridBagConstraints.insets.bottom = 5;
        this.add((Component)this.expression, gridBagConstraints);
        jLabel.setLabelFor(this.expression);
    }

    public JTextField getExpressionField() {
        return (JTextField)this.expression.getEditor().getEditorComponent();
    }

    public XSearchFormInfo getInfo(NamespacePrefixMap namespacePrefixMap, boolean bl) {
        NodeSetExpr nodeSetExpr;
        JTextField jTextField = this.getExpressionField();
        String string = jTextField.getText().trim();
        if (string.length() == 0) {
            DialogUtil.badField(jTextField);
            return null;
        }
        try {
            nodeSetExpr = ExprParser.parseNodeSetExpr(string, namespacePrefixMap, bl);
        }
        catch (ParseException parseException) {
            DialogUtil.badField(jTextField);
            return null;
        }
        this.expression.setSelectedItem(string);
        return new XSearchFormInfo(string, nodeSetExpr);
    }

    public void addToHistory(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this.expression.getModel();
        Object object = defaultComboBoxModel.getSelectedItem();
        defaultComboBoxModel.removeElement(string);
        int n = defaultComboBoxModel.getSize();
        if (n == 10) {
            defaultComboBoxModel.removeElementAt(n - 1);
        }
        defaultComboBoxModel.insertElementAt(string, 0);
        defaultComboBoxModel.setSelectedItem(object);
    }

    public void setHistory(String[] stringArray) {
        DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this.expression.getModel();
        Object object = defaultComboBoxModel.getSelectedItem();
        defaultComboBoxModel.removeAllElements();
        int n = 0;
        while (n < stringArray.length) {
            defaultComboBoxModel.addElement(stringArray[n]);
            ++n;
        }
        defaultComboBoxModel.setSelectedItem(object);
    }

    public String[] getHistory() {
        DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this.expression.getModel();
        int n = defaultComboBoxModel.getSize();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = (String)defaultComboBoxModel.getElementAt(n2);
            ++n2;
        }
        return stringArray;
    }
}

