/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.command;

import com.xmlmind.xmledit.command.RecordableCommand;
import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.InclusionInfo;
import com.xmlmind.xmledit.doc.LocationInfo;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.doctype.DocumentType;
import com.xmlmind.xmledit.doctype.DocumentTypeUtil;
import com.xmlmind.xmledit.doctype.IdEntry;
import com.xmlmind.xmledit.edit.ClipboardFormat;
import com.xmlmind.xmledit.edit.MarkManager;
import com.xmlmind.xmledit.gadget.Gadget;
import com.xmlmind.xmledit.guiutil.Clipboard;
import com.xmlmind.xmledit.view.DocumentView;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xmlutil.PrefixEntry;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;

public class CopyAsInclusion
extends RecordableCommand {
    public static final Name SOURCE_DOCUMENT_ATTRIBUTE = Name.get(ClipboardFormat.CLIPBOARD_NAMESPACE, "sourceDocument");
    public static final Name SOURCE_ELEMENT_ATTRIBUTE = Name.get(ClipboardFormat.CLIPBOARD_NAMESPACE, "sourceElement");
    public static final Name LOCATION_ATTRIBUTE = Name.get(ClipboardFormat.CLIPBOARD_NAMESPACE, "location");
    public static final String XML_BASE_AWARE_SUFFIX = ";XMLBaseAware";
    private ClipboardFormat clipboardFormat = new ClipboardFormat();
    private Element selectedElement;
    private Node[] nodes1 = new Node[1];

    public boolean prepareCommand(Gadget gadget, String string, int n, int n2) {
        this.nodes1[0] = null;
        DocumentView documentView = (DocumentView)gadget;
        this.selectedElement = documentView.getSelectedElement("[implicitElement]".equals(string));
        if (this.selectedElement == null) {
            return false;
        }
        Element element = null;
        Element element2 = this.selectedElement;
        while (element2 != null) {
            InclusionInfo inclusionInfo = (InclusionInfo)element2.getProperty("INCLUSION_INFO");
            if (inclusionInfo != null) {
                element = element2;
                break;
            }
            element2 = element2.getParentElement();
        }
        if (element != null) {
            if (element == this.selectedElement) {
                return true;
            }
            this.selectedElement = null;
            return false;
        }
        return true;
    }

    protected Object doExecuteCommand(DocumentView documentView, String string, int n, int n2) {
        Object object;
        PrefixEntry[] prefixEntryArray;
        Object object2;
        String string2;
        MarkManager markManager = documentView.getMarkManager();
        Document document = this.selectedElement.getDocument();
        String string3 = null;
        InclusionInfo inclusionInfo = (InclusionInfo)this.selectedElement.getProperty("INCLUSION_INFO");
        if (inclusionInfo != null) {
            string2 = inclusionInfo.getDocumentLocation(this.selectedElement).toExternalForm();
            string3 = inclusionInfo.getXIncludeXPointer();
        } else {
            string2 = document.getLocation().toExternalForm();
            if (this.selectedElement == document.getRootElement()) {
                if (document.getChildCount() > 1) {
                    string3 = "element(/1)";
                }
            } else {
                object2 = (DocumentType)document.getProperty("DOCUMENT_TYPE");
                prefixEntryArray = new IdentityHashMap();
                if (DocumentTypeUtil.isConstrainedDocumentType((DocumentType)object2)) {
                    object = new HashMap();
                    object2.collectIds(document.getRootElement(), (Map)object);
                    Iterator iterator = ((HashMap)object).values().iterator();
                    while (iterator.hasNext()) {
                        IdEntry idEntry = (IdEntry)iterator.next();
                        prefixEntryArray.put(idEntry.elements[0], idEntry.id);
                    }
                }
                object = new StringBuffer();
                CopyAsInclusion.findXPointer(this.selectedElement, (IdentityHashMap)prefixEntryArray, object);
                string3 = "element(" + ((StringBuffer)object).toString() + ")";
            }
        }
        object2 = CopyAsInclusion.createAnnotatedElement(this.selectedElement, string2, string3);
        prefixEntryArray = document.getPreferredPrefixes(false);
        this.nodes1[0] = object2;
        object = this.clipboardFormat.formatNodes(this.nodes1, 1, prefixEntryArray);
        Clipboard.put(documentView.getPanel(), (String)object);
        markManager.notifyContextChangeListeners();
        this.selectedElement = null;
        return null;
    }

    static final Element createAnnotatedElement(Element element, String string, String string2) {
        Element element2 = (Element)element.copy();
        CopyAsInclusion.annotate(element, element2);
        element2.putAttribute(SOURCE_DOCUMENT_ATTRIBUTE, string);
        if (string2 != null) {
            element2.putAttribute(SOURCE_ELEMENT_ATTRIBUTE, string2);
        }
        return element2;
    }

    private static final void annotate(Element element, Element element2) {
        Object object;
        String string = null;
        if (element2.getParent() == null) {
            string = element.getLocation().toExternalForm();
        } else {
            object = (LocationInfo)element.getProperty("LOCATION_INFO");
            if (object != null) {
                string = ((LocationInfo)object).getLocation();
                if (((LocationInfo)object).isXMLBaseAware()) {
                    string = string + XML_BASE_AWARE_SUFFIX;
                }
            }
        }
        if (string != null) {
            element2.putAttribute(LOCATION_ATTRIBUTE, string);
        }
        object = element.getFirstChild();
        Node node = element2.getFirstChild();
        while (object != null) {
            if (object instanceof Element) {
                CopyAsInclusion.annotate((Element)object, (Element)node);
            }
            object = ((Node)object).getNextSibling();
            node = node.getNextSibling();
        }
    }

    private static final void findXPointer(Element element, IdentityHashMap identityHashMap, StringBuffer stringBuffer) {
        Element element2 = element;
        while (element2 != null) {
            String string = (String)identityHashMap.get(element2);
            if (string != null) {
                stringBuffer.insert(0, string);
                break;
            }
            stringBuffer.insert(0, CopyAsInclusion.indexOfElement(element2));
            stringBuffer.insert(0, '/');
            element2 = element2.getParentElement();
        }
    }

    private static final int indexOfElement(Element element) {
        int n = 1;
        Node node = element.getParent().getFirstChild();
        while (node != null) {
            if (node instanceof Element) {
                if (node == element) {
                    return n;
                }
                ++n;
            }
            node = node.getNextSibling();
        }
        return -1;
    }
}

