/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.command;

import com.xmlmind.xmledit.command.Copy;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.doc.TextNode;
import com.xmlmind.xmledit.doc.Traversal;
import com.xmlmind.xmledit.edit.EditUtil;
import com.xmlmind.xmledit.edit.TextOffset;
import com.xmlmind.xmledit.search.ElementCharSequence;
import com.xmlmind.xmledit.view.DocumentView;

public class CopyChars
extends Copy {
    private TextOffset begin = new TextOffset();
    private TextOffset end = new TextOffset();
    private static final String EMPTY_TEXT_CONTENT = " ";
    private static String PARAGRAPH_MARK;

    public CopyChars() {
        if (PARAGRAPH_MARK == null && (PARAGRAPH_MARK = System.getProperty("line.separator")) == null) {
            PARAGRAPH_MARK = "\n";
        }
    }

    protected String copyElement(Element element, DocumentView documentView, String string) {
        ElementCharSequence elementCharSequence = new ElementCharSequence(element, EMPTY_TEXT_CONTENT, this.markParagraphs(string), PARAGRAPH_MARK);
        return elementCharSequence.toString();
    }

    protected String copyNodeRange(Element element, Node node, Node node2, DocumentView documentView, String string) {
        Node node3;
        switch (EditUtil.checkRange(element, node, node2)) {
            case 0: {
                return "";
            }
            case 2: {
                node3 = node;
                node = node2;
                node2 = node3;
            }
        }
        node3 = (TextNode)Traversal.traverse(node, Traversal.textNodeFinder);
        if (node3 == null) {
            return "";
        }
        this.begin.text = node3;
        this.begin.offset = 0;
        this.end.text = (TextNode)Traversal.traverseBackwards(node2, Traversal.textNodeFinder);
        this.end.offset = this.end.text.getTextLength();
        ElementCharSequence elementCharSequence = new ElementCharSequence(this.begin, this.end, EMPTY_TEXT_CONTENT, this.markParagraphs(string), PARAGRAPH_MARK);
        return elementCharSequence.toString();
    }

    protected String copyTextRange(TextNode textNode, int n, TextNode textNode2, int n2, DocumentView documentView, String string) {
        Object object;
        switch (EditUtil.checkRange(textNode, n, textNode2, n2)) {
            case 0: {
                return "";
            }
            case 2: {
                object = textNode;
                textNode = textNode2;
                textNode2 = object;
                int n3 = n;
                n = n2;
                n2 = n3;
            }
        }
        this.begin.text = textNode;
        this.begin.offset = n;
        this.end.text = textNode2;
        this.end.offset = n2;
        object = new ElementCharSequence(this.begin, this.end, EMPTY_TEXT_CONTENT, this.markParagraphs(string), PARAGRAPH_MARK);
        return ((ElementCharSequence)object).toString();
    }

    private int markParagraphs(String string) {
        if (string != null) {
            if (string.endsWith("[separateParagraphs]")) {
                return 2;
            }
            if (string.endsWith("[separateNodes]")) {
                return 1;
            }
        }
        return 0;
    }
}

