/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.command;

import com.xmlmind.xmledit.command.RecordableCommand;
import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.Tree;
import com.xmlmind.xmledit.form.ImageDataTypes;
import com.xmlmind.xmledit.form.ImageViewportVP;
import com.xmlmind.xmledit.gadget.Command;
import com.xmlmind.xmledit.gadget.Gadget;
import com.xmlmind.xmledit.guiutil.AWTUtil;
import com.xmlmind.xmledit.guiutil.Alert;
import com.xmlmind.xmledit.guiutil.ChooseFile;
import com.xmlmind.xmledit.guiutil.FilterByExtension;
import com.xmlmind.xmledit.guiutil.ShowLog;
import com.xmlmind.xmledit.guiutil.ShowStatus;
import com.xmlmind.xmledit.imagetoolkit.ImageToolkits;
import com.xmlmind.xmledit.imagetoolkit.XMLImageUtil;
import com.xmlmind.xmledit.util.Console;
import com.xmlmind.xmledit.util.FileUtil;
import com.xmlmind.xmledit.util.Log;
import com.xmlmind.xmledit.util.MiscUtil;
import com.xmlmind.xmledit.util.StringUtil;
import com.xmlmind.xmledit.util.URIUtil;
import com.xmlmind.xmledit.util.URLPathUtil;
import com.xmlmind.xmledit.util.URLUtil;
import com.xmlmind.xmledit.view.DocumentView;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xsd.datatype.Base16;
import com.xmlmind.xmledit.xsd.datatype.Base64;
import com.xmlmind.xmledit.xsd.datatype.InvalidDataException;
import com.xmlmind.xmleditapp.command.Msg;
import com.xmlmind.xmleditapp.upload.FileUpload;
import com.xmlmind.xmleditapp.upload.Upload;
import com.xmlmind.xmleditapp.upload.UploadInvoker;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.zip.GZIPInputStream;
import javax.swing.JFileChooser;

public class ExtractImage
extends RecordableCommand
implements ImageDataTypes {
    private static ExtractImage instance = null;
    private Element element;
    private Name attributeName;
    private int dataType;
    private String imageFileName;
    private static File lastSelectedFile;

    public static ExtractImage getInstance() {
        if (instance == null) {
            instance = new ExtractImage();
        }
        return instance;
    }

    /*
     * Unable to fully structure code
     */
    public boolean prepareCommand(Gadget var1_1, String var2_2, int var3_3, int var4_4) {
        block9: {
            this.attributeName = null;
            this.dataType = -1;
            this.imageFileName = null;
            var5_5 = (DocumentView)var1_1;
            this.element = var5_5.getSelectedElement(false);
            if (this.element == null || this.element.getLocation() == null) {
                return false;
            }
            if (var2_2 == null) break block9;
            var6_6 = StringUtil.splitArguments(var2_2);
            switch (var6_6.length) {
                case 3: {
                    this.imageFileName = var6_6[2];
                    if ("-".equals(this.imageFileName)) {
                        return false;
                    }
                }
                case 2: {
                    var7_7 = var6_6[1];
                    if ("-".equals(var7_7)) ** GOTO lbl31
                    if (!"base64Binary".equalsIgnoreCase(var7_7)) ** GOTO lbl21
                    this.dataType = 3;
                    ** GOTO lbl31
lbl21:
                    // 1 sources

                    if (!"hexBinary".equalsIgnoreCase(var7_7)) ** GOTO lbl24
                    this.dataType = 2;
                    ** GOTO lbl31
lbl24:
                    // 1 sources

                    if (!"XML".equalsIgnoreCase(var7_7)) ** GOTO lbl27
                    this.dataType = 4;
                    ** GOTO lbl31
lbl27:
                    // 1 sources

                    if ("anyURI".equalsIgnoreCase(var7_7)) {
                        this.dataType = 1;
                    } else {
                        return false;
                    }
                }
lbl31:
                // 6 sources

                case 1: {
                    var7_7 = var6_6[0];
                    if ("-".equals(var7_7)) break;
                    this.attributeName = Name.fromString(var7_7);
                    if (this.attributeName != null) break;
                    return false;
                }
                default: {
                    return false;
                }
            }
        }
        this.dataType = this.canExtractImage(this.element, this.attributeName, this.dataType);
        return this.dataType != 0;
    }

    protected Object doExecuteCommand(DocumentView documentView, String string, int n, int n2) {
        if (this.imageFileName == null) {
            this.imageFileName = ExtractImage.chooseSaveFileName(this.element, documentView);
            if (this.imageFileName == null) {
                return Command.EXECUTION_FAILED;
            }
        }
        ShowStatus.showStatus(Msg.msg(this.msgPrefix() + "extractingImage"));
        String[] stringArray = new String[]{this.imageFileName};
        String string2 = this.extractImage(this.element, this.attributeName, this.dataType, stringArray, null);
        if (string2 == null) {
            ShowStatus.showStatus(Msg.msg(this.msgPrefix() + "imageExtracted", stringArray[0]));
            return this.imageFileName;
        }
        Alert.showError(documentView.getPanel(), string2);
        ShowStatus.showStatus("");
        return Command.EXECUTION_FAILED;
    }

    protected String msgPrefix() {
        return "EI.";
    }

    private static String chooseSaveFileName(Element element, DocumentView documentView) {
        Serializable serializable;
        File file = null;
        if (lastSelectedFile == null) {
            serializable = FileUtil.urlToFile(element.getLocation());
            if (serializable != null) {
                file = ((File)serializable).getParentFile();
            }
        } else {
            file = lastSelectedFile.getParentFile();
        }
        serializable = new JFileChooser(file);
        ((JFileChooser)serializable).setFileSelectionMode(0);
        ((JFileChooser)serializable).setDialogTitle(ChooseFile.getChooserTitle(false, true));
        String[][] stringArrayArray = new String[][]{{"png"}, {"gif"}, {"jpg", "jpeg"}, {"bmp"}, {"tif", "tiff"}, {"svg", "svgz"}};
        int n = 0;
        while (n < stringArrayArray.length) {
            ((JFileChooser)serializable).addChoosableFileFilter(new FilterByExtension(stringArrayArray[n]));
            ++n;
        }
        ((JFileChooser)serializable).setAcceptAllFileFilterUsed(true);
        int n2 = ((JFileChooser)serializable).showSaveDialog(AWTUtil.getDialogAnchor(documentView.getPanel()));
        if (n2 == 0) {
            lastSelectedFile = ((JFileChooser)serializable).getSelectedFile();
            return lastSelectedFile.getPath();
        }
        return null;
    }

    public int canExtractImage(Element element, Name name, int n) {
        if (n < 1 || n > 4) {
            n = ImageViewportVP.checkImageDataType(n, element, name);
        }
        switch (n) {
            case 1: 
            case 2: 
            case 3: {
                return name == null || element.hasAttribute(name) ? n : 0;
            }
            case 4: {
                return name == null ? n : 0;
            }
        }
        return 0;
    }

    public String extractImage(Element element, Name name, int n, String[] stringArray, Console console) {
        String string;
        switch (n) {
            case 2: 
            case 3: {
                string = this.extractBinaryImage(element, name, n, stringArray, console);
                break;
            }
            case 4: {
                string = this.extractXMLImage(element, name, n, stringArray, console);
                break;
            }
            case 1: {
                string = this.copyImage(element, name, n, stringArray, console);
                break;
            }
            default: {
                string = "internal error: unknown dataType " + n;
            }
        }
        return string;
    }

    private String extractBinaryImage(Element element, Name name, int n, String[] stringArray, Console console) {
        Object object;
        byte[] byArray;
        String string = name == null ? element.getText() : element.getAttribute(name);
        if (string == null) {
            return Msg.msg(this.msgPrefix() + "noBinaryData");
        }
        try {
            byArray = n == 3 ? Base64.decode(string) : Base16.decode(string);
        }
        catch (InvalidDataException invalidDataException) {
            return Msg.msg(this.msgPrefix() + "cannotDecodeBinaryData", MiscUtil.reason(invalidDataException));
        }
        if (FileUtil.isGzipped(byArray)) {
            try {
                object = new GZIPInputStream(new ByteArrayInputStream(byArray));
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                FileUtil.copy((InputStream)object, byteArrayOutputStream);
                byArray = byteArrayOutputStream.toByteArray();
            }
            catch (IOException iOException) {
                return Msg.msg(this.msgPrefix() + "cannotUngzipDecodedData", MiscUtil.reason(iOException));
            }
        }
        if (stringArray[0].equals("%T")) {
            try {
                object = File.createTempFile(this.tempFileBaseName(element), this.imageSuffix(byArray));
            }
            catch (IOException iOException) {
                return Msg.msg("EIEO.cannotCreateTempFile", MiscUtil.reason(iOException));
            }
            ((File)object).deleteOnExit();
            stringArray[0] = ((File)object).getPath();
        } else if (stringArray[0].endsWith(".%X")) {
            stringArray[0] = stringArray[0].substring(0, stringArray[0].length() - 3) + this.imageSuffix(byArray);
        }
        try {
            FileUtil.saveBytes(byArray, stringArray[0]);
        }
        catch (IOException iOException) {
            return Msg.msg("EIEO.cannotSaveFile", stringArray[0], MiscUtil.reason(iOException));
        }
        return null;
    }

    public String tempFileBaseName(Element element) {
        URL uRL = element.getLocation();
        String string = URIUtil.unescape(URLPathUtil.trimExtension(URLUtil.getRawBaseName(uRL)));
        return string + this.tempFileBaseNameSuffix();
    }

    protected String tempFileBaseNameSuffix() {
        return "_image";
    }

    private String imageSuffix(byte[] byArray) {
        String[] stringArray = ImageToolkits.detectImageFormat(byArray);
        return stringArray == null ? this.defaultSuffix() : "." + stringArray[0];
    }

    protected String defaultSuffix() {
        return ".img";
    }

    private String extractXMLImage(Element element, Name name, int n, String[] stringArray, Console console) {
        Comparable<File> comparable;
        if (stringArray[0].equals("%T")) {
            try {
                comparable = File.createTempFile(this.tempFileBaseName(element), this.imageSuffix(element));
            }
            catch (IOException iOException) {
                return Msg.msg("EIEO.cannotCreateTempFile", MiscUtil.reason(iOException));
            }
            ((File)comparable).deleteOnExit();
            stringArray[0] = ((File)comparable).getPath();
        } else if (stringArray[0].endsWith(".%X")) {
            stringArray[0] = stringArray[0].substring(0, stringArray[0].length() - 3) + this.imageSuffix(element);
        }
        try {
            comparable = XMLImageUtil.createImageDocument(element);
        }
        catch (Exception exception) {
            return Msg.msg(this.msgPrefix() + "cannotCreateImageDocument", MiscUtil.reason(exception));
        }
        return this.saveXMLImage((Document)comparable, ((Tree)comparable).getLocation(), stringArray[0], console);
    }

    private String imageSuffix(Element element) {
        return element.getLocalName().endsWith("svg") ? ".svg" : ".xml";
    }

    private String saveXMLImage(Document document, URL uRL, String string, final Console console) {
        File file = new File(string);
        ArrayList arrayList = new ArrayList();
        XMLImageUtil.processImageDocument(document, uRL, FileUtil.fileToURL(file), arrayList);
        boolean bl = FileUtil.fileExtension(string).equalsIgnoreCase("svgz");
        try {
            XMLImageUtil.saveImageDocument(document, file, bl);
        }
        catch (IOException iOException) {
            return Msg.msg("EIEO.cannotSaveFile", string, MiscUtil.reason(iOException));
        }
        if (arrayList.size() > 0) {
            URL[] uRLArray = new URL[arrayList.size()];
            arrayList.toArray(uRLArray);
            FileUpload fileUpload = new FileUpload();
            fileUpload.setInvoker(new UploadInvoker(){

                public void beginUpload() {
                }

                public void endUpload() {
                }

                public boolean uploading(URL uRL, URL uRL2, int n, int n2) {
                    String string = Upload.uploadingMessage(uRL, uRL2, n, n2);
                    if (console == null) {
                        Log.log(ShowLog.LOG_STATUS, string);
                    } else {
                        console.showMessage(string, 0);
                    }
                    return true;
                }

                public boolean missingSource(URL uRL) {
                    String string = Upload.missingSourceMessage(uRL);
                    if (console == null) {
                        Log.log(ShowLog.LOG_STATUS, string);
                    } else {
                        console.showMessage(string, 2);
                    }
                    return true;
                }
            });
            String string2 = fileUpload.upload(uRLArray);
            if (string2 != null) {
                string2 = Msg.msg(this.msgPrefix() + "cannotCopyResources", string2);
                file.delete();
                return string2;
            }
        }
        return null;
    }

    private String copyImage(Element element, Name name, int n, String[] stringArray, Console console) {
        Comparable<File> comparable;
        String string = name == null ? element.getText() : element.getAttribute(name);
        URL uRL = null;
        if (string != null && (string = string.trim()).length() > 0 && !"???".equals(string)) {
            try {
                uRL = new URL(element.getLocation(), string);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (uRL == null) {
            return Msg.msg("EIEO.missingOrInvalidLocation", string);
        }
        if (stringArray[0].equals("%T")) {
            try {
                comparable = File.createTempFile(this.tempFileBaseName(element), this.imageSuffix(uRL));
            }
            catch (IOException iOException) {
                return Msg.msg("EIEO.cannotCreateTempFile", MiscUtil.reason(iOException));
            }
            ((File)comparable).deleteOnExit();
            stringArray[0] = ((File)comparable).getPath();
        } else if (stringArray[0].endsWith(".%X")) {
            stringArray[0] = stringArray[0].substring(0, stringArray[0].length() - 3) + this.imageSuffix(uRL);
        }
        if (XMLImageUtil.isXMLImage(uRL)) {
            try {
                comparable = XMLImageUtil.loadImageDocument(uRL);
            }
            catch (Exception exception) {
                return Msg.msg("EIEO.cannotLoadImageDocument", MiscUtil.reason(exception));
            }
            return this.saveXMLImage((Document)comparable, uRL, stringArray[0], console);
        }
        try {
            FileUtil.copyFile(uRL, new File(stringArray[0]));
            return null;
        }
        catch (IOException iOException) {
            return Msg.msg("EIEO.cannotSaveFile", stringArray[0], MiscUtil.reason(iOException));
        }
    }

    private String imageSuffix(URL uRL) {
        String string = URLUtil.getRawExtension(uRL);
        return string == null || string.length() == 0 ? this.defaultSuffix() : "." + URIUtil.unescape(string);
    }
}

