/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.command;

import com.xmlmind.xmledit.command.RecordableCommand;
import com.xmlmind.xmledit.dialog.LoadDocument;
import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.doc.Tree;
import com.xmlmind.xmledit.doctype.DocumentType;
import com.xmlmind.xmledit.doctype.DocumentTypeUtil;
import com.xmlmind.xmledit.doctype.UnconstrainedDocumentType;
import com.xmlmind.xmledit.edit.ClipboardFormat;
import com.xmlmind.xmledit.edit.Trimmer;
import com.xmlmind.xmledit.gadget.Command;
import com.xmlmind.xmledit.gadget.Gadget;
import com.xmlmind.xmledit.guiutil.AWTUtil;
import com.xmlmind.xmledit.guiutil.Alert;
import com.xmlmind.xmledit.guiutil.ShowStatus;
import com.xmlmind.xmledit.util.URLUtil;
import com.xmlmind.xmledit.view.DocumentView;
import com.xmlmind.xmledit.xmlutil.ElementXPointer;
import com.xmlmind.xmledit.xmlutil.PrefixEntry;
import com.xmlmind.xmleditapp.command.CopyAsInclusion;
import com.xmlmind.xmleditapp.command.InclusionChooserDialog;
import com.xmlmind.xmleditapp.command.Msg;
import com.xmlmind.xmleditapp.command.PasteInclusionEnabled;
import java.awt.Container;
import java.net.MalformedURLException;
import java.net.URL;

public class Include
extends RecordableCommand {
    private static final int INSERT_BEFORE = 0;
    private static final int INSERT_INTO = 1;
    private static final int INSERT_AFTER = 2;
    private static final int REPLACE = 3;
    private ClipboardFormat clipboardFormat = new ClipboardFormat();
    private PasteCmd pasteCmd = new PasteCmd();
    private InclusionChooserDialog chooserDialog = null;
    private int op;
    private boolean implicitElement;
    private boolean implicitNode;
    private int inclusionType;
    private ElementXPointer xpointer;
    private boolean isRelativeLocation;
    private URL includedDocURL;
    private URL includingDocURL;
    private Node[] nodes1 = new Node[1];

    public boolean prepareCommand(Gadget gadget, String string, int n, int n2) {
        int n3;
        this.nodes1[0] = null;
        DocumentView documentView = (DocumentView)gadget;
        Document document = documentView.getDocument();
        if (document == null) {
            return false;
        }
        if (string == null) {
            return false;
        }
        if (string.startsWith("before")) {
            this.op = 0;
            n3 = 6;
        } else if (string.startsWith("into")) {
            this.op = 1;
            n3 = 4;
        } else if (string.startsWith("after")) {
            this.op = 2;
            n3 = 5;
        } else if (string.startsWith("replace")) {
            this.op = 3;
            n3 = 7;
        } else {
            return false;
        }
        this.implicitElement = false;
        this.implicitNode = false;
        if (string.indexOf("[implicitElement]", n3) == n3) {
            this.implicitElement = true;
            n3 += 17;
        } else if (string.indexOf("[implicitNode]", n3) == n3) {
            this.implicitNode = true;
            n3 += 14;
        }
        this.inclusionType = -1;
        if (string.indexOf("[useEntity]", n3) == n3) {
            this.inclusionType = 0;
            n3 += 11;
        } else if (string.indexOf("[useXInclude]", n3) == n3) {
            this.inclusionType = 1;
            n3 += 13;
        } else if (string.indexOf("[chooseBest]", n3) == n3) {
            this.inclusionType = 2;
            n3 += 12;
        }
        String string2 = null;
        if (n3 < string.length() && (string2 = string.substring(n3).trim()).length() == 0) {
            string2 = null;
        }
        this.includingDocURL = document.getLocation();
        this.isRelativeLocation = false;
        this.xpointer = null;
        this.includedDocURL = null;
        if (string2 != null) {
            URL uRL = null;
            try {
                uRL = new URL(string2);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            if (uRL == null) {
                try {
                    uRL = new URL(this.includingDocURL, string2);
                    this.isRelativeLocation = true;
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            if (uRL == null) {
                return false;
            }
            String string3 = uRL.getRef();
            if (string3 != null) {
                this.xpointer = ElementXPointer.parse(string3);
                if (this.xpointer == null) {
                    return false;
                }
                this.includedDocURL = URLUtil.trimFragment(uRL);
            } else {
                this.xpointer = null;
                this.includedDocURL = uRL;
            }
        }
        return true;
    }

    protected Object doExecuteCommand(DocumentView documentView, String string, int n, int n2) {
        Object object;
        Object object2;
        Document document = documentView.getDocument();
        Container container = documentView.getPanel();
        String string2 = null;
        switch (this.op) {
            case 0: {
                string2 = Msg.msg("I.includeBefore");
                break;
            }
            case 1: {
                string2 = Msg.msg("I.includeInto");
                break;
            }
            case 2: {
                string2 = Msg.msg("I.includeAfter");
                break;
            }
            case 3: {
                string2 = Msg.msg("I.includeReplace");
            }
        }
        InclusionChooserDialog.Info info = null;
        if (this.includedDocURL == null) {
            object2 = AWTUtil.getDialogOwner(container);
            if (this.chooserDialog == null || this.chooserDialog.getOwner() != object2) {
                this.chooserDialog = new InclusionChooserDialog(container);
            }
            if ((info = this.chooserDialog.chooseInclusion(string2, this.includingDocURL)) == null) {
                return Command.EXECUTION_FAILED;
            }
            this.includedDocURL = info.includedDocURL;
            this.isRelativeLocation = info.isRelativeLocation;
            this.xpointer = info.xpointer;
        }
        ShowStatus.showStatus(Msg.msg("I.loadingDocument", URLUtil.toLabel(this.includedDocURL)));
        object2 = LoadDocument.loadDocument(this.includedDocURL, container);
        ShowStatus.showStatus("");
        if (object2 == null) {
            return Command.EXECUTION_FAILED;
        }
        Object object3 = UnconstrainedDocumentType.INSTANCE;
        DocumentType documentType = (DocumentType)((Document)object2).getProperty("DOCUMENT_TYPE");
        if (DocumentTypeUtil.isConstrainedDocumentType(documentType)) {
            object3 = documentType;
        } else {
            object = (DocumentType)document.getProperty("DOCUMENT_TYPE");
            if (DocumentTypeUtil.isConstrainedDocumentType((DocumentType)object)) {
                new Trimmer((DocumentType)object).trim((Document)object2);
                object3 = object;
            }
        }
        if (this.xpointer != null) {
            object = DocumentTypeUtil.findElement((Document)object2, this.xpointer, (DocumentType)object3);
            if (object == null) {
                Alert.showError(container, Msg.msg("I.xpointerNotFound", this.xpointer, URLUtil.toLabel(this.includedDocURL)));
                return Command.EXECUTION_FAILED;
            }
        } else {
            object = ((Document)object2).getRootElement();
            if (((Tree)object2).getChildCount() > 1) {
                this.xpointer = new ElementXPointer(null, new int[]{1});
            }
        }
        Element element = CopyAsInclusion.createAnnotatedElement((Element)object, this.includedDocURL.toExternalForm(), this.xpointer != null ? this.xpointer.toString() : null);
        PrefixEntry[] prefixEntryArray = ((Document)object2).getPreferredPrefixes(false);
        this.nodes1[0] = element;
        String string3 = this.clipboardFormat.formatNodes(this.nodes1, 1, prefixEntryArray);
        StringBuffer stringBuffer = new StringBuffer();
        switch (this.op) {
            case 0: {
                stringBuffer.append("before");
                break;
            }
            case 1: {
                stringBuffer.append("into");
                break;
            }
            case 2: {
                stringBuffer.append("after");
                break;
            }
            case 3: {
                stringBuffer.append("to");
            }
        }
        if (this.op != 1) {
            if (this.implicitElement) {
                stringBuffer.append("[implicitElement]");
            } else if (this.implicitNode) {
                stringBuffer.append("[implicitNode]");
            }
        }
        stringBuffer.append(' ');
        stringBuffer.append(string3);
        String string4 = stringBuffer.toString();
        if (!this.pasteCmd.prepareCommand(documentView, string4, n, n2)) {
            Alert.showError(container, Msg.msg("I.cannotInclude"));
            return Command.EXECUTION_FAILED;
        }
        Object object4 = this.pasteCmd.executeCommand(documentView, string4, n, n2);
        if (object4 != Command.EXECUTION_FAILED) {
            stringBuffer = new StringBuffer(string);
            if (info != null) {
                stringBuffer.append(' ');
                stringBuffer.append(info.includedDocLocation);
                if (info.xpointer != null) {
                    stringBuffer.append('#');
                    stringBuffer.append(info.xpointer.toString());
                }
            }
            documentView.addToCommandHistory(this, stringBuffer.toString(), string2);
            documentView.notifyContextChangeListeners();
        }
        return object4;
    }

    private final class PasteCmd
    extends PasteInclusionEnabled {
        private PasteCmd() {
        }

        protected int preferredInclusionType() {
            return Include.this.inclusionType < 0 ? PasteInclusionEnabled.getPreferredInclusionType() : Include.this.inclusionType;
        }

        protected boolean confirmInclusion(DocumentView documentView, Element element, URL uRL, ElementXPointer elementXPointer, URL uRL2) {
            this.useRelativeLocation = Include.this.isRelativeLocation;
            return true;
        }
    }
}

