/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.command;

import com.xmlmind.xmledit.dialog.LoadDocument;
import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doctype.DocumentType;
import com.xmlmind.xmledit.doctype.DocumentTypeUtil;
import com.xmlmind.xmledit.guiutil.Alert;
import com.xmlmind.xmledit.guiutil.ChooseURL;
import com.xmlmind.xmledit.guiutil.DialogBase;
import com.xmlmind.xmledit.guiutil.DialogUtil;
import com.xmlmind.xmledit.guiutil.HintLabel;
import com.xmlmind.xmledit.guiutil.ShowStatus;
import com.xmlmind.xmledit.guiutil.StringChooserDialog;
import com.xmlmind.xmledit.util.URLUtil;
import com.xmlmind.xmledit.xmlutil.ElementXPointer;
import com.xmlmind.xmleditapp.command.Msg;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;

public class InclusionChooserDialog
extends DialogBase {
    private JComboBox docURLCombo;
    private JTextField docURLField;
    private HintLabel helpLabel;
    private JRadioButton wholeDocumentToggle;
    private JRadioButton elementToggle;
    private ButtonGroup xpointerGroup;
    private JTextField xpointerField;
    private JButton listIDsButton;
    private ArrayList lastChosenURLs = new ArrayList();
    private boolean selectRelativeURL = true;
    private JPopupMenu browseOptionMenu = null;
    private ButtonGroup browseOptionGroup = null;
    private URL includingDocURL;
    private Info result;
    static /* synthetic */ Class class$com$xmlmind$xmleditapp$command$InclusionChooserDialog;

    public InclusionChooserDialog(Component component) {
        super(component, "", 27);
    }

    protected Component createForm() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        String string = Msg.msg("ICD.docURL");
        JLabel jLabel = new JLabel(DialogUtil.buttonLabel(string));
        DialogUtil.setDisplayedMnemonic(jLabel, string);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.left = 5;
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.docURLCombo = new JComboBox();
        this.docURLCombo.setEditable(true);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.top = 1;
        jPanel.add((Component)this.docURLCombo, gridBagConstraints);
        jLabel.setLabelFor(this.docURLCombo);
        this.docURLField = (JTextField)this.docURLCombo.getEditor().getEditorComponent();
        this.docURLField.setFont(this.getFont());
        this.docURLField.setColumns(40);
        ImageIcon imageIcon = new ImageIcon((class$com$xmlmind$xmleditapp$command$InclusionChooserDialog == null ? (class$com$xmlmind$xmleditapp$command$InclusionChooserDialog = InclusionChooserDialog.class$("com.xmlmind.xmleditapp.command.InclusionChooserDialog")) : class$com$xmlmind$xmleditapp$command$InclusionChooserDialog).getResource("browsecombo.gif"));
        String string2 = Msg.msg("ICD.browseToolTip");
        JButton jButton = new JButton(imageIcon);
        DialogUtil.setIconic(jButton);
        jButton.setToolTipText(string2);
        jButton.setActionCommand("browse");
        jButton.addActionListener(this);
        ++gridBagConstraints.gridx;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.left = 1;
        gridBagConstraints.insets.right = 5;
        jPanel.add((Component)jButton, gridBagConstraints);
        jButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                this.showMenu(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.showMenu(mouseEvent);
            }

            public void showMenu(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    JPopupMenu jPopupMenu = InclusionChooserDialog.this.getBrowseOptionMenu();
                    DialogUtil.showMenu(jPopupMenu, (JButton)mouseEvent.getSource());
                }
            }
        });
        this.helpLabel = new HintLabel(Msg.msg("ICD.isRelativeURL", ""));
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets.left = 5;
        jPanel.add((Component)this.helpLabel, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(new EtchedBorder());
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.bottom = 5;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.anchor = 17;
        string = Msg.msg("ICD.wholeDocument");
        this.wholeDocumentToggle = new JRadioButton(DialogUtil.buttonLabel(string));
        DialogUtil.setMnemonic(this.wholeDocumentToggle, string);
        this.wholeDocumentToggle.setActionCommand("toggleXPointer");
        this.wholeDocumentToggle.addActionListener(this);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridwidth = 3;
        gridBagConstraints2.insets.top = 5;
        gridBagConstraints2.insets.left = 5;
        gridBagConstraints2.insets.right = 5;
        jPanel2.add((Component)this.wholeDocumentToggle, gridBagConstraints2);
        string = Msg.msg("ICD.element");
        this.elementToggle = new JRadioButton(DialogUtil.buttonLabel(string));
        this.elementToggle.setActionCommand("toggleXPointer");
        this.elementToggle.addActionListener(this);
        DialogUtil.setMnemonic(this.elementToggle, string);
        ++gridBagConstraints2.gridy;
        jPanel2.add((Component)this.elementToggle, gridBagConstraints2);
        this.xpointerGroup = new ButtonGroup();
        this.xpointerGroup.add(this.wholeDocumentToggle);
        this.xpointerGroup.add(this.elementToggle);
        string = Msg.msg("ICD.xpointer");
        JLabel jLabel2 = new JLabel(DialogUtil.buttonLabel(string));
        DialogUtil.setDisplayedMnemonic(jLabel2, string);
        gridBagConstraints2.gridwidth = 1;
        ++gridBagConstraints2.gridy;
        gridBagConstraints2.insets.left = 40;
        gridBagConstraints2.insets.right = 0;
        gridBagConstraints2.insets.bottom = 5;
        jPanel2.add((Component)jLabel2, gridBagConstraints2);
        this.xpointerField = new JTextField(30);
        ++gridBagConstraints2.gridx;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.insets.left = 1;
        jPanel2.add((Component)this.xpointerField, gridBagConstraints2);
        jLabel2.setLabelFor(this.xpointerField);
        ImageIcon imageIcon2 = new ImageIcon((class$com$xmlmind$xmleditapp$command$InclusionChooserDialog == null ? (class$com$xmlmind$xmleditapp$command$InclusionChooserDialog = InclusionChooserDialog.class$("com.xmlmind.xmleditapp.command.InclusionChooserDialog")) : class$com$xmlmind$xmleditapp$command$InclusionChooserDialog).getResource("list.gif"));
        String string3 = Msg.msg("ICD.listToolTip");
        this.listIDsButton = new JButton(imageIcon2);
        DialogUtil.setIconic(this.listIDsButton);
        this.listIDsButton.setToolTipText(string3);
        this.listIDsButton.setActionCommand("listIDs");
        this.listIDsButton.addActionListener(this);
        ++gridBagConstraints2.gridx;
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.insets.right = 5;
        jPanel2.add((Component)this.listIDsButton, gridBagConstraints2);
        return jPanel;
    }

    public Info chooseInclusion(String string, URL uRL) {
        if (string != null) {
            this.setTitle(string);
        }
        this.includingDocURL = uRL;
        this.fillDocURLCombo();
        this.docURLCombo.setSelectedItem(null);
        this.helpLabel.setText(Msg.msg("ICD.isRelativeURL", URLUtil.toDisplayForm(URLUtil.getDirectory(uRL))));
        this.wholeDocumentToggle.setSelected(true);
        this.toggleXPointer();
        this.getRootPane().setDefaultButton(this.dialogButtons[0]);
        this.setLocationRelativeTo(this.dialogAnchor);
        this.pack();
        this.setVisible(true);
        return this.result;
    }

    private void fillDocURLCombo() {
        String[] stringArray;
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.lastChosenURLs);
        arrayList.remove(this.includingDocURL);
        URL[] uRLArray = new URL[arrayList.size()];
        arrayList.toArray(uRLArray);
        String[] stringArray2 = new String[uRLArray.length];
        int n = 0;
        URL uRL = URLUtil.getRoot(this.includingDocURL, true);
        int n2 = 0;
        while (n2 < uRLArray.length) {
            String string;
            stringArray = uRLArray[n2];
            URL uRL2 = URLUtil.getRoot((URL)stringArray, true);
            if (uRL2.equals(uRL) && (string = URLUtil.getRelativeRawPath((URL)stringArray, this.includingDocURL)) != null) {
                stringArray2[n++] = string;
            }
            ++n2;
        }
        if (stringArray2.length != n) {
            stringArray = new String[n];
            System.arraycopy(stringArray2, 0, stringArray, 0, n);
            stringArray2 = stringArray;
        }
        this.docURLCombo.setModel(new DefaultComboBoxModel<String>(stringArray2));
    }

    public void ok() {
        this.result = new Info();
        if (!this.getDocumentURL(this.result)) {
            this.result = null;
            return;
        }
        if (this.elementToggle.isSelected()) {
            String string = this.xpointerField.getText().trim();
            if (string.length() == 0) {
                DialogUtil.badField(this.xpointerField);
                this.result = null;
                return;
            }
            this.result.xpointer = ElementXPointer.parse(string);
            if (this.result.xpointer == null) {
                DialogUtil.badField(this.xpointerField);
                this.result = null;
                return;
            }
        }
        if (this.lastChosenURLs.size() == 10) {
            this.lastChosenURLs.remove(9);
        }
        this.lastChosenURLs.remove(this.result.includedDocURL);
        this.lastChosenURLs.add(0, this.result.includedDocURL);
        this.setVisible(false);
        this.dispose();
    }

    private boolean getDocumentURL(Info info) {
        info.includedDocLocation = this.docURLField.getText().trim();
        if (info.includedDocLocation.length() == 0) {
            DialogUtil.badField(this.docURLField);
            return false;
        }
        info.includingDocURL = this.includingDocURL;
        info.isRelativeLocation = false;
        try {
            info.includedDocURL = new URL(info.includedDocLocation);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (info.includedDocURL == null) {
            try {
                info.includedDocURL = new URL(info.includingDocURL, info.includedDocLocation);
                info.isRelativeLocation = true;
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (info.includedDocURL == null || info.includedDocURL.equals(info.includingDocURL)) {
            DialogUtil.badField(this.docURLField);
            return false;
        }
        return true;
    }

    public void cancel() {
        this.result = null;
        this.setVisible(false);
        this.dispose();
    }

    public void browse() {
        URL uRL;
        URL uRL2 = null;
        String string = this.docURLField.getText().trim();
        if (string.length() > 0) {
            try {
                uRL2 = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            if (uRL2 == null) {
                try {
                    uRL2 = new URL(this.includingDocURL, string);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        }
        if (uRL2 == null && this.lastChosenURLs.size() > 0) {
            uRL2 = (URL)this.lastChosenURLs.get(0);
        }
        if (uRL2 == null) {
            uRL2 = this.includingDocURL;
        }
        if ((uRL = ChooseURL.chooseOpenFileURL(this, uRL2)) != null) {
            String string2 = null;
            if (this.selectRelativeURL && URLUtil.getRoot(uRL, true).equals(URLUtil.getRoot(this.includingDocURL, true))) {
                string2 = URLUtil.getRelativeRawPath(uRL, this.includingDocURL);
            }
            if (string2 == null) {
                string2 = uRL.toExternalForm();
            }
            this.docURLField.setText(string2);
        }
    }

    private JPopupMenu getBrowseOptionMenu() {
        if (this.browseOptionMenu == null) {
            this.browseOptionMenu = new JPopupMenu();
            this.browseOptionGroup = new ButtonGroup();
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(Msg.msg("ICD.relativeURL"));
            jRadioButtonMenuItem.setSelected(this.selectRelativeURL);
            jRadioButtonMenuItem.addActionListener(this);
            jRadioButtonMenuItem.setActionCommand("selectRelativeURL");
            this.browseOptionMenu.add(jRadioButtonMenuItem);
            this.browseOptionGroup.add(jRadioButtonMenuItem);
            jRadioButtonMenuItem = new JRadioButtonMenuItem(Msg.msg("ICD.absoluteURL"));
            jRadioButtonMenuItem.setSelected(!this.selectRelativeURL);
            jRadioButtonMenuItem.addActionListener(this);
            jRadioButtonMenuItem.setActionCommand("selectAbsoluteURL");
            this.browseOptionMenu.add(jRadioButtonMenuItem);
            this.browseOptionGroup.add(jRadioButtonMenuItem);
        }
        return this.browseOptionMenu;
    }

    public void toggleXPointer() {
        boolean bl = this.elementToggle.isSelected();
        this.xpointerField.setText("");
        this.xpointerField.setEnabled(bl);
        this.listIDsButton.setEnabled(bl);
    }

    public void listIDs() {
        Info info = new Info();
        if (!this.getDocumentURL(info)) {
            return;
        }
        ShowStatus.showStatus(Msg.msg("I.loadingDocument", URLUtil.toLabel(info.includedDocURL)));
        Document document = LoadDocument.loadDocument(info.includedDocURL, this);
        ShowStatus.showStatus("");
        if (document == null) {
            return;
        }
        DocumentType documentType = (DocumentType)document.getProperty("DOCUMENT_TYPE");
        if (!DocumentTypeUtil.isConstrainedDocumentType(documentType)) {
            return;
        }
        String[] stringArray = DocumentTypeUtil.getIds(document, documentType);
        if (stringArray.length == 0) {
            Alert.showInfo(this, Msg.msg("ICD.documentHasNoIDs", URLUtil.toLabel(info.includedDocURL)));
            return;
        }
        String string = Msg.msg("ICD.listToolTip");
        if (string.endsWith("...")) {
            string = string.substring(0, string.length() - 3);
        }
        StringChooserDialog stringChooserDialog = new StringChooserDialog((Dialog)this, string, 20, 30);
        stringChooserDialog.setSingleClick(true);
        stringChooserDialog.setPressSpaceToAppend(true);
        String string2 = stringChooserDialog.chooseItem(stringArray, false, null);
        if (string2 != null) {
            this.xpointerField.setText(string2);
        }
    }

    public void selectAbsoluteURL() {
        this.selectRelativeURL = false;
    }

    public void selectRelativeURL() {
        this.selectRelativeURL = true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static final class Info {
        public String includedDocLocation;
        public boolean isRelativeLocation;
        public URL includingDocURL;
        public URL includedDocURL;
        public ElementXPointer xpointer;

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("[includedDocLocation=");
            stringBuffer.append(this.includedDocLocation);
            stringBuffer.append(",isRelativeLocation=");
            stringBuffer.append(this.isRelativeLocation);
            stringBuffer.append(",includingDocURL=");
            stringBuffer.append(this.includingDocURL);
            stringBuffer.append(",includedDocURL=");
            stringBuffer.append(this.includedDocURL);
            stringBuffer.append(",xpointer=");
            if (this.xpointer != null) {
                stringBuffer.append(this.xpointer);
            }
            stringBuffer.append(']');
            return stringBuffer.toString();
        }
    }
}

