/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.command;

import com.xmlmind.xmledit.command.RecordableCommand;
import com.xmlmind.xmledit.edit.ClipboardFormat;
import com.xmlmind.xmledit.gadget.Command;
import com.xmlmind.xmledit.gadget.Gadget;
import com.xmlmind.xmledit.guiutil.Clipboard;
import com.xmlmind.xmledit.guiutil.SystemSelection;
import com.xmlmind.xmledit.view.DocumentView;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xmlutil.XMLUtil;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.ArrayList;

public class MakeParagraphs
extends RecordableCommand {
    private Name elementName;
    private boolean systemSelection;
    private boolean blocks;
    private String pastable;

    public boolean prepareCommand(Gadget gadget, String string, int n, int n2) {
        this.elementName = null;
        this.pastable = null;
        DocumentView documentView = (DocumentView)gadget;
        if (documentView.getDocument() == null) {
            return false;
        }
        if (string == null || string.length() == 0) {
            return false;
        }
        String string2 = null;
        int n3 = string.lastIndexOf(93);
        if (n3 < 0) {
            string2 = string;
        } else if (n3 + 1 < string.length()) {
            string2 = string.substring(n3 + 1);
        }
        if (string2 != null) {
            this.elementName = Name.fromString(string2.trim());
        }
        if (this.elementName == null) {
            return false;
        }
        this.systemSelection = string.indexOf("[systemSelection]") >= 0;
        this.blocks = string.indexOf("[blocks]") >= 0;
        this.pastable = this.systemSelection ? SystemSelection.get(documentView.getPanel()) : Clipboard.get(documentView.getPanel());
        return this.pastable != null && this.pastable.length() != 0 && !this.pastable.startsWith("<?xml ");
    }

    protected Object doExecuteCommand(DocumentView documentView, String string, int n, int n2) {
        int n3;
        String string2;
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer = new StringBuffer();
        LineNumberReader lineNumberReader = new LineNumberReader(new StringReader(this.pastable));
        while ((string2 = MakeParagraphs.readLine(lineNumberReader)) != null) {
            if ((string2 = XMLUtil.collapseWhiteSpace(string2)).length() == 0) {
                if (!this.blocks || stringBuffer.length() <= 0) continue;
                arrayList.add(stringBuffer.toString());
                stringBuffer = new StringBuffer();
                continue;
            }
            string2 = XMLUtil.filterText(string2);
            if (this.blocks) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(' ');
                }
                stringBuffer.append(string2);
                continue;
            }
            arrayList.add(string2);
        }
        if (this.blocks && stringBuffer.length() > 0) {
            arrayList.add(stringBuffer.toString());
        }
        if ((n3 = arrayList.size()) == 0) {
            return Command.EXECUTION_FAILED;
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append("<?xml version='1.0'?>");
        MakeParagraphs.openTag(ClipboardFormat.ENVELOPE_NAME, stringBuffer2);
        int n4 = 0;
        while (n4 < n3) {
            String string3 = (String)arrayList.get(n4);
            MakeParagraphs.openTag(this.elementName, stringBuffer2);
            XMLUtil.escapeXML(string3, stringBuffer2);
            MakeParagraphs.closeTag(this.elementName, stringBuffer2);
            ++n4;
        }
        MakeParagraphs.closeTag(ClipboardFormat.ENVELOPE_NAME, stringBuffer2);
        return stringBuffer2.toString();
    }

    private static final String readLine(LineNumberReader lineNumberReader) {
        try {
            return lineNumberReader.readLine();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    private static final void openTag(Name name, StringBuffer stringBuffer) {
        stringBuffer.append('<');
        stringBuffer.append(name.getLocalPart());
        stringBuffer.append(" xmlns='");
        stringBuffer.append(name.getNamespace().getURI());
        stringBuffer.append("'>");
    }

    private static final void closeTag(Name name, StringBuffer stringBuffer) {
        stringBuffer.append("</");
        stringBuffer.append(name.getLocalPart());
        stringBuffer.append('>');
    }
}

