/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.command;

import com.xmlmind.xmledit.command.Paste;
import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.InclusionInfo;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.doc.TextNode;
import com.xmlmind.xmledit.doc.Traversal;
import com.xmlmind.xmledit.doctype.DocumentTypeUtil;
import com.xmlmind.xmledit.edit.ElementEditor;
import com.xmlmind.xmledit.edit.TextEditor;
import com.xmlmind.xmledit.edit.TextLocation;
import com.xmlmind.xmledit.edit.XIncluderUtil;
import com.xmlmind.xmledit.gadget.Command;
import com.xmlmind.xmledit.guiutil.AWTUtil;
import com.xmlmind.xmledit.guiutil.Alert;
import com.xmlmind.xmledit.util.URIUtil;
import com.xmlmind.xmledit.util.URLPathUtil;
import com.xmlmind.xmledit.util.URLUtil;
import com.xmlmind.xmledit.view.DocumentView;
import com.xmlmind.xmledit.xmlutil.ElementXPointer;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xmlutil.Namespace;
import com.xmlmind.xmledit.xmlutil.PreferredPrefix;
import com.xmlmind.xmledit.xmlutil.XMLUtil;
import com.xmlmind.xmleditapp.command.CopyAsInclusion;
import com.xmlmind.xmleditapp.command.Msg;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;

public class PasteInclusionEnabled
extends Paste {
    public static final int USE_ENTITY = 0;
    public static final int USE_XINCLUDE = 1;
    public static final int CHOOSE_BEST = 2;
    private static int preferredInclusionType = 2;
    private static boolean warnAboutHierarchicalXPointer = true;
    private Element includedElement;
    protected boolean useRelativeLocation;
    private Node[] nodes1 = new Node[1];
    private AddLocationInfo addLocationInfo = new AddLocationInfo();

    public static void setPreferredInclusionType(int n) {
        preferredInclusionType = n;
    }

    public static int getPreferredInclusionType() {
        return preferredInclusionType;
    }

    public static void setWarnAboutHierarchicalXPointer(boolean bl) {
        warnAboutHierarchicalXPointer = bl;
    }

    public static boolean getWarnAboutHierarchicalXPointer() {
        return warnAboutHierarchicalXPointer;
    }

    protected Object doExecuteCommand(DocumentView documentView, String string, int n, int n2) {
        ElementEditor elementEditor = documentView.getElementEditor();
        Node[] nodeArray = elementEditor.getPastableNodes(this.pastable);
        this.includedElement = PasteInclusionEnabled.toIncludedElement(nodeArray);
        if (this.includedElement != null) {
            this.includedElement = (Element)this.includedElement.copy();
            if (!this.processIncludedElement(documentView)) {
                return Command.EXECUTION_FAILED;
            }
        }
        Object object = super.doExecuteCommand(documentView, string, n, n2);
        this.includedElement = null;
        return object;
    }

    private static final Element toIncludedElement(Node[] nodeArray) {
        if (nodeArray == null || nodeArray.length != 1 || !(nodeArray[0] instanceof Element)) {
            return null;
        }
        Element element = (Element)nodeArray[0];
        if (element.hasAttribute(CopyAsInclusion.SOURCE_DOCUMENT_ATTRIBUTE)) {
            return element;
        }
        return null;
    }

    protected Node[] doPaste(TextEditor textEditor, TextLocation textLocation, TextLocation textLocation2, String string) {
        if (this.includedElement == null) {
            return super.doPaste(textEditor, textLocation, textLocation2, string);
        }
        this.nodes1[0] = this.includedElement;
        return textEditor.paste(textLocation, textLocation2, this.nodes1);
    }

    protected Node[] doPaste(ElementEditor elementEditor, Node node, Node node2, String string) {
        if (this.includedElement == null) {
            return super.doPaste(elementEditor, node, node2, string);
        }
        this.nodes1[0] = this.includedElement;
        return elementEditor.paste(node, node2, this.nodes1);
    }

    protected Node[] doPaste(ElementEditor elementEditor, TextNode textNode, int n, String string) {
        if (this.includedElement == null) {
            return super.doPaste(elementEditor, textNode, n, string);
        }
        this.nodes1[0] = this.includedElement;
        return elementEditor.paste(textNode, n, this.nodes1);
    }

    protected Node[] doPaste(ElementEditor elementEditor, Node node, String string) {
        if (this.includedElement == null) {
            return super.doPaste(elementEditor, node, string);
        }
        this.nodes1[0] = this.includedElement;
        return elementEditor.paste(node, this.nodes1);
    }

    private boolean processIncludedElement(DocumentView documentView) {
        Object object;
        String string;
        String string2;
        URL uRL;
        String string3 = this.includedElement.removeAttribute(CopyAsInclusion.SOURCE_DOCUMENT_ATTRIBUTE);
        if (string3 == null) {
            PasteInclusionEnabled.showError(documentView, "Internal error: missing sourceDocument attribute.");
            return false;
        }
        try {
            uRL = new URL(string3);
        }
        catch (MalformedURLException malformedURLException) {
            PasteInclusionEnabled.showError(documentView, "Internal error: sourceDocument attribute not an URL '" + string3 + "'.");
            return false;
        }
        ElementXPointer elementXPointer = null;
        string3 = this.includedElement.removeAttribute(CopyAsInclusion.SOURCE_ELEMENT_ATTRIBUTE);
        if (string3 == null) {
            elementXPointer = null;
        } else {
            elementXPointer = ElementXPointer.parse(string3);
            if (elementXPointer == null) {
                PasteInclusionEnabled.showError(documentView, "Internal error: sourceElement attribute not a valid element-scheme XPointer '" + string3 + "'.");
                return false;
            }
        }
        URL uRL2 = null;
        string3 = this.includedElement.removeAttribute(CopyAsInclusion.LOCATION_ATTRIBUTE);
        if (string3 == null) {
            PasteInclusionEnabled.showError(documentView, "Internal error: missing location attribute.");
            return false;
        }
        try {
            uRL2 = new URL(string3);
        }
        catch (MalformedURLException malformedURLException) {
            PasteInclusionEnabled.showError(documentView, "Internal error: location attribute not an URL '" + string3 + "'.");
            return false;
        }
        Document document = documentView.getDocument();
        URL uRL3 = document.getLocation();
        if (uRL.equals(uRL3)) {
            PasteInclusionEnabled.showError(documentView, Msg.msg("PIE.cannotReferenceSameDoc"));
            return false;
        }
        int n = this.preferredInclusionType();
        if (n == 0) {
            string2 = null;
            if (document.getDocumentTypeDeclaration() == null) {
                string2 = Msg.msg("PIE.entityRequiresDTD", URLUtil.toLabel(uRL3));
            }
            if (string2 == null && elementXPointer != null) {
                string2 = Msg.msg("PIE.xpointerRequiresXInclude", elementXPointer);
            }
            if (string2 != null) {
                string2 = string2 + "\n\n" + Msg.msg("PIE.selectXInclude");
                PasteInclusionEnabled.showError(documentView, string2);
                return false;
            }
        }
        if (!this.confirmInclusion(documentView, this.includedElement, uRL, elementXPointer, uRL3)) {
            return false;
        }
        string2 = this.useRelativeLocation ? XIncluderUtil.relativeLocation(uRL, uRL3) : uRL.toExternalForm();
        if (elementXPointer != null) {
            n = 1;
            string = XIncluderUtil.relativeLocation(uRL2, uRL);
            object = XIncluderUtil.relativeLocation(string, string2, uRL3);
            this.includedElement.putLocationInfo((String)object, true);
        } else {
            string = null;
            if (n == 2) {
                n = document.getDocumentTypeDeclaration() != null ? 0 : 1;
            }
            this.includedElement.putLocationInfo(string2, n == 1);
        }
        if (n == 0) {
            object = new InclusionInfo(PasteInclusionEnabled.toEntityName(uRL), (String)null, string2, false);
        } else {
            Element element;
            String string4;
            String string5 = string2;
            String string6 = string4 = elementXPointer != null ? elementXPointer.toString() : null;
            if (DocumentTypeUtil.isNamespaceAware(document)) {
                element = new Element(Name.XI_INCLUDE);
                PreferredPrefix preferredPrefix = (PreferredPrefix)document.getProperty("NAMESPACE_PREFIX_MAP");
                if (preferredPrefix != null) {
                    preferredPrefix.add(Namespace.XI, "xi");
                }
            } else {
                element = new Element(Name.get("xi:include"));
                element.putAttribute(Name.get("xmlns:xi"), Namespace.XI.getURI());
            }
            element.putAttribute(Name.get("href"), string5);
            if (string4 != null) {
                element.putAttribute(Name.get("xpointer"), string4);
            }
            object = new InclusionInfo(string5, string4, element, string);
        }
        this.includedElement.putProperty("INCLUSION_INFO", object);
        Traversal.traverse(this.includedElement, this.addLocationInfo);
        this.includedElement.setReadOnly(true);
        return true;
    }

    private static final void showError(DocumentView documentView, String string) {
        Alert.showError(documentView.getPanel(), string);
    }

    protected boolean confirmInclusion(DocumentView documentView, Element element, URL uRL, ElementXPointer elementXPointer, URL uRL2) {
        Object[] objectArray;
        String string;
        boolean bl = elementXPointer == null || elementXPointer.isRootElement();
        String string2 = null;
        if (bl) {
            string = Msg.msg("PIE.confirmIncludeDocument");
        } else {
            string2 = element.getName().format(false, element);
            string = Msg.msg("PIE.confirmIncludeElement", string2);
        }
        String string3 = null;
        if (URLUtil.getRoot(uRL, true).equals(URLUtil.getRoot(uRL2, true))) {
            string3 = URLUtil.getRelativeRawPath(uRL, uRL2);
        }
        String string4 = URLUtil.toShortDisplayForm(uRL, 40);
        String string5 = elementXPointer != null ? "(" + Msg.msg("PIE.xpointedElement", elementXPointer) + ")" : "\u00a0";
        JRadioButton jRadioButton = null;
        JRadioButton jRadioButton2 = null;
        ButtonGroup buttonGroup = null;
        if (string3 != null) {
            jRadioButton = new JRadioButton(Msg.msg("PIE.usingAbsolutePath"));
            jRadioButton2 = new JRadioButton(Msg.msg("PIE.usingRelativePath"));
            buttonGroup = new ButtonGroup();
            buttonGroup.add(jRadioButton);
            buttonGroup.add(jRadioButton2);
            jRadioButton2.setSelected(true);
            objectArray = new Object[]{string, "\u00a0", jRadioButton, "\"" + string4 + "\"", "\u00a0", jRadioButton2, "\"" + string3 + "\"", "\u00a0", string5, "\u00a0"};
        } else {
            objectArray = new Object[]{string, "\"" + string4 + "\"", "\u00a0", string5, "\u00a0"};
        }
        int n = JOptionPane.showConfirmDialog(AWTUtil.getDialogAnchor(documentView.getPanel()), objectArray, Msg.msg("confirm"), 2);
        if (n != 0) {
            return false;
        }
        this.useRelativeLocation = string3 != null ? jRadioButton2.isSelected() : false;
        if (bl) {
            return true;
        }
        if (warnAboutHierarchicalXPointer && elementXPointer.getDescendant().length != 0) {
            JCheckBox jCheckBox = new JCheckBox(Msg.msg("doNotShowThisDialogAgain"));
            objectArray = new Object[]{Msg.msg("PIE.warnAboutHierarchicalXPointer", elementXPointer.toString(), URLUtil.toShortLabel(uRL2, 40), URLUtil.toShortLabel(uRL, 40), string2), "\u00a0", jCheckBox};
            n = JOptionPane.showConfirmDialog(AWTUtil.getDialogAnchor(documentView.getPanel()), objectArray, Msg.msg("confirm"), 0);
            boolean bl2 = warnAboutHierarchicalXPointer = !jCheckBox.isSelected();
            if (n != 0) {
                return false;
            }
        }
        return true;
    }

    protected int preferredInclusionType() {
        return PasteInclusionEnabled.getPreferredInclusionType();
    }

    private static final String toEntityName(URL uRL) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = URLPathUtil.trimExtension(URLUtil.getRawBaseName(uRL));
        string = URIUtil.unescape(string);
        stringBuffer.append("__");
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (XMLUtil.isNCNameStartChar(c) || c == ':' || XMLUtil.isNCNameOtherChar(c)) {
                stringBuffer.append(c);
            }
            ++n2;
        }
        stringBuffer.append("__");
        stringBuffer.append(Long.toString(System.currentTimeMillis(), 36));
        return stringBuffer.toString();
    }

    private static final class AddLocationInfo
    extends Traversal.HandlerBase {
        private AddLocationInfo() {
        }

        public Object enterElement(Element element) {
            String string = element.removeAttribute(CopyAsInclusion.LOCATION_ATTRIBUTE);
            if (string != null) {
                boolean bl;
                String string2;
                if (string.endsWith(";XMLBaseAware")) {
                    string2 = string.substring(0, string.length() - ";XMLBaseAware".length());
                    bl = true;
                } else {
                    string2 = string;
                    bl = false;
                }
                element.putLocationInfo(string2, bl);
            }
            return null;
        }
    }
}

