/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.command;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.SimpleDoc;
import javax.print.attribute.PrintRequestAttributeSet;

public final class Printer
implements Comparable {
    private DocFlavor flavor;
    private PrintService service;
    private PrintRequestAttributeSet attributes;
    private long lastAccessed;

    public Printer(DocFlavor docFlavor, PrintService printService, PrintRequestAttributeSet printRequestAttributeSet) {
        this.flavor = docFlavor;
        this.service = printService;
        this.attributes = printRequestAttributeSet;
        this.lastAccessed = System.currentTimeMillis();
    }

    public String getFormat() {
        return this.flavor.getMimeType();
    }

    public String getName() {
        return this.service.getName();
    }

    public DocFlavor getFlavor() {
        return this.flavor;
    }

    public PrintService getService() {
        return this.service;
    }

    public PrintRequestAttributeSet getAttributes() {
        return this.attributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(File file) throws IOException, PrintException {
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            this.print(fileInputStream);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            ((InputStream)fileInputStream).close();
            throw throwable;
        }
        ((InputStream)fileInputStream).close();
    }

    public void print(InputStream inputStream) throws PrintException {
        SimpleDoc simpleDoc = new SimpleDoc(inputStream, this.flavor, null);
        DocPrintJob docPrintJob = this.service.createPrintJob();
        docPrintJob.print(simpleDoc, this.attributes);
    }

    public int hashCode() {
        return this.getFormat().hashCode() ^ this.getName().hashCode();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Printer)) {
            return false;
        }
        Printer printer = (Printer)object;
        return this.getFormat().equals(printer.getFormat()) && this.getName().equals(printer.getName());
    }

    public int compareTo(Object object) {
        String string;
        Printer printer = (Printer)object;
        String string2 = this.getFormat();
        if (string2.equals(string = printer.getFormat())) {
            String string3;
            String string4 = this.getName();
            if (string4.equals(string3 = printer.getName())) {
                return 0;
            }
            return (int)(printer.lastAccessed - this.lastAccessed);
        }
        return string2.compareTo(string);
    }
}

