/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.command;

import com.xmlmind.xmledit.guiutil.AWTUtil;
import com.xmlmind.xmledit.guiutil.Alert;
import com.xmlmind.xmledit.util.LinearHashtable;
import com.xmlmind.xmleditapp.command.Msg;
import com.xmlmind.xmleditapp.command.Printer;
import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Arrays;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.ServiceUI;
import javax.print.attribute.HashPrintRequestAttributeSet;

public final class Printers {
    public static final String POSTSCRIPT = "application/postscript";
    public static final String PDF = "application/pdf";
    public static final String PCL = "application/vnd.hp-PCL";
    private static LinearHashtable formatToPrinters = new LinearHashtable();
    private static final int UI_WIDTH = 500;
    private static final int UI_HEIGHT = 400;

    public static Printer[] getPrinters(String string) {
        string = Printers.toCanonicalFormat(string);
        LinearHashtable linearHashtable = Printers.doGetPrinters(string);
        Object[] objectArray = new Printer[linearHashtable.size()];
        linearHashtable.copyElementsInto(objectArray);
        if (objectArray.length > 1) {
            Arrays.sort(objectArray);
        }
        return objectArray;
    }

    public static String toCanonicalFormat(String string) {
        if ("ps".equalsIgnoreCase(string)) {
            return POSTSCRIPT;
        }
        if ("pdf".equalsIgnoreCase(string)) {
            return PDF;
        }
        if ("pcl".equalsIgnoreCase(string)) {
            return PCL;
        }
        return string;
    }

    private static LinearHashtable doGetPrinters(String string) {
        LinearHashtable linearHashtable = (LinearHashtable)formatToPrinters.get(string);
        if (linearHashtable == null) {
            linearHashtable = new LinearHashtable();
            formatToPrinters.put(string, linearHashtable);
            DocFlavor docFlavor = new DocFlavor(string, "java.io.InputStream");
            PrintService[] printServiceArray = PrintServiceLookup.lookupPrintServices(docFlavor, null);
            int n = printServiceArray.length - 1;
            while (n >= 0) {
                PrintService printService = printServiceArray[n];
                linearHashtable.put(printService.getName(), new Printer(docFlavor, printService, new HashPrintRequestAttributeSet()));
                --n;
            }
        }
        return linearHashtable;
    }

    public static Printer getPrinter(String string, String string2) {
        string = Printers.toCanonicalFormat(string);
        LinearHashtable linearHashtable = Printers.doGetPrinters(string);
        return (Printer)linearHashtable.get(string2);
    }

    public static void putPrinter(Printer printer) {
        LinearHashtable linearHashtable = Printers.doGetPrinters(printer.getFormat());
        linearHashtable.put(printer.getName(), printer);
    }

    public static Printer choosePrinter(Component component, String string, String string2) {
        int n;
        Object object;
        Printer[] printerArray = Printers.getPrinters(string = Printers.toCanonicalFormat(string));
        if (printerArray.length == 0) {
            Alert.showInfo(component, Msg.msg("P.formatNotSupported", string));
            return null;
        }
        Object object2 = null;
        PrintService[] printServiceArray = new PrintService[printerArray.length];
        int n2 = 0;
        while (n2 < printerArray.length) {
            object = printerArray[n2];
            printServiceArray[n2] = ((Printer)object).getService();
            if (((Printer)object).getName().equals(string2)) {
                object2 = object;
            }
            ++n2;
        }
        if (object2 == null) {
            object2 = printerArray[0];
        }
        component = AWTUtil.getDialogAnchor(component);
        object = component.getGraphicsConfiguration();
        Rectangle rectangle = ((GraphicsConfiguration)object).getBounds();
        Point point = component.getLocationOnScreen();
        int n3 = component.getWidth();
        int n4 = component.getHeight();
        int n5 = point.x + (n3 - 500) / 2;
        if (n5 + 500 > rectangle.width) {
            n5 = rectangle.width - 500;
        }
        if (n5 < 0) {
            n5 = 0;
        }
        if ((n = point.y + (n4 - 400) / 2) + 400 > rectangle.height) {
            n = rectangle.height - 400;
        }
        if (n < 0) {
            n = 0;
        }
        DocFlavor docFlavor = ((Printer)object2).getFlavor();
        HashPrintRequestAttributeSet hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet(((Printer)object2).getAttributes());
        PrintService printService = ServiceUI.printDialog((GraphicsConfiguration)object, n5, n, printServiceArray, ((Printer)object2).getService(), docFlavor, hashPrintRequestAttributeSet);
        if (printService == null) {
            return null;
        }
        Printer printer = new Printer(docFlavor, printService, hashPrintRequestAttributeSet);
        Printers.putPrinter(printer);
        return printer;
    }
}

