/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.command;

import com.xmlmind.xmledit.command.RecordableCommand;
import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.gadget.Command;
import com.xmlmind.xmledit.gadget.Gadget;
import com.xmlmind.xmledit.gadget.GadgetContainer;
import com.xmlmind.xmledit.guiutil.Alert;
import com.xmlmind.xmledit.imagetoolkit.ImageToolkit;
import com.xmlmind.xmledit.imagetoolkit.ImageToolkits;
import com.xmlmind.xmledit.imagetoolkit.VectorImage;
import com.xmlmind.xmledit.imagetoolkit.VectorImageToolkit;
import com.xmlmind.xmledit.styledgadget.AbstractImageViewport;
import com.xmlmind.xmledit.styledgadget.Box;
import com.xmlmind.xmledit.util.MiscUtil;
import com.xmlmind.xmledit.view.DocumentView;
import com.xmlmind.xmledit.view.GadgetList;
import com.xmlmind.xmledit.view.NodeView;
import com.xmlmind.xmledit.view.NodeViewPart;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmleditapp.command.Msg;
import com.xmlmind.xmleditapp.command.ResizeSVGDialog;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.geom.RectangularShape;

public class ResizeSVG
extends RecordableCommand
implements GadgetList {
    private Element svgElement;
    private NodeView svgView;
    private AbstractImageViewport imageViewport;
    private ResizeSVGDialog.Info infoTemplate;
    private static final Name VIEW_BOX_ATTR = Name.get("viewBox");
    private static final Name WIDTH_ATTR = Name.get("width");
    private static final Name HEIGHT_ATTR = Name.get("height");
    private static final Name PRESERVE_ASPECT_RATIO_ATTR = Name.get("preserveAspectRatio");

    public boolean prepareCommand(Gadget gadget, String string, int n, int n2) {
        this.svgView = null;
        this.imageViewport = null;
        DocumentView documentView = (DocumentView)gadget;
        this.svgElement = documentView.getSelectedElement(true);
        while (this.svgElement != null) {
            if (this.svgElement.getLocalName().endsWith("svg")) break;
            this.svgElement = this.svgElement.getParentElement();
        }
        if (this.svgElement == null) {
            return false;
        }
        return this.svgElement.isEditable();
    }

    protected Object doExecuteCommand(DocumentView documentView, String string, int n, int n2) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Container container = documentView.getPanel();
        if (this.infoTemplate == null) {
            this.infoTemplate = new ResizeSVGDialog.Info();
            this.infoTemplate.resolution = 96.0;
            this.infoTemplate.fontMetrics = documentView.getFontMetrics(new Font("SansSerif", 0, 12));
            this.infoTemplate.defaultWidth = 400;
            this.infoTemplate.defaultHeight = 400;
            object4 = ImageToolkits.getAll();
            int n3 = 0;
            while (n3 < ((ImageToolkit[])object4).length) {
                object3 = object4[n3];
                object2 = object3.getImageRenderer(this.svgElement);
                if (object2 != null && object3 instanceof VectorImageToolkit) {
                    object = (VectorImageToolkit)object3;
                    this.infoTemplate.resolution = object.getDefaultResolution();
                    this.infoTemplate.fontMetrics = documentView.getFontMetrics(new Font(object.getDefaultFontFamily(), 0, object.getDefaultFontSize()));
                    this.infoTemplate.defaultWidth = object.getDefaultImageWidth();
                    this.infoTemplate.defaultHeight = object.getDefaultImageHeight();
                    break;
                }
                ++n3;
            }
        }
        object4 = this.infoTemplate.copy();
        RectangularShape rectangularShape = null;
        object3 = null;
        this.svgView = documentView.getNodeView(this.svgElement);
        if (this.svgView != null) {
            this.imageViewport = null;
            int n4 = documentView.getDocument().documentListenerIndex(documentView);
            this.svgView.getGadgets(this, n4);
            this.svgView = null;
            if (this.imageViewport != null) {
                object = this.imageViewport.getImage();
                if (object != null && !this.imageViewport.isShowingFallbackImage() && object instanceof VectorImage) {
                    rectangularShape = ((VectorImage)object).getBoundingBox();
                }
                object3 = new Dimension();
                Box.getContentSizeConstraints(this.imageViewport, this.imageViewport.getStyle(), (Dimension)object3);
                this.imageViewport = null;
            }
        }
        if (rectangularShape != null) {
            ((ResizeSVGDialog.Info)object4).actualViewBoxX = Math.floor(rectangularShape.getX());
            ((ResizeSVGDialog.Info)object4).actualViewBoxY = Math.floor(rectangularShape.getY());
            ((ResizeSVGDialog.Info)object4).actualViewBoxWidth = Math.ceil(rectangularShape.getWidth());
            ((ResizeSVGDialog.Info)object4).actualViewBoxHeight = Math.ceil(rectangularShape.getHeight());
        }
        if (object3 != null) {
            if (((Dimension)object3).width <= 1 || ((Dimension)object3).height <= 1) {
                object2 = documentView.getVisibleRectangle();
                if (((Dimension)object3).width <= 1) {
                    ((Dimension)object3).width = ((Rectangle)object2).width * 90 / 100;
                    if (((Dimension)object3).width < 10) {
                        ((Dimension)object3).width = 10;
                    }
                }
                if (((Dimension)object3).height <= 1) {
                    ((Dimension)object3).height = ((Rectangle)object2).height * 90 / 100;
                    if (((Dimension)object3).height < 10) {
                        ((Dimension)object3).height = 10;
                    }
                }
            }
            ((ResizeSVGDialog.Info)object4).availableWidth = ((Dimension)object3).width;
            ((ResizeSVGDialog.Info)object4).availableHeight = ((Dimension)object3).height;
        }
        if (((object2 = this.svgElement.getAttribute(VIEW_BOX_ATTR)) == null || !((ResizeSVGDialog.Info)object4).setViewBoxAttribute((String)object2)) && ((ResizeSVGDialog.Info)object4).actualViewBoxWidth > 0.0 && ((ResizeSVGDialog.Info)object4).actualViewBoxHeight > 0.0) {
            ((ResizeSVGDialog.Info)object4).viewBoxX = ((ResizeSVGDialog.Info)object4).actualViewBoxX;
            ((ResizeSVGDialog.Info)object4).viewBoxY = ((ResizeSVGDialog.Info)object4).actualViewBoxY;
            ((ResizeSVGDialog.Info)object4).viewBoxWidth = ((ResizeSVGDialog.Info)object4).actualViewBoxWidth;
            ((ResizeSVGDialog.Info)object4).viewBoxHeight = ((ResizeSVGDialog.Info)object4).actualViewBoxHeight;
        }
        if (((ResizeSVGDialog.Info)object4).viewBoxWidth <= 0.0 || ((ResizeSVGDialog.Info)object4).viewBoxHeight <= 0.0) {
            Alert.showError(container, Msg.msg("RS.noViewBox"));
            return Command.EXECUTION_FAILED;
        }
        object = this.svgElement.getAttribute(WIDTH_ATTR);
        String string2 = this.svgElement.getAttribute(HEIGHT_ATTR);
        String string3 = this.svgElement.getAttribute(PRESERVE_ASPECT_RATIO_ATTR);
        ((ResizeSVGDialog.Info)object4).setWidthAttribute((String)object);
        ((ResizeSVGDialog.Info)object4).setHeightAttribute(string2);
        ((ResizeSVGDialog.Info)object4).setPreserveAspectRatioAttribute(string3);
        ResizeSVGDialog resizeSVGDialog = new ResizeSVGDialog(container);
        object4 = resizeSVGDialog.getInfo((ResizeSVGDialog.Info)object4);
        if (object4 == null) {
            return Command.EXECUTION_FAILED;
        }
        String string4 = ((ResizeSVGDialog.Info)object4).getWidthAttribute();
        String string5 = ((ResizeSVGDialog.Info)object4).getHeightAttribute();
        String string6 = ((ResizeSVGDialog.Info)object4).getViewBoxAttribute();
        String string7 = ((ResizeSVGDialog.Info)object4).getPreserveAspectRatioAttribute();
        if (MiscUtil.eq(string4, object) && MiscUtil.eq(string5, string2) && MiscUtil.eq(string6, object2) && MiscUtil.eq(string7, string3)) {
            return null;
        }
        Document document = documentView.getDocument();
        document.beginBatchEditing();
        this.svgElement.putAttribute(WIDTH_ATTR, string4);
        this.svgElement.putAttribute(HEIGHT_ATTR, string5);
        this.svgElement.putAttribute(VIEW_BOX_ATTR, string6);
        this.svgElement.putAttribute(PRESERVE_ASPECT_RATIO_ATTR, string7);
        document.endBatchEditing();
        documentView.describeUndo(Msg.msg("RS.resizeSVG"));
        documentView.selectNode(this.svgElement);
        return null;
    }

    public void appendGadget(Gadget gadget) {
        if (this.imageViewport == null) {
            AbstractImageViewport abstractImageViewport;
            if (gadget instanceof AbstractImageViewport) {
                this.imageViewport = (AbstractImageViewport)gadget;
            } else if (gadget instanceof GadgetContainer && (abstractImageViewport = this.findImageViewport((GadgetContainer)gadget)) != null) {
                this.imageViewport = abstractImageViewport;
            }
        }
    }

    private AbstractImageViewport findImageViewport(GadgetContainer gadgetContainer) {
        Gadget[] gadgetArray = gadgetContainer.getChildren();
        int n = 0;
        while (n < gadgetArray.length) {
            Gadget gadget = gadgetArray[n];
            if (gadget instanceof NodeViewPart && ((NodeViewPart)((Object)gadget)).getView() == this.svgView) {
                AbstractImageViewport abstractImageViewport;
                if (gadget instanceof AbstractImageViewport) {
                    return (AbstractImageViewport)gadget;
                }
                if (gadget instanceof GadgetContainer && (abstractImageViewport = this.findImageViewport((GadgetContainer)gadget)) != null) {
                    return abstractImageViewport;
                }
            }
            ++n;
        }
        return null;
    }

    public void appendGadgets(Gadget[] gadgetArray, int n, int n2) {
        int n3 = n + n2;
        int n4 = n;
        while (n4 < n3) {
            this.appendGadget(gadgetArray[n4]);
            ++n4;
        }
    }
}

