/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.command;

import com.xmlmind.xmledit.guiutil.DialogBase;
import com.xmlmind.xmledit.guiutil.DialogUtil;
import com.xmlmind.xmledit.guiutil.HintLabel;
import com.xmlmind.xmledit.guiutil.LabeledValue;
import com.xmlmind.xmledit.styledgadget.Icon;
import com.xmlmind.xmledit.xmlutil.XMLUtil;
import com.xmlmind.xmleditapp.command.Msg;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Stroke;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class ResizeSVGDialog
extends DialogBase {
    public static final int UNIT_PX = 0;
    public static final int UNIT_IN = 1;
    public static final int UNIT_CM = 2;
    public static final int UNIT_MM = 3;
    public static final int UNIT_PT = 4;
    public static final int UNIT_PC = 5;
    public static final int UNIT_EM = 6;
    public static final int UNIT_EX = 7;
    private static final String[] UNIT_NAMES = new String[]{"px", "in", "cm", "mm", "pt", "pc", "em", "ex"};
    public static final int ASPECT_RATIO_MEET = 0;
    public static final int ASPECT_RATIO_SLICE = 1;
    public static final int ASPECT_RATIO_NONE = 2;
    public static final int HALIGN_CENTER = 0;
    public static final int HALIGN_LEFT = 1;
    public static final int HALIGN_RIGHT = 2;
    public static final int VALIGN_MIDDLE = 0;
    public static final int VALIGN_BOTTOM = 1;
    public static final int VALIGN_TOP = 2;
    private PreviewCanvas previewCanvas;
    private JTextField widthField;
    private JComboBox widthUnitCombo;
    private JTextField heightField;
    private JComboBox heightUnitCombo;
    private ButtonGroup aspectRatioGroup;
    private JRadioButton aspectRatioMeetToggle;
    private JRadioButton aspectRatioSliceToggle;
    private JRadioButton aspectRatioNoneToggle;
    private JComboBox hAlignCombo;
    private JComboBox vAlignCombo;
    private static LabeledValue[] unitItems;
    private static LabeledValue[] hAlignItems;
    private static LabeledValue[] vAlignItems;
    private JButton fitInWindowButton;
    private Info previewInfo = null;
    private Info result = null;
    private static final int PREVIEW_CANVAS_MARGIN = 5;

    public ResizeSVGDialog(Dialog dialog) {
        super(dialog, Msg.msg("RS.resizeSVG"), true);
        this.initialize(dialog, 24);
    }

    public ResizeSVGDialog(Component component) {
        super(component, Msg.msg("RS.resizeSVG"), true);
        this.initialize(component, 24);
    }

    protected Component createForm() {
        Object object;
        Object object2;
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.insets.right = 5;
        gridBagConstraints.insets.bottom = 5;
        gridBagConstraints.anchor = 17;
        this.previewCanvas = new PreviewCanvas();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 3;
        jPanel.add((Component)this.previewCanvas, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(new TitledBorder(new EtchedBorder(), Msg.msg("RSD.viewportSize")));
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.setBorder(new TitledBorder(new EtchedBorder(), Msg.msg("RSD.fitInViewport")));
        ++gridBagConstraints.gridy;
        jPanel.add((Component)jPanel3, gridBagConstraints);
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        jPanel4.setBorder(new TitledBorder(new EtchedBorder(), Msg.msg("RSD.alignInViewport")));
        ++gridBagConstraints.gridy;
        jPanel.add((Component)jPanel4, gridBagConstraints);
        if (unitItems == null) {
            unitItems = new LabeledValue[UNIT_NAMES.length];
            int n = 0;
            while (n < UNIT_NAMES.length) {
                ResizeSVGDialog.unitItems[n] = new LabeledValue(UNIT_NAMES[n], n);
                ++n;
            }
            object2 = new String[]{"center", "left", "right"};
            hAlignItems = new LabeledValue[((String[])object2).length];
            int n2 = 0;
            while (n2 < ((String[])object2).length) {
                ResizeSVGDialog.hAlignItems[n2] = new LabeledValue(Msg.msg("RSD." + object2[n2]), n2);
                ++n2;
            }
            object = new String[]{"middle", "bottom", "top"};
            vAlignItems = new LabeledValue[((String[])object).length];
            int n3 = 0;
            while (n3 < ((String[])object).length) {
                ResizeSVGDialog.vAlignItems[n3] = new LabeledValue(Msg.msg("RSD." + object[n3]), n3);
                ++n3;
            }
        }
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        String string = Msg.msg("RSD.width");
        object2 = new ImageIcon(Icon.get(42, HintLabel.getHintForeground()));
        JLabel jLabel = new JLabel(DialogUtil.buttonLabel(string), (javax.swing.Icon)object2, 10);
        jLabel.setHorizontalTextPosition(10);
        jLabel.setIconTextGap(1);
        DialogUtil.setDisplayedMnemonic(jLabel, string);
        jPanel2.add((Component)jLabel, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.widthField = new JTextField(10);
        this.widthField.setActionCommand("preview");
        this.widthField.addActionListener(this);
        jPanel2.add((Component)this.widthField, gridBagConstraints);
        ++gridBagConstraints.gridx;
        jLabel.setLabelFor(this.widthField);
        this.widthUnitCombo = new JComboBox<LabeledValue>(unitItems);
        this.widthUnitCombo.setEditable(false);
        this.widthUnitCombo.setActionCommand("preview");
        this.widthUnitCombo.addActionListener(this);
        gridBagConstraints.insets.right = 5;
        jPanel2.add((Component)this.widthUnitCombo, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        string = Msg.msg("RSD.height");
        jLabel = new JLabel(DialogUtil.buttonLabel(string), (javax.swing.Icon)object2, 10);
        jLabel.setHorizontalTextPosition(10);
        jLabel.setIconTextGap(1);
        DialogUtil.setDisplayedMnemonic(jLabel, string);
        gridBagConstraints.insets.right = 0;
        jPanel2.add((Component)jLabel, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.heightField = new JTextField(10);
        this.heightField.setActionCommand("preview");
        this.heightField.addActionListener(this);
        jPanel2.add((Component)this.heightField, gridBagConstraints);
        ++gridBagConstraints.gridx;
        jLabel.setLabelFor(this.heightField);
        this.heightUnitCombo = new JComboBox<LabeledValue>(unitItems);
        this.heightUnitCombo.setEditable(false);
        this.heightUnitCombo.setActionCommand("preview");
        this.heightUnitCombo.addActionListener(this);
        gridBagConstraints.insets.right = 5;
        jPanel2.add((Component)this.heightUnitCombo, gridBagConstraints);
        string = Msg.msg("RSD.fitInWindow");
        this.fitInWindowButton = new JButton(DialogUtil.buttonLabel(string));
        DialogUtil.setMnemonic(this.fitInWindowButton, string);
        this.fitInWindowButton.addActionListener(this);
        this.fitInWindowButton.setActionCommand("fitInWindow");
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets.top = 15;
        jPanel2.add((Component)this.fitInWindowButton, gridBagConstraints);
        object = new HintLabel(Msg.msg("RSD.fitInWindowHelp"), 0);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets.top = 1;
        gridBagConstraints.insets.bottom = 5;
        jPanel2.add((Component)object, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.insets.right = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        string = Msg.msg("RSD.aspectRatioMeet");
        this.aspectRatioMeetToggle = new JRadioButton(DialogUtil.buttonLabel(string));
        DialogUtil.setMnemonic(this.aspectRatioMeetToggle, string);
        this.aspectRatioMeetToggle.setActionCommand("preview");
        this.aspectRatioMeetToggle.addActionListener(this);
        jPanel3.add((Component)this.aspectRatioMeetToggle, gridBagConstraints);
        ++gridBagConstraints.gridy;
        string = Msg.msg("RSD.aspectRatioNone");
        this.aspectRatioNoneToggle = new JRadioButton(DialogUtil.buttonLabel(string));
        DialogUtil.setMnemonic(this.aspectRatioNoneToggle, string);
        this.aspectRatioNoneToggle.setActionCommand("preview");
        this.aspectRatioNoneToggle.addActionListener(this);
        jPanel3.add((Component)this.aspectRatioNoneToggle, gridBagConstraints);
        ++gridBagConstraints.gridy;
        string = Msg.msg("RSD.aspectRatioSlice");
        this.aspectRatioSliceToggle = new JRadioButton(DialogUtil.buttonLabel(string));
        DialogUtil.setMnemonic(this.aspectRatioSliceToggle, string);
        this.aspectRatioSliceToggle.setActionCommand("preview");
        this.aspectRatioSliceToggle.addActionListener(this);
        gridBagConstraints.insets.bottom = 5;
        jPanel3.add((Component)this.aspectRatioSliceToggle, gridBagConstraints);
        this.aspectRatioGroup = new ButtonGroup();
        this.aspectRatioGroup.add(this.aspectRatioMeetToggle);
        this.aspectRatioGroup.add(this.aspectRatioNoneToggle);
        this.aspectRatioGroup.add(this.aspectRatioSliceToggle);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        string = Msg.msg("RSD.horizontal");
        jLabel = new JLabel(DialogUtil.buttonLabel(string));
        DialogUtil.setDisplayedMnemonic(jLabel, string);
        jPanel4.add((Component)jLabel, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.hAlignCombo = new JComboBox<LabeledValue>(hAlignItems);
        this.hAlignCombo.setEditable(false);
        this.hAlignCombo.setActionCommand("preview");
        this.hAlignCombo.addActionListener(this);
        gridBagConstraints.insets.right = 5;
        jPanel4.add((Component)this.hAlignCombo, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        jLabel.setLabelFor(this.hAlignCombo);
        string = Msg.msg("RSD.vertical");
        jLabel = new JLabel(DialogUtil.buttonLabel(string));
        DialogUtil.setDisplayedMnemonic(jLabel, string);
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.insets.bottom = 5;
        jPanel4.add((Component)jLabel, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.vAlignCombo = new JComboBox<LabeledValue>(vAlignItems);
        this.vAlignCombo.setEditable(false);
        this.vAlignCombo.setActionCommand("preview");
        this.vAlignCombo.addActionListener(this);
        gridBagConstraints.insets.right = 5;
        jPanel4.add((Component)this.vAlignCombo, gridBagConstraints);
        jLabel.setLabelFor(this.vAlignCombo);
        return jPanel;
    }

    public Info getInfo(Info info) {
        info = info.copy();
        this.applyInfo(info);
        this.pack();
        this.setLocationRelativeTo(this.dialogAnchor);
        this.widthField.requestFocus();
        this.setVisible(true);
        return this.result;
    }

    private void applyInfo(Info info) {
        if (info.resolution <= 0.0 || info.fontMetrics == null || info.defaultWidth <= 0 || info.defaultHeight <= 0 || info.viewBoxWidth <= 0.0 || info.viewBoxHeight <= 0.0 || info.widthUnit < 0 || info.widthUnit > 7 || info.heightUnit < 0 || info.heightUnit > 7 || info.aspectRatio < 0 || info.aspectRatio > 2 || info.hAlign < 0 || info.hAlign > 2 || info.vAlign < 0 || info.vAlign > 2) {
            throw new IllegalArgumentException("invalid Info: '" + info + "'");
        }
        if (info.width <= 0.0) {
            info.width = info.defaultWidth;
        }
        if (info.height <= 0.0) {
            info.height = info.defaultHeight;
        }
        this.previewInfo = null;
        this.widthField.setText(Double.toString(info.width));
        this.widthField.selectAll();
        this.widthUnitCombo.setSelectedIndex(info.widthUnit);
        this.heightField.setText(Double.toString(info.height));
        this.heightField.selectAll();
        this.heightUnitCombo.setSelectedIndex(info.heightUnit);
        switch (info.aspectRatio) {
            case 1: {
                this.aspectRatioSliceToggle.setSelected(true);
                break;
            }
            case 2: {
                this.aspectRatioNoneToggle.setSelected(true);
                break;
            }
            default: {
                this.aspectRatioMeetToggle.setSelected(true);
            }
        }
        this.hAlignCombo.setSelectedIndex(info.hAlign);
        this.vAlignCombo.setSelectedIndex(info.vAlign);
        this.fitInWindowButton.setEnabled(info.availableWidth > 0 && info.availableHeight > 0);
        this.previewInfo = info;
        this.previewCanvas.repaint();
    }

    public boolean preview() {
        if (this.previewInfo == null) {
            return false;
        }
        ViewportDimension viewportDimension = ResizeSVGDialog.parseDimension(this.widthField);
        if (viewportDimension == null) {
            DialogUtil.badField(this.widthField);
            return false;
        }
        ViewportDimension viewportDimension2 = ResizeSVGDialog.parseDimension(this.heightField);
        if (viewportDimension2 == null) {
            DialogUtil.badField(this.heightField);
            return false;
        }
        Info info = this.previewInfo.copy();
        this.previewInfo = null;
        info.width = viewportDimension.length;
        if (viewportDimension.unit >= 0) {
            this.widthUnitCombo.setSelectedIndex(viewportDimension.unit);
            this.widthField.setText(Double.toString(viewportDimension.length));
        }
        info.widthUnit = this.widthUnitCombo.getSelectedIndex();
        info.height = viewportDimension2.length;
        if (viewportDimension2.unit >= 0) {
            this.heightUnitCombo.setSelectedIndex(viewportDimension2.unit);
            this.heightField.setText(Double.toString(viewportDimension2.length));
        }
        info.heightUnit = this.heightUnitCombo.getSelectedIndex();
        info.aspectRatio = this.aspectRatioSliceToggle.isSelected() ? 1 : (this.aspectRatioNoneToggle.isSelected() ? 2 : 0);
        info.hAlign = this.hAlignCombo.getSelectedIndex();
        info.vAlign = this.vAlignCombo.getSelectedIndex();
        this.previewInfo = info;
        this.previewCanvas.repaint();
        return true;
    }

    private static final ViewportDimension parseDimension(JTextField jTextField) {
        ViewportDimension viewportDimension = new ViewportDimension();
        viewportDimension.length = -1.0;
        viewportDimension.unit = -1;
        String string = jTextField.getText().trim();
        int n = 0;
        while (n < UNIT_NAMES.length) {
            String string2 = UNIT_NAMES[n];
            if (string.endsWith(string2)) {
                viewportDimension.unit = n;
                string = string.substring(0, string.length() - string2.length());
                string = string.trim();
                break;
            }
            ++n;
        }
        try {
            viewportDimension.length = Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            viewportDimension.length = -1.0;
        }
        if (viewportDimension.length <= 0.0) {
            return null;
        }
        return viewportDimension;
    }

    public void fitInWindow() {
        Info info = this.previewInfo.copy();
        if (info.actualViewBoxWidth > 0.0 && info.actualViewBoxHeight > 0.0) {
            info.viewBoxX = info.actualViewBoxX;
            info.viewBoxY = info.actualViewBoxY;
            info.viewBoxWidth = info.actualViewBoxWidth;
            info.viewBoxHeight = info.actualViewBoxHeight;
        }
        double d = (double)info.availableWidth / info.viewBoxWidth;
        double d2 = (double)info.availableHeight / info.viewBoxHeight;
        double d3 = Math.min(d, d2);
        info.width = Math.ceil(info.viewBoxWidth * d3);
        info.height = Math.ceil(info.viewBoxHeight * d3);
        info.widthUnit = 0;
        info.heightUnit = 0;
        info.aspectRatio = 0;
        info.hAlign = 0;
        info.vAlign = 0;
        this.applyInfo(info);
    }

    public void ok() {
        if (!this.preview()) {
            return;
        }
        this.result = this.previewInfo;
        this.setVisible(false);
        this.dispose();
    }

    public void cancel() {
        this.result = null;
        this.setVisible(false);
        this.dispose();
    }

    public static final int lengthUnit(String string) {
        int n = 0;
        while (n < UNIT_NAMES.length) {
            if (string.endsWith(UNIT_NAMES[n])) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public static final double lengthToPixels(String string, Info info) throws NumberFormatException {
        int n = ResizeSVGDialog.lengthUnit(string);
        if (n >= 0) {
            string = string.substring(0, string.length() - 2);
        }
        double d = Double.parseDouble(string);
        return ResizeSVGDialog.lengthToPixels(d, n, info.resolution, info.fontMetrics);
    }

    public static final double lengthToPixels(double d, int n, Info info) {
        return ResizeSVGDialog.lengthToPixels(d, n, info.resolution, info.fontMetrics);
    }

    public static final double lengthToPixels(double d, int n, double d2, FontMetrics fontMetrics) {
        double d3;
        switch (n) {
            case 1: {
                d3 = d * d2;
                break;
            }
            case 2: {
                d3 = d / 2.54 * d2;
                break;
            }
            case 3: {
                d3 = d / 25.4 * d2;
                break;
            }
            case 4: {
                d3 = d / 72.0 * d2;
                break;
            }
            case 5: {
                d3 = d / 6.0 * d2;
                break;
            }
            case 6: {
                d3 = d * (double)fontMetrics.getHeight();
                break;
            }
            case 7: {
                d3 = d * (double)fontMetrics.getAscent() / 2.0;
                break;
            }
            default: {
                d3 = d;
            }
        }
        return d3;
    }

    public final class PreviewCanvas
    extends JPanel {
        private Stroke normalStroke;
        private Stroke dashStroke;

        public PreviewCanvas() {
            this.setFont(new Font("SansSerif", 0, 10));
            this.setBorder(new BevelBorder(1));
            this.normalStroke = new BasicStroke();
            this.dashStroke = new BasicStroke(1.0f, 2, 0, 10.0f, new float[]{2.0f, 3.0f}, 0.0f);
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public Dimension getPreferredSize() {
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            int n = Math.max(fontMetrics.stringWidth(Msg.msg("RSD.graphics")), fontMetrics.stringWidth(Msg.msg("RSD.viewport")));
            n = Math.max(n, fontMetrics.getHeight());
            n += 10;
            n = Math.max(n, 250);
            Insets insets = this.getInsets();
            return new Dimension(n + insets.left + insets.right, n + insets.top + insets.bottom);
        }

        protected void paintComponent(Graphics graphics) {
            double d;
            double d2;
            double d3;
            double d4;
            double d5;
            double d6;
            double d7;
            super.paintComponent(graphics);
            double d8 = ResizeSVGDialog.lengthToPixels(((ResizeSVGDialog)ResizeSVGDialog.this).previewInfo.width, ((ResizeSVGDialog)ResizeSVGDialog.this).previewInfo.widthUnit, ResizeSVGDialog.this.previewInfo);
            double d9 = ResizeSVGDialog.lengthToPixels(((ResizeSVGDialog)ResizeSVGDialog.this).previewInfo.height, ((ResizeSVGDialog)ResizeSVGDialog.this).previewInfo.heightUnit, ResizeSVGDialog.this.previewInfo);
            if (((ResizeSVGDialog)ResizeSVGDialog.this).previewInfo.aspectRatio == 2) {
                d7 = 0.0;
                d6 = 0.0;
                d5 = d8;
                d4 = d9;
            } else {
                d3 = d8 / ((ResizeSVGDialog)ResizeSVGDialog.this).previewInfo.viewBoxWidth;
                d2 = d9 / ((ResizeSVGDialog)ResizeSVGDialog.this).previewInfo.viewBoxHeight;
                d = ((ResizeSVGDialog)ResizeSVGDialog.this).previewInfo.aspectRatio == 1 ? Math.max(d3, d2) : Math.min(d3, d2);
                d5 = ((ResizeSVGDialog)ResizeSVGDialog.this).previewInfo.viewBoxWidth * d;
                d4 = ((ResizeSVGDialog)ResizeSVGDialog.this).previewInfo.viewBoxHeight * d;
                switch (((ResizeSVGDialog)ResizeSVGDialog.this).previewInfo.hAlign) {
                    case 1: {
                        d6 = 0.0;
                        break;
                    }
                    case 2: {
                        d6 = d8 - d5;
                        break;
                    }
                    default: {
                        d6 = (d8 - d5) / 2.0;
                    }
                }
                switch (((ResizeSVGDialog)ResizeSVGDialog.this).previewInfo.vAlign) {
                    case 2: {
                        d7 = 0.0;
                        break;
                    }
                    case 1: {
                        d7 = d9 - d4;
                        break;
                    }
                    default: {
                        d7 = (d9 - d4) / 2.0;
                    }
                }
            }
            Font font = this.getFont();
            FontMetrics fontMetrics = graphics.getFontMetrics(font);
            Dimension dimension = this.getSize();
            Insets insets = this.getInsets();
            int n = insets.left + 5;
            int n2 = insets.top + fontMetrics.getHeight() + 5;
            int n3 = dimension.width - insets.right - 5 - n;
            int n4 = dimension.height - insets.bottom - 5 - n2;
            d3 = (double)n3 / d8;
            d2 = (double)n4 / d9;
            d = Math.min(d3, d2);
            d3 = (double)n3 / d5;
            d2 = (double)n4 / d4;
            d = Math.min(d, Math.min(d3, d2));
            int n5 = (int)Math.rint(d8 * d);
            int n6 = (int)Math.rint(d9 * d);
            int n7 = (int)Math.rint(d6 * d);
            int n8 = (int)Math.rint(d7 * d);
            int n9 = (int)Math.rint(d5 * d);
            int n10 = (int)Math.rint(d4 * d);
            String string = Msg.msg("RSD.viewport");
            String string2 = Msg.msg("RSD.graphics");
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            graphics2D.translate(n + (n3 - n5) / 2, n2 + (n4 - n6) / 2);
            graphics2D.setFont(font);
            graphics2D.setColor(Color.blue);
            this.paintImage(graphics2D, string2, true, n7, n8, n9, n10);
            graphics2D.setColor(Color.white);
            graphics2D.fillRect(0, 0, n5, n6);
            graphics2D.setColor(Color.black);
            graphics2D.drawRect(-1, -1, n5 + 2 - 1, n6 + 2 - 1);
            graphics2D.drawString(string, 0, -1 - fontMetrics.getDescent() - 1);
            graphics2D.clipRect(0, 0, n5, n6);
            graphics2D.setColor(Color.blue);
            this.paintImage(graphics2D, string2, false, n7, n8, n9, n10);
            graphics2D.dispose();
        }

        private void paintImage(Graphics2D graphics2D, String string, boolean bl, int n, int n2, int n3, int n4) {
            if (bl) {
                graphics2D.setStroke(this.dashStroke);
            }
            graphics2D.drawRect(n, n2, n3 - 1, n4 - 1);
            graphics2D.drawLine(n, n2, n + n3 - 1, n2 + n4 - 1);
            graphics2D.drawLine(n + n3 - 1, n2, n, n2 + n4 - 1);
            if (bl) {
                graphics2D.setStroke(this.normalStroke);
            }
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            int n5 = n + 1;
            int n6 = n2 + 1 + fontMetrics.getAscent();
            graphics2D.drawString(string, n5, n6);
        }
    }

    private static final class ViewportDimension {
        double length;
        int unit;

        private ViewportDimension() {
        }
    }

    public static final class Info
    implements Cloneable {
        public double resolution;
        public FontMetrics fontMetrics;
        public int defaultWidth;
        public int defaultHeight;
        public int availableWidth;
        public int availableHeight;
        public double actualViewBoxX;
        public double actualViewBoxY;
        public double actualViewBoxWidth;
        public double actualViewBoxHeight;
        public double viewBoxX;
        public double viewBoxY;
        public double viewBoxWidth;
        public double viewBoxHeight;
        public double width;
        public int widthUnit;
        public double height;
        public int heightUnit;
        public int aspectRatio;
        public int hAlign;
        public int vAlign;

        public boolean setWidthAttribute(String string) {
            if (string == null) {
                return false;
            }
            int n = ResizeSVGDialog.lengthUnit(string = string.trim());
            if (n < 0) {
                n = 0;
            } else {
                string = string.substring(0, string.length() - 2);
            }
            double d = -1.0;
            try {
                d = Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            if (d <= 0.0) {
                return false;
            }
            this.width = d;
            this.widthUnit = n;
            return true;
        }

        public boolean setHeightAttribute(String string) {
            if (string == null) {
                return false;
            }
            int n = ResizeSVGDialog.lengthUnit(string = string.trim());
            if (n < 0) {
                n = 0;
            } else {
                string = string.substring(0, string.length() - 2);
            }
            double d = -1.0;
            try {
                d = Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            if (d <= 0.0) {
                return false;
            }
            this.height = d;
            this.heightUnit = n;
            return true;
        }

        public boolean setViewBoxAttribute(String string) {
            if (string == null) {
                return false;
            }
            String[] stringArray = XMLUtil.splitList(string);
            if (stringArray.length != 4) {
                return false;
            }
            double d = -1.0;
            double d2 = -1.0;
            double d3 = -1.0;
            double d4 = -1.0;
            try {
                d = ResizeSVGDialog.lengthToPixels(stringArray[0], this);
                d2 = ResizeSVGDialog.lengthToPixels(stringArray[1], this);
                d3 = ResizeSVGDialog.lengthToPixels(stringArray[2], this);
                d4 = ResizeSVGDialog.lengthToPixels(stringArray[3], this);
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            if (d3 <= 0.0 || d4 <= 0.0) {
                return false;
            }
            this.viewBoxX = d;
            this.viewBoxY = d2;
            this.viewBoxWidth = d3;
            this.viewBoxHeight = d4;
            return true;
        }

        public boolean setPreserveAspectRatioAttribute(String string) {
            if (string == null) {
                return false;
            }
            String string2 = null;
            String string3 = null;
            String[] stringArray = XMLUtil.splitList(string);
            switch (stringArray.length) {
                case 3: {
                    string2 = stringArray[1];
                    string3 = stringArray[2];
                    break;
                }
                case 2: {
                    if ("defer".equals(stringArray[0])) {
                        string2 = stringArray[1];
                        break;
                    }
                    string2 = stringArray[0];
                    string3 = stringArray[1];
                    break;
                }
                case 1: {
                    string2 = stringArray[0];
                    break;
                }
                default: {
                    return false;
                }
            }
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            if ("none".equals(string2)) {
                n = 2;
            } else {
                if ("xMinYMin".equals(string2)) {
                    n2 = 1;
                    n3 = 2;
                } else if ("xMidYMin".equals(string2)) {
                    n2 = 0;
                    n3 = 2;
                } else if ("xMaxYMin".equals(string2)) {
                    n2 = 2;
                    n3 = 2;
                } else if ("xMinYMid".equals(string2)) {
                    n2 = 1;
                    n3 = 0;
                } else if ("xMidYMid".equals(string2)) {
                    n2 = 0;
                    n3 = 0;
                } else if ("xMaxYMid".equals(string2)) {
                    n2 = 2;
                    n3 = 0;
                } else if ("xMinYMax".equals(string2)) {
                    n2 = 1;
                    n3 = 1;
                } else if ("xMidYMax".equals(string2)) {
                    n2 = 0;
                    n3 = 1;
                } else if ("xMaxYMax".equals(string2)) {
                    n2 = 2;
                    n3 = 1;
                } else {
                    return false;
                }
                if ("slice".equals(string3)) {
                    n = 1;
                } else if (string3 == null || "meet".equals(string3)) {
                    n = 0;
                } else {
                    return false;
                }
            }
            this.aspectRatio = n;
            this.hAlign = n2;
            this.vAlign = n3;
            return true;
        }

        public String getWidthAttribute() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(Double.toString(this.width));
            if (this.widthUnit > 0 && this.widthUnit <= 7) {
                stringBuffer.append(UNIT_NAMES[this.widthUnit]);
            }
            return stringBuffer.toString();
        }

        public String getHeightAttribute() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(Double.toString(this.height));
            if (this.heightUnit > 0 && this.heightUnit <= 7) {
                stringBuffer.append(UNIT_NAMES[this.heightUnit]);
            }
            return stringBuffer.toString();
        }

        public String getViewBoxAttribute() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(Double.toString(this.viewBoxX));
            stringBuffer.append(' ');
            stringBuffer.append(Double.toString(this.viewBoxY));
            stringBuffer.append(' ');
            stringBuffer.append(Double.toString(this.viewBoxWidth));
            stringBuffer.append(' ');
            stringBuffer.append(Double.toString(this.viewBoxHeight));
            return stringBuffer.toString();
        }

        public String getPreserveAspectRatioAttribute() {
            if (this.aspectRatio == 2) {
                return "none";
            }
            StringBuffer stringBuffer = new StringBuffer();
            switch (this.hAlign) {
                case 1: {
                    stringBuffer.append("xMin");
                    break;
                }
                case 2: {
                    stringBuffer.append("xMax");
                    break;
                }
                default: {
                    stringBuffer.append("xMid");
                }
            }
            switch (this.vAlign) {
                case 2: {
                    stringBuffer.append("YMin");
                    break;
                }
                case 1: {
                    stringBuffer.append("YMax");
                    break;
                }
                default: {
                    stringBuffer.append("YMid");
                }
            }
            if (this.aspectRatio == 1) {
                stringBuffer.append(" slice");
            } else {
                stringBuffer.append(" meet");
            }
            return stringBuffer.toString();
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("width='");
            stringBuffer.append(this.getWidthAttribute());
            stringBuffer.append('\'');
            stringBuffer.append(" height='");
            stringBuffer.append(this.getHeightAttribute());
            stringBuffer.append('\'');
            stringBuffer.append(" viewBox='");
            stringBuffer.append(this.getViewBoxAttribute());
            stringBuffer.append('\'');
            stringBuffer.append(" preserveAspectRatio='");
            stringBuffer.append(this.getPreserveAspectRatioAttribute());
            stringBuffer.append('\'');
            return stringBuffer.toString();
        }

        public Info copy() {
            try {
                return (Info)this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                cloneNotSupportedException.printStackTrace();
                return null;
            }
        }
    }
}

