/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.command;

import com.xmlmind.xmledit.guiutil.Alert;
import com.xmlmind.xmledit.guiutil.DialogBase;
import com.xmlmind.xmledit.guiutil.DialogUtil;
import com.xmlmind.xmledit.guiutil.HintLabel;
import com.xmlmind.xmledit.util.FileUtil;
import com.xmlmind.xmledit.util.URIUtil;
import com.xmlmind.xmledit.util.URLUtil;
import com.xmlmind.xmleditapp.command.Msg;
import com.xmlmind.xmleditapp.urlchooser.DAVLister;
import com.xmlmind.xmleditapp.urlchooser.DirectoryLister;
import com.xmlmind.xmleditapp.urlchooser.FTPLister;
import com.xmlmind.xmleditapp.urlchooser.FileChooserDialog;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class ResourceDialog
extends DialogBase {
    private JTextField srcField;
    private ButtonGroup actionGroup;
    private JRadioButton copyToToggle;
    private JRadioButton referenceAsToggle;
    private JLabel dstLabel;
    private JTextField dstField;
    private HintLabel helpLabel;
    private URL dstBaseURL = null;
    private Info result = null;
    static /* synthetic */ Class class$com$xmlmind$xmleditapp$command$ResourceDialog;

    public ResourceDialog(Dialog dialog) {
        super(dialog, "", true);
        this.initialize(dialog, 26);
    }

    public ResourceDialog(Component component) {
        super(component, "", true);
        this.initialize(component, 26);
    }

    protected Component createForm() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.anchor = 17;
        String string = Msg.msg("RD.sourceURL");
        JLabel jLabel = new JLabel(DialogUtil.buttonLabel(string));
        DialogUtil.setDisplayedMnemonic(jLabel, string);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.srcField = new JTextField(40);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.top = 1;
        jPanel.add((Component)this.srcField, gridBagConstraints);
        jLabel.setLabelFor(this.srcField);
        ImageIcon imageIcon = new ImageIcon((class$com$xmlmind$xmleditapp$command$ResourceDialog == null ? (class$com$xmlmind$xmleditapp$command$ResourceDialog = ResourceDialog.class$("com.xmlmind.xmleditapp.command.ResourceDialog")) : class$com$xmlmind$xmleditapp$command$ResourceDialog).getResource("home.gif"));
        String string2 = Msg.msg("RD.homeToolTip");
        JButton jButton = new JButton(imageIcon);
        DialogUtil.setIconic(jButton);
        jButton.setToolTipText(string2);
        jButton.setActionCommand("browseHome");
        jButton.addActionListener(this);
        ++gridBagConstraints.gridx;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.left = 2;
        gridBagConstraints.insets.right = 2;
        jPanel.add((Component)jButton, gridBagConstraints);
        ImageIcon imageIcon2 = new ImageIcon((class$com$xmlmind$xmleditapp$command$ResourceDialog == null ? (class$com$xmlmind$xmleditapp$command$ResourceDialog = ResourceDialog.class$("com.xmlmind.xmleditapp.command.ResourceDialog")) : class$com$xmlmind$xmleditapp$command$ResourceDialog).getResource("browse.gif"));
        String string3 = Msg.msg("RD.browseToolTip");
        jButton = new JButton(imageIcon2);
        DialogUtil.setIconic(jButton);
        jButton.setToolTipText(string3);
        jButton.setActionCommand("browseSource");
        jButton.addActionListener(this);
        ++gridBagConstraints.gridx;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.insets.right = 5;
        jPanel.add((Component)jButton, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new FlowLayout(3, 5, 0));
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets.top = 10;
        gridBagConstraints.insets.left = 5;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        string = Msg.msg("RD.copyTo");
        this.copyToToggle = new JRadioButton(DialogUtil.buttonLabel(string));
        DialogUtil.setMnemonic(this.copyToToggle, string);
        this.copyToToggle.setActionCommand("updateDestination");
        this.copyToToggle.addActionListener(this);
        jPanel2.add(this.copyToToggle);
        string = Msg.msg("RD.referenceAs");
        this.referenceAsToggle = new JRadioButton(DialogUtil.buttonLabel(string));
        DialogUtil.setMnemonic(this.referenceAsToggle, string);
        this.referenceAsToggle.setActionCommand("updateDestination");
        this.referenceAsToggle.addActionListener(this);
        jPanel2.add(this.referenceAsToggle);
        this.actionGroup = new ButtonGroup();
        this.actionGroup.add(this.copyToToggle);
        this.actionGroup.add(this.referenceAsToggle);
        string = Msg.msg("RD.destinationURL");
        this.dstLabel = new JLabel(DialogUtil.buttonLabel(string));
        DialogUtil.setDisplayedMnemonic(this.dstLabel, string);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets.top = 10;
        jPanel.add((Component)this.dstLabel, gridBagConstraints);
        this.dstField = new JTextField(40);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.insets.top = 1;
        jPanel.add((Component)this.dstField, gridBagConstraints);
        this.dstLabel.setLabelFor(this.dstField);
        jButton = new JButton(imageIcon2);
        DialogUtil.setIconic(jButton);
        jButton.setToolTipText(string3);
        jButton.setActionCommand("browseDestination");
        jButton.addActionListener(this);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx += 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.left = 2;
        gridBagConstraints.insets.right = 5;
        jPanel.add((Component)jButton, gridBagConstraints);
        this.helpLabel = new HintLabel(Msg.msg("RD.isRelativeURL", ""));
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.insets.bottom = 5;
        jPanel.add((Component)this.helpLabel, gridBagConstraints);
        return jPanel;
    }

    public Info getInfo(Info info, URL uRL, boolean bl, String string) {
        String string2;
        String string3;
        this.dstBaseURL = uRL;
        if (bl) {
            string3 = Msg.msg("RD.editAttribute", string);
            string2 = Msg.msg("RD.destinationURL") + Msg.msg("RD.valueOfAttribute", string) + ':';
        } else {
            string3 = Msg.msg("RD.editElement", string);
            string2 = Msg.msg("RD.destinationURL") + Msg.msg("RD.valueOfElement", string) + ':';
        }
        this.setTitle(string3);
        this.dstLabel.setText(DialogUtil.buttonLabel(string2));
        DialogUtil.setDisplayedMnemonic(this.dstLabel, string2);
        this.helpLabel.setText(Msg.msg("RD.isRelativeURL", URLUtil.toDisplayForm(URLUtil.getDirectory(uRL))));
        this.srcField.setText(info.srcURL == null ? "" : info.srcURL.toExternalForm());
        if (info.copyTo == null && info.referenceAs == null) {
            boolean bl2 = true;
            if (info.srcURL != null) {
                String string4;
                String string5 = URLUtil.getDirectory(uRL, true).toExternalForm();
                if (!string5.endsWith("/")) {
                    string5 = string5 + '/';
                }
                if ((string4 = URLUtil.getDirectory(info.srcURL, true).toExternalForm()).startsWith(string5)) {
                    bl2 = false;
                }
            }
            if (bl2) {
                this.copyToToggle.setSelected(true);
            } else {
                this.referenceAsToggle.setSelected(true);
            }
            this.updateDestination();
        } else if (info.referenceAs == null) {
            this.copyToToggle.setSelected(true);
            this.dstField.setText(info.copyTo);
        } else {
            this.referenceAsToggle.setSelected(true);
            this.dstField.setText(info.referenceAs);
        }
        this.getRootPane().setDefaultButton(this.dialogButtons[0]);
        this.pack();
        this.setLocationRelativeTo(this.dialogAnchor);
        if (info.srcURL == null) {
            this.srcField.requestFocus();
        } else {
            this.dstField.requestFocus();
        }
        this.setVisible(true);
        return this.result;
    }

    public void browseHome() {
        String string = System.getProperty("user.home");
        if (string == null) {
            string = "any";
        }
        URL uRL = FileUtil.fileToURL(string);
        if ((uRL = this.browse(uRL, false)) == null) {
            return;
        }
        this.srcField.setText(uRL.toExternalForm());
        this.updateDestination();
    }

    public void browseSource() {
        URL uRL = this.getSourceURL();
        if (uRL == null) {
            uRL = FileUtil.fileToURL("any");
        }
        if ((uRL = this.browse(uRL, false)) == null) {
            return;
        }
        this.srcField.setText(uRL.toExternalForm());
        this.updateDestination();
    }

    private URL getSourceURL() {
        URL uRL = null;
        try {
            uRL = new URL(this.srcField.getText().trim());
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (uRL != null && uRL.getPath().length() == 0) {
            return null;
        }
        return uRL;
    }

    public void browseDestination() {
        URL uRL = this.getDestinationURL();
        if (uRL == null) {
            uRL = this.dstBaseURL;
        }
        if ((uRL = this.browse(uRL, true)) == null) {
            return;
        }
        String string = URLUtil.getRoot(this.dstBaseURL, true).equals(URLUtil.getRoot(uRL, true)) ? URLUtil.getRelativeRawPath(uRL, this.dstBaseURL) : uRL.toExternalForm();
        this.dstField.setText(string);
    }

    private URL getDestinationURL() {
        URL uRL = null;
        try {
            uRL = new URL(this.dstBaseURL, this.dstField.getText().trim());
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (uRL != null && uRL.getPath().length() == 0) {
            return null;
        }
        return uRL;
    }

    private URL browse(URL uRL, boolean bl) {
        int n;
        String string = uRL.getProtocol();
        if ("http".equals(string) || "https".equals(string) || "ftp".equals(string)) {
            String string2;
            DirectoryLister directoryLister;
            block9: {
                directoryLister = null;
                string2 = null;
                try {
                    directoryLister = "ftp".equals(string) ? new FTPLister(uRL) : new DAVLister(uRL);
                }
                catch (Exception exception) {
                    string2 = exception.getMessage();
                    if (string2 != null) break block9;
                    string2 = exception.getClass().getName();
                }
            }
            if (string2 != null) {
                Alert.showError(this, Msg.msg("RD.cannotConnectToServer", URLUtil.getRoot(uRL).toExternalForm(), string2));
                return null;
            }
            FileChooserDialog fileChooserDialog = new FileChooserDialog(this);
            String string3 = bl ? fileChooserDialog.selectSaveFile(directoryLister, null, null) : fileChooserDialog.selectOpenFile(directoryLister, null, null);
            directoryLister.dispose();
            if (string3 != null) {
                try {
                    return new URL(URLUtil.getRoot(uRL), URIUtil.quotePath(string3));
                }
                catch (MalformedURLException malformedURLException) {
                    return null;
                }
            }
            return null;
        }
        File file = FileUtil.urlToFile(URLUtil.getDirectory(uRL));
        JFileChooser jFileChooser = new JFileChooser(file);
        jFileChooser.setFileSelectionMode(0);
        int n2 = n = bl ? jFileChooser.showSaveDialog(this) : jFileChooser.showOpenDialog(this);
        if (n == 0) {
            File file2 = jFileChooser.getSelectedFile();
            if (file2 != null) {
                return FileUtil.fileToURL(file2);
            }
            return null;
        }
        return null;
    }

    public void updateDestination() {
        URL uRL = this.getSourceURL();
        if (uRL == null) {
            this.dstField.setText("");
            return;
        }
        if (this.copyToToggle.isSelected()) {
            this.dstField.setText(URLUtil.getRawBaseName(uRL));
        } else {
            String string = URLUtil.getRoot(this.dstBaseURL, true).equals(URLUtil.getRoot(uRL, true)) ? URLUtil.getRelativeRawPath(uRL, this.dstBaseURL) : (uRL.getProtocol().equals("file") ? "" : uRL.toExternalForm());
            this.dstField.setText(string);
        }
    }

    public void ok() {
        URL uRL = this.getSourceURL();
        if (uRL == null) {
            DialogUtil.badField(this.srcField);
            return;
        }
        String string = this.dstField.getText().trim();
        if (string.length() == 0) {
            DialogUtil.badField(this.dstField);
            return;
        }
        URL uRL2 = this.getDestinationURL();
        if (uRL2 == null) {
            DialogUtil.badField(this.dstField);
            return;
        }
        this.result = new Info();
        this.result.srcURL = uRL;
        if (this.copyToToggle.isSelected()) {
            this.result.copyTo = string;
        } else {
            this.result.referenceAs = string;
        }
        this.result.dstURL = uRL2;
        this.setVisible(false);
        this.dispose();
    }

    public void cancel() {
        this.result = null;
        this.setVisible(false);
        this.dispose();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static final class Info {
        public URL srcURL;
        public String referenceAs;
        public String copyTo;
        public URL dstURL;

        public String toString() {
            if (this.referenceAs == null) {
                return "copy '" + this.srcURL + "' to '" + this.copyTo + "'";
            }
            return "reference '" + this.srcURL + "' as '" + this.referenceAs + "'";
        }
    }
}

