/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.command;

import com.xmlmind.xmledit.command.RecordableCommand;
import com.xmlmind.xmledit.gadget.Command;
import com.xmlmind.xmledit.gadget.Gadget;
import com.xmlmind.xmledit.guiutil.ChooseURL;
import com.xmlmind.xmledit.util.FileUtil;
import com.xmlmind.xmledit.view.DocumentView;
import com.xmlmind.xmleditapp.urlchooser.URLChooserDialog;
import java.awt.Container;
import java.net.MalformedURLException;
import java.net.URL;

public class SelectFile
extends RecordableCommand {
    protected boolean urlMode = false;
    protected boolean saveMode = false;
    protected boolean dirMode = false;
    protected URL template = null;
    private URL lastOpenFileURL = null;
    private URL lastSaveFileURL = null;
    private URL lastOpenDirectoryURL = null;
    private URL lastSaveDirectoryURL = null;
    private URL lastOpenFile = null;
    private URL lastSaveFile = null;
    private URL lastOpenDirectory = null;
    private URL lastSaveDirectory = null;

    public boolean prepareCommand(Gadget gadget, String string, int n, int n2) {
        DocumentView documentView = (DocumentView)gadget;
        if (documentView.getDocument() == null) {
            return false;
        }
        if (string == null) {
            this.urlMode = false;
            this.saveMode = false;
            this.dirMode = false;
            this.template = null;
        } else if (!this.parseParameter(documentView, string)) {
            return false;
        }
        if (this.template == null) {
            this.template = this.getDefaultTemplate(documentView);
        }
        return true;
    }

    protected boolean parseParameter(DocumentView documentView, String string) {
        int n = 0;
        if (string.startsWith("openFileURL")) {
            this.urlMode = true;
            this.saveMode = false;
            this.dirMode = false;
            n = 11;
        } else if (string.startsWith("saveFileURL")) {
            this.urlMode = true;
            this.saveMode = true;
            this.dirMode = false;
            n = 11;
        } else if (string.startsWith("openDirectoryURL")) {
            this.urlMode = true;
            this.saveMode = false;
            this.dirMode = true;
            n = 16;
        } else if (string.startsWith("saveDirectoryURL")) {
            this.urlMode = true;
            this.saveMode = true;
            this.dirMode = true;
            n = 16;
        } else if (string.startsWith("openFile")) {
            this.urlMode = false;
            this.saveMode = false;
            this.dirMode = false;
            n = 8;
        } else if (string.startsWith("saveFile")) {
            this.urlMode = false;
            this.saveMode = true;
            this.dirMode = false;
            n = 8;
        } else if (string.startsWith("openDirectory")) {
            this.urlMode = false;
            this.saveMode = false;
            this.dirMode = true;
            n = 13;
        } else if (string.startsWith("saveDirectory")) {
            this.urlMode = false;
            this.saveMode = true;
            this.dirMode = true;
            n = 13;
        } else {
            return false;
        }
        this.template = null;
        if (n < string.length() && (string = string.substring(n).trim()).length() > 0) {
            try {
                this.template = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                return false;
            }
        }
        return true;
    }

    protected URL getDefaultTemplate(DocumentView documentView) {
        if (this.urlMode) {
            if (this.saveMode) {
                if (this.dirMode) {
                    return this.lastSaveDirectoryURL;
                }
                return this.lastSaveFileURL;
            }
            if (this.dirMode) {
                return this.lastOpenDirectoryURL;
            }
            return this.lastOpenFileURL;
        }
        if (this.saveMode) {
            if (this.dirMode) {
                return this.lastSaveDirectory;
            }
            return this.lastSaveFile;
        }
        if (this.dirMode) {
            return this.lastOpenDirectory;
        }
        return this.lastOpenFile;
    }

    protected Object doExecuteCommand(DocumentView documentView, String string, int n, int n2) {
        URL uRL;
        Container container = documentView.getPanel();
        if (this.urlMode) {
            URLChooserDialog uRLChooserDialog = new URLChooserDialog(container);
            uRL = this.saveMode ? (this.dirMode ? uRLChooserDialog.selectSaveDirectory(this.template) : uRLChooserDialog.selectSaveFile(this.template)) : (this.dirMode ? uRLChooserDialog.selectOpenDirectory(this.template) : uRLChooserDialog.selectOpenFile(this.template));
        } else {
            uRL = this.saveMode ? (this.dirMode ? ChooseURL.defaultChooseSaveDirectoryURL(container, this.template) : ChooseURL.defaultChooseSaveFileURL(container, this.template)) : (this.dirMode ? ChooseURL.defaultChooseOpenDirectoryURL(container, this.template) : ChooseURL.defaultChooseOpenFileURL(container, this.template));
        }
        if (uRL == null) {
            return Command.EXECUTION_FAILED;
        }
        this.setDefaultTemplate(documentView, uRL);
        if (this.urlMode) {
            return uRL;
        }
        return FileUtil.urlToFile(uRL);
    }

    protected void setDefaultTemplate(DocumentView documentView, URL uRL) {
        if (this.urlMode) {
            if (this.saveMode) {
                if (this.dirMode) {
                    this.lastSaveDirectoryURL = uRL;
                } else {
                    this.lastSaveFileURL = uRL;
                }
            } else if (this.dirMode) {
                this.lastOpenDirectoryURL = uRL;
            } else {
                this.lastOpenFileURL = uRL;
            }
        } else if (this.saveMode) {
            if (this.dirMode) {
                this.lastSaveDirectory = uRL;
            } else {
                this.lastSaveFile = uRL;
            }
        } else if (this.dirMode) {
            this.lastOpenDirectory = uRL;
        } else {
            this.lastOpenFile = uRL;
        }
    }
}

