/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.command;

import com.xmlmind.xmledit.command.RecordableCommand;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.Node;
import com.xmlmind.xmledit.edit.ElementEditor;
import com.xmlmind.xmledit.form.ImageDataTypes;
import com.xmlmind.xmledit.form.ImageViewportVP;
import com.xmlmind.xmledit.gadget.Command;
import com.xmlmind.xmledit.gadget.Gadget;
import com.xmlmind.xmledit.guiutil.AWTUtil;
import com.xmlmind.xmledit.guiutil.Alert;
import com.xmlmind.xmledit.guiutil.ChooseURL;
import com.xmlmind.xmledit.guiutil.ShowLog;
import com.xmlmind.xmledit.guiutil.ShowStatus;
import com.xmlmind.xmledit.imagetoolkit.XMLImageUtil;
import com.xmlmind.xmledit.util.FileUtil;
import com.xmlmind.xmledit.util.MiscUtil;
import com.xmlmind.xmledit.util.StringUtil;
import com.xmlmind.xmledit.util.URLUtil;
import com.xmlmind.xmledit.view.DocumentView;
import com.xmlmind.xmledit.xmlutil.Name;
import com.xmlmind.xmledit.xsd.datatype.Base16;
import com.xmlmind.xmledit.xsd.datatype.Base64;
import com.xmlmind.xmleditapp.command.Msg;
import com.xmlmind.xmleditapp.command.ResourceDialog;
import com.xmlmind.xmleditapp.upload.UploadDialog;
import java.awt.Container;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.zip.GZIPOutputStream;
import javax.swing.JOptionPane;

public class SetImage
extends RecordableCommand
implements ImageDataTypes {
    private static SetImage instance = null;
    private Element element;
    private Name attributeName;
    private int dataType;
    private boolean gzip;
    private URL imageURL;
    private static URL lastSelectedURL = null;

    public static SetImage getInstance() {
        if (instance == null) {
            instance = new SetImage();
        }
        return instance;
    }

    /*
     * Unable to fully structure code
     */
    public boolean prepareCommand(Gadget var1_1, String var2_2, int var3_3, int var4_4) {
        block16: {
            this.attributeName = null;
            this.dataType = -1;
            this.gzip = false;
            this.imageURL = null;
            var5_5 = (DocumentView)var1_1;
            this.element = var5_5.getSelectedElement(false);
            if (this.element == null) {
                return false;
            }
            if (var2_2 == null) break block16;
            var6_6 = StringUtil.splitArguments(var2_2);
            switch (var6_6.length) {
                case 4: {
                    var7_7 = var6_6[3];
                    try {
                        this.imageURL = new URL(var7_7);
                    }
                    catch (MalformedURLException var8_8) {
                        // empty catch block
                    }
                    if (this.imageURL == null && (var8_9 = new File(var7_7)).isFile()) {
                        this.imageURL = FileUtil.fileToURL(var8_9);
                    }
                }
                case 3: {
                    var7_7 = var6_6[2];
                    if (!"-".equals(var7_7)) {
                        if ("gzip".equals(var7_7)) {
                            this.gzip = true;
                        } else {
                            return false;
                        }
                    }
                }
                case 2: {
                    var7_7 = var6_6[1];
                    if ("-".equals(var7_7)) ** GOTO lbl44
                    if (!"anyURI".equalsIgnoreCase(var7_7)) ** GOTO lbl34
                    this.dataType = 1;
                    ** GOTO lbl44
lbl34:
                    // 1 sources

                    if (!"base64Binary".equalsIgnoreCase(var7_7)) ** GOTO lbl37
                    this.dataType = 3;
                    ** GOTO lbl44
lbl37:
                    // 1 sources

                    if (!"hexBinary".equalsIgnoreCase(var7_7)) ** GOTO lbl40
                    this.dataType = 2;
                    ** GOTO lbl44
lbl40:
                    // 1 sources

                    if ("XML".equalsIgnoreCase(var7_7)) {
                        this.dataType = 4;
                    } else {
                        return false;
                    }
                }
lbl44:
                // 6 sources

                case 1: {
                    var7_7 = var6_6[0];
                    if ("-".equals(var7_7)) break;
                    this.attributeName = Name.fromString(var7_7);
                    if (this.attributeName != null) break;
                    return false;
                }
                default: {
                    return false;
                }
            }
        }
        if (this.dataType < 1 || this.dataType > 4) {
            this.dataType = ImageViewportVP.checkImageDataType(this.dataType, this.element, this.attributeName);
        }
        return this.canSetImage(this.element, this.attributeName, this.dataType);
    }

    protected Object doExecuteCommand(DocumentView documentView, String string, int n, int n2) {
        boolean bl = this.setImage(this.imageURL, this.element, this.attributeName, this.dataType, this.gzip, documentView);
        this.element = null;
        return bl ? null : Command.EXECUTION_FAILED;
    }

    public boolean canSetImage(Element element, Name name, int n) {
        if (element.getLocation() == null) {
            return false;
        }
        switch (n) {
            case 1: 
            case 2: 
            case 3: {
                return element.isEditable();
            }
            case 4: {
                Element element2;
                return name == null && (element2 = element.getParentElement()) != null && element2.isEditable();
            }
        }
        return false;
    }

    public boolean setImage(URL uRL, Element element, Name name, int n, boolean bl, DocumentView documentView) {
        boolean bl2 = this.doSetImage(uRL, element, name, n, bl, documentView);
        if (bl2) {
            documentView.describeUndo(Msg.msg(this.msgPrefix() + "setImage"));
            if (name == null && n != 4) {
                documentView.rebuildView(element);
            }
        }
        return bl2;
    }

    protected String msgPrefix() {
        return "SI.";
    }

    private boolean doSetImage(URL uRL, Element element, Name name, int n, boolean bl, DocumentView documentView) {
        switch (n) {
            case 1: {
                String string;
                boolean bl2 = name != null;
                URL uRL2 = element.getLocation();
                ResourceDialog resourceDialog = new ResourceDialog(documentView.getPanel());
                ResourceDialog.Info info = new ResourceDialog.Info();
                if (uRL == null) {
                    String string2 = string = bl2 ? element.getAttribute(name) : element.getText();
                    if (string != null) {
                        string = string.trim();
                        try {
                            uRL = new URL(uRL2, string);
                        }
                        catch (MalformedURLException malformedURLException) {
                            // empty catch block
                        }
                    }
                    if (uRL != null) {
                        info.referenceAs = string;
                    }
                }
                info.srcURL = uRL;
                string = bl2 ? name.format(true, element) : element.getName().format(false, element);
                if ((info = resourceDialog.getInfo(info, uRL2, bl2, string)) == null) {
                    return false;
                }
                if (info.referenceAs != null) {
                    return this.setImageValue(info.referenceAs, element, name, documentView);
                }
                if (!this.copy(info.srcURL, info.dstURL, documentView)) break;
                return this.setImageValue(info.copyTo, element, name, documentView);
            }
            case 2: 
            case 3: {
                if (uRL == null) {
                    uRL = SetImage.chooseImage(element, documentView);
                }
                if (uRL == null) break;
                return this.setBinaryImage(uRL, element, name, n, bl, documentView);
            }
            case 4: {
                if (uRL == null) {
                    uRL = SetImage.chooseImage(element, documentView);
                }
                if (uRL == null) break;
                return this.setXMLImage(uRL, element, documentView);
            }
        }
        return false;
    }

    private boolean setImageValue(String string, Element element, Name name, DocumentView documentView) {
        ElementEditor elementEditor = documentView.getElementEditor();
        elementEditor.setEditedElement(element);
        if (name != null) {
            if (elementEditor.canPutAttribute(name, string)) {
                elementEditor.putAttribute(name, string);
                return true;
            }
        } else if (elementEditor.canSetText(string)) {
            elementEditor.setText(string);
            return true;
        }
        Alert.showError(documentView.getPanel(), Msg.msg(this.msgPrefix() + "operationNotAllowed"));
        return false;
    }

    private boolean copy(URL uRL, URL uRL2, DocumentView documentView) {
        if (XMLImageUtil.isXMLImage(uRL)) {
            ShowStatus.showStatus(Msg.msg("SISO.loadingFile", URLUtil.toShortLabel(uRL, 40)));
            boolean bl = this.copyXMLImage(uRL, uRL2, documentView);
            ShowStatus.showStatus("");
            return bl;
        }
        return SetImage.doCopy(new URL[]{uRL, uRL2}, documentView);
    }

    private boolean copyXMLImage(URL uRL, URL uRL2, DocumentView documentView) {
        ArrayList arrayList = new ArrayList();
        File file = null;
        try {
            file = XMLImageUtil.createCopiableImageFile(uRL, uRL2, arrayList);
        }
        catch (Exception exception) {
            Alert.showError(documentView.getPanel(), Msg.msg("SISO.cannotLoadFile", URLUtil.toLabel(uRL), MiscUtil.reason(exception)));
            return false;
        }
        if (file == null) {
            return SetImage.doCopy(new URL[]{uRL, uRL2}, documentView);
        }
        URL[] uRLArray = new URL[arrayList.size()];
        arrayList.toArray(uRLArray);
        boolean bl = SetImage.doCopy(uRLArray, documentView);
        file.delete();
        return bl;
    }

    private static boolean doCopy(URL[] uRLArray, DocumentView documentView) {
        Container container = documentView.getPanel();
        UploadDialog uploadDialog = new UploadDialog(container);
        uploadDialog.setMessageLog(ShowLog.LOG_STATUS);
        String string = uploadDialog.upload(uRLArray);
        if (string != null) {
            Alert.showError(container, string);
            return false;
        }
        return true;
    }

    private static URL chooseImage(Element element, DocumentView documentView) {
        URL uRL;
        URL uRL2 = lastSelectedURL;
        if (uRL2 == null) {
            uRL2 = element.getLocation();
        }
        if ((uRL = ChooseURL.chooseOpenFileURL(documentView.getPanel(), uRL2)) == null) {
            return null;
        }
        lastSelectedURL = uRL;
        return uRL;
    }

    private boolean setBinaryImage(URL uRL, Element element, Name name, int n, boolean bl, DocumentView documentView) {
        ShowStatus.showStatus(Msg.msg(bl ? "SISO.encodingGzippedFile" : "SISO.encodingFile", URLUtil.toShortLabel(uRL, 40)));
        String string = this.encodeBinaryImage(uRL, n, bl, documentView);
        ShowStatus.showStatus("");
        if (string == null) {
            return false;
        }
        return this.setImageValue(string, element, name, documentView);
    }

    private String encodeBinaryImage(URL uRL, int n, boolean bl, DocumentView documentView) {
        byte[] byArray;
        try {
            ByteArrayOutputStream byteArrayOutputStream;
            OutputStream outputStream = byteArrayOutputStream = new ByteArrayOutputStream();
            if (bl) {
                outputStream = new GZIPOutputStream(outputStream);
            }
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setUseCaches(false);
            uRLConnection.setIfModifiedSince(0L);
            InputStream inputStream = uRLConnection.getInputStream();
            FileUtil.copy(inputStream, outputStream);
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            Alert.showError(documentView.getPanel(), Msg.msg("SISO.cannotLoadFile", URLUtil.toLabel(uRL), MiscUtil.reason(iOException)));
            return null;
        }
        if (n == 3) {
            return Base64.encode(byArray);
        }
        return Base16.encode(byArray);
    }

    private boolean setXMLImage(URL uRL, Element element, DocumentView documentView) {
        ShowStatus.showStatus(Msg.msg("SISO.loadingFile", URLUtil.toShortLabel(uRL, 40)));
        String string = null;
        Element element2 = element.getParentElement();
        ArrayList arrayList = new ArrayList();
        Element element3 = null;
        try {
            element3 = XMLImageUtil.createEmbeddableImageElement(uRL, element.getDocument(), element2.getLocation(), arrayList);
        }
        catch (Exception exception) {
            string = MiscUtil.reason(exception);
        }
        ShowStatus.showStatus("");
        Container container = documentView.getPanel();
        if (string != null) {
            Alert.showError(container, Msg.msg("SISO.cannotLoadFile", URLUtil.toLabel(uRL), string));
            return false;
        }
        ElementEditor elementEditor = documentView.getElementEditor();
        elementEditor.setEditedElement(element2);
        Node[] nodeArray = new Node[]{element3};
        if (elementEditor.canPaste((Node)element, (Node)element, nodeArray)) {
            int n = arrayList.size();
            if (n > 0) {
                int n2 = JOptionPane.showConfirmDialog(AWTUtil.getDialogAnchor(container), Msg.msg(this.msgPrefix() + "confirmCopyOfResources", new Integer(n / 2), URLUtil.toLabel((URL)arrayList.get(0)), URLUtil.toLabel((URL)arrayList.get(1))), Msg.msg("confirm"), 2);
                if (n2 != 0) {
                    return false;
                }
                URL[] uRLArray = new URL[n];
                arrayList.toArray(uRLArray);
                if (!SetImage.doCopy(uRLArray, documentView)) {
                    return false;
                }
            }
            elementEditor.paste((Node)element, (Node)element, nodeArray);
            documentView.selectNode(element3);
            return true;
        }
        Alert.showError(container, Msg.msg(this.msgPrefix() + "operationNotAllowed"));
        return false;
    }
}

