/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.command;

import com.xmlmind.xmledit.doc.Document;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doctype.DocumentType;
import com.xmlmind.xmledit.doctype.DocumentTypeUtil;
import com.xmlmind.xmledit.doctype.DocumentationGeneratorBase;
import com.xmlmind.xmledit.doctype.ElementType;
import com.xmlmind.xmledit.guiutil.DialogUtil;
import com.xmlmind.xmledit.guiutil.ImageResource;
import com.xmlmind.xmledit.rng.doctype.DocumentTypeImpl;
import com.xmlmind.xmledit.rng.doctype.DocumentationGenerator;
import com.xmlmind.xmledit.util.MiscUtil;
import com.xmlmind.xmledit.util.URIUtil;
import com.xmlmind.xmledit.xmlutil.NamespacePrefixMap;
import com.xmlmind.xmledit.xmlutil.PreferredPrefix;
import com.xmlmind.xmledit.xmlutil.XMLUtil;
import com.xmlmind.xmledit.xsd.validate.Schema;
import com.xmlmind.xmleditapp.command.Msg;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import java.util.Stack;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLEditorKit;

public class ShowContentModelFrame
extends JFrame
implements ActionListener,
HyperlinkListener {
    private static final String STATE_PROPERTY = "com.xmlmind.xmleditapp.command.ShowContentModelFrame.STATE_PROPERTY";
    private JButton backButton;
    private JButton forwardButton;
    private JButton indexButton;
    private JEditorPane htmlPane;
    private State state = null;
    static /* synthetic */ Class class$com$xmlmind$xmleditapp$command$ShowContentModelFrame;

    public ShowContentModelFrame() {
        super("");
        this.setIconImage(ImageResource.get(class$com$xmlmind$xmleditapp$command$ShowContentModelFrame == null ? (class$com$xmlmind$xmleditapp$command$ShowContentModelFrame = ShowContentModelFrame.class$("com.xmlmind.xmleditapp.command.ShowContentModelFrame")) : class$com$xmlmind$xmleditapp$command$ShowContentModelFrame, "showContentModel.gif"));
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ShowContentModelFrame.this.close();
            }
        });
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.top = 5;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.anchor = 17;
        URL uRL = (class$com$xmlmind$xmleditapp$command$ShowContentModelFrame == null ? (class$com$xmlmind$xmleditapp$command$ShowContentModelFrame = ShowContentModelFrame.class$("com.xmlmind.xmleditapp.command.ShowContentModelFrame")) : class$com$xmlmind$xmleditapp$command$ShowContentModelFrame).getResource("back.gif");
        this.backButton = new JButton(new ImageIcon(uRL));
        DialogUtil.setIconic(this.backButton);
        this.backButton.setToolTipText(Msg.msg("SCMF.back"));
        this.backButton.setActionCommand("back");
        this.backButton.addActionListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)this.backButton, gridBagConstraints);
        uRL = (class$com$xmlmind$xmleditapp$command$ShowContentModelFrame == null ? (class$com$xmlmind$xmleditapp$command$ShowContentModelFrame = ShowContentModelFrame.class$("com.xmlmind.xmleditapp.command.ShowContentModelFrame")) : class$com$xmlmind$xmleditapp$command$ShowContentModelFrame).getResource("forward.gif");
        this.forwardButton = new JButton(new ImageIcon(uRL));
        DialogUtil.setIconic(this.forwardButton);
        this.forwardButton.setToolTipText(Msg.msg("SCMF.forward"));
        this.forwardButton.setActionCommand("forward");
        this.forwardButton.addActionListener(this);
        ++gridBagConstraints.gridx;
        jPanel.add((Component)this.forwardButton, gridBagConstraints);
        uRL = (class$com$xmlmind$xmleditapp$command$ShowContentModelFrame == null ? (class$com$xmlmind$xmleditapp$command$ShowContentModelFrame = ShowContentModelFrame.class$("com.xmlmind.xmleditapp.command.ShowContentModelFrame")) : class$com$xmlmind$xmleditapp$command$ShowContentModelFrame).getResource("index.gif");
        this.indexButton = new JButton(new ImageIcon(uRL));
        DialogUtil.setIconic(this.indexButton);
        this.indexButton.setToolTipText(Msg.msg("SCMF.index"));
        this.indexButton.setActionCommand("index");
        this.indexButton.addActionListener(this);
        ++gridBagConstraints.gridx;
        gridBagConstraints.insets.left = 15;
        jPanel.add((Component)this.indexButton, gridBagConstraints);
        uRL = (class$com$xmlmind$xmleditapp$command$ShowContentModelFrame == null ? (class$com$xmlmind$xmleditapp$command$ShowContentModelFrame = ShowContentModelFrame.class$("com.xmlmind.xmleditapp.command.ShowContentModelFrame")) : class$com$xmlmind$xmleditapp$command$ShowContentModelFrame).getResource("close.gif");
        JButton jButton = new JButton(new ImageIcon(uRL));
        DialogUtil.setIconic(jButton);
        jButton.setToolTipText(DialogUtil.buttonLabel(Msg.msg("close")));
        jButton.setActionCommand("close");
        jButton.addActionListener(this);
        ++gridBagConstraints.gridx;
        gridBagConstraints.insets.left = 15;
        gridBagConstraints.insets.right = 5;
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)jButton, gridBagConstraints);
        this.htmlPane = new JEditorPane();
        HTMLEditorKit hTMLEditorKit = (HTMLEditorKit)this.htmlPane.getEditorKitForContentType("text/html");
        hTMLEditorKit.getStyleSheet().addRule("body { font-family: sans-serif; font-size: 12pt; }");
        this.htmlPane.setEditorKit(hTMLEditorKit);
        this.htmlPane.setEditable(false);
        this.htmlPane.addHyperlinkListener(this);
        JScrollPane jScrollPane = new JScrollPane(this.htmlPane);
        FontMetrics fontMetrics = this.htmlPane.getFontMetrics(this.htmlPane.getFont());
        jScrollPane.setPreferredSize(new Dimension(fontMetrics.charWidth('x') * 81, fontMetrics.getHeight() * 30));
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.insets.bottom = 5;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        this.pack();
        this.setResizable(true);
    }

    public void showContentModel(Element element) {
        if (this.getState() == 1) {
            this.setState(0);
        }
        this.setVisible(true);
        State state = this.state;
        this.state = this.getState(element);
        if (state == null || this.state != state) {
            this.showText(null);
            this.enableButtons();
        }
        if (this.state == null) {
            return;
        }
        ElementType elementType = this.state.getDocumentType().getElementType(element);
        if (elementType == null) {
            this.index();
            return;
        }
        this.go(elementType, null, true, true);
    }

    private State getState(Element element) {
        Document document = element.getDocument();
        if (document == null) {
            return null;
        }
        State state = (State)document.getProperty(STATE_PROPERTY);
        if (state != null) {
            return state;
        }
        DocumentType documentType = (DocumentType)document.getProperty("DOCUMENT_TYPE");
        if (!DocumentTypeUtil.isConstrainedDocumentType(documentType)) {
            return null;
        }
        PreferredPrefix preferredPrefix = null;
        NamespacePrefixMap namespacePrefixMap = (NamespacePrefixMap)document.getProperty("NAMESPACE_PREFIX_MAP");
        if (namespacePrefixMap != null && namespacePrefixMap instanceof PreferredPrefix) {
            preferredPrefix = (PreferredPrefix)namespacePrefixMap;
        }
        state = new State(documentType, preferredPrefix);
        document.putProperty(STATE_PROPERTY, state);
        return state;
    }

    private void showText(String string) {
        if (string == null) {
            string = "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html><body>");
        XMLUtil.escapeXML(string, stringBuffer);
        stringBuffer.append("</body></html>");
        this.showHTML(stringBuffer.toString());
    }

    private void showHTML(String string) {
        try {
            this.htmlPane.read(new StringReader(string), null);
        }
        catch (IOException iOException) {
            System.err.println("Internal error: " + MiscUtil.reason(iOException));
            System.err.println("Cannot display this HTML page:");
            System.err.println("----------------------------------------");
            System.err.println(string);
            System.err.println("----------------------------------------");
        }
        this.htmlPane.scrollRectToVisible(new Rectangle(0, 0, 10, 10));
    }

    private void enableButtons() {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (this.state != null) {
            bl = true;
            bl2 = this.state.backStack.size() > 0;
            bl3 = this.state.forwardStack.size() > 0;
        }
        this.indexButton.setEnabled(bl);
        this.backButton.setEnabled(bl2);
        this.forwardButton.setEnabled(bl3);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("back")) {
            this.back();
        } else if (string.equals("forward")) {
            this.forward();
        } else if (string.equals("index")) {
            this.index();
        } else if (string.equals("close")) {
            this.close();
        }
    }

    private void back() {
        if (this.state.backStack.empty()) {
            return;
        }
        String string = (String)this.state.backStack.pop();
        if (this.state.currentHref != null) {
            this.state.forwardStack.push(this.state.currentHref);
        }
        this.go(string, false, false);
    }

    private void forward() {
        if (this.state.forwardStack.empty()) {
            return;
        }
        String string = (String)this.state.forwardStack.pop();
        this.go(string, true, false);
    }

    private void index() {
        DocumentationGeneratorBase.PageInfo pageInfo = new DocumentationGeneratorBase.PageInfo();
        this.state.docGen.generateIndexPage(pageInfo);
        this.go(pageInfo, null, true, true);
    }

    private void close() {
        this.setVisible(false);
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            String string = hyperlinkEvent.getDescription();
            if (string.startsWith("#")) {
                string = URIUtil.trimFragment(this.state.currentHref) + string;
            }
            this.go(string, true, true);
        }
    }

    private void go(String string, boolean bl, boolean bl2) {
        String string2 = string;
        String string3 = null;
        int n = string.lastIndexOf(35);
        if (n >= 0) {
            string2 = string.substring(0, n);
            if (n + 1 < string.length()) {
                string3 = string.substring(n + 1);
            }
        }
        if (string2.equals("index.html") || string2.equals("namespaces.html")) {
            DocumentationGeneratorBase.PageInfo pageInfo = new DocumentationGeneratorBase.PageInfo();
            if (string2.equals("index.html")) {
                this.state.docGen.generateIndexPage(pageInfo);
            } else {
                this.state.docGen.generateNamespacesPage(pageInfo);
            }
            this.go(pageInfo, string3, bl, bl2);
        } else {
            ElementType elementType = this.state.docGen.getElementType(string2);
            if (elementType == null) {
                System.err.println("Internal error: don't find ElementType corresponding to HTML page named '" + string2 + "'");
                return;
            }
            this.go(elementType, string3, bl, bl2);
        }
    }

    private void go(ElementType elementType, String string, boolean bl, boolean bl2) {
        DocumentationGeneratorBase.PageInfo pageInfo = new DocumentationGeneratorBase.PageInfo();
        if (!this.state.docGen.generateElementPage(elementType, pageInfo)) {
            System.err.println("Internal error: cannot generate HTML page documenting ElementType " + elementType);
            return;
        }
        this.go(pageInfo, string, bl, bl2);
    }

    private void go(DocumentationGeneratorBase.PageInfo pageInfo, String string, boolean bl, boolean bl2) {
        String string2;
        this.setTitle(pageInfo.title);
        this.showHTML(pageInfo.html);
        if (string != null) {
            this.htmlPane.scrollToReference(string);
        }
        if (string == null) {
            string2 = pageInfo.name;
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(pageInfo.name);
            stringBuffer.append('#');
            stringBuffer.append(string);
            string2 = stringBuffer.toString();
        }
        if (bl && this.state.currentHref != null && !string2.equals(this.state.currentHref)) {
            this.state.backStack.push(this.state.currentHref);
        }
        if (bl2) {
            while (!this.state.forwardStack.empty()) {
                this.state.forwardStack.pop();
            }
        }
        this.state.currentHref = string2;
        this.enableButtons();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static final class State {
        public DocumentationGeneratorBase docGen;
        public String currentHref = null;
        public Stack backStack = new Stack();
        public Stack forwardStack = new Stack();

        public State(DocumentType documentType, PreferredPrefix preferredPrefix) {
            if (documentType instanceof Schema) {
                this.docGen = new com.xmlmind.xmledit.xsd.validate.DocumentationGenerator((Schema)documentType);
            } else {
                DocumentationGenerator documentationGenerator = new DocumentationGenerator((DocumentTypeImpl)documentType);
                documentationGenerator.setAnnotated(true);
                this.docGen = documentationGenerator;
            }
            this.docGen.setContentMetaAdded(false);
            this.docGen.setNavigationBars(0);
            this.docGen.setPreferredPrefix(preferredPrefix);
        }

        public DocumentType getDocumentType() {
            return this.docGen.getDocumentType();
        }
    }
}

