/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xmleditapp.command;

import com.xmlmind.xmledit.command.InsertString;
import com.xmlmind.xmledit.doc.Comment;
import com.xmlmind.xmledit.doc.Element;
import com.xmlmind.xmledit.doc.ProcessingInstruction;
import com.xmlmind.xmledit.doc.Text;
import com.xmlmind.xmledit.doc.TextNode;
import com.xmlmind.xmledit.doc.Traversal;
import com.xmlmind.xmledit.edit.MarkManager;
import com.xmlmind.xmledit.edit.TextLocation;
import com.xmlmind.xmledit.edit.TextOffset;
import com.xmlmind.xmledit.guiutil.ShowStatus;
import com.xmlmind.xmledit.view.DocumentView;
import com.xmlmind.xmledit.xmlutil.XMLUtil;
import com.xmlmind.xmleditapp.command.Msg;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;

public class ShowMatchingChar
extends InsertString
implements Traversal.Handler {
    private int highlightId = 0;
    private char matchingChar;
    private char insertedChar;
    private int charCount;

    protected Object doExecuteCommand(DocumentView documentView, String string, int n, int n2) {
        String string2 = string.substring(0, 1);
        documentView.insertString(string2);
        this.insertedChar = string2.charAt(0);
        switch (this.insertedChar) {
            case '}': {
                this.matchingChar = (char)123;
                break;
            }
            case ')': {
                this.matchingChar = (char)40;
                break;
            }
            case ']': {
                this.matchingChar = (char)91;
                break;
            }
            default: {
                this.matchingChar = '\u0000';
            }
        }
        if (this.matchingChar == '\u0000') {
            documentView.getToolkit().beep();
            return null;
        }
        final MarkManager markManager = documentView.getMarkManager();
        TextLocation textLocation = markManager.getDot();
        this.charCount = 0;
        TextOffset textOffset = null;
        if (textLocation.getOffset() > 0) {
            textOffset = this.processTextNode(textLocation.getTextNode(), textLocation.getOffset() - 1);
        }
        if (textOffset == null) {
            textOffset = (TextOffset)Traversal.traverseBefore(textLocation.getTextNode(), this);
        }
        if (textOffset == null) {
            documentView.getToolkit().beep();
            return null;
        }
        Rectangle rectangle = documentView.modelToView(textOffset.text, textOffset.offset);
        Rectangle rectangle2 = documentView.getVisibleRectangle();
        if (rectangle == null || rectangle.height <= 0 || rectangle2.height <= 0 || !rectangle.intersects(rectangle2)) {
            char[] cArray = textOffset.text.getTextChars();
            int n3 = 1;
            int n4 = textOffset.offset - 1;
            block8: while (n4 >= 0) {
                switch (cArray[n4]) {
                    case '\n': 
                    case '\r': {
                        break block8;
                    }
                    default: {
                        if (++n3 == 80) break block8;
                        --n4;
                    }
                }
            }
            String string3 = new String(cArray, n4 + 1, textOffset.offset - n4);
            string3 = XMLUtil.collapseWhiteSpace(string3);
            if (n4 >= 0 && n3 == 80) {
                string3 = "..." + string3;
            }
            ShowStatus.showStatus(Msg.msg("SMC.matches", string3));
            return null;
        }
        final String string4 = "highlight.matchingChar" + this.highlightId;
        final String string5 = "highlight2.matchingChar" + this.highlightId;
        ++this.highlightId;
        markManager.add(string5, textOffset.text, textOffset.offset + 1);
        markManager.add(string4, textOffset.text, textOffset.offset);
        Timer timer = new Timer(500, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                markManager.remove(string4);
                markManager.remove(string5);
            }
        });
        timer.setRepeats(false);
        timer.start();
        return null;
    }

    private TextOffset processTextNode(TextNode textNode, int n) {
        char[] cArray = textNode.getTextChars();
        if (n < 0) {
            n = cArray.length - 1;
        }
        int n2 = n;
        while (n2 >= 0) {
            char c = cArray[n2];
            if (c == this.insertedChar) {
                ++this.charCount;
            } else if (c == this.matchingChar) {
                --this.charCount;
                if (this.charCount == 0) {
                    return new TextOffset(textNode, n2);
                }
            }
            --n2;
        }
        return null;
    }

    public Object processText(Text text) {
        return this.processTextNode(text, -1);
    }

    public Object processPI(ProcessingInstruction processingInstruction) {
        return this.processTextNode(processingInstruction, -1);
    }

    public Object processComment(Comment comment) {
        return this.processTextNode(comment, -1);
    }

    public Object enterElement(Element element) {
        return null;
    }

    public Object leaveElement(Element element) {
        return null;
    }
}

